/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.ajde;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.aspectj.ajde.BuildProgressMonitor;
import org.aspectj.ajde.TaskListManager;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.weaver.WeaverMetrics;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator;
import org.eclipse.ajdt.internal.builder.Builder;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;

public class CompilerMonitor
implements TaskListManager,
BuildProgressMonitor {
    private long compileStartTime;
    private boolean reportedCompiledMessages;
    private boolean reportedWovenMessages;
    private IProgressMonitor monitor = null;
    private boolean compilationInProgress = false;
    private static List affectedResources = new ArrayList();
    private static List problems = new ArrayList();
    private static Map otherProjectMarkers = new HashMap();
    private float ajdeMonitorMaxRatio = 1.0f;
    private int currentAjdeProgress;
    private boolean linked;

    public void prepare(IProject iProject, List list, IProgressMonitor iProgressMonitor) {
        this.linked = false;
        IResource[] iResourceArray = null;
        try {
            iResourceArray = iProject.members();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        for (int i = 0; !this.linked && i < iResourceArray.length; ++i) {
            if (iResourceArray[i].getType() != 2) continue;
            this.linked = iResourceArray[i].isLinked();
        }
        if (AspectJPlugin.DEBUG_COMPILER) {
            System.out.println("CompilerMonitor.prepare called: IPM is " + (iProgressMonitor == null ? "Null" : "Not-Null"));
        }
        this.monitor = iProgressMonitor;
        if (this.monitor != null) {
            this.monitor.beginTask(AspectJPlugin.getResourceString("ajCompilation"), 100);
        }
        this.compileStartTime = System.currentTimeMillis();
        this.reportedCompiledMessages = false;
        this.reportedWovenMessages = false;
        this.compilationInProgress = true;
    }

    public void start(String string) {
        if (AspectJPlugin.DEBUG_COMPILER) {
            System.err.println("AJDE Callback: CompileProgressMonitor.start() called");
        }
        this.currentAjdeProgress = 0;
        if (this.monitor != null) {
            AspectJPlugin.getDefault().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ProjectBuildConfigurator projectBuildConfigurator;
                    if (CompilerMonitor.this.monitor != null && Builder.isLocalBuild && (projectBuildConfigurator = BuildConfigurator.getBuildConfigurator().getActiveProjectBuildConfigurator()) != null) {
                        String string = projectBuildConfigurator.getActiveBuildConfiguration().getName();
                        CompilerMonitor.this.monitor.setTaskName("Building project with '" + string + "' configuration");
                    }
                }
            });
        }
    }

    public void setProgressText(String string) {
        String string2;
        if (string.startsWith("compiled: ") && !this.reportedCompiledMessages) {
            this.reportedCompiledMessages = true;
            AJDTEventTrace.generalEvent("Time to first 'compiled:' message: " + (System.currentTimeMillis() - this.compileStartTime) + "ms");
        }
        if (string.startsWith("woven: ") && !this.reportedWovenMessages) {
            this.reportedWovenMessages = true;
            AJDTEventTrace.generalEvent("Time to first 'woven:' message: " + (System.currentTimeMillis() - this.compileStartTime) + "ms");
        }
        if (string.startsWith("compiled: ")) {
            string2 = new Path(string.substring(10));
            IWorkspaceRoot iWorkspaceRoot = AspectJPlugin.getWorkspace().getRoot();
            if (this.linked) {
                IFile[] iFileArray = iWorkspaceRoot.findFilesForLocation((IPath)string2);
                for (int i = 0; i < iFileArray.length; ++i) {
                    affectedResources.add(iFileArray[i]);
                }
            } else {
                IFile iFile = iWorkspaceRoot.getFileForLocation((IPath)string2);
                if (iFile == null) {
                    AJDTEventTrace.generalEvent("Processing progress message: Can't find eclipse resource for file with path " + string);
                } else {
                    affectedResources.add(iFile);
                }
            }
        }
        string2 = this.removePrefix(string);
        if (AspectJPlugin.DEBUG_COMPILER) {
            System.err.println("AJDE Callback: setProgressText(" + string + ")");
        }
        if (this.monitor != null) {
            AspectJPlugin.getDefault().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (CompilerMonitor.this.monitor != null) {
                        CompilerMonitor.this.monitor.subTask(string2);
                    }
                }
            });
        }
    }

    public void setProgressBarVal(int n) {
        if (AspectJPlugin.DEBUG_COMPILER) {
            System.err.println("AJDE Callback: setProgressBarVal(" + n + ")");
        }
        if (n >= this.currentAjdeProgress) {
            this.incrementProgressBarVal("setProgressBarVal() delegating to ");
        }
    }

    public void setProgressBarMax(int n) {
        if (AspectJPlugin.DEBUG_COMPILER) {
            System.err.println("AJDE Callback: setProgressBarMax(" + n + ")");
        }
        this.ajdeMonitorMaxRatio = (float)n / 100.0f;
    }

    public void incrementProgressBarVal() {
        this.incrementProgressBarVal("AJDE Callback:");
    }

    public void incrementProgressBarVal(String string) {
        if (AspectJPlugin.DEBUG_COMPILER) {
            System.err.println(string + " incrementProgressBarVal():" + this.currentAjdeProgress);
        }
        ++this.currentAjdeProgress;
        if (this.monitor != null) {
            AspectJPlugin.getDefault().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (CompilerMonitor.this.monitor != null) {
                        CompilerMonitor.this.monitor.worked(1);
                    }
                }
            });
        }
    }

    public int getProgressBarMax() {
        if (AspectJPlugin.DEBUG_COMPILER) {
            System.err.println("AJDE Callback: getProgressBarMax()");
        }
        return 100;
    }

    public synchronized void finish() {
        if (AspectJPlugin.DEBUG_COMPILER) {
            System.err.println("AJDE Callback: finish()");
        }
        this.compilationInProgress = false;
        AJDTEventTrace.generalEvent("Weaver stress level: ");
        int n = WeaverMetrics.fastMatchOnTypeAttempted - WeaverMetrics.fastMatchOnTypeTrue - WeaverMetrics.fastMatchOnTypeFalse;
        AJDTEventTrace.generalEvent("Fast fast matching (type level) of #" + WeaverMetrics.fastMatchOnTypeAttempted + " types " + "resulting in us dismissing " + WeaverMetrics.fastMatchOnTypeFalse);
        AJDTEventTrace.generalEvent("Fast matching within the remaining #" + (WeaverMetrics.fastMatchOnTypeTrue + n) + " types, " + "we fast matched on #" + WeaverMetrics.fastMatchOnShadowsAttempted + " shadows and dismissed #" + WeaverMetrics.fastMatchOnShadowsFalse);
        AJDTEventTrace.generalEvent("Slow match then attempted on #" + WeaverMetrics.matchAttempted + " shadows of which " + WeaverMetrics.matchTrue + " successful");
        WeaverMetrics.reset();
        if (AspectJPlugin.getDefault().getDisplay().isDisposed()) {
            System.err.println("Not finishing with bpm, display is disposed!");
        } else {
            AspectJPlugin.getDefault().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (CompilerMonitor.this.monitor != null) {
                        if (CompilerMonitor.this.monitor != null) {
                            CompilerMonitor.this.monitor.worked(100);
                        }
                        if (CompilerMonitor.this.monitor != null) {
                            CompilerMonitor.this.monitor.done();
                        }
                        CompilerMonitor.this.monitor = null;
                    }
                }
            });
        }
    }

    public boolean finished() {
        return !this.compilationInProgress;
    }

    private String removePrefix(String string) {
        int n;
        String string2 = string;
        IProject iProject = AspectJPlugin.getDefault().getCurrentProject();
        String string3 = iProject.getLocation().toOSString() + "\\";
        if (string.indexOf(string3) != -1) {
            string2 = string.substring(0, string.indexOf(string3)) + string.substring(string.indexOf(string3) + string3.length());
        } else if (string.indexOf(string3 = string3.replace('\\', '/')) != -1) {
            string2 = string.substring(0, string.indexOf(string3)) + string.substring(string.indexOf(string3) + string3.length());
        }
        if (string2.startsWith("might need to weave")) {
            string2 = "weaving ...";
        }
        if (string2.startsWith("directory classpath entry does not exist: null")) {
            string2 = "";
        }
        if (string2.startsWith("woven") && string2.indexOf("(from") != -1 && (n = string2.indexOf("(from")) != -1) {
            String string4 = string2.substring(n);
            int n2 = string4.lastIndexOf("/");
            if (n2 == -1) {
                n2 = string4.lastIndexOf("\\");
            }
            if (n2 != -1) {
                string4 = string4.substring(n2 + 1);
                string2 = string2.substring(0, n) + " (" + string4;
            } else {
                int n3 = string4.indexOf(" ");
                if (n3 != -1) {
                    string2 = string2.substring(0, n) + " (" + string4.substring(n3 + 1);
                }
            }
        }
        return string2;
    }

    public void addSourcelineTask(String string, ISourceLocation iSourceLocation, IMessage.Kind kind) {
        if (AspectJPlugin.DEBUG_COMPILER) {
            System.err.println("CompilerMessage received ]" + string + "[");
        }
        problems.add(new ProblemTracker(string, iSourceLocation, kind));
    }

    public void addProjectTask(String string, IMessage.Kind kind) {
        problems.add(new ProblemTracker(string, null, kind));
    }

    public void clearTasks() {
        if (AspectJPlugin.DEBUG_COMPILER) {
            System.err.println("clearTasks() called");
        }
        affectedResources = new ArrayList();
        problems = new ArrayList();
    }

    public static void showOutstandingProblems() {
        if (problems.size() > 0 || affectedResources.size() > 0) {
            new CompilerMonitor().showMessages();
        }
    }

    private void showMessages() {
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) {
                try {
                    Iterator iterator = affectedResources.iterator();
                    IResource iResource = null;
                    while (iterator.hasNext()) {
                        iResource = (IResource)iterator.next();
                        try {
                            if (!iResource.exists()) continue;
                            iResource.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                            iResource.deleteMarkers("org.eclipse.core.resources.taskmarker", true, 2);
                        }
                        catch (ResourceException resourceException) {
                            AJDTEventTrace.generalEvent("Failed marker deletion: resource=" + iResource.getLocation());
                            throw resourceException;
                        }
                    }
                    IProject iProject = Builder.getLastBuildTarget();
                    Iterator iterator2 = problems.iterator();
                    ProblemTracker problemTracker = null;
                    while (iterator2.hasNext()) {
                        problemTracker = (ProblemTracker)iterator2.next();
                        iResource = null;
                        IMarker iMarker = null;
                        try {
                            int n;
                            if (problemTracker.location != null) {
                                iResource = CompilerMonitor.this.locationToResource(problemTracker.location, iProject);
                                n = CompilerMonitor.this.getTaskPriority(problemTracker);
                                if (n != -1) {
                                    iMarker = iResource.createMarker("org.eclipse.core.resources.taskmarker");
                                    iMarker.setAttribute("priority", n);
                                } else {
                                    iMarker = problemTracker.declaredErrorOrWarning ? iResource.createMarker("org.eclipse.ajdt.ui.problemmarker") : iResource.createMarker("org.eclipse.core.resources.problemmarker");
                                }
                                if (!iResource.getProject().equals(iProject)) {
                                    CompilerMonitor.this.addOtherProjectMarker(iProject, iMarker);
                                }
                                if (problemTracker.location.getLine() > 0) {
                                    iMarker.setAttribute("lineNumber", (Object)new Integer(problemTracker.location.getLine()));
                                }
                                if (problemTracker.location.getColumn() > 0) {
                                    // empty if block
                                }
                            } else {
                                iMarker = iProject.createMarker("org.eclipse.core.resources.problemmarker");
                            }
                            CompilerMonitor.this.setSeverity(iMarker, problemTracker.kind);
                            if (problemTracker.extraLocs != null && problemTracker.extraLocs.size() > 0) {
                                n = 0;
                                Iterator iterator3 = problemTracker.extraLocs.iterator();
                                while (iterator3.hasNext()) {
                                    ISourceLocation iSourceLocation = (ISourceLocation)iterator3.next();
                                    iMarker.setAttribute("relatedLocations-" + n++, (Object)(iSourceLocation.getSourceFile().getAbsolutePath() + ":::" + iSourceLocation.getLine() + ":::" + iSourceLocation.getEndLine() + ":::" + iSourceLocation.getColumn()));
                                }
                            }
                            CompilerMonitor.this.setMessage(iMarker, problemTracker.message);
                        }
                        catch (ResourceException resourceException) {
                            AJDTEventTrace.generalEvent("Failed marker creation: resource=" + problemTracker.location.getSourceFile().getPath() + " line=" + problemTracker.location.getLine() + " message=" + problemTracker.message);
                            throw resourceException;
                        }
                    }
                    CompilerMonitor.this.clearTasks();
                }
                catch (Exception exception) {
                    AspectJPlugin.getDefault().getErrorHandler().handleError("Error creating marker", exception);
                }
            }
        };
        try {
            AspectJPlugin.getWorkspace().run(iWorkspaceRunnable, null);
        }
        catch (CoreException coreException) {
            AspectJPlugin.getDefault().getErrorHandler().handleError("AJDT Error adding problem markers", coreException);
        }
    }

    private void setSeverity(IMarker iMarker, IMessage.Kind kind) throws CoreException {
        if (kind == IMessage.ERROR) {
            iMarker.setAttribute("severity", (Object)new Integer(2));
        } else if (kind == IMessage.WARNING) {
            iMarker.setAttribute("severity", (Object)new Integer(1));
        } else {
            iMarker.setAttribute("severity", (Object)new Integer(0));
        }
    }

    private void setMessage(IMarker iMarker, String string) throws CoreException {
        if (string.indexOf("\":") != -1 && string.indexOf(", at line") != -1) {
            String string2 = string.substring(string.indexOf("\":") + 2);
            string = string2.substring(0, string2.indexOf(", at line"));
        }
        iMarker.setAttribute("message", (Object)string);
    }

    private int getTaskPriority(ProblemTracker problemTracker) {
        if (problemTracker == null) {
            return -1;
        }
        String string = problemTracker.message;
        Preferences preferences = JavaCore.getPlugin().getPluginPreferences();
        String string2 = preferences.getString("org.eclipse.jdt.core.compiler.taskTags");
        String string3 = preferences.getString("org.eclipse.jdt.core.compiler.taskCaseSensitive");
        String string4 = preferences.getString("org.eclipse.jdt.core.compiler.taskPriorities");
        boolean bl = !string3.equals("disabled");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string4, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string5;
            String string6 = stringTokenizer2.nextToken();
            String string7 = stringTokenizer.nextToken();
            if (!(bl ? string.startsWith(string7) : string7.length() <= string.length() && string7.compareToIgnoreCase(string5 = string.substring(0, string7.length())) == 0)) continue;
            return this.getPrioritiyFlag(string6);
        }
        return -1;
    }

    private int getPrioritiyFlag(String string) {
        if (string.equals("NORMAL")) {
            return 1;
        }
        if (string.equals("HIGH")) {
            return 2;
        }
        return 0;
    }

    private IResource locationToResource(ISourceLocation iSourceLocation, IProject iProject) {
        IResource iResource = null;
        String string = iSourceLocation.getSourceFile().getPath();
        iResource = AspectJPlugin.getDefault().getAjdtProjectProperties().findResource(string, iProject);
        if (iResource == null) {
            iResource = AspectJPlugin.getDefault().getAjdtProjectProperties().findResource(string);
            if (iResource == null) {
                iResource = this.tryToFindResource(string);
            }
            if (iResource == null) {
                AJDTEventTrace.generalEvent("Whilst adding post compilation markers to resources, cannot locate valid eclipse resource for file " + string);
            }
        }
        return iResource;
    }

    private IResource tryToFindResource(String string) {
        IProject iProject = null;
        String string2 = string.replace('\\', '/');
        IProject iProject2 = AspectJPlugin.getDefault().getCurrentProject();
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject2);
        try {
            IClasspathEntry[] iClasspathEntryArray = iJavaProject.getResolvedClasspath(false);
            for (int i = 0; i < iClasspathEntryArray.length; ++i) {
                IResource[] iResourceArray;
                IPath iPath;
                IClasspathEntry iClasspathEntry = iClasspathEntryArray[i];
                if (iClasspathEntry.getEntryKind() == 3) {
                    iPath = iClasspathEntry.getPath();
                    iPath = iPath.removeFirstSegments(1);
                    iResourceArray = new IResource[]{iProject2.findMember(iPath)};
                    iProject = this.findFile(iResourceArray, string2);
                    if (iProject == null) continue;
                    break;
                }
                if (iClasspathEntry.getEntryKind() != 2) continue;
                iPath = iClasspathEntry.getPath();
                iResourceArray = AspectJPlugin.getWorkspace().getRoot().findMember(iPath);
                iProject = this.findFile(new IResource[]{iResourceArray}, string2);
            }
        }
        catch (JavaModelException javaModelException) {
            String string3 = AspectJPlugin.getResourceString("jmCoreException");
            Status status = new Status(4, "org.eclipse.ajdt.ui", 0, string3, (Throwable)javaModelException);
            Shell shell = AspectJPlugin.getDefault().getActiveWorkbenchWindow().getShell();
            ErrorDialog.openError((Shell)shell, (String)AspectJPlugin.getResourceString("ajErrorDialogTitle"), (String)string3, (IStatus)status);
        }
        if (iProject == null) {
            iProject = iProject2;
        }
        return iProject;
    }

    private IResource findFile(IResource[] iResourceArray, String string) {
        IResource iResource = null;
        try {
            for (int i = 0; i < iResourceArray.length; ++i) {
                IResource iResource2 = iResourceArray[i];
                if (iResource2.getFullPath().toString().endsWith(string)) {
                    iResource = iResource2;
                } else if (!(iResource2 instanceof IContainer) || (iResource = this.findFile(((IContainer)iResource2).members(), string)) == null) {
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return iResource;
    }

    private void addOtherProjectMarker(IProject iProject, IMarker iMarker) {
        if (!otherProjectMarkers.containsKey(iProject.getName())) {
            otherProjectMarkers.put(iProject.getName(), new ArrayList());
        }
        List list = (List)otherProjectMarkers.get(iProject.getName());
        list.add(iMarker);
    }

    public static void clearOtherProjectMarkers(IProject iProject) {
        List list = (List)otherProjectMarkers.get(iProject.getName());
        if (list != null) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                IMarker iMarker = (IMarker)listIterator.next();
                try {
                    iMarker.delete();
                }
                catch (CoreException coreException) {}
            }
            list.clear();
        }
    }

    public void addSourcelineTask(IMessage iMessage) {
        if (iMessage.getSourceLocation() == null) {
            this.addProjectTask(iMessage.getMessage(), iMessage.getKind());
        } else {
            problems.add(new ProblemTracker(iMessage.getMessage(), iMessage.getSourceLocation(), iMessage.getKind(), iMessage.getDeclared(), iMessage.getExtraSourceLocations()));
        }
    }

    public boolean hasWarning() {
        return false;
    }

    class ProblemTracker {
        public ISourceLocation location;
        public String message;
        public IMessage.Kind kind;
        public boolean declaredErrorOrWarning = false;
        public List extraLocs;

        public ProblemTracker(String string, ISourceLocation iSourceLocation, IMessage.Kind kind) {
            this(string, iSourceLocation, kind, false, null);
        }

        public ProblemTracker(String string, ISourceLocation iSourceLocation, IMessage.Kind kind, boolean bl, List list) {
            this.location = iSourceLocation;
            this.message = string;
            this.kind = kind;
            this.declaredErrorOrWarning = bl;
            this.extraLocs = list;
        }
    }

    class ProblemAdder
    implements IWorkspaceRunnable {
        private Iterator problemIterator;

        public ProblemAdder(Iterator iterator) {
            this.problemIterator = iterator;
        }

        public void run(IProgressMonitor iProgressMonitor) {
            System.out.println("Adding problem markers");
            while (this.problemIterator.hasNext()) {
                ProblemTracker problemTracker = (ProblemTracker)this.problemIterator.next();
                IResource iResource = null;
                if (problemTracker.location == null) continue;
                String string = problemTracker.location.getSourceFile().getAbsolutePath();
                iResource = AspectJPlugin.getDefault().getAjdtProjectProperties().findResource(string);
                if (iResource == null) {
                    iResource = AspectJPlugin.getDefault().getCurrentProject();
                }
                try {
                    IMarker iMarker = iResource.createMarker("org.eclipse.core.resources.problemmarker");
                    if (problemTracker.location.getLine() > 0) {
                        iMarker.setAttribute("lineNumber", problemTracker.location.getLine());
                    }
                    if (problemTracker.location.getColumn() > 0) {
                        // empty if block
                    }
                    if (problemTracker.kind == IMessage.ERROR) {
                        iMarker.setAttribute("severity", 2);
                    } else if (problemTracker.kind == IMessage.WARNING) {
                        iMarker.setAttribute("severity", 1);
                    } else {
                        iMarker.setAttribute("severity", 0);
                    }
                    if (problemTracker.message.indexOf("\":") != -1 && problemTracker.message.indexOf(", at line") != -1) {
                        String string2 = problemTracker.message.substring(problemTracker.message.indexOf("\":") + 2);
                        string2 = string2.substring(0, string2.indexOf(", at line"));
                        iMarker.setAttribute("message", (Object)string2);
                        continue;
                    }
                    iMarker.setAttribute("message", (Object)problemTracker.message);
                }
                catch (Exception exception) {
                    AspectJPlugin.getDefault().getErrorHandler().handleError("Error creating marker", exception);
                }
            }
            CompilerMonitor.this.clearTasks();
        }
    }
}

