/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.ajde;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.ProjectPropertiesAdapter;
import org.eclipse.ajdt.buildconfigurator.BuildConfiguration;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator;
import org.eclipse.ajdt.internal.ui.ajde.RuntimeClasspathCalculator;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

public class ProjectProperties
implements ProjectPropertiesAdapter {
    private static final String AJDE_VERSION_KEY = "ajde.version";
    private static final String AJDE_DEV = "@AJDEVERSION@";
    private static final String AJDE_VERSION_DEV = "9.9.9";
    private Hashtable fileToResourceHt = null;
    private String aspectjrtPath = null;
    public static final FilenameFilter ASPECTJ_SOURCE_FILTER = new FilenameFilter(){

        public boolean accept(String string) {
            return string.endsWith(".java") || string.endsWith(".aj");
        }
    };
    public static final FilenameFilter RESOURCE_FILTER = new FilenameFilter(){

        public boolean accept(String string) {
            return !string.endsWith(".java") && !string.endsWith(".aj") && !string.endsWith(".class");
        }
    };
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

    public String getAjcWorkingDir() {
        return AspectJPlugin.getWorkspace().getRoot().getLocation().toOSString();
    }

    public String getOutputPath() {
        try {
            IProject iProject = AspectJPlugin.getDefault().getCurrentProject();
            IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
            IPath iPath = iJavaProject.getOutputLocation();
            if (iPath.segmentCount() == 1) {
                return iJavaProject.getResource().getLocation().toOSString();
            }
            IFolder iFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(iPath);
            return iFolder.getLocation().toOSString();
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
            Ajde.getDefault().getErrorHandler().handleError(AspectJPlugin.getResourceString("noOutputDir"), (Throwable)coreException);
            return null;
        }
    }

    public String getProjectName() {
        return AspectJPlugin.getDefault().getCurrentProject().getName();
    }

    public String getClassToExecute() {
        System.err.println("*** AJ Plugin: ProjectProperties.getClassToExecute NOT IMPLEMENTED ***");
        return null;
    }

    public String getRootProjectDir() {
        IProject iProject = AspectJPlugin.getDefault().getCurrentProject();
        return iProject.getLocation().toOSString();
    }

    public List getProjectSourceFiles() {
        IProject iProject = AspectJPlugin.getDefault().getCurrentProject();
        return this.getProjectSourceFiles(iProject, ASPECTJ_SOURCE_FILTER);
    }

    public List getProjectSourceFiles(IProject iProject, FilenameFilter filenameFilter) {
        ProjectBuildConfigurator projectBuildConfigurator = BuildConfigurator.getBuildConfigurator().getProjectBuildConfigurator(iProject);
        if (projectBuildConfigurator != null) {
            return projectBuildConfigurator.getActiveBuildConfiguration().getIncludedJavaFiles(filenameFilter);
        }
        return new ArrayList(0);
    }

    public String getProjectSourcePath() {
        IProject iProject = AspectJPlugin.getDefault().getCurrentProject();
        return iProject.getLocation().toOSString();
    }

    public String getClasspath() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            IProject iProject = AspectJPlugin.getDefault().getCurrentProject();
            IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
            IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = JavaRuntime.computeUnresolvedRuntimeClasspath((IJavaProject)iJavaProject);
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = 0; i < iRuntimeClasspathEntryArray.length; ++i) {
                IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray2 = RuntimeClasspathCalculator.resolveRuntimeClasspathEntry(iRuntimeClasspathEntryArray[i], iJavaProject);
                for (int j = 0; j < iRuntimeClasspathEntryArray2.length; ++j) {
                    hashSet.add(iRuntimeClasspathEntryArray2[j].getLocation());
                }
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next());
                stringBuffer.append(File.pathSeparator);
            }
        }
        catch (CoreException coreException) {
            System.out.println((Object)coreException);
        }
        if (AspectJPlugin.isDebugging) {
            System.out.println("Using classpath: " + stringBuffer);
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void getJavaProjectClasspath(IProject iProject, Set set, Set set2, boolean bl) throws CoreException {
        String string = File.separator + iProject.getName();
        String string2 = iProject.getLocation().removeLastSegments(1).toOSString();
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        String string3 = iJavaProject.getOutputLocation().toOSString();
        if (bl) {
            set.add(string2 + string3);
        }
        IClasspathEntry[] iClasspathEntryArray = iJavaProject.getResolvedClasspath(false);
        int n = 0;
        while (true) {
            block10: {
                if (n >= iClasspathEntryArray.length) {
                    return;
                }
                String string4 = iClasspathEntryArray[n].getPath().toOSString();
                if (!bl || iClasspathEntryArray[n].isExported()) {
                    switch (iClasspathEntryArray[n].getEntryKind()) {
                        case 1: {
                            if (string4 == null || !string4.startsWith(string)) break;
                            string4 = string2 + string4;
                            break;
                        }
                        case 2: {
                            String string5 = iClasspathEntryArray[n].getPath().lastSegment();
                            IProject iProject2 = AspectJPlugin.getWorkspace().getRoot().getProject(string5);
                            if (iProject2.exists() && iProject2.isOpen() && iProject2.hasNature("org.eclipse.jdt.core.javanature") && !set2.contains(iProject2)) {
                                set2.add(iProject2);
                                this.getJavaProjectClasspath(iProject2, set, set2, true);
                            }
                            break block10;
                        }
                        case 3: {
                            string4 = string2 + string4;
                        }
                    }
                    set.add(string4);
                }
            }
            ++n;
        }
    }

    public String getBootClasspath() {
        return null;
    }

    public String getExecutionArgs() {
        String string = AspectJPreferences.getCompilerOptions();
        return string;
    }

    public String getVmArgs() {
        return null;
    }

    public void clearMarkers(boolean bl) {
        IProject iProject = AspectJPlugin.getDefault().getCurrentProject();
        try {
            iProject.deleteMarkers("org.eclipse.core.resources.problemmarker", true, bl ? 2 : 0);
            iProject.deleteMarkers("org.eclipse.core.resources.taskmarker", true, bl ? 2 : 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public IResource findResource(String string) {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        Path path = new Path(string);
        return iWorkspaceRoot.getFileForLocation((IPath)path);
    }

    public IResource findResource(String string, IProject iProject) {
        Path path;
        IPath iPath;
        IPath iPath2;
        IJavaProject iJavaProject;
        String string2 = string.replace('\\', '/');
        try {
            iJavaProject = JavaCore.create((IProject)iProject);
            iPath2 = iJavaProject.getRawClasspath();
            for (int i = 0; i < ((IPath)iPath2).length; ++i) {
                String string3;
                Path path2;
                IFolder iFolder;
                IResource iResource;
                IPath iPath3;
                iPath = iPath2[i];
                if (iPath.getEntryKind() != 3 || !(iPath3 = iPath.getPath()).segment(0).equals(iProject.getName()) || !((iResource = iProject.findMember(iPath3.removeFirstSegments(1))) instanceof IFolder ? string2.startsWith((iFolder = (IFolder)iResource).getLocation().toString()) && iFolder.exists((IPath)(path2 = new Path(string3 = string2.substring(iFolder.getLocation().toString().length())))) : iResource instanceof IProject && string2.startsWith((iFolder = (IProject)iResource).getLocation().toString()) && iFolder.exists((IPath)(path2 = new Path(string3 = string2.substring(iFolder.getLocation().toString().length())))))) continue;
                return iFolder.findMember((IPath)path2);
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        if ((iPath2 = (iJavaProject = ResourcesPlugin.getWorkspace().getRoot()).getLocation()).isPrefixOf((IPath)(path = new Path(string)))) {
            path = path.removeFirstSegments(iPath2.segmentCount());
        }
        iPath = iProject.findMember((IPath)path);
        return iPath;
    }

    public String getAspectjrtClasspath() {
        if (this.aspectjrtPath == null) {
            URL uRL;
            URL uRL2;
            StringBuffer stringBuffer = new StringBuffer();
            Bundle bundle = Platform.getBundle((String)"org.aspectj.ajde");
            String string = null;
            if (bundle != null) {
                uRL2 = bundle.getEntry("/");
                uRL = null;
                try {
                    uRL = Platform.resolve((URL)uRL2);
                    string = uRL.toExternalForm();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (string != null && string.startsWith("file:")) {
                stringBuffer.append(string.substring("file:".length()));
                stringBuffer.append("aspectjrt.jar");
            }
            if (new File(stringBuffer.toString()).exists()) {
                this.aspectjrtPath = stringBuffer.toString();
            } else {
                uRL2 = AspectJPlugin.getWorkspace().getRoot().getLocation();
                uRL = uRL2.removeLastSegments(1);
                stringBuffer = new StringBuffer().append(uRL.toOSString());
                stringBuffer.append(File.separator);
                stringBuffer.append("workspace");
                stringBuffer.append(File.separator);
                stringBuffer.append("org.aspectj.ajde");
                stringBuffer.append(File.separator);
                stringBuffer.append("aspectjrt.jar");
                if (new File(stringBuffer.toString()).exists()) {
                    this.aspectjrtPath = stringBuffer.toString();
                }
            }
        }
        return this.aspectjrtPath;
    }

    private void getAllFiles(IResource[] iResourceArray, List list, Hashtable hashtable, FilenameFilter filenameFilter, BuildConfiguration buildConfiguration) {
        try {
            for (int i = 0; i < iResourceArray.length; ++i) {
                IResource iResource = iResourceArray[i];
                if (iResource instanceof IContainer) {
                    this.getAllFiles(((IContainer)iResource).members(), list, hashtable, filenameFilter, buildConfiguration);
                    continue;
                }
                if (!filenameFilter.accept(iResource.getName()) || !buildConfiguration.isIncluded(iResource)) continue;
                list.add(new File(iResource.getLocation().toOSString()));
                if (hashtable == null) continue;
                hashtable.put(new File(iResource.getLocation().toOSString()), iResource);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void getProjectRelativePaths(IResource[] iResourceArray, List list, FilenameFilter filenameFilter, int n) {
        try {
            for (int i = 0; i < iResourceArray.length; ++i) {
                IResource iResource = iResourceArray[i];
                if (iResource instanceof IContainer) {
                    this.getProjectRelativePaths(((IContainer)iResource).members(), list, filenameFilter, n);
                    continue;
                }
                if (!filenameFilter.accept(iResource.getName())) continue;
                String[] stringArray = iResource.getProjectRelativePath().segments();
                String string = "";
                for (int j = n; j < stringArray.length; ++j) {
                    string = string + stringArray[j];
                    if (j >= stringArray.length - 1) continue;
                    string = string + '/';
                }
                list.add(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public List getBuildConfigFiles() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = AspectJPlugin.getDefault().getListOfConfigFilesForCurrentProject();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IResource iResource = (IResource)iterator.next();
            arrayList.add(iResource.getFullPath().toOSString());
        }
        return arrayList;
    }

    public String getDefaultBuildConfigFile() {
        String string = AspectJPlugin.getDefault().getCurrentProject().getLocation().toOSString() + File.separator + ".generated.lst";
        return string;
    }

    public String getLastActiveBuildConfigFile() {
        String string = AspectJPlugin.getBuildConfigurationFile(AspectJPlugin.getDefault().getCurrentProject());
        return string;
    }

    public Set getInJars() {
        return AspectJPlugin.getDefault().getAjdtBuildOptionsAdapter().getInJars();
    }

    public Map getSourcePathResources() {
        IProject iProject = AspectJPlugin.getDefault().getCurrentProject();
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        HashMap<String, File> hashMap = new HashMap<String, File>();
        try {
            String string;
            IClasspathEntry[] iClasspathEntryArray = iJavaProject.getResolvedClasspath(false);
            IPath iPath = iJavaProject.getOutputLocation();
            if (iPath.segmentCount() == 1) {
                string = iJavaProject.getResource().getLocation().toOSString();
            } else {
                IFolder iFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(iPath);
                string = iFolder.getLocation().toOSString();
            }
            for (int i = 0; i < iClasspathEntryArray.length; ++i) {
                if (iClasspathEntryArray[i].getEntryKind() != 3) continue;
                IClasspathEntry iClasspathEntry = iClasspathEntryArray[i];
                IPath iPath2 = iClasspathEntry.getPath();
                ArrayList arrayList = new ArrayList();
                iPath2 = iPath2.removeFirstSegments(1);
                IResource[] iResourceArray = new IResource[]{iProject.findMember(iPath2)};
                this.getProjectRelativePaths(iResourceArray, arrayList, RESOURCE_FILTER, iResourceArray[0].getFullPath().segmentCount() - 1);
                ArrayList arrayList2 = this.getLinkedChildFolders(iResourceArray[0]);
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    String string3 = this.getResourceFullPath(iResourceArray[0], string2, arrayList2);
                    if (string3.startsWith(string) || string2.endsWith(".classpath") || string2.endsWith(".project") || string2.endsWith(".ajsym") || string2.endsWith(".lst")) continue;
                    File file = new File(string3);
                    hashMap.put(string2, file);
                }
            }
        }
        catch (JavaModelException javaModelException) {
            String string = AspectJPlugin.getResourceString("jmCoreException");
            Status status = new Status(4, "org.eclipse.ajdt.ui", 0, string, (Throwable)javaModelException);
            Shell shell = AspectJPlugin.getDefault().getActiveWorkbenchWindow().getShell();
            ErrorDialog.openError((Shell)shell, (String)AspectJPlugin.getResourceString("ajErrorDialogTitle"), (String)string, (IStatus)status);
        }
        return hashMap;
    }

    public boolean getIncrementalMode() {
        return AspectJPlugin.getDefault().getAjdtBuildOptionsAdapter().getIncrementalMode();
    }

    public String getOutJar() {
        return AspectJPlugin.getDefault().getAjdtBuildOptionsAdapter().getOutJar();
    }

    public Set getSourceRoots() {
        return AspectJPlugin.getDefault().getAjdtBuildOptionsAdapter().getSourceRoots();
    }

    public Set getAspectPath() {
        return AspectJPlugin.getDefault().getAjdtBuildOptionsAdapter().getAspectPath();
    }

    private ArrayList getLinkedChildFolders(IResource iResource) {
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        if (iResource instanceof IContainer) {
            try {
                IResource[] iResourceArray = ((IContainer)iResource).members();
                for (int i = 0; i < iResourceArray.length; ++i) {
                    try {
                        Method method = (class$org$eclipse$core$resources$IResource == null ? ProjectProperties.class$("org.eclipse.core.resources.IResource") : class$org$eclipse$core$resources$IResource).getDeclaredMethod("isLinked", new Class[0]);
                        boolean bl = (Boolean)method.invoke((Object)iResourceArray[i], new Object[0]);
                        if (!(iResourceArray[i] instanceof IFolder) || !bl) continue;
                        arrayList.add(iResourceArray[i]);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
        }
        return arrayList;
    }

    private String getResourceFullPath(IResource iResource, String string, ArrayList arrayList) {
        String string2 = null;
        if (string.lastIndexOf(47) != -1) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                IFolder iFolder = (IFolder)iterator.next();
                String string3 = iFolder.getName();
                if (string.indexOf(string3 + "/") != 0) continue;
                string2 = iFolder.getLocation().toString() + string.substring(string3.length());
                string2 = string2.replace('/', File.separatorChar);
                break;
            }
        }
        if (string2 == null) {
            string2 = iResource.getLocation().toOSString() + File.separator + string;
        }
        return string2;
    }

    public Set getInpath() {
        return AspectJPlugin.getDefault().getAjdtBuildOptionsAdapter().getInPath();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface FilenameFilter {
        public boolean accept(String var1);
    }
}

