/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.aspectj.ajde.Ajde;
import org.aspectj.asm.IHierarchy;
import org.aspectj.asm.IProgramElement;
import org.eclipse.ajdt.buildconfigurator.BuildConfiguration;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionDelegateHelper;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.ManageBreakpointRulerAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;

public class AspectJBreakpointRulerAction
extends Action {
    private IVerticalRulerInfo fRuler;
    private ITextEditor fTextEditor;
    private IEditorStatusLine fStatusLine;
    static /* synthetic */ Class class$org$eclipse$ui$texteditor$IEditorStatusLine;

    public AspectJBreakpointRulerAction(IVerticalRulerInfo iVerticalRulerInfo, ITextEditor iTextEditor, IEditorPart iEditorPart) {
        super(ActionMessages.getString((String)"ManageBreakpointRulerAction.label"));
        this.fRuler = iVerticalRulerInfo;
        this.fTextEditor = iTextEditor;
        this.fStatusLine = (IEditorStatusLine)iEditorPart.getAdapter(class$org$eclipse$ui$texteditor$IEditorStatusLine == null ? (class$org$eclipse$ui$texteditor$IEditorStatusLine = AspectJBreakpointRulerAction.class$("org.eclipse.ui.texteditor.IEditorStatusLine")) : class$org$eclipse$ui$texteditor$IEditorStatusLine);
    }

    public void dispose() {
        this.fTextEditor = null;
        this.fRuler = null;
    }

    protected IVerticalRulerInfo getVerticalRulerInfo() {
        return this.fRuler;
    }

    protected ITextEditor getTextEditor() {
        return this.fTextEditor;
    }

    protected IDocument getDocument() {
        IDocumentProvider iDocumentProvider = this.fTextEditor.getDocumentProvider();
        return iDocumentProvider.getDocument((Object)this.fTextEditor.getEditorInput());
    }

    boolean containsAspect(IProgramElement iProgramElement) {
        if (iProgramElement.getKind().equals(IProgramElement.Kind.ASPECT)) {
            return true;
        }
        List list = iProgramElement.getChildren();
        if (list != null && list.size() > 0) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                if (!this.containsAspect((IProgramElement)iterator.next())) continue;
                return true;
            }
        }
        return false;
    }

    boolean isInAspect(IProgramElement iProgramElement) {
        if (iProgramElement.getKind().equals(IProgramElement.Kind.ASPECT)) {
            return true;
        }
        IProgramElement iProgramElement2 = iProgramElement.getParent();
        if (iProgramElement2 != null) {
            return this.isInAspect(iProgramElement2);
        }
        return false;
    }

    boolean isBreakpointable(IProgramElement iProgramElement) {
        return iProgramElement.getKind().equals(IProgramElement.Kind.ADVICE) || iProgramElement.getKind().equals(IProgramElement.Kind.METHOD) || iProgramElement.getKind().equals(IProgramElement.Kind.CODE) || iProgramElement.getKind().equals(IProgramElement.Kind.CONSTRUCTOR) || iProgramElement.getKind().equals(IProgramElement.Kind.INITIALIZER) || iProgramElement.getKind().equals(IProgramElement.Kind.INTER_TYPE_CONSTRUCTOR) || iProgramElement.getKind().equals(IProgramElement.Kind.INTER_TYPE_METHOD) || iProgramElement.getKind().equals(IProgramElement.Kind.INTER_TYPE_FIELD) || iProgramElement.getKind().equals(IProgramElement.Kind.FIELD);
    }

    public String getQualifiedMainClassName(IProgramElement iProgramElement) {
        String string = iProgramElement.getPackageName();
        IProgramElement iProgramElement2 = iProgramElement.getParent();
        while (iProgramElement2.getKind() != IProgramElement.Kind.PACKAGE) {
            iProgramElement = iProgramElement2;
            iProgramElement2 = iProgramElement2.getParent();
        }
        String string2 = iProgramElement.getName();
        string2 = string2.substring(0, string2.lastIndexOf(46));
        if ("".equals(string)) {
            return string2;
        }
        return string + "." + string2;
    }

    public void run() {
        try {
            List list = this.getMarkers();
            if (list.isEmpty()) {
                Object object;
                int n = this.getVerticalRulerInfo().getLineOfLastMouseButtonActivity() + 1;
                if (n >= this.getDocument().getNumberOfLines()) {
                    return;
                }
                IResource iResource = this.getResource();
                IHierarchy iHierarchy = Ajde.getDefault().getStructureModelManager().getHierarchy();
                IProgramElement iProgramElement = iHierarchy.findElementForSourceLine(iResource.getLocation().toOSString(), n);
                if (iProgramElement.getParent() == null) {
                    BuildConfiguration buildConfiguration;
                    object = BuildConfigurator.getBuildConfigurator().getProjectBuildConfigurator(iResource.getProject());
                    if (object != null && (buildConfiguration = ((ProjectBuildConfigurator)object).getActiveBuildConfiguration()) != null && !buildConfiguration.isIncluded(iResource)) {
                        this.report(AspectJPlugin.getResourceString("breakpoint.fileExcluded"));
                        return;
                    }
                } else {
                    IProgramElement iProgramElement2;
                    if (!this.isInAspect(iProgramElement)) {
                        new ManageBreakpointRulerAction(this.fRuler, this.fTextEditor).run();
                        return;
                    }
                    while (!this.isBreakpointable(iProgramElement) && n < this.getDocument().getNumberOfLines()) {
                        iProgramElement = iHierarchy.findElementForSourceLine(iResource.getLocation().toOSString(), ++n);
                    }
                    object = iProgramElement.getBytecodeName();
                    if (object != null && !((String)object).equals((iProgramElement2 = iHierarchy.findElementForSourceLine(iResource.getLocation().toOSString(), n - 1)).getBytecodeName()) && n < this.getDocument().getNumberOfLines() && ((String)object).equals((iProgramElement2 = iHierarchy.findElementForSourceLine(iResource.getLocation().toOSString(), n + 1)).getBytecodeName())) {
                        ++n;
                    }
                }
                object = this.getQualifiedMainClassName(iProgramElement);
                AJDTEventTrace.generalEvent("creating breakpoint in " + (String)object);
                JDIDebugModel.createLineBreakpoint((IResource)this.getResource(), (String)object, (int)n, (int)-1, (int)-1, (int)0, (boolean)true, new HashMap(10));
            } else {
                IBreakpointManager iBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    IMarker iMarker = (IMarker)iterator.next();
                    IBreakpoint iBreakpoint = iBreakpointManager.getBreakpoint(iMarker);
                    if (iBreakpoint == null) continue;
                    iBreakpoint.delete();
                }
            }
        }
        catch (CoreException coreException) {
            JDIDebugUIPlugin.errorDialog((String)ActionMessages.getString((String)"ManageBreakpointRulerAction.error.adding.message1"), (Throwable)coreException);
        }
    }

    protected IType getType(ITextSelection iTextSelection) {
        IMember iMember = ActionDelegateHelper.getDefault().getCurrentMember(iTextSelection);
        IType iType = null;
        if (iMember instanceof IType) {
            iType = (IType)iMember;
        } else if (iMember != null) {
            iType = iMember.getDeclaringType();
        }
        try {
            while (iType != null && !iType.isBinary() && iType.isLocal()) {
                iType = iType.getDeclaringType();
            }
        }
        catch (JavaModelException javaModelException) {
            JDIDebugUIPlugin.log((Throwable)javaModelException);
        }
        return iType;
    }

    protected IResource getResource() {
        IFile iFile = null;
        IEditorInput iEditorInput = this.fTextEditor.getEditorInput();
        if (iEditorInput instanceof IFileEditorInput) {
            iFile = ((IFileEditorInput)iEditorInput).getFile();
        }
        return iFile;
    }

    protected List getMarkers() {
        ArrayList<IMarker> arrayList = new ArrayList<IMarker>();
        IResource iResource = this.getResource();
        IDocument iDocument = this.getDocument();
        AbstractMarkerAnnotationModel abstractMarkerAnnotationModel = this.getAnnotationModel();
        if (abstractMarkerAnnotationModel != null) {
            try {
                IWorkspaceRoot iWorkspaceRoot;
                IMarker[] iMarkerArray = null;
                if (iResource instanceof IFile) {
                    iMarkerArray = iResource.findMarkers(IBreakpoint.BREAKPOINT_MARKER, true, 2);
                } else {
                    iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                    iMarkerArray = iWorkspaceRoot.findMarkers(IBreakpoint.BREAKPOINT_MARKER, true, 2);
                }
                if (iMarkerArray != null) {
                    iWorkspaceRoot = DebugPlugin.getDefault().getBreakpointManager();
                    for (int i = 0; i < iMarkerArray.length; ++i) {
                        IBreakpoint iBreakpoint = iWorkspaceRoot.getBreakpoint(iMarkerArray[i]);
                        if (iBreakpoint == null || !iWorkspaceRoot.isRegistered(iBreakpoint) || !this.includesRulerLine(abstractMarkerAnnotationModel.getMarkerPosition(iMarkerArray[i]), iDocument)) continue;
                        arrayList.add(iMarkerArray[i]);
                    }
                }
            }
            catch (CoreException coreException) {
                JDIDebugUIPlugin.log((IStatus)coreException.getStatus());
            }
        }
        return arrayList;
    }

    protected AbstractMarkerAnnotationModel getAnnotationModel() {
        IDocumentProvider iDocumentProvider = this.fTextEditor.getDocumentProvider();
        IAnnotationModel iAnnotationModel = iDocumentProvider.getAnnotationModel((Object)this.fTextEditor.getEditorInput());
        if (iAnnotationModel instanceof AbstractMarkerAnnotationModel) {
            return (AbstractMarkerAnnotationModel)iAnnotationModel;
        }
        return null;
    }

    protected boolean includesRulerLine(Position position, IDocument iDocument) {
        if (position != null) {
            try {
                int n = iDocument.getLineOfOffset(position.getOffset());
                int n2 = this.fRuler.getLineOfLastMouseButtonActivity();
                if (n2 == n) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return false;
    }

    protected void report(final String string) {
        JDIDebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                if (AspectJBreakpointRulerAction.this.fStatusLine != null) {
                    AspectJBreakpointRulerAction.this.fStatusLine.setMessage(true, string, null);
                }
                if (string != null && JDIDebugUIPlugin.getActiveWorkbenchShell() != null) {
                    Display.getCurrent().beep();
                }
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

