/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ajdt.internal.ui.editor.DotWordRule;
import org.eclipse.jdt.internal.ui.text.AbstractJavaScanner;
import org.eclipse.jdt.internal.ui.text.JavaWhitespaceDetector;
import org.eclipse.jdt.internal.ui.text.JavaWordDetector;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.jface.util.PropertyChangeEvent;

public final class AspectJCodeScanner
extends AbstractJavaScanner {
    private static final String SOURCE_VERSION = "org.eclipse.jdt.core.compiler.source";
    private static String[] fgKeywords = new String[]{"abstract", "break", "case", "catch", "class", "const", "continue", "default", "do", "else", "extends", "final", "finally", "for", "goto", "if", "implements", "import", "instanceof", "interface", "native", "new", "package", "private", "protected", "public", "return", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "volatile", "while"};
    private static String[] ajKeywords = new String[]{"aspect", "pointcut", "privileged", "call", "execution", "initialization", "preinitialization", "handler", "get", "set", "staticinitialization", "target", "args", "within", "withincode", "cflow", "cflowbelow", "before", "after", "around", "proceed", "throwing", "returning", "adviceexecution", "declare", "parents", "warning", "error", "soft", "precedence", "thisJoinPoint", "thisJoinPointStaticPart", "thisEnclosingJoinPointStaticPart", "issingleton", "perthis", "pertarget", "percflow", "percflowbelow"};
    private static String[] fgNewKeywords = new String[]{"assert"};
    private static String[] fgTypes = new String[]{"void", "boolean", "char", "byte", "short", "strictfp", "int", "long", "float", "double"};
    private static String[] fgConstants = new String[]{"false", "null", "true"};
    private static String[] fgTokenProperties = new String[]{"java_keyword", "java_string", "java_default"};
    private VersionedWordRule fVersionedWordRule;

    public AspectJCodeScanner(IColorManager iColorManager, IPreferenceStore iPreferenceStore) {
        super(iColorManager, iPreferenceStore);
        this.initialize();
    }

    protected String[] getTokenProperties() {
        return fgTokenProperties;
    }

    protected List createRules() {
        int n;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Token token = this.getToken("java_string");
        arrayList.add(new SingleLineRule("\"", "\"", (IToken)token, '\\'));
        arrayList.add(new SingleLineRule("'", "'", (IToken)token, '\\'));
        arrayList.add(new WhitespaceRule((IWhitespaceDetector)new JavaWhitespaceDetector()));
        String string = this.getPreferenceStore().getString(SOURCE_VERSION);
        this.fVersionedWordRule = new VersionedWordRule((IWordDetector)new JavaWordDetector(), "1.4", true, string);
        token = this.getToken("java_keyword");
        for (int i = 0; i < fgNewKeywords.length; ++i) {
            this.fVersionedWordRule.addWord(fgNewKeywords[i], (IToken)token);
        }
        arrayList.add((Object)this.fVersionedWordRule);
        token = this.getToken("java_default");
        WordRule wordRule = new WordRule((IWordDetector)new JavaWordDetector(), (IToken)token);
        DotWordRule dotWordRule = new DotWordRule((IWordDetector)new JavaWordDetector());
        token = this.getToken("java_keyword");
        for (n = 0; n < fgKeywords.length; ++n) {
            wordRule.addWord(fgKeywords[n], (IToken)token);
        }
        for (n = 0; n < fgTypes.length; ++n) {
            wordRule.addWord(fgTypes[n], (IToken)token);
        }
        for (n = 0; n < fgConstants.length; ++n) {
            wordRule.addWord(fgConstants[n], (IToken)token);
        }
        for (n = 0; n < ajKeywords.length; ++n) {
            dotWordRule.addWord(ajKeywords[n], (IToken)token);
        }
        arrayList.add((Object)dotWordRule);
        arrayList.add(wordRule);
        this.setDefaultReturnToken((IToken)this.getToken("java_default"));
        return arrayList;
    }

    public void setRules(IRule[] iRuleArray) {
        int n;
        for (n = 0; n < iRuleArray.length && !iRuleArray[n].equals((Object)this.fVersionedWordRule); ++n) {
        }
        if (n == iRuleArray.length) {
            this.fVersionedWordRule = null;
        }
        super.setRules(iRuleArray);
    }

    public boolean affectsBehavior(PropertyChangeEvent propertyChangeEvent) {
        return propertyChangeEvent.getProperty().equals(SOURCE_VERSION) || super.affectsBehavior(propertyChangeEvent);
    }

    public void adaptToPreferenceChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals(SOURCE_VERSION)) {
            Object object = propertyChangeEvent.getNewValue();
            if (object instanceof String) {
                String string = (String)object;
                if (this.fVersionedWordRule != null) {
                    this.fVersionedWordRule.setCurrentVersion(string);
                }
            }
        } else if (super.affectsBehavior(propertyChangeEvent)) {
            super.adaptToPreferenceChange(propertyChangeEvent);
        }
    }

    private static class VersionedWordRule
    extends WordRule {
        private final String fVersion;
        private final boolean fEnable;
        private String fCurrentVersion;

        public VersionedWordRule(IWordDetector iWordDetector, String string, boolean bl, String string2) {
            super(iWordDetector);
            this.fVersion = string;
            this.fEnable = bl;
            this.fCurrentVersion = string2;
        }

        public void setCurrentVersion(String string) {
            this.fCurrentVersion = string;
        }

        public IToken evaluate(ICharacterScanner iCharacterScanner) {
            IToken iToken = super.evaluate(iCharacterScanner);
            if (this.fEnable) {
                if (this.fCurrentVersion.equals(this.fVersion)) {
                    return iToken;
                }
                return Token.UNDEFINED;
            }
            if (this.fCurrentVersion.equals(this.fVersion)) {
                return Token.UNDEFINED;
            }
            return iToken;
        }
    }
}

