/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.ui.AbstractIcon;
import org.aspectj.ajde.ui.FileStructureView;
import org.aspectj.ajde.ui.IStructureViewNode;
import org.aspectj.ajde.ui.StructureView;
import org.aspectj.ajde.ui.StructureViewManager;
import org.aspectj.ajde.ui.StructureViewProperties;
import org.aspectj.ajde.ui.StructureViewRenderer;
import org.aspectj.asm.IProgramElement;
import org.eclipse.ajdt.internal.builder.Builder;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.internal.core.AJDTStructureViewNode;
import org.eclipse.ajdt.internal.core.AJDTUtils;
import org.eclipse.ajdt.internal.core.resources.AJDTIcon;
import org.eclipse.ajdt.internal.core.resources.AspectJImages;
import org.eclipse.ajdt.internal.ui.editor.AspectJEditor;
import org.eclipse.ajdt.internal.ui.editor.AspectJLabelProvider;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class AspectJContentOutlinePage
extends ContentOutlinePage
implements StructureViewRenderer {
    protected IFile input;
    private static final int RELATIONSHIP_LEVEL = 3;
    private AbstractTextEditor editor;
    private StructureViewProperties viewProperties;
    private StructureViewManager svManager;
    private StructureView view;
    private static String lastLoadedConfigFile = "";
    private boolean outlinePageCreation = true;
    private static List outlinesWithPendingAdviceMarkerUpdates = null;
    private ViewerSorter lexicalSorter;

    public AspectJContentOutlinePage(AbstractTextEditor abstractTextEditor, IFile iFile) {
        this.input = iFile;
        this.editor = abstractTextEditor;
        this.svManager = Ajde.getDefault().getStructureViewManager();
        this.viewProperties = this.svManager.getDefaultViewProperties();
        this.viewProperties.setGranularity(StructureViewProperties.Granularity.DECLARED_ELEMENTS);
        this.lexicalSorter = new LexicalSorter();
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        this.configureHelp();
        this.configureContextMenu();
        this.registerToolbarActions();
        TreeViewer treeViewer = this.getTreeViewer();
        treeViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new AspectJLabelProvider(composite));
        IAdaptable iAdaptable = this.getContentOutline(this.input, true);
        treeViewer.setInput((Object)iAdaptable);
        this.expandTreeView();
    }

    public void update() {
        AJDTEventTrace.generalEvent("Editor Update called: " + this.input.getName());
        this.getControl().setRedraw(false);
        IAdaptable iAdaptable = this.getContentOutline(this.input, true);
        this.getTreeViewer().setInput((Object)iAdaptable);
        this.expandTreeView();
        this.updateAdviceMarkers(true);
        this.getControl().setRedraw(true);
    }

    public void update(StructureView structureView) {
        if (structureView != null && this.view != null && !structureView.toString().equals(this.view.toString())) {
            AJDTEventTrace.generalEvent("Assumption Not True: Old view object:" + structureView.toString() + "  New view object:" + structureView.toString());
        }
        IProject iProject = this.input.getProject();
        IProject iProject2 = Builder.getLastBuildTarget();
        if (this.input.getProject().equals(Builder.getLastBuildTarget())) {
            AJDTEventTrace.modelUpdated(this.input);
            this.view = structureView;
            this.getControl().setRedraw(false);
            AJDTStructureViewNode aJDTStructureViewNode = (AJDTStructureViewNode)structureView.getRootNode();
            this.updateAdviceMarkers(false);
            this.getTreeViewer().setInput((Object)aJDTStructureViewNode);
            this.expandTreeView();
            this.getControl().setRedraw(true);
        }
    }

    public void updateAdviceMarkers(boolean bl) {
        if (outlinesWithPendingAdviceMarkerUpdates == null) {
            outlinesWithPendingAdviceMarkerUpdates = new ArrayList();
        }
        outlinesWithPendingAdviceMarkerUpdates.add(this);
        if (bl) {
            AspectJContentOutlinePage.performPendingAdviceMarkerUpdates();
        }
    }

    public static void performPendingAdviceMarkerUpdates() {
        if (outlinesWithPendingAdviceMarkerUpdates == null) {
            return;
        }
        Iterator iterator = outlinesWithPendingAdviceMarkerUpdates.iterator();
        while (iterator.hasNext()) {
            AspectJContentOutlinePage aspectJContentOutlinePage = (AspectJContentOutlinePage)((Object)iterator.next());
            AJDTStructureViewNode aJDTStructureViewNode = (AJDTStructureViewNode)aspectJContentOutlinePage.view.getRootNode();
            if (!(aspectJContentOutlinePage.editor instanceof AspectJEditor)) continue;
            if (aspectJContentOutlinePage.editor.getEditorInput() != null) {
                ((AspectJEditor)aspectJContentOutlinePage.editor).forceUpdateOfAdviceMarkers();
                continue;
            }
            AJDTEventTrace.generalEvent("INFO message: Compiler made attempt to update outline for a currently (possibly temporarily) non-existent resource: " + aspectJContentOutlinePage.editor.getTitle());
        }
        outlinesWithPendingAdviceMarkerUpdates = null;
    }

    public void updateView(StructureView structureView) {
        AJDTEventTrace.generalEvent("outline updateview called (file:" + this.input.getName() + "): " + structureView.toString());
        final StructureView structureView2 = structureView;
        AspectJPlugin.getDefault().getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    AspectJContentOutlinePage.this.update(structureView2);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    public void setActiveNode(IStructureViewNode iStructureViewNode) {
        TreeViewer treeViewer = this.getTreeViewer();
        treeViewer.setInput((Object)((AJDTStructureViewNode)iStructureViewNode));
    }

    protected void setInput(IFile iFile) {
        this.input = iFile;
    }

    public void dispose() {
        String string = "Unable to unregister with structure view manager";
        if (this.view != null) {
            boolean bl = this.svManager.deleteView(this.view);
            string = "Unregistering with structure view manager.  Successful:" + bl;
        }
        AJDTEventTrace.generalEvent("Outline disposed for file " + this.editor.getTitle() + ": " + string);
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        IStructuredSelection iStructuredSelection;
        Object object;
        super.selectionChanged(selectionChangedEvent);
        if (this.outlinePageCreation) {
            this.outlinePageCreation = false;
            return;
        }
        ISelection iSelection = selectionChangedEvent.getSelection();
        if (iSelection instanceof IStructuredSelection && (object = (iStructuredSelection = (IStructuredSelection)iSelection).getFirstElement()) instanceof AJDTStructureViewNode) {
            AJDTStructureViewNode aJDTStructureViewNode = (AJDTStructureViewNode)object;
            if (this.editor.getEditorInput() instanceof IFileEditorInput) {
                IMarker iMarker = aJDTStructureViewNode.getMarker(((IFileEditorInput)this.editor.getEditorInput()).getFile().getProject());
                if (aJDTStructureViewNode.getStructureNode() != null) {
                    AJDTEventTrace.nodeClicked(aJDTStructureViewNode.getStructureNode().getName(), iMarker);
                    if (iMarker != null) {
                        try {
                            IEditorPart iEditorPart = IDE.openEditor((IWorkbenchPage)AspectJPlugin.getDefault().getActiveWorkbenchWindow().getActivePage(), (IMarker)iMarker, (boolean)false);
                        }
                        catch (PartInitException partInitException) {
                            System.err.println("Doh!" + (Object)((Object)partInitException));
                        }
                    }
                }
            } else {
                AJDTEventTrace.generalEvent("Problem in outline view: Editor input is not a file");
            }
        }
    }

    private IAdaptable getContentOutline(IFile iFile, boolean bl) {
        this.updateActiveConfig();
        String string = AJDTUtils.getResourcePath((IResource)iFile);
        AJDTEventTrace.structureViewRequested(iFile.getName());
        if (this.view != null) {
            this.svManager.deleteView(this.view);
        }
        FileStructureView fileStructureView = this.svManager.createViewForSourceFile(string, this.viewProperties);
        fileStructureView.setRenderer((StructureViewRenderer)this);
        this.view = fileStructureView;
        return (AJDTStructureViewNode)this.view.getRootNode();
    }

    private void updateActiveConfig() {
        IProject iProject = this.input.getProject();
        String string = AspectJPlugin.getBuildConfigurationFile(iProject);
        if (!string.equals(lastLoadedConfigFile)) {
            AJDTEventTrace.buildConfigSelected(string, iProject);
            Ajde.getDefault().getConfigurationManager().setActiveConfigFile(string);
            lastLoadedConfigFile = string;
        }
    }

    private void expandTreeView() {
        TreeViewer treeViewer = this.getTreeViewer();
        treeViewer.collapseAll();
        Tree tree = treeViewer.getTree();
        TreeItem[] treeItemArray = tree.getItems();
        for (int i = 0; i < treeItemArray.length; ++i) {
            TreeItem treeItem = treeItemArray[i];
            AJDTStructureViewNode aJDTStructureViewNode = (AJDTStructureViewNode)treeItem.getData();
            if (!(aJDTStructureViewNode.getStructureNode() instanceof IProgramElement)) continue;
            treeViewer.expandToLevel((Object)aJDTStructureViewNode, 1);
        }
    }

    private void configureHelp() {
    }

    private void configureContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)new Separator("additions-end"));
        TreeViewer treeViewer = this.getTreeViewer();
        Menu menu = menuManager.createContextMenu((Control)treeViewer.getTree());
        treeViewer.getTree().setMenu(menu);
        this.getSite().registerContextMenu("org.eclipse.ajdt.ui.outline", menuManager, (ISelectionProvider)treeViewer);
    }

    public void setActiveNode(IStructureViewNode iStructureViewNode, int n) {
        this.setActiveNode(iStructureViewNode);
    }

    private void registerToolbarActions() {
        IToolBarManager iToolBarManager = this.getSite().getActionBars().getToolBarManager();
        if (iToolBarManager != null) {
            LexicalSortingAction lexicalSortingAction = new LexicalSortingAction();
            iToolBarManager.add((IAction)lexicalSortingAction);
            FilterAction filterAction = new FilterAction(new CategoryFilter(6), AspectJPlugin.getResourceString("JavaOutlinePage.HideFields.label"), AspectJPlugin.getResourceString("JavaOutlinePage.HideFields.description.checked"), AspectJPlugin.getResourceString("JavaOutlinePage.HideFields.description.unchecked"), AspectJPlugin.getResourceString("JavaOutlinePage.HideFields.tooltip.checked"), AspectJPlugin.getResourceString("JavaOutlinePage.HideFields.tooltip.unchecked"), "HideFields.isChecked");
            JavaPluginImages.setLocalImageDescriptors((IAction)filterAction, (String)"fields_co.gif");
            iToolBarManager.add((IAction)filterAction);
            FilterAction filterAction2 = new FilterAction(new StaticFilter(), AspectJPlugin.getResourceString("JavaOutlinePage.HideStaticMembers.label"), AspectJPlugin.getResourceString("JavaOutlinePage.HideStaticMembers.description.checked"), AspectJPlugin.getResourceString("JavaOutlinePage.HideStaticMembers.description.unchecked"), AspectJPlugin.getResourceString("JavaOutlinePage.HideStaticMembers.tooltip.checked"), AspectJPlugin.getResourceString("JavaOutlinePage.HideStaticMembers.tooltip.unchecked"), "HideStaticMembers.isChecked");
            JavaPluginImages.setLocalImageDescriptors((IAction)filterAction2, (String)"static_co.gif");
            iToolBarManager.add((IAction)filterAction2);
            FilterAction filterAction3 = new FilterAction(new VisibilityFilter(), AspectJPlugin.getResourceString("JavaOutlinePage.HideNonePublicMembers.label"), AspectJPlugin.getResourceString("JavaOutlinePage.HideNonePublicMembers.description.checked"), AspectJPlugin.getResourceString("JavaOutlinePage.HideNonePublicMembers.description.unchecked"), AspectJPlugin.getResourceString("JavaOutlinePage.HideNonePublicMembers.tooltip.checked"), AspectJPlugin.getResourceString("JavaOutlinePage.HideNonePublicMembers.tooltip.unchecked"), "HideNonePublicMembers.isChecked");
            JavaPluginImages.setLocalImageDescriptors((IAction)filterAction3, (String)"public_co.gif");
            iToolBarManager.add((IAction)filterAction3);
            FilterAction filterAction4 = new FilterAction(new CategoryFilter(7), AspectJPlugin.getResourceString("AJavaOutlinePage.HidePointcuts.label"), AspectJPlugin.getResourceString("AJavaOutlinePage.HidePointcuts.description.checked"), AspectJPlugin.getResourceString("AJavaOutlinePage.HidePointcuts.description.unchecked"), AspectJPlugin.getResourceString("AJavaOutlinePage.HidePointcuts.tooltip.checked"), AspectJPlugin.getResourceString("AJavaOutlinePage.HidePointcuts.tooltip.unchecked"), "HidePointcuts.isChecked");
            filterAction4.setImageDescriptor(AspectJImages.G_POINTCUT_DEF.getImageDescriptor());
            AbstractIcon abstractIcon = AspectJImages.registry().getIcon(IProgramElement.Kind.POINTCUT);
            filterAction4.setHoverImageDescriptor(((AJDTIcon)abstractIcon).getImageDescriptor());
            filterAction4.setDisabledImageDescriptor(AspectJImages.E_POINTCUT_DEF.getImageDescriptor());
            iToolBarManager.add((IAction)filterAction4);
            FilterAction filterAction5 = new FilterAction(new CategoryFilter(9), AspectJPlugin.getResourceString("AJavaOutlinePage.HideAdvice.label"), AspectJPlugin.getResourceString("AJavaOutlinePage.HideAdvice.description.checked"), AspectJPlugin.getResourceString("AJavaOutlinePage.HideAdvice.description.unchecked"), AspectJPlugin.getResourceString("AJavaOutlinePage.HideAdvice.tooltip.checked"), AspectJPlugin.getResourceString("AJavaOutlinePage.HideAdvice.tooltip.unchecked"), "HideAdvice.isChecked");
            filterAction5.setImageDescriptor(AspectJImages.G_ADVICE.getImageDescriptor());
            AbstractIcon abstractIcon2 = AspectJImages.registry().getIcon(IProgramElement.Kind.ADVICE);
            filterAction5.setHoverImageDescriptor(((AJDTIcon)abstractIcon2).getImageDescriptor());
            filterAction5.setDisabledImageDescriptor(AspectJImages.E_ADVICE.getImageDescriptor());
            iToolBarManager.add((IAction)filterAction5);
            FilterAction filterAction6 = new FilterAction(new CategoryFilter(5), AspectJPlugin.getResourceString("AJavaOutlinePage.HideIntroductions.label"), AspectJPlugin.getResourceString("AJavaOutlinePage.HideIntroductions.description.checked"), AspectJPlugin.getResourceString("AJavaOutlinePage.HideIntroductions.description.unchecked"), AspectJPlugin.getResourceString("AJavaOutlinePage.HideIntroductions.tooltip.checked"), AspectJPlugin.getResourceString("AJavaOutlinePage.HideIntroductions.tooltip.unchecked"), "HideIntroductions.isChecked");
            filterAction6.setImageDescriptor(AspectJImages.G_ITD_FIELD_DEF.getImageDescriptor());
            AbstractIcon abstractIcon3 = AspectJImages.registry().getIcon(IProgramElement.Kind.INTER_TYPE_METHOD);
            filterAction6.setHoverImageDescriptor(((AJDTIcon)abstractIcon3).getImageDescriptor());
            filterAction6.setDisabledImageDescriptor(AspectJImages.E_ITD_FIELD_DEF.getImageDescriptor());
            iToolBarManager.add((IAction)filterAction6);
            FilterAction filterAction7 = new FilterAction(new CategoryFilter(8), AspectJPlugin.getResourceString("AJavaOutlinePage.HideDeclarations.label"), AspectJPlugin.getResourceString("AJavaOutlinePage.HideDeclarations.description.checked"), AspectJPlugin.getResourceString("AJavaOutlinePage.HideDeclarations.description.unchecked"), AspectJPlugin.getResourceString("AJavaOutlinePage.HideDeclarations.tooltip.checked"), AspectJPlugin.getResourceString("AJavaOutlinePage.HideDeclarations.tooltip.unchecked"), "HideIntroductions.isChecked");
            filterAction7.setImageDescriptor(AspectJImages.G_DECLARE_PARENTS.getImageDescriptor());
            AbstractIcon abstractIcon4 = AspectJImages.registry().getIcon(IProgramElement.Kind.DECLARE_PARENTS);
            filterAction7.setHoverImageDescriptor(((AJDTIcon)abstractIcon4).getImageDescriptor());
            filterAction7.setDisabledImageDescriptor(AspectJImages.E_DECLARE_PARENTS.getImageDescriptor());
            iToolBarManager.add((IAction)filterAction7);
        }
    }

    private void setSorting(boolean bl) {
        if (bl) {
            AJDTEventTrace.outlineViewAction("Sorting Alphabetical order", this.input);
            this.getTreeViewer().setSorter(this.lexicalSorter);
        } else {
            AJDTEventTrace.outlineViewAction("Sorting Declaration order", this.input);
            this.getTreeViewer().setSorter(null);
        }
    }

    private void addFilter(ViewerFilter viewerFilter) {
        this.getTreeViewer().addFilter(viewerFilter);
        this.expandTreeView();
    }

    private void removeFilter(ViewerFilter viewerFilter) {
        this.getTreeViewer().removeFilter(viewerFilter);
        this.expandTreeView();
    }

    class CategoryFilter
    extends ViewerFilter {
        private int category;

        public CategoryFilter(int n) {
            this.category = n;
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            boolean bl = true;
            if (object2 instanceof AJDTStructureViewNode) {
                int n = ((AJDTStructureViewNode)object2).category();
                bl = this.category != n;
            }
            return bl;
        }
    }

    class StaticFilter
    extends ViewerFilter {
        StaticFilter() {
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            boolean bl = true;
            if (object2 instanceof AJDTStructureViewNode) {
                bl = !((AJDTStructureViewNode)object2).getStructureNode().getModifiers().contains(IProgramElement.Modifiers.STATIC);
            }
            return bl;
        }
    }

    class VisibilityFilter
    extends ViewerFilter {
        VisibilityFilter() {
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            boolean bl = true;
            if (object2 instanceof AJDTStructureViewNode) {
                bl = ((AJDTStructureViewNode)object2).isPublic();
            }
            return bl;
        }
    }

    class FilterAction
    extends Action {
        private ViewerFilter fFilter;
        private String fCheckedDesc;
        private String fUncheckedDesc;
        private String fCheckedTooltip;
        private String fUncheckedTooltip;
        private String fPreferenceKey;

        public FilterAction(ViewerFilter viewerFilter, String string, String string2, String string3, String string4, String string5, String string6) {
            this.fFilter = viewerFilter;
            this.setText(string);
            this.fCheckedDesc = string2;
            this.fUncheckedDesc = string3;
            this.fCheckedTooltip = string4;
            this.fUncheckedTooltip = string5;
            this.fPreferenceKey = string6;
            boolean bl = AspectJPlugin.getDefault().getPreferenceStore().getBoolean(this.fPreferenceKey);
            this.valueChanged(bl, false);
        }

        public void run() {
            this.valueChanged(this.isChecked(), true);
        }

        private void valueChanged(boolean bl, boolean bl2) {
            this.setChecked(bl);
            if (bl) {
                AJDTEventTrace.outlineViewAction(this.fUncheckedTooltip, AspectJContentOutlinePage.this.input);
                AspectJContentOutlinePage.this.addFilter(this.fFilter);
                this.setToolTipText(this.fCheckedTooltip);
                this.setDescription(this.fCheckedDesc);
            } else {
                AJDTEventTrace.outlineViewAction(this.fCheckedTooltip, AspectJContentOutlinePage.this.input);
                AspectJContentOutlinePage.this.removeFilter(this.fFilter);
                this.setToolTipText(this.fUncheckedTooltip);
                this.setDescription(this.fUncheckedDesc);
            }
            if (bl2) {
                AspectJPlugin.getDefault().getPreferenceStore().setValue(this.fPreferenceKey, bl);
            }
        }
    }

    class LexicalSorter
    extends ViewerSorter {
        LexicalSorter() {
        }

        public int category(Object object) {
            if (object instanceof AJDTStructureViewNode) {
                return ((AJDTStructureViewNode)object).category();
            }
            return 0;
        }
    }

    class LexicalSortingAction
    extends Action {
        public LexicalSortingAction() {
            this.setText(AspectJPlugin.getResourceString("JavaOutlinePage.Sort.label"));
            JavaPluginImages.setLocalImageDescriptors((IAction)this, (String)"alphab_sort_co.gif");
            boolean bl = AspectJPlugin.getDefault().getPreferenceStore().getBoolean("LexicalSortingAction.isChecked");
            this.valueChanged(bl, false);
        }

        public void run() {
            this.valueChanged(this.isChecked(), true);
        }

        private void valueChanged(boolean bl, boolean bl2) {
            this.setChecked(bl);
            AspectJContentOutlinePage.this.setSorting(bl);
            this.setToolTipText(bl ? AspectJPlugin.getResourceString("JavaOutlinePage.Sort.tooltip.checked") : AspectJPlugin.getResourceString("JavaOutlinePage.Sort.tooltip.unchecked"));
            this.setDescription(bl ? AspectJPlugin.getResourceString("JavaOutlinePage.Sort.description.checked") : AspectJPlugin.getResourceString("JavaOutlinePage.Sort.description.unchecked"));
            if (bl2) {
                AspectJPlugin.getDefault().getPreferenceStore().setValue("LexicalSortingAction.isChecked", bl);
            }
        }
    }
}

