/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.aspectj.asm.IProgramElement;
import org.aspectj.bridge.ISourceLocation;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.internal.ui.editor.AJSourceViewerConfiguration;
import org.eclipse.ajdt.internal.ui.editor.AspectJContentOutlinePage;
import org.eclipse.ajdt.internal.ui.editor.AspectJTextTools;
import org.eclipse.ajdt.internal.ui.editor.ContextMenuManipulator;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.ajdt.ui.visualiser.NodeHolder;
import org.eclipse.ajdt.ui.visualiser.StructureModelUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class AspectJEditor
extends CompilationUnitEditor {
    private AspectJContentOutlinePage contentOutlinePage;
    private AnnotationAccessWrapper annotationAccessWrapper;
    private boolean markersNeedUpdating = true;
    private static Set activeEditorList = new HashSet();
    private IFileEditorInput currentFileInput;
    static Set modifiedAspectToClass = new HashSet();
    private AJSourceViewerConfiguration fAJSourceViewerConfiguration;
    static /* synthetic */ Class class$org$eclipse$ui$views$contentoutline$IContentOutlinePage;
    static /* synthetic */ Class class$org$eclipse$jface$text$source$IAnnotationAccess;

    public void createPartControl(Composite composite) {
        super.createPartControl(composite);
        if (this.getRulerContextMenuId() != null) {
            String string = this.getRulerContextMenuId() != null ? this.getRulerContextMenuId() : "#RulerContext";
            MenuManager menuManager = new MenuManager(string, string);
            menuManager.setRemoveAllWhenShown(true);
            menuManager.addMenuListener(this.getContextMenuListener());
            Control control = this.getVerticalRuler().getControl();
            Menu menu = menuManager.createContextMenu(control);
            control.setMenu(menu);
            this.getSite().registerContextMenu(this.getRulerContextMenuId(), menuManager, this.getSelectionProvider());
            menuManager.addMenuListener((IMenuListener)new ContextMenuManipulator());
        }
    }

    public Object getAdapter(Class clazz) {
        if (clazz.equals(class$org$eclipse$ui$views$contentoutline$IContentOutlinePage == null ? (class$org$eclipse$ui$views$contentoutline$IContentOutlinePage = AspectJEditor.class$("org.eclipse.ui.views.contentoutline.IContentOutlinePage")) : class$org$eclipse$ui$views$contentoutline$IContentOutlinePage)) {
            return this.getContentOutlinePage(clazz);
        }
        if (clazz.equals(class$org$eclipse$jface$text$source$IAnnotationAccess == null ? (class$org$eclipse$jface$text$source$IAnnotationAccess = AspectJEditor.class$("org.eclipse.jface.text.source.IAnnotationAccess")) : class$org$eclipse$jface$text$source$IAnnotationAccess)) {
            Object object = super.getAdapter(clazz);
            if (object instanceof IAnnotationAccessExtension) {
                if (this.annotationAccessWrapper == null) {
                    this.annotationAccessWrapper = new AnnotationAccessWrapper();
                }
                this.annotationAccessWrapper.setWrapped((IAnnotationAccessExtension)object);
                return this.annotationAccessWrapper;
            }
            return object;
        }
        return super.getAdapter(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSave(IProgressMonitor iProgressMonitor) {
        Object object;
        IDocumentProvider iDocumentProvider = this.getDocumentProvider();
        if (iDocumentProvider == null) {
            return;
        }
        if (iDocumentProvider.isDeleted((Object)this.getEditorInput())) {
            if (this.isSaveAsAllowed()) {
                this.performSaveAs(iProgressMonitor);
            } else {
                object = this.getSite().getShell();
                MessageDialog.openError((Shell)object, (String)"CompilationUnitEditor.error.saving.title1", (String)"CompilationUnitEditor.error.saving.message1");
            }
        } else {
            object = JavaPlugin.getDefault().getWorkingCopyManager();
            ICompilationUnit iCompilationUnit = object.getWorkingCopy(this.getEditorInput());
            if (iCompilationUnit != null) {
                ICompilationUnit iCompilationUnit2 = iCompilationUnit;
                synchronized (iCompilationUnit2) {
                    this.performSave(false, iProgressMonitor);
                }
            } else {
                this.performSave(false, iProgressMonitor);
            }
        }
        if (this.contentOutlinePage == null && (object = this.getContentOutlinePage(class$org$eclipse$ui$views$contentoutline$IContentOutlinePage == null ? (class$org$eclipse$ui$views$contentoutline$IContentOutlinePage = AspectJEditor.class$("org.eclipse.ui.views.contentoutline.IContentOutlinePage")) : class$org$eclipse$ui$views$contentoutline$IContentOutlinePage)) instanceof AspectJContentOutlinePage) {
            this.contentOutlinePage = (AspectJContentOutlinePage)((Object)object);
        }
    }

    private Object getContentOutlinePage(Class clazz) {
        Object object;
        block7: {
            object = null;
            if (AspectJPreferences.isAspectJOutlineEnabled()) {
                IEditorInput iEditorInput = this.getEditorInput();
                if (iEditorInput instanceof IFileEditorInput) {
                    IFile iFile = ((IFileEditorInput)iEditorInput).getFile();
                    IProject iProject = iFile.getProject();
                    try {
                        if (iProject.hasNature("org.eclipse.ajdt.ui.ajnature")) {
                            this.contentOutlinePage = new AspectJContentOutlinePage((AbstractTextEditor)this, iFile);
                            object = this.contentOutlinePage;
                            break block7;
                        }
                        object = super.getAdapter(clazz);
                    }
                    catch (CoreException coreException) {
                        object = super.getAdapter(clazz);
                    }
                } else {
                    object = super.getAdapter(clazz);
                }
            } else {
                object = super.getAdapter(clazz);
            }
        }
        return object;
    }

    protected void setSourceViewerConfiguration(SourceViewerConfiguration sourceViewerConfiguration) {
        Assert.isNotNull((Object)sourceViewerConfiguration);
        SourceViewerConfiguration sourceViewerConfiguration2 = this.getSourceViewerConfiguration();
        if (sourceViewerConfiguration2 != null && sourceViewerConfiguration2 instanceof AJSourceViewerConfiguration && !(sourceViewerConfiguration instanceof AJSourceViewerConfiguration)) {
            return;
        }
        super.setSourceViewerConfiguration(sourceViewerConfiguration);
    }

    public void doSetInput(IEditorInput iEditorInput) throws CoreException {
        super.doSetInput(iEditorInput);
        if (iEditorInput instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
            if (this.currentFileInput != null) {
                this.removeAJDTMarkers(this.currentFileInput);
            }
            this.currentFileInput = iFileEditorInput;
            AJDTEventTrace.editorOpened(iFileEditorInput.getFile());
            this.updateAdviceMarkers(iFileEditorInput);
            activeEditorList.add(this);
            IDocument iDocument = this.getDocumentProvider().getDocument((Object)iFileEditorInput);
            AspectJTextTools aspectJTextTools = AspectJPlugin.getDefault().getAspectJTextTools();
            aspectJTextTools.setupJavaDocumentPartitioner(iDocument, "___java_partitioning");
            if (this.contentOutlinePage != null) {
                this.contentOutlinePage.setInput(iFileEditorInput.getFile());
                this.contentOutlinePage.update();
            }
        }
    }

    public void forceUpdateOfAdviceMarkers() {
        this.markersNeedUpdating = true;
        this.updateAdviceMarkers((IFileEditorInput)this.getEditorInput());
    }

    public void updateAdviceMarkers(final IFileEditorInput iFileEditorInput) {
        if (!this.markersNeedUpdating) {
            return;
        }
        if (iFileEditorInput == null) {
            AJDTEventTrace.generalEvent("AspectJEditor: FileEditorInput is null for editor with title (" + this.getTitle() + "): Cannot update markers on it");
            return;
        }
        if (iFileEditorInput.getFile() == null) {
            AJDTEventTrace.generalEvent("AspectJEditor: fileeditorinput.getFile() is null: see bugzilla #43662");
            return;
        }
        this.removeAJDTMarkers(iFileEditorInput);
        AspectJPlugin.getDefault().getDisplay().asyncExec(new Runnable(){

            public void run() {
                AspectJEditor.this.addNewMarkers(iFileEditorInput);
            }
        });
    }

    private void removeAJDTMarkers(final IFileEditorInput iFileEditorInput) {
        AspectJPlugin.getDefault().getDisplay().asyncExec(new Runnable(){

            public void run() {
                block2: {
                    try {
                        iFileEditorInput.getFile().deleteMarkers("org.eclipse.ajdt.ui.advicemarker", true, 2);
                        iFileEditorInput.getFile().deleteMarkers("org.eclipse.ajdt.ui.declarationmarker", true, 2);
                    }
                    catch (CoreException coreException) {
                        if (!iFileEditorInput.getFile().exists()) break block2;
                        AspectJPlugin.getDefault().getErrorHandler().handleError("Advice marker delete failed", coreException);
                    }
                }
            }
        });
    }

    private void addNewMarkers(final IFileEditorInput iFileEditorInput) {
        IProject iProject = iFileEditorInput.getFile().getProject();
        try {
            if (iProject == null || !iProject.isOpen() || !iProject.hasNature("org.eclipse.ajdt.ui.ajnature")) {
                return;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        String string = iFileEditorInput.getFile().getRawLocation().toOSString();
        Map map = StructureModelUtil.getLinesToAspectMap(string, true);
        if (map != null) {
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                final Integer n = (Integer)k;
                final Vector vector = (Vector)map.get(k);
                IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor iProgressMonitor) {
                        try {
                            NodeHolder nodeHolder;
                            boolean bl = true;
                            boolean bl2 = false;
                            NodeHolder nodeHolder2 = (NodeHolder)vector.get(0);
                            if (vector.size() > 1) {
                                NodeHolder nodeHolder3 = (NodeHolder)vector.get(0);
                                String string = nodeHolder3.node.getExtraInfo() == null ? null : nodeHolder3.node.getExtraInfo().getExtraAdviceInformation();
                                Iterator iterator = vector.iterator();
                                while (iterator.hasNext()) {
                                    nodeHolder = (NodeHolder)iterator.next();
                                    boolean bl3 = bl2 = bl2 || nodeHolder.runtimeTest;
                                    if (string != null) {
                                        if (nodeHolder.node.getExtraInfo() == null) {
                                            bl = false;
                                            continue;
                                        }
                                        bl = bl && string.equals(nodeHolder.node.getExtraInfo().getExtraAdviceInformation());
                                        continue;
                                    }
                                    bl = bl && nodeHolder.node.getExtraInfo() == null;
                                }
                            } else if (vector.size() == 1) {
                                bl2 = ((NodeHolder)vector.get((int)0)).runtimeTest;
                            }
                            boolean bl4 = bl2;
                            boolean bl5 = !bl;
                            for (int i = 0; i < vector.size(); ++i) {
                                nodeHolder = (NodeHolder)vector.get(i);
                                IProgramElement iProgramElement = nodeHolder.node;
                                IFile iFile = iFileEditorInput.getFile();
                                ISourceLocation iSourceLocation = iProgramElement.getSourceLocation();
                                String string = iProgramElement.toLinkLabelString();
                                String string2 = iProgramElement.getName();
                                IMarker iMarker = AspectJEditor.this.createMarker(n, bl4, (IResource)iFile, iProgramElement, bl5, nodeHolder.runtimeTest);
                                ISourceLocation iSourceLocation2 = iProgramElement.getSourceLocation();
                                iMarker.setAttribute("priority", 2);
                                iMarker.setAttribute("sourceLocationOfAdvice", (Object)(iSourceLocation2.getSourceFile().getAbsolutePath() + ":::" + iSourceLocation2.getLine() + ":::" + iSourceLocation2.getEndLine() + ":::" + iSourceLocation2.getColumn()));
                            }
                        }
                        catch (CoreException coreException) {
                            AspectJPlugin.getDefault().getErrorHandler().handleError("Exception creating advice marker", coreException);
                        }
                    }
                };
                try {
                    AspectJPlugin.getWorkspace().run(iWorkspaceRunnable, null);
                }
                catch (CoreException coreException) {
                    AspectJPlugin.getDefault().getErrorHandler().handleError("AJDT Error adding advice markers", coreException);
                }
            }
        }
        this.markersNeedUpdating = false;
    }

    public void dispose() {
        AJDTEventTrace.generalEvent("Disposing editor for:" + this.getTitle());
        IEditorInput iEditorInput = this.getEditorInput();
        if (iEditorInput instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
            AJDTEventTrace.editorClosed(iFileEditorInput.getFile());
            activeEditorList.remove((Object)this);
        }
        this.removeAJDTMarkers(this.currentFileInput);
        super.dispose();
    }

    public static void forceEditorUpdates(final IProject iProject) {
        final Iterator iterator = activeEditorList.iterator();
        AspectJPlugin.getDefault().getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    while (iterator.hasNext()) {
                        IFileEditorInput iFileEditorInput;
                        AspectJEditor aspectJEditor = (AspectJEditor)((Object)iterator.next());
                        IEditorInput iEditorInput = aspectJEditor.getEditorInput();
                        boolean bl = true;
                        if (iProject != null && iEditorInput instanceof IFileEditorInput && !(iFileEditorInput = (IFileEditorInput)iEditorInput).getFile().getProject().getName().equals(iProject.getName())) {
                            bl = false;
                        }
                        if (!bl) continue;
                        AJDTEventTrace.generalEvent("Forcing update of outline page for editor: " + aspectJEditor.getEditorInput().getName());
                        try {
                            aspectJEditor.contentOutlinePage.update();
                        }
                        catch (Throwable throwable) {
                            AJDTEventTrace.generalEvent("Unexpected exception updating editor outline " + throwable.toString());
                        }
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        });
    }

    public void setFocus() {
        IEditorInput iEditorInput = this.getEditorInput();
        if (iEditorInput instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
            AspectJPlugin.getDefault().setCurrentProject(iFileEditorInput.getFile().getProject());
            this.updateAdviceMarkers(iFileEditorInput);
        }
        super.setFocus();
    }

    public void gotoMarker(IMarker iMarker) {
        super.gotoMarker(iMarker);
    }

    protected void initializeEditor() {
        super.initializeEditor();
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        AspectJTextTools aspectJTextTools = new AspectJTextTools(iPreferenceStore);
        this.fAJSourceViewerConfiguration = new AJSourceViewerConfiguration(aspectJTextTools, this, "___java_partitioning");
        this.setSourceViewerConfiguration((SourceViewerConfiguration)this.fAJSourceViewerConfiguration);
    }

    private IMarker createMarker(Integer n, boolean bl, IResource iResource, IProgramElement iProgramElement, boolean bl2, boolean bl3) throws CoreException {
        String string = iProgramElement.toLinkLabelString();
        String string2 = "";
        if (iProgramElement.getExtraInfo() != null) {
            string2 = iProgramElement.getExtraInfo().getExtraAdviceInformation();
        }
        IMarker iMarker = bl2 ? (bl ? iResource.createMarker("org.eclipse.ajdt.ui.dynamicadvicemarker") : (string2 == "" ? iResource.createMarker("org.eclipse.ajdt.ui.declarationmarker") : iResource.createMarker("org.eclipse.ajdt.ui.advicemarker"))) : (string2.equals("before") ? (bl ? iResource.createMarker("org.eclipse.ajdt.ui.dynamicbeforeadvicemarker") : iResource.createMarker("org.eclipse.ajdt.ui.beforeadvicemarker")) : (string2.equals("around") ? (bl ? iResource.createMarker("org.eclipse.ajdt.ui.dynamicaroundadvicemarker") : iResource.createMarker("org.eclipse.ajdt.ui.aroundadvicemarker")) : (string2.startsWith("after") ? (bl ? iResource.createMarker("org.eclipse.ajdt.ui.dynamicafteradvicemarker") : iResource.createMarker("org.eclipse.ajdt.ui.afteradvicemarker")) : iResource.createMarker("org.eclipse.ajdt.ui.itdmarker"))));
        iMarker.setAttribute("lineNumber", n.intValue());
        if (bl3) {
            string = string + " " + AspectJPlugin.getResourceString("AspectJEditor.runtimetest");
        }
        iMarker.setAttribute("message", (Object)string);
        return iMarker;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class AnnotationAccessWrapper
    implements IAnnotationAccessExtension {
        private IAnnotationAccessExtension wrapped;

        AnnotationAccessWrapper() {
        }

        public void setWrapped(IAnnotationAccessExtension iAnnotationAccessExtension) {
            this.wrapped = iAnnotationAccessExtension;
        }

        public String getTypeLabel(Annotation annotation) {
            return this.wrapped.getTypeLabel(annotation);
        }

        public int getLayer(Annotation annotation) {
            int n = this.wrapped.getLayer(annotation);
            if ("org.eclipse.jdt.ui.overrideIndicator".equals(annotation.getType())) {
                n += 2;
            }
            return n;
        }

        public void paint(Annotation annotation, GC gC, Canvas canvas, Rectangle rectangle) {
            this.wrapped.paint(annotation, gC, canvas, rectangle);
        }

        public boolean isPaintable(Annotation annotation) {
            return this.wrapped.isPaintable(annotation);
        }

        public boolean isSubtype(Object object, Object object2) {
            return this.wrapped.isSubtype(object, object2);
        }

        public Object[] getSupertypes(Object object) {
            return this.wrapped.getSupertypes(object);
        }
    }
}

