/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.ui.BuildConfigModel;
import org.aspectj.ajde.ui.BuildConfigNode;
import org.aspectj.bridge.IMessage;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.internal.core.AJDTUtils;
import org.eclipse.ajdt.internal.core.resources.AJDTIcon;
import org.eclipse.ajdt.internal.core.resources.AspectJImages;
import org.eclipse.ajdt.internal.ui.ajde.CompilerMonitor;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.EditorPart;

public class BuildConfigEditor
extends EditorPart
implements SelectionListener {
    boolean isDirty = false;
    private Tree tree = null;
    BuildConfigModel model = null;
    IFileEditorInput fileInput;
    private Hashtable nodeMap;
    ImageDescriptor compilationUnitImgDesc;
    ImageDescriptor directoryImgDesc;
    private static Hashtable reusableImageMap;

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        TreeItem treeItem = (TreeItem)selectionEvent.item;
        BuildConfigNode buildConfigNode = (BuildConfigNode)treeItem.getData();
        if (buildConfigNode != null && buildConfigNode.getBuildConfigNodeKind() == BuildConfigNode.Kind.FILE_LST) {
            String string = buildConfigNode.getResourcePath();
            IFile iFile = this.fileInput.getFile().getProject().getFile(string);
            if (iFile != null) {
                try {
                    IDE.openEditor((IWorkbenchPage)AspectJPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)iFile, (boolean)true);
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            }
        } else {
            this.widgetSelected(selectionEvent);
        }
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if ((selectionEvent.detail & 0x20) > 0) {
            TreeItem treeItem = (TreeItem)selectionEvent.item;
            boolean bl = treeItem.getChecked();
            this.setTreeNodeStatus(treeItem, bl);
            this.ensureTreeCheckboxConsistency((Widget)this.tree);
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        Ajde.getDefault().getConfigurationManager().writeModel(this.model);
        this.clearDirty();
        try {
            this.fileInput.getFile().refreshLocal(0, iProgressMonitor);
        }
        catch (CoreException coreException) {
            AspectJPlugin.getDefault().getErrorHandler().handleError("Failed to update lst file resource", coreException);
        }
        this.clearMarkers(this.fileInput);
        this.buildModel(this.fileInput);
        CompilerMonitor.showOutstandingProblems();
        this.tree.removeAll();
        this.populateTree();
    }

    public void doSaveAs() {
        this.doSave(null);
    }

    public void gotoMarker(IMarker iMarker) {
        try {
            TreeItem treeItem;
            Integer n = (Integer)iMarker.getAttribute("lineNumber");
            String string = AJDTUtils.getResourcePath(iMarker.getResource());
            BuildConfigNode buildConfigNode = this.model.findNodeForSourceLine(string, n.intValue());
            if (buildConfigNode != null && (treeItem = (TreeItem)this.nodeMap.get(buildConfigNode)) != null) {
                TreeItem[] treeItemArray = new TreeItem[]{treeItem};
                this.tree.setSelection(treeItemArray);
            }
        }
        catch (CoreException coreException) {
            AspectJPlugin.getDefault().getErrorHandler().handleError("Unable to go to marker", coreException);
        }
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInput(iEditorInput);
        this.setContentDescription(iEditorInput.getName());
        if (!(iEditorInput instanceof IFileEditorInput)) {
            throw new PartInitException("InvalidInput");
        }
        this.fileInput = (IFileEditorInput)iEditorInput;
        this.isDirty = false;
        this.clearMarkers(this.fileInput);
        this.buildModel(this.fileInput);
        CompilerMonitor.showOutstandingProblems();
        AJDTEventTrace.editorOpened(this.fileInput.getFile());
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite composite) {
        this.tree = new Tree(composite, 96);
        this.tree.addSelectionListener((SelectionListener)this);
        this.populateTree();
    }

    public void setFocus() {
        this.tree.setFocus();
    }

    public void dispose() {
        AJDTEventTrace.editorClosed(this.fileInput.getFile());
        super.dispose();
    }

    private void clearMarkers(IFileEditorInput iFileEditorInput) {
        try {
            iFileEditorInput.getFile().deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        }
        catch (CoreException coreException) {
            AspectJPlugin.getDefault().getErrorHandler().handleError(coreException.getMessage(), coreException);
        }
    }

    private void buildModel(IFileEditorInput iFileEditorInput) {
        String string = iFileEditorInput.getFile().getLocation().toOSString();
        this.nodeMap = new Hashtable();
        this.model = Ajde.getDefault().getConfigurationManager().buildModel(string);
    }

    private void populateTree() {
        if (this.model != null) {
            this.populateBranch((Widget)this.tree, this.model.getRoot());
            this.ensureTreeCheckboxConsistency((Widget)this.tree);
        }
    }

    private void populateBranch(Widget widget, BuildConfigNode buildConfigNode) {
        Iterator iterator = buildConfigNode.getChildren().iterator();
        while (iterator.hasNext()) {
            BuildConfigNode buildConfigNode2 = (BuildConfigNode)iterator.next();
            TreeItem treeItem = widget instanceof Tree ? new TreeItem((Tree)widget, 0) : new TreeItem((TreeItem)widget, 0);
            treeItem.setImage(this.createNodeImage(buildConfigNode2));
            treeItem.setText(buildConfigNode2.getName());
            treeItem.setData((Object)buildConfigNode2);
            treeItem.setChecked(buildConfigNode2.isActive());
            treeItem.setExpanded(true);
            this.nodeMap.put(buildConfigNode2, treeItem);
            this.populateBranch((Widget)treeItem, buildConfigNode2);
        }
    }

    private boolean ensureTreeCheckboxConsistency(Widget widget) {
        boolean bl = false;
        if (widget instanceof TreeItem) {
            TreeItem treeItem = (TreeItem)widget;
            TreeItem[] treeItemArray = treeItem.getItems();
            bl = false;
            boolean bl2 = false;
            int n = 0;
            for (int i = 0; i < treeItemArray.length; ++i) {
                if (!this.ensureTreeCheckboxConsistency((Widget)treeItemArray[i])) continue;
                treeItem.setChecked(true);
                treeItem.setExpanded(true);
                bl = true;
                if (treeItemArray[i].getGrayed()) {
                    bl2 = true;
                }
                ++n;
            }
            if (bl) {
                if (n != treeItemArray.length || bl2) {
                    treeItem.setGrayed(true);
                } else {
                    treeItem.setGrayed(false);
                }
            }
            if (n == 0 && treeItemArray.length != 0) {
                treeItem.setChecked(false);
                treeItem.setGrayed(false);
                treeItem.setExpanded(false);
            }
            return bl || treeItem.getChecked();
        }
        TreeItem[] treeItemArray = ((Tree)widget).getItems();
        for (int i = 0; i < treeItemArray.length; ++i) {
            this.ensureTreeCheckboxConsistency((Widget)treeItemArray[i]);
        }
        return false;
    }

    private void setTreeNodeStatus(TreeItem treeItem, boolean bl) {
        BuildConfigNode buildConfigNode = (BuildConfigNode)treeItem.getData();
        if (bl) {
            this.includeNodeInConfig(buildConfigNode);
        } else {
            this.excludeNodeFromConfig(buildConfigNode);
        }
        TreeItem[] treeItemArray = treeItem.getItems();
        for (int i = 0; i < treeItemArray.length; ++i) {
            treeItemArray[i].setChecked(bl);
            this.setTreeNodeStatus(treeItemArray[i], bl);
        }
    }

    private void setDirty() {
        this.isDirty = true;
        this.firePropertyChange(257);
    }

    private void clearDirty() {
        this.isDirty = false;
        this.firePropertyChange(257);
    }

    private void includeNodeInConfig(BuildConfigNode buildConfigNode) {
        if (!buildConfigNode.isActive()) {
            buildConfigNode.setActive(true);
            this.setDirty();
        }
    }

    private void excludeNodeFromConfig(BuildConfigNode buildConfigNode) {
        if (buildConfigNode.isActive()) {
            buildConfigNode.setActive(false);
            this.setDirty();
        }
    }

    private Image createNodeImage(BuildConfigNode buildConfigNode) {
        Image image;
        String string;
        BuildConfigNode.Kind kind = buildConfigNode.getBuildConfigNodeKind();
        int n = 0;
        if (kind == BuildConfigNode.Kind.ERROR) {
            n = 64;
        }
        List list = this.getLinkedSourceFolders();
        IMessage iMessage = buildConfigNode.getMessage();
        if (iMessage != null) {
            if (iMessage.getKind() == IMessage.ERROR) {
                n = 64;
            } else if (iMessage.getKind() == IMessage.WARNING) {
                n = 32;
            }
        }
        String string2 = buildConfigNode.getName();
        if (n != 0 && string2.startsWith("Use relative paths only, omitting: ")) {
            string = buildConfigNode.getName().substring("Use relative paths only, omitting: ".length());
            string = string.replace('/', File.separatorChar);
            string = string.replace('\\', File.separatorChar);
            boolean bl = false;
            image = list.iterator();
            while (image.hasNext()) {
                String string3 = (String)image.next();
                string3 = string3.replace('/', File.separatorChar);
                if (!string.startsWith(string3 = string3.replace('\\', File.separatorChar))) continue;
                buildConfigNode.setName("Resource from linked source folder: " + string);
                n = 0;
            }
        }
        string = new String(kind.toString() + ":::" + n);
        if (reusableImageMap == null) {
            reusableImageMap = new Hashtable();
        }
        if (reusableImageMap.get(string) != null) {
            return (Image)reusableImageMap.get(string);
        }
        AJDTIcon aJDTIcon = (AJDTIcon)AspectJImages.registry().getIcon(kind);
        ImageDescriptor imageDescriptor = aJDTIcon.getImageDescriptor();
        image = AJDTUtils.decorate(imageDescriptor, n).createImage();
        reusableImageMap.put(string, image);
        return image;
    }

    public List getLinkedSourceFolders() {
        ArrayList<String> arrayList = new ArrayList<String>();
        IProject iProject = this.fileInput.getFile().getProject();
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        try {
            IClasspathEntry[] iClasspathEntryArray = iJavaProject.getResolvedClasspath(false);
            for (int i = 0; i < iClasspathEntryArray.length; ++i) {
                if (iClasspathEntryArray[i].getEntryKind() != 3) continue;
                IClasspathEntry iClasspathEntry = iClasspathEntryArray[i];
                IPath iPath = iClasspathEntry.getPath();
                iPath = iPath.removeFirstSegments(1);
                IResource[] iResourceArray = new IResource[]{iProject.findMember(iPath)};
                arrayList.add(iResourceArray[0].getLocation().toOSString());
            }
        }
        catch (JavaModelException javaModelException) {
            javaModelException.printStackTrace();
        }
        return arrayList;
    }
}

