/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.util.TabFolderLayout;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class AJCompilerPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String COMPILER_PB_INVALID_ABSOLUTE_TYPE_NAME = "org.aspectj.ajdt.core.compiler.lint.InvalidAbsoluteTypeName";
    public static final String COMPILER_PB_INVALID_WILDCARD_TYPE_NAME = "org.aspectj.ajdt.core.compiler.lint.WildcardTypeName";
    public static final String COMPILER_PB_UNRESOLVABLE_MEMBER = "org.aspectj.ajdt.core.compiler.lint.UnresolvableMember";
    public static final String COMPILER_PB_TYPE_NOT_EXPOSED_TO_WEAVER = "org.aspectj.ajdt.core.compiler.lint.TypeNotExposedToWeaver";
    public static final String COMPILER_PB_SHADOW_NOT_IN_STRUCTURE = "org.aspectj.ajdt.core.compiler.lint.ShadowNotInStructure";
    public static final String COMPILER_PB_UNMATCHED_SUPERTYPE_IN_CALL = "org.aspectj.ajdt.core.compiler.list.UnmatchedSuperTypeInCall";
    public static final String COMPILER_PB_CANNOT_IMPLEMENT_LAZY_TJP = "org.aspectj.ajdt.core.compiler.lint.CannotImplementLazyTJP";
    public static final String COMPILER_PB_NEED_SERIAL_VERSION_UID = "org.aspectj.ajdt.core.compiler.lint.NeedSerialVersionUIDField";
    public static final String COMPILER_PB_INCOMPATIBLE_SERIAL_VERSION = "org.aspectj.ajdt.core.compiler.lint.BrokeSerialVersionCompatibility";
    public static final String COMPILER_PB_NO_INTERFACE_CTOR_JOINPOINT = "org.aspectj.ajdt.core.compiler.lint.NoInterfaceCtorJoinpoint";
    public static final String COMPILER_NO_WEAVE = "org.aspectj.ajdt.core.compiler.weaver.NoWeave";
    public static final String COMPILER_SERIALIZABLE_ASPECTS = "org.aspectj.ajdt.core.compiler.weaver.XSerializableAspects";
    public static final String COMPILER_LAZY_TJP = "org.aspectj.ajdt.core.compiler.weaver.XLazyThisJoinPoint";
    public static final String COMPILER_NO_ADVICE_INLINE = "org.aspectj.ajdt.core.compiler.weaver.XNoInline";
    public static final String COMPILER_REWEAVABLE = "org.aspectj.ajdt.core.compiler.weaver.XReweavable";
    public static final String COMPILER_REWEAVABLE_COMPRESS = "org.aspectj.ajdt.core.compiler.weaver.XReweavableCompress";
    private static final String PREF_AJ_INVALID_ABSOLUTE_TYPE_NAME = "org.aspectj.ajdt.core.compiler.lint.InvalidAbsoluteTypeName";
    private static final String PREF_AJ_SHADOW_NOT_IN_STRUCTURE = "org.aspectj.ajdt.core.compiler.lint.ShadowNotInStructure";
    private static final String PREF_AJ_CANNOT_IMPLEMENT_LAZY_TJP = "org.aspectj.ajdt.core.compiler.lint.CannotImplementLazyTJP";
    private static final String PREF_AJ_INVALID_WILDCARD_TYPE_NAME = "org.aspectj.ajdt.core.compiler.lint.WildcardTypeName";
    private static final String PREF_AJ_TYPE_NOT_EXPOSED_TO_WEAVER = "org.aspectj.ajdt.core.compiler.lint.TypeNotExposedToWeaver";
    private static final String PREF_AJ_UNRESOLVABLE_MEMBER = "org.aspectj.ajdt.core.compiler.lint.UnresolvableMember";
    private static final String PREF_AJ_UNMATCHED_SUPER_TYPE_IN_CALL = "org.aspectj.ajdt.core.compiler.list.UnmatchedSuperTypeInCall";
    private static final String PREF_AJ_INCOMPATIBLE_SERIAL_VERSION = "org.aspectj.ajdt.core.compiler.lint.BrokeSerialVersionCompatibility";
    private static final String PREF_AJ_NEED_SERIAL_VERSION_UID_FIELD = "org.aspectj.ajdt.core.compiler.lint.NeedSerialVersionUIDField";
    private static final String PREF_AJ_NO_INTERFACE_CTOR_JOINPOINT = "org.aspectj.ajdt.core.compiler.lint.NoInterfaceCtorJoinpoint";
    private static final String PREF_ENABLE_NO_WEAVE = "org.aspectj.ajdt.core.compiler.weaver.NoWeave";
    private static final String PREF_ENABLE_SERIALIZABLE_ASPECTS = "org.aspectj.ajdt.core.compiler.weaver.XSerializableAspects";
    private static final String PREF_ENABLE_LAZY_TJP = "org.aspectj.ajdt.core.compiler.weaver.XLazyThisJoinPoint";
    private static final String PREF_ENABLE_NO_INLINE = "org.aspectj.ajdt.core.compiler.weaver.XNoInline";
    private static final String PREF_ENABLE_REWEAVABLE = "org.aspectj.ajdt.core.compiler.weaver.XReweavable";
    private static final String PREF_ENABLE_REWEAVABLE_COMPRESS = "org.aspectj.ajdt.core.compiler.weaver.XReweavableCompress";
    private static final String ERROR = "error";
    private static final String WARNING = "warning";
    private static final String IGNORE = "ignore";
    private static final String ENABLED = "enabled";
    private static final String DISABLED = "disabled";
    private Button noweaveButton;
    private Button lazytjpButton;
    private Button noinlineButton;
    private Button reweaveButton;
    private Button reweaveCompressButton;
    protected List fComboBoxes;
    protected List fCheckBoxes;

    public AJCompilerPreferencePage() {
        this.setTitle("AspectJ Compiler");
        this.fCheckBoxes = new ArrayList();
        this.fComboBoxes = new ArrayList();
    }

    public static void initDefaults(IPreferenceStore iPreferenceStore) {
        iPreferenceStore.setDefault("org.aspectj.ajdt.core.compiler.lint.InvalidAbsoluteTypeName", WARNING);
        iPreferenceStore.setDefault("org.aspectj.ajdt.core.compiler.lint.ShadowNotInStructure", IGNORE);
        iPreferenceStore.setDefault("org.aspectj.ajdt.core.compiler.lint.CannotImplementLazyTJP", WARNING);
        iPreferenceStore.setDefault("org.aspectj.ajdt.core.compiler.lint.WildcardTypeName", IGNORE);
        iPreferenceStore.setDefault("org.aspectj.ajdt.core.compiler.lint.TypeNotExposedToWeaver", WARNING);
        iPreferenceStore.setDefault("org.aspectj.ajdt.core.compiler.lint.UnresolvableMember", WARNING);
        iPreferenceStore.setDefault("org.aspectj.ajdt.core.compiler.list.UnmatchedSuperTypeInCall", WARNING);
        iPreferenceStore.setDefault("org.aspectj.ajdt.core.compiler.lint.BrokeSerialVersionCompatibility", IGNORE);
        iPreferenceStore.setDefault("org.aspectj.ajdt.core.compiler.lint.NeedSerialVersionUIDField", IGNORE);
        iPreferenceStore.setDefault("org.aspectj.ajdt.core.compiler.lint.NoInterfaceCtorJoinpoint", WARNING);
        iPreferenceStore.setDefault("org.aspectj.ajdt.core.compiler.weaver.NoWeave", false);
        iPreferenceStore.setDefault("org.aspectj.ajdt.core.compiler.weaver.XSerializableAspects", false);
        iPreferenceStore.setDefault("org.aspectj.ajdt.core.compiler.weaver.XLazyThisJoinPoint", false);
        iPreferenceStore.setDefault("org.aspectj.ajdt.core.compiler.weaver.XNoInline", false);
        iPreferenceStore.setDefault("org.aspectj.ajdt.core.compiler.weaver.XReweavable", false);
        iPreferenceStore.setDefault("org.aspectj.ajdt.core.compiler.weaver.XReweavableCompress", false);
    }

    public void init(IWorkbench iWorkbench) {
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
    }

    protected Control createContents(Composite composite) {
        TabFolder tabFolder = new TabFolder(composite, 0);
        tabFolder.setLayout((Layout)new TabFolderLayout());
        tabFolder.setLayoutData((Object)new GridData(1808));
        Composite composite2 = this.createMessagesTabContent((Composite)tabFolder);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(AspectJPlugin.getResourceString("CompilerConfigurationBlock.aj_messages.tabtitle"));
        tabItem.setControl((Control)composite2);
        composite2 = this.createAdvancedTabContent((Composite)tabFolder);
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(AspectJPlugin.getResourceString("CompilerConfigurationBlock.aj_advanced.tabtitle"));
        tabItem.setControl((Control)composite2);
        return tabFolder;
    }

    private Composite createMessagesTabContent(Composite composite) {
        String[] stringArray = new String[]{ERROR, WARNING, IGNORE};
        String[] stringArray2 = new String[]{AspectJPlugin.getResourceString("CompilerConfigurationBlock.error"), AspectJPlugin.getResourceString("CompilerConfigurationBlock.warning"), AspectJPlugin.getResourceString("CompilerConfigurationBlock.ignore")};
        int n = 3;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = n;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 64);
        label.setText(AspectJPlugin.getResourceString("CompilerConfigurationBlock.aj_messages.description"));
        GridData gridData = new GridData();
        gridData.horizontalSpan = n;
        label.setLayoutData((Object)gridData);
        String string = AspectJPlugin.getResourceString("CompilerConfigurationBlock.aj_invalid_absolute_type_name.label");
        this.addComboBox(composite2, string, "org.aspectj.ajdt.core.compiler.lint.InvalidAbsoluteTypeName", stringArray, stringArray2, 0);
        string = AspectJPlugin.getResourceString("CompilerConfigurationBlock.aj_invalid_wildcard_type_name.label");
        this.addComboBox(composite2, string, "org.aspectj.ajdt.core.compiler.lint.WildcardTypeName", stringArray, stringArray2, 0);
        string = AspectJPlugin.getResourceString("CompilerConfigurationBlock.aj_unresolvable_member.label");
        this.addComboBox(composite2, string, "org.aspectj.ajdt.core.compiler.lint.UnresolvableMember", stringArray, stringArray2, 0);
        string = AspectJPlugin.getResourceString("CompilerConfigurationBlock.aj_type_not_exposed_to_weaver.label");
        this.addComboBox(composite2, string, "org.aspectj.ajdt.core.compiler.lint.TypeNotExposedToWeaver", stringArray, stringArray2, 0);
        string = AspectJPlugin.getResourceString("CompilerConfigurationBlock.aj_shadow_not_in_structure.label");
        this.addComboBox(composite2, string, "org.aspectj.ajdt.core.compiler.lint.ShadowNotInStructure", stringArray, stringArray2, 0);
        string = AspectJPlugin.getResourceString("CompilerConfigurationBlock.aj_unmatched_super_type_in_call.label");
        this.addComboBox(composite2, string, "org.aspectj.ajdt.core.compiler.list.UnmatchedSuperTypeInCall", stringArray, stringArray2, 0);
        string = AspectJPlugin.getResourceString("CompilerConfigurationBlock.aj_cannot_implement_lazy_tjp.label");
        this.addComboBox(composite2, string, "org.aspectj.ajdt.core.compiler.lint.CannotImplementLazyTJP", stringArray, stringArray2, 0);
        string = AspectJPlugin.getResourceString("CompilerConfigurationBlock.aj_need_serial_version_uid_field.label");
        this.addComboBox(composite2, string, "org.aspectj.ajdt.core.compiler.lint.NeedSerialVersionUIDField", stringArray, stringArray2, 0);
        string = AspectJPlugin.getResourceString("CompilerConfigurationBlock.aj_incompatible_serial_version.label");
        this.addComboBox(composite2, string, "org.aspectj.ajdt.core.compiler.lint.BrokeSerialVersionCompatibility", stringArray, stringArray2, 0);
        string = AspectJPlugin.getResourceString("CompilerConfigurationBlock.aj_no_interface_ctor_joinpoint.label");
        this.addComboBox(composite2, string, "org.aspectj.ajdt.core.compiler.lint.NoInterfaceCtorJoinpoint", stringArray, stringArray2, 0);
        return composite2;
    }

    private Composite createAdvancedTabContent(Composite composite) {
        String[] stringArray = new String[]{ENABLED, DISABLED};
        CheckBoxListener checkBoxListener = new CheckBoxListener();
        int n = 3;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = n;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 64);
        label.setText(AspectJPlugin.getResourceString("CompilerConfigurationBlock.aj_advanced.description"));
        GridData gridData = new GridData();
        gridData.horizontalSpan = n;
        label.setLayoutData((Object)gridData);
        String string = AspectJPlugin.getResourceString("CompilerConfigurationBlock.aj_no_weave.label");
        this.noweaveButton = this.addCheckBox(composite2, string, "org.aspectj.ajdt.core.compiler.weaver.NoWeave", stringArray, 0);
        this.noweaveButton.addSelectionListener((SelectionListener)checkBoxListener);
        string = AspectJPlugin.getResourceString("CompilerConfigurationBlock.aj_x_serializable_aspects.label");
        this.addCheckBox(composite2, string, "org.aspectj.ajdt.core.compiler.weaver.XSerializableAspects", stringArray, 0);
        string = AspectJPlugin.getResourceString("CompilerConfigurationBlock.aj_x_lazy_tjp.label");
        this.lazytjpButton = this.addCheckBox(composite2, string, "org.aspectj.ajdt.core.compiler.weaver.XLazyThisJoinPoint", stringArray, 0);
        string = AspectJPlugin.getResourceString("CompilerConfigurationBlock.aj_x_no_inline.label");
        this.noinlineButton = this.addCheckBox(composite2, string, "org.aspectj.ajdt.core.compiler.weaver.XNoInline", stringArray, 0);
        string = AspectJPlugin.getResourceString("CompilerConfigurationBlock.aj_x_reweavable.label");
        this.reweaveButton = this.addCheckBox(composite2, string, "org.aspectj.ajdt.core.compiler.weaver.XReweavable", stringArray, 0);
        this.reweaveButton.addSelectionListener((SelectionListener)checkBoxListener);
        string = AspectJPlugin.getResourceString("CompilerConfigurationBlock.aj_x_reweavable_compress.label");
        this.reweaveCompressButton = this.addCheckBox(composite2, string, "org.aspectj.ajdt.core.compiler.weaver.XReweavableCompress", stringArray, 0);
        this.reweaveCompressButton.addSelectionListener((SelectionListener)checkBoxListener);
        this.checkNoWeaveSelection();
        return composite2;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return AspectJPlugin.getDefault().getPreferenceStore();
    }

    public boolean performOk() {
        int n;
        int n2;
        Object object;
        String[] stringArray;
        int n3;
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        boolean bl = false;
        for (n3 = this.fComboBoxes.size() - 1; n3 >= 0; --n3) {
            Combo combo = (Combo)this.fComboBoxes.get(n3);
            stringArray = (String[])combo.getData();
            object = stringArray.getValue(combo.getSelectionIndex());
            if (((String)object).equals(iPreferenceStore.getString(stringArray.getKey()))) continue;
            bl = true;
            iPreferenceStore.setValue(stringArray.getKey(), (String)object);
        }
        n3 = 0;
        for (n2 = this.fCheckBoxes.size() - 1; n2 >= 0; --n2) {
            stringArray = (Button)this.fCheckBoxes.get(n2);
            object = (ControlData)stringArray.getData();
            n = stringArray.getSelection();
            if (n == iPreferenceStore.getBoolean(((ControlData)object).getKey())) continue;
            n3 = 1;
            iPreferenceStore.setValue(((ControlData)object).getKey(), n != 0);
        }
        AspectJPlugin.getDefault().savePluginPreferences();
        if (bl || n3 != 0) {
            n2 = 0;
            stringArray = this.getFullBuildDialogStrings();
            if (stringArray != null) {
                object = new MessageDialog(this.getShell(), stringArray[0], null, stringArray[1], 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 2);
                n = object.open();
                if (n == 0) {
                    n2 = 1;
                } else if (n != 1) {
                    return false;
                }
            }
            if (n2 != 0) {
                this.doFullBuild();
            }
        }
        return true;
    }

    protected String[] getFullBuildDialogStrings() {
        String string = AspectJPlugin.getResourceString("CompilerConfigurationBlock.needsbuild.title");
        String string2 = AspectJPlugin.getResourceString("CompilerConfigurationBlock.needsfullbuild.message");
        return new String[]{string, string2};
    }

    protected void doFullBuild() {
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getShell());
        try {
            progressMonitorDialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                    iProgressMonitor.beginTask("", 2);
                    try {
                        iProgressMonitor.setTaskName(AspectJPlugin.getResourceString("OptionsConfigurationBlock.buildall.taskname"));
                        JavaPlugin.getWorkspace().build(6, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2));
                    }
                    catch (CoreException coreException) {
                        throw new InvocationTargetException(coreException);
                    }
                    finally {
                        iProgressMonitor.done();
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = AspectJPlugin.getResourceString("OptionsConfigurationBlock.builderror.message");
            AspectJPlugin.getDefault().getErrorHandler().handleError(string, invocationTargetException);
        }
    }

    protected void performDefaults() {
        String string;
        ControlData controlData;
        Combo combo;
        int n;
        super.performDefaults();
        for (n = this.fComboBoxes.size() - 1; n >= 0; --n) {
            combo = (Combo)this.fComboBoxes.get(n);
            controlData = (ControlData)combo.getData();
            string = this.getPreferenceStore().getDefaultString(controlData.getKey());
            combo.select(controlData.getSelection(string));
        }
        for (n = this.fCheckBoxes.size() - 1; n >= 0; --n) {
            combo = (Button)this.fCheckBoxes.get(n);
            combo.setEnabled(true);
            controlData = (ControlData)combo.getData();
            string = this.getPreferenceStore().getDefaultString(controlData.getKey());
            combo.setSelection(controlData.getSelection(string) == 1);
        }
    }

    private Label createLabel(Composite composite, String string) {
        Label label = new Label(composite, 16384);
        label.setText(string);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        label.setLayoutData((Object)gridData);
        return label;
    }

    protected Button addCheckBox(Composite composite, String string, String string2, String[] stringArray, int n) {
        ControlData controlData = new ControlData(string2, stringArray);
        int n2 = string.indexOf("-");
        String string3 = string.substring(0, n2);
        String string4 = string.substring(n2 + 1);
        string4 = string4.trim();
        GridData gridData = new GridData(1040);
        gridData.horizontalSpan = 3;
        gridData.horizontalIndent = n;
        Button button = new Button(composite, 32);
        button.setText(string3);
        button.setData((Object)controlData);
        button.setLayoutData((Object)gridData);
        Label label = new Label(composite, 64);
        label.setText(string4);
        GridData gridData2 = new GridData(768);
        gridData2.horizontalIndent = 20;
        label.setLayoutData((Object)gridData2);
        this.createLabel(composite, "");
        boolean bl = this.getPreferenceStore().getBoolean(string2);
        button.setSelection(bl);
        this.fCheckBoxes.add(button);
        return button;
    }

    protected void addComboBox(Composite composite, String string, String string2, String[] stringArray, String[] stringArray2, int n) {
        ControlData controlData = new ControlData(string2, stringArray);
        GridData gridData = new GridData(32);
        gridData.horizontalIndent = n;
        Label label = new Label(composite, 16448);
        label.setText(string);
        label.setLayoutData((Object)gridData);
        Combo combo = new Combo(composite, 8);
        combo.setItems(stringArray2);
        combo.setData((Object)controlData);
        combo.setLayoutData((Object)new GridData(256));
        Label label2 = new Label(composite, 0);
        label2.setLayoutData((Object)new GridData(768));
        String string3 = this.getPreferenceStore().getString(string2);
        if (string3 != null && string3.length() > 0) {
            combo.select(controlData.getSelection(string3));
        }
        this.fComboBoxes.add(combo);
    }

    private void checkNoWeaveSelection() {
        boolean bl = this.noweaveButton.getSelection();
        if (bl) {
            this.lazytjpButton.setEnabled(!bl);
            this.noinlineButton.setEnabled(!bl);
            this.reweaveButton.setEnabled(!bl);
            this.reweaveCompressButton.setEnabled(!bl);
        }
    }

    private class CheckBoxListener
    implements SelectionListener {
        private CheckBoxListener() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            boolean bl;
            if (selectionEvent.getSource().equals(AJCompilerPreferencePage.this.noweaveButton)) {
                boolean bl2 = AJCompilerPreferencePage.this.noweaveButton.getSelection();
                if (bl2) {
                    AJCompilerPreferencePage.this.lazytjpButton.setSelection(false);
                    AJCompilerPreferencePage.this.noinlineButton.setSelection(false);
                    AJCompilerPreferencePage.this.reweaveButton.setSelection(false);
                    AJCompilerPreferencePage.this.reweaveCompressButton.setSelection(false);
                }
                AJCompilerPreferencePage.this.lazytjpButton.setEnabled(!bl2);
                AJCompilerPreferencePage.this.noinlineButton.setEnabled(!bl2);
                AJCompilerPreferencePage.this.reweaveButton.setEnabled(!bl2);
                AJCompilerPreferencePage.this.reweaveCompressButton.setEnabled(!bl2);
            } else if (selectionEvent.getSource().equals(AJCompilerPreferencePage.this.reweaveButton)) {
                boolean bl3 = AJCompilerPreferencePage.this.reweaveButton.getSelection();
                if (bl3) {
                    AJCompilerPreferencePage.this.reweaveCompressButton.setSelection(false);
                }
            } else if (selectionEvent.getSource().equals(AJCompilerPreferencePage.this.reweaveCompressButton) && (bl = AJCompilerPreferencePage.this.reweaveCompressButton.getSelection())) {
                AJCompilerPreferencePage.this.reweaveButton.setSelection(false);
            }
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }
    }

    protected static class ControlData {
        private String fKey;
        private String[] fValues;

        public ControlData(String string, String[] stringArray) {
            this.fKey = string;
            this.fValues = stringArray;
        }

        public String getKey() {
            return this.fKey;
        }

        public String getValue(boolean bl) {
            int n = bl ? 0 : 1;
            return this.fValues[n];
        }

        public String getValue(int n) {
            return this.fValues[n];
        }

        public int getSelection(String string) {
            for (int i = 0; i < this.fValues.length; ++i) {
                if (!string.equals(this.fValues[i])) continue;
                return i;
            }
            return 0;
        }
    }
}

