/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.preferences;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPreferenceStore;

public class AspectJPreferences {
    public static final String COMPILER_OPTIONS = "aspectj.compiler.options.flags";
    public static final String JAVA_OR_AJ_EXT = "aspectjPreferences.fileExt";
    public static final String ASPECTJ_OUTLINE = "org.eclipse.ajdt.ui.ajoutline";
    public static final String AUTOBUILD_SUPPRESSED = "org.eclipse.ajdt.ui.preferences.autobuildSuppressed";
    public static final String AJDT_PREF_CONFIG_DONE = "org.eclipse.ajdt.ui.preferences.ajdtPrefConfigDone";
    public static final String PDE_AUTO_IMPORT_CONFIG_DONE = "org.eclipse.ajdt.ui.preferences.pdeAutoImportConfigDone";
    public static final String ASK_PDE_AUTO_IMPORT = "org.eclipse.ajdt.ui.preferences.askPdeAutoImport";
    public static final String DO_PDE_AUTO_IMPORT = "org.eclipse.ajdt.ui.preferences.doPdeAutoImport";
    private static final String WARNING = "warning";
    public static final String OPTION_ReportInvalidAbsoluteTypeName = "org.aspectj.ajdt.core.compiler.lint.InvalidAbsoluteTypeName";
    public static final String OPTION_ReportInvalidWildcardTypeName = "org.aspectj.ajdt.core.compiler.lint.WildcardTypeName";
    public static final String OPTION_ReportUnresolvableMember = "org.aspectj.ajdt.core.compiler.lint.UnresolvableMember";
    public static final String OPTION_ReportTypeNotExposedToWeaver = "org.aspectj.ajdt.core.compiler.lint.TypeNotExposedToWeaver";
    public static final String OPTION_ReportShadowNotInStructure = "org.aspectj.ajdt.core.compiler.lint.ShadowNotInStructure";
    public static final String OPTION_ReportUnmatchedSuperTypeInCall = "org.aspectj.ajdt.core.compiler.list.UnmatchedSuperTypeInCall";
    public static final String OPTION_ReportCannotImplementLazyTJP = "org.aspectj.ajdt.core.compiler.lint.CannotImplementLazyTJP";
    public static final String OPTION_ReportNeedSerialVersionUIDField = "org.aspectj.ajdt.core.compiler.lint.NeedSerialVersionUIDField";
    public static final String OPTION_ReportIncompatibleSerialVersion = "org.aspectj.ajdt.core.compiler.lint.BrokeSerialVersionCompatibility";
    public static final String OPTION_ReportNoInterfaceCtorJoinpoint = "org.aspectj.ajdt.core.compiler.lint.NoInterfaceCtorJoinpoint";
    public static final String OPTION_NoWeave = "org.aspectj.ajdt.core.compiler.weaver.NoWeave";
    public static final String OPTION_XSerializableAspects = "org.aspectj.ajdt.core.compiler.weaver.XSerializableAspects";
    public static final String OPTION_XLazyThisJoinPoint = "org.aspectj.ajdt.core.compiler.weaver.XLazyThisJoinPoint";
    public static final String OPTION_XNoInline = "org.aspectj.ajdt.core.compiler.weaver.XNoInline";
    public static final String OPTION_XReweavable = "org.aspectj.ajdt.core.compiler.weaver.XReweavable";
    public static final String OPTION_XReweavableCompress = "org.aspectj.ajdt.core.compiler.weaver.XReweavableCompress";
    private static String[][] lintKeysName = new String[][]{{"org.aspectj.ajdt.core.compiler.lint.InvalidAbsoluteTypeName", "invalidAbsoluteTypeName"}, {"org.aspectj.ajdt.core.compiler.lint.WildcardTypeName", "invalidWildcardTypeName"}, {"org.aspectj.ajdt.core.compiler.lint.UnresolvableMember", "unresolvableMember"}, {"org.aspectj.ajdt.core.compiler.lint.TypeNotExposedToWeaver", "typeNotExposedToWeaver"}, {"org.aspectj.ajdt.core.compiler.lint.ShadowNotInStructure", "shadowNotInStructure"}, {"org.aspectj.ajdt.core.compiler.list.UnmatchedSuperTypeInCall", "unmatchedSuperTypeInCall"}, {"org.aspectj.ajdt.core.compiler.lint.CannotImplementLazyTJP", "canNotImplementLazyTjp"}, {"org.aspectj.ajdt.core.compiler.lint.NeedSerialVersionUIDField", "needsSerialVersionUIDField"}, {"org.aspectj.ajdt.core.compiler.lint.BrokeSerialVersionCompatibility", "brokeSerialVersionCompatibility"}, {"org.aspectj.ajdt.core.compiler.lint.NoInterfaceCtorJoinpoint", "noInterfaceCtorJoinpoint"}};
    private static String XlintProperties = "Xlint.properties";

    public static String getCompilerOptions() {
        IPreferenceStore iPreferenceStore = AspectJPlugin.getDefault().getPreferenceStore();
        return iPreferenceStore.getString(COMPILER_OPTIONS);
    }

    public static String getFileExt() {
        boolean bl = AspectJPreferences.getJavaOrAjExt();
        return bl ? ".java" : ".aj";
    }

    private static boolean getJavaOrAjExt() {
        IPreferenceStore iPreferenceStore = AspectJPlugin.getDefault().getPreferenceStore();
        return iPreferenceStore.getBoolean(JAVA_OR_AJ_EXT);
    }

    public static void setCompilerOptions(String string) {
        IPreferenceStore iPreferenceStore = AspectJPlugin.getDefault().getPreferenceStore();
        iPreferenceStore.setValue(COMPILER_OPTIONS, string);
    }

    public static String getLintOptions(IProject iProject) {
        File file = AspectJPlugin.getDefault().getStateLocation().append(XlintProperties).toFile();
        AspectJPreferences.writeLintOptionsFile(iProject);
        String string = " -Xlintfile \"" + file + "\" ";
        return string;
    }

    private static void writeLintOptionsFile(IProject iProject) {
        File file = AspectJPlugin.getDefault().getStateLocation().append(XlintProperties).toFile();
        try {
            FileWriter fileWriter = new FileWriter(file);
            IPreferenceStore iPreferenceStore = AspectJPlugin.getDefault().getPreferenceStore();
            String string = iPreferenceStore.getBoolean(iProject + "useProjectSettings") ? iProject.toString() : "";
            for (int i = 0; i < lintKeysName.length; ++i) {
                String string2 = iPreferenceStore.getString(string + lintKeysName[i][0]);
                if (string2.equals("")) {
                    iPreferenceStore.setDefault(string + lintKeysName[i][0], WARNING);
                    string2 = iPreferenceStore.getString(string + lintKeysName[i][0]);
                }
                fileWriter.write(lintKeysName[i][1] + " = " + string2);
                fileWriter.write(System.getProperty("line.separator"));
            }
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static String getAdvancedOptions(IProject iProject) {
        IPreferenceStore iPreferenceStore = AspectJPlugin.getDefault().getPreferenceStore();
        String string = " ";
        String string2 = iPreferenceStore.getBoolean(iProject + "useProjectSettings") ? iProject.toString() : "";
        if (iPreferenceStore.getBoolean(string2 + OPTION_NoWeave)) {
            string = string + "-XnoWeave ";
        }
        if (iPreferenceStore.getBoolean(string2 + OPTION_XSerializableAspects)) {
            string = string + "-XserializableAspects ";
        }
        if (iPreferenceStore.getBoolean(string2 + OPTION_XLazyThisJoinPoint)) {
            string = string + "-XlazyTjp ";
        }
        if (iPreferenceStore.getBoolean(string2 + OPTION_XNoInline)) {
            string = string + "-XnoInline ";
        }
        if (iPreferenceStore.getBoolean(string2 + OPTION_XReweavable)) {
            string = string + "-Xreweavable ";
        }
        if (iPreferenceStore.getBoolean(string2 + OPTION_XReweavableCompress)) {
            string = string + "-Xreweavable:compress ";
        }
        return string;
    }

    public static boolean isAspectJOutlineEnabled() {
        IPreferenceStore iPreferenceStore = AspectJPlugin.getDefault().getPreferenceStore();
        return iPreferenceStore.getBoolean(ASPECTJ_OUTLINE);
    }

    public static boolean isAutobuildSuppressed() {
        return false;
    }

    public static void setAJDTPrefConfigDone(boolean bl) {
        IPreferenceStore iPreferenceStore = AspectJPlugin.getDefault().getPreferenceStore();
        iPreferenceStore.setValue(AJDT_PREF_CONFIG_DONE, bl);
    }

    public static boolean isAJDTPrefConfigDone() {
        IPreferenceStore iPreferenceStore = AspectJPlugin.getDefault().getPreferenceStore();
        return iPreferenceStore.getBoolean(AJDT_PREF_CONFIG_DONE);
    }

    public static void setAskPDEAutoImport(boolean bl) {
        IPreferenceStore iPreferenceStore = AspectJPlugin.getDefault().getPreferenceStore();
        iPreferenceStore.setValue(ASK_PDE_AUTO_IMPORT, bl);
    }

    public static boolean askPDEAutoImport() {
        IPreferenceStore iPreferenceStore = AspectJPlugin.getDefault().getPreferenceStore();
        return iPreferenceStore.getBoolean(ASK_PDE_AUTO_IMPORT);
    }

    public static void setPDEAutoImportConfigDone(boolean bl) {
        IPreferenceStore iPreferenceStore = AspectJPlugin.getDefault().getPreferenceStore();
        iPreferenceStore.setValue(PDE_AUTO_IMPORT_CONFIG_DONE, bl);
    }

    public static boolean isPDEAutoImportConfigDone() {
        IPreferenceStore iPreferenceStore = AspectJPlugin.getDefault().getPreferenceStore();
        return iPreferenceStore.getBoolean(PDE_AUTO_IMPORT_CONFIG_DONE);
    }

    public static void setDoPDEAutoImport(boolean bl) {
        IPreferenceStore iPreferenceStore = AspectJPlugin.getDefault().getPreferenceStore();
        iPreferenceStore.setValue(DO_PDE_AUTO_IMPORT, bl);
    }

    public static boolean doPDEAutoImport() {
        IPreferenceStore iPreferenceStore = AspectJPlugin.getDefault().getPreferenceStore();
        return iPreferenceStore.getBoolean(DO_PDE_AUTO_IMPORT);
    }
}

