/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.preferences;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.ajdt.internal.ui.ajde.BuildOptionsAdapter;
import org.eclipse.ajdt.internal.ui.wizards.AspectPathBlock;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.help.WorkbenchHelp;

public class AspectPathPropertyPage
extends PropertyPage
implements IStatusChangeListener {
    private IProject thisProject;
    protected AspectPathBlock fAspectPathBlock;
    private static final String PAGE_SETTINGS = "AspectPathPropertyPage";
    private static final String INDEX = "pageIndex";
    static /* synthetic */ Class class$org$eclipse$jdt$core$IJavaElement;

    protected Control createContents(Composite composite) {
        this.noDefaultAndApplyButton();
        this.thisProject = this.getProject();
        BuildOptionsAdapter.ensurePropertiesInitialized(this.thisProject);
        Control control = this.thisProject == null || !this.isAspectJProject(this.thisProject) ? this.createWithoutJava(composite) : (!this.thisProject.isOpen() ? this.createForClosedProject(composite) : this.createWithJava(composite, this.thisProject));
        Dialog.applyDialogFont((Control)control);
        return control;
    }

    private IProject getProject() {
        IJavaElement iJavaElement;
        IAdaptable iAdaptable = this.getElement();
        if (iAdaptable != null && (iJavaElement = (IJavaElement)iAdaptable.getAdapter(class$org$eclipse$jdt$core$IJavaElement == null ? (class$org$eclipse$jdt$core$IJavaElement = AspectPathPropertyPage.class$("org.eclipse.jdt.core.IJavaElement")) : class$org$eclipse$jdt$core$IJavaElement)) instanceof IJavaProject) {
            return ((IJavaProject)iJavaElement).getProject();
        }
        return null;
    }

    private boolean isAspectJProject(IProject iProject) {
        try {
            return iProject.hasNature("org.eclipse.ajdt.ui.ajnature");
        }
        catch (CoreException coreException) {
            AspectJPlugin.getDefault().getLog().log(coreException.getStatus());
            return false;
        }
    }

    private Control createWithoutJava(Composite composite) {
        Label label = new Label(composite, 16384);
        label.setText(PreferencesMessages.getString((String)"BuildPathsPropertyPage.no_java_project.message"));
        this.fAspectPathBlock = null;
        this.setValid(true);
        return label;
    }

    public void statusChanged(IStatus iStatus) {
        this.setValid(!iStatus.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, (IStatus)iStatus);
    }

    private Control createForClosedProject(Composite composite) {
        Label label = new Label(composite, 16384);
        label.setText(PreferencesMessages.getString((String)"BuildPathsPropertyPage.closed_project.message"));
        this.fAspectPathBlock = null;
        this.setValid(true);
        return label;
    }

    protected Control createWithJava(Composite composite, IProject iProject) {
        this.fAspectPathBlock = new AspectPathBlock(this, this.getSettings().getInt(INDEX));
        IClasspathEntry[] iClasspathEntryArray = null;
        try {
            iClasspathEntryArray = this.getInitialAspectpathValue(iProject);
        }
        catch (CoreException coreException) {
            AspectJPlugin.getDefault().getLog().log(coreException.getStatus());
            ErrorDialog.openError((Shell)AspectJPlugin.getDefault().getActiveWorkbenchWindow().getShell(), (String)AspectJPlugin.getResourceString("AspectPathProp.exceptionInitializingAspectpath.title"), (String)AspectJPlugin.getResourceString("AspectPathProp.exceptionInitializingAspectpath.message"), (IStatus)coreException.getStatus());
        }
        this.fAspectPathBlock.init(JavaCore.create((IProject)iProject), null, iClasspathEntryArray);
        return this.fAspectPathBlock.createControl(composite);
    }

    private IClasspathEntry[] getInitialAspectpathValue(IProject iProject) throws CoreException {
        ArrayList<ClasspathEntry> arrayList = new ArrayList<ClasspathEntry>();
        String string = iProject.getPersistentProperty(BuildOptionsAdapter.ASPECTPATH);
        String string2 = iProject.getPersistentProperty(BuildOptionsAdapter.ASPECTPATH_CON_KINDS);
        String string3 = iProject.getPersistentProperty(BuildOptionsAdapter.ASPECTPATH_ENT_KINDS);
        if (string != null && string.length() > 0 && string2 != null && string2.length() > 0 && string3 != null && string3.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, File.pathSeparator);
            StringTokenizer stringTokenizer3 = new StringTokenizer(string3, File.pathSeparator);
            if (stringTokenizer.countTokens() == stringTokenizer2.countTokens() && stringTokenizer.countTokens() == stringTokenizer3.countTokens()) {
                while (stringTokenizer.hasMoreTokens()) {
                    ClasspathEntry classpathEntry = new ClasspathEntry(Integer.parseInt(stringTokenizer2.nextToken()), Integer.parseInt(stringTokenizer3.nextToken()), (IPath)new Path(stringTokenizer.nextToken()), new IPath[0], new IPath[0], null, null, null, false);
                    arrayList.add(classpathEntry);
                }
            }
        }
        if (arrayList.size() > 0) {
            return arrayList.toArray(new IClasspathEntry[0]);
        }
        return null;
    }

    protected IDialogSettings getSettings() {
        IDialogSettings iDialogSettings = AspectJPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(PAGE_SETTINGS);
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(PAGE_SETTINGS);
            iDialogSettings2.put(INDEX, 1);
        }
        return iDialogSettings2;
    }

    public boolean performOk() {
        if (this.fAspectPathBlock != null) {
            this.getSettings().put(INDEX, this.fAspectPathBlock.getPageIndex());
            Shell shell = this.getControl().getShell();
            IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    try {
                        AspectPathPropertyPage.this.fAspectPathBlock.configureJavaProject(iProgressMonitor);
                    }
                    catch (CoreException coreException) {
                        throw new InvocationTargetException(coreException);
                    }
                }
            };
            WorkspaceModifyDelegatingOperation workspaceModifyDelegatingOperation = new WorkspaceModifyDelegatingOperation(iRunnableWithProgress);
            try {
                new ProgressMonitorDialog(shell).run(true, true, (IRunnableWithProgress)workspaceModifyDelegatingOperation);
            }
            catch (InvocationTargetException invocationTargetException) {
                String string = PreferencesMessages.getString((String)"BuildPathsPropertyPage.error.title");
                String string2 = PreferencesMessages.getString((String)"BuildPathsPropertyPage.error.message");
                return false;
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        return true;
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.jdt.ui.build_path_property_page_context");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

