/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.internal.core.AJDTUtils;
import org.eclipse.ajdt.internal.core.resources.AspectJImages;
import org.eclipse.ajdt.internal.ui.wizards.AspectJWizardNewProjectCreationPage;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPage;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class AspectJProjectWizard
extends BasicNewProjectResourceWizard
implements IExecutableExtension {
    protected NewJavaProjectWizardPage fJavaPage;
    protected AspectJWizardNewProjectCreationPage fMainPage;
    private IConfigurationElement fConfigElement;

    public AspectJProjectWizard() {
        this.setDefaultPageImageDescriptor(AspectJImages.W_NEW_AJ_PRJ.getImageDescriptor());
        this.setDialogSettings(AspectJPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(AspectJPlugin.getResourceString("NewAspectjProjectCreationWizard.title"));
    }

    public void addPages() {
        this.fMainPage = new AspectJWizardNewProjectCreationPage("NewAspectjProjectCreationWizard");
        this.fMainPage.setTitle(AspectJPlugin.getResourceString("NewAspectjProjectCreationWizard.MainPage.title"));
        this.fMainPage.setDescription(AspectJPlugin.getResourceString("NewAspectjProjectCreationWizard.MainPage.description"));
        this.fMainPage.setImageDescriptor(AspectJImages.W_NEW_AJ_PRJ.getImageDescriptor());
        this.addPage((IWizardPage)this.fMainPage);
        IWorkspaceRoot iWorkspaceRoot = AspectJPlugin.getWorkspace().getRoot();
        this.fJavaPage = new NewJavaProjectWizardPage(iWorkspaceRoot, (WizardNewProjectCreationPage)this.fMainPage);
        this.addPage((IWizardPage)this.fJavaPage);
    }

    public boolean performFinish() {
        NullProgressMonitor nullProgressMonitor;
        IProject iProject = this.fJavaPage.getNewJavaProject().getProject();
        IWorkspaceRoot iWorkspaceRoot = AspectJPlugin.getWorkspace().getRoot();
        File file = iWorkspaceRoot.getLocation().append(iProject.getName()).toFile();
        File file2 = iWorkspaceRoot.getLocation().append(iProject.getName() + '/' + ".classpath").toFile();
        File file3 = iWorkspaceRoot.getLocation().append(iProject.getName() + '/' + ".project").toFile();
        boolean bl = file.exists();
        boolean bl2 = file2.exists();
        boolean bl3 = file3.exists();
        boolean bl4 = false;
        if (bl && bl2 && bl3) {
            bl4 = true;
        }
        if (!bl4) {
            nullProgressMonitor = new WorkspaceModifyDelegatingOperation(this.fJavaPage.getRunnable());
            try {
                this.getContainer().run(false, true, (IRunnableWithProgress)nullProgressMonitor);
            }
            catch (InvocationTargetException invocationTargetException) {
                String string = AspectJPlugin.getResourceString("NewAspectjProjectCreationWizard.op_error.title");
                String string2 = AspectJPlugin.getResourceString("NewAspectjProjectCreationWizard.op_error.message");
                ExceptionHandler.handle((InvocationTargetException)invocationTargetException, (Shell)this.getShell(), (String)string, (String)string2);
                return false;
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
            iProject = this.fJavaPage.getNewJavaProject().getProject();
        } else {
            nullProgressMonitor = new NullProgressMonitor();
            try {
                iProject.create((IProgressMonitor)nullProgressMonitor);
                iProject.open((IProgressMonitor)nullProgressMonitor);
            }
            catch (CoreException coreException) {
                String string = AspectJPlugin.getResourceString("NewAspectjProjectCreationWizard.build_error.title");
                String string3 = AspectJPlugin.getResourceString("NewAspectjProjectCreationWizard.build_error.message");
                ExceptionHandler.handle((CoreException)coreException, (Shell)this.getShell(), (String)string, (String)string3);
                return false;
            }
        }
        boolean bl5 = this.finalizeNewProject(iProject, bl4);
        return bl5;
    }

    private boolean finalizeNewProject(IProject iProject, boolean bl) {
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
        final IProject iProject2 = iProject;
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getShell());
        try {
            progressMonitorDialog.run(true, true, new IRunnableWithProgress(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                    iProgressMonitor.beginTask("", 2);
                    try {
                        iProgressMonitor.setTaskName(AspectJPlugin.getResourceString("OptionsConfigurationBlock.buildproject.taskname"));
                        iProject2.build(6, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2));
                    }
                    catch (CoreException coreException) {
                        System.err.println("Failed initial Java build of new project " + iProject2.getName() + " : " + (Object)((Object)coreException));
                        AspectJPlugin.getDefault().getLog().log(coreException.getStatus());
                    }
                    finally {
                        iProgressMonitor.done();
                    }
                }
            });
            if (!bl) {
                AJDTUtils.addAspectJNature(iProject);
            }
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (Throwable throwable) {
            System.out.println("> Error creating new project: " + throwable);
            throwable.printStackTrace();
            return false;
        }
        iProject = iProject2;
        AspectJPlugin.getDefault().setCurrentProject(iProject);
        this.selectAndReveal((IResource)iProject);
        AJDTEventTrace.newProjectCreated(iProject);
        return true;
    }

    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) {
        this.fConfigElement = iConfigurationElement;
    }
}

