/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ajdt.internal.ui.ajde.BuildOptionsAdapter;
import org.eclipse.ajdt.internal.ui.wizards.AspectPathLibrariesWorkbookPage;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.util.TabFolderLayout;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDisposer;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathBasePage;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListLabelProvider;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ClasspathOrderingWorkbookPage;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.SourceContainerWorkbookPage;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.help.WorkbenchHelp;

public class AspectPathBlock {
    private IWorkspaceRoot fWorkspaceRoot = AspectJPlugin.getWorkspace().getRoot();
    private ListDialogField fAspectPathList;
    private StatusInfo fAspectPathStatus;
    private StatusInfo fOutputFolderStatus;
    private StatusInfo fBuildPathStatus;
    private IJavaProject fCurrJProject;
    private IPath fOutputLocationPath;
    private IStatusChangeListener fContext;
    private Control fSWTWidget;
    private int fPageIndex;
    private SourceContainerWorkbookPage fSourceContainerPage;
    private AspectPathLibrariesWorkbookPage fLibrariesPage;
    private BuildPathBasePage fCurrPage;

    public AspectPathBlock(IStatusChangeListener iStatusChangeListener, int n) {
        this.fContext = iStatusChangeListener;
        this.fPageIndex = n;
        this.fSourceContainerPage = null;
        this.fLibrariesPage = null;
        this.fCurrPage = null;
        AspectPathAdapter aspectPathAdapter = new AspectPathAdapter();
        String[] stringArray = new String[]{AspectJPlugin.getResourceString("InPathBlock.order.up.button"), AspectJPlugin.getResourceString("InPathBlock.order.down.button")};
        this.fAspectPathList = new ListDialogField(null, stringArray, (ILabelProvider)new CPListLabelProvider());
        this.fAspectPathList.setDialogFieldListener((IDialogFieldListener)aspectPathAdapter);
        this.fAspectPathList.setLabelText(AspectJPlugin.getResourceString("AspectPathBlock.aspectpath.label"));
        this.fAspectPathList.setUpButtonIndex(0);
        this.fAspectPathList.setDownButtonIndex(1);
        this.fBuildPathStatus = new StatusInfo();
        this.fAspectPathStatus = new StatusInfo();
        this.fOutputFolderStatus = new StatusInfo();
        this.fCurrJProject = null;
    }

    private void buildPathDialogFieldChanged(DialogField dialogField) {
        if (dialogField == this.fAspectPathList) {
            this.updateAspectPathStatus();
        }
        this.doStatusLineUpdate();
    }

    public void init(IJavaProject iJavaProject, IPath iPath, IClasspathEntry[] iClasspathEntryArray) {
        this.fCurrJProject = iJavaProject;
        ArrayList arrayList = null;
        if (iPath == null) {
            iPath = this.getDefaultBuildPath(iJavaProject);
        }
        if (iClasspathEntryArray != null) {
            arrayList = this.getExistingEntries(iClasspathEntryArray);
        }
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        this.fOutputLocationPath = new Path(iPath.makeRelative().toString()).makeAbsolute();
        this.fAspectPathList.setElements(arrayList);
        if (this.fLibrariesPage != null) {
            this.fLibrariesPage.init(this.fCurrJProject);
        }
        this.doStatusLineUpdate();
    }

    public void updateAspectPathStatus() {
        this.fAspectPathStatus.setOK();
        List list = this.fAspectPathList.getElements();
        CPListElement cPListElement = null;
        int n = 0;
        IClasspathEntry[] iClasspathEntryArray = new IClasspathEntry[list.size()];
        for (int i = list.size() - 1; i >= 0; --i) {
            CPListElement cPListElement2 = (CPListElement)list.get(i);
            iClasspathEntryArray[i] = cPListElement2.getClasspathEntry();
            if (!cPListElement2.isMissing()) continue;
            ++n;
            if (cPListElement != null) continue;
            cPListElement = cPListElement2;
        }
        if (n > 0) {
            if (n == 1) {
                this.fAspectPathStatus.setWarning(AspectJPlugin.getResourceString("AspectPathBlock.warning.EntryMissing"));
            } else {
                this.fAspectPathStatus.setWarning(AspectJPlugin.getResourceString("AspectPathBlock.warning.EntriesMissing"));
            }
        }
        this.updateBuildPathStatus();
    }

    private void doStatusLineUpdate() {
        IStatus iStatus = this.findMostSevereStatus();
        this.fContext.statusChanged(iStatus);
    }

    private Shell getShell() {
        if (this.fSWTWidget != null) {
            return this.fSWTWidget.getShell();
        }
        return AspectJPlugin.getDefault().getActiveWorkbenchWindow().getShell();
    }

    private IPath getDefaultBuildPath(IJavaProject iJavaProject) {
        IPreferenceStore iPreferenceStore = PreferenceConstants.getPreferenceStore();
        if (iPreferenceStore.getBoolean("org.eclipse.jdt.ui.wizards.srcBinFoldersInNewProjects")) {
            String string = iPreferenceStore.getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName");
            return iJavaProject.getProject().getFullPath().append(string);
        }
        return iJavaProject.getProject().getFullPath();
    }

    private ArrayList getExistingEntries(IClasspathEntry[] iClasspathEntryArray) {
        ArrayList<CPListElement> arrayList = new ArrayList<CPListElement>();
        for (int i = 0; i < iClasspathEntryArray.length; ++i) {
            IClasspathEntry iClasspathEntry = iClasspathEntryArray[i];
            arrayList.add(CPListElement.createFromExisting((IClasspathEntry)iClasspathEntry, (IJavaProject)this.fCurrJProject));
        }
        return arrayList;
    }

    private void updateBuildPathStatus() {
        List list = this.fAspectPathList.getElements();
        IClasspathEntry[] iClasspathEntryArray = new IClasspathEntry[list.size()];
        for (int i = list.size() - 1; i >= 0; --i) {
            CPListElement cPListElement = (CPListElement)list.get(i);
            iClasspathEntryArray[i] = cPListElement.getClasspathEntry();
        }
        IJavaModelStatus iJavaModelStatus = JavaConventions.validateClasspath((IJavaProject)this.fCurrJProject, (IClasspathEntry[])iClasspathEntryArray, (IPath)this.fOutputLocationPath);
        if (!iJavaModelStatus.isOK()) {
            this.fBuildPathStatus.setError(iJavaModelStatus.getMessage());
            return;
        }
        this.fBuildPathStatus.setOK();
    }

    private IStatus findMostSevereStatus() {
        return StatusUtil.getMostSevere((IStatus[])new IStatus[]{this.fAspectPathStatus, this.fOutputFolderStatus, this.fBuildPathStatus});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureJavaProject(IProgressMonitor iProgressMonitor) throws CoreException, InterruptedException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.setTaskName(AspectJPlugin.getResourceString("AspectPathBlock.operationdesc_java"));
        iProgressMonitor.beginTask("", 10);
        try {
            this.internalConfigureJavaProject(this.fAspectPathList.getElements(), iProgressMonitor);
        }
        finally {
            iProgressMonitor.done();
        }
    }

    protected void internalConfigureJavaProject(List list, IProgressMonitor iProgressMonitor) throws CoreException, InterruptedException {
        Object object;
        int n = list.size();
        IClasspathEntry[] iClasspathEntryArray = new IClasspathEntry[n];
        for (int i = 0; i < n; ++i) {
            object = (CPListElement)list.get(i);
            iClasspathEntryArray[i] = object.getClasspathEntry();
        }
        iProgressMonitor.worked(2);
        StringBuffer stringBuffer = new StringBuffer();
        object = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < iClasspathEntryArray.length; ++i) {
            stringBuffer.append(iClasspathEntryArray[i].getPath());
            stringBuffer.append(File.pathSeparator);
            ((StringBuffer)object).append(iClasspathEntryArray[i].getContentKind());
            ((StringBuffer)object).append(File.pathSeparator);
            stringBuffer2.append(iClasspathEntryArray[i].getEntryKind());
            stringBuffer2.append(File.pathSeparator);
        }
        stringBuffer = this.removeFinalPathSeparatorChar(stringBuffer);
        object = this.removeFinalPathSeparatorChar((StringBuffer)object);
        stringBuffer2 = this.removeFinalPathSeparatorChar(stringBuffer2);
        this.fCurrJProject.getProject().setPersistentProperty(BuildOptionsAdapter.ASPECTPATH, stringBuffer.toString());
        this.fCurrJProject.getProject().setPersistentProperty(BuildOptionsAdapter.ASPECTPATH_CON_KINDS, ((StringBuffer)object).toString());
        this.fCurrJProject.getProject().setPersistentProperty(BuildOptionsAdapter.ASPECTPATH_ENT_KINDS, stringBuffer2.toString());
    }

    private StringBuffer removeFinalPathSeparatorChar(StringBuffer stringBuffer) {
        if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == File.pathSeparatorChar) {
            stringBuffer = stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer;
    }

    public int getPageIndex() {
        return this.fPageIndex;
    }

    public Control createControl(Composite composite) {
        this.fSWTWidget = composite;
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        TabFolder tabFolder = new TabFolder(composite2, 0);
        tabFolder.setLayout((Layout)new TabFolderLayout());
        tabFolder.setLayoutData((Object)new GridData(1808));
        ImageRegistry imageRegistry = JavaPlugin.getDefault().getImageRegistry();
        IWorkbench iWorkbench = AspectJPlugin.getDefault().getWorkbench();
        Image image = iWorkbench.getSharedImages().getImage("IMG_OBJ_PROJECT");
        this.fLibrariesPage = new AspectPathLibrariesWorkbookPage(this.fWorkspaceRoot, this.fAspectPathList);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(AspectJPlugin.getResourceString("AspectPathBlock.tab.libraries"));
        tabItem.setImage(imageRegistry.get("org.eclipse.jdt.ui.library_obj.gif"));
        tabItem.setData((Object)this.fLibrariesPage);
        tabItem.setControl(this.fLibrariesPage.getControl((Composite)tabFolder));
        Image image2 = JavaPluginImages.DESC_TOOL_CLASSPATH_ORDER.createImage();
        composite2.addDisposeListener((DisposeListener)new ImageDisposer(image2));
        ClasspathOrderingWorkbookPage classpathOrderingWorkbookPage = new ClasspathOrderingWorkbookPage(this.fAspectPathList);
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(AspectJPlugin.getResourceString("InPathBlock.tab.inpath.order"));
        tabItem.setImage(image2);
        tabItem.setData((Object)classpathOrderingWorkbookPage);
        tabItem.setControl(classpathOrderingWorkbookPage.getControl((Composite)tabFolder));
        if (this.fCurrJProject != null) {
            this.fLibrariesPage.init(this.fCurrJProject);
        }
        CLabel cLabel = new CLabel(composite2, 16384);
        cLabel.setImage(AspectJPlugin.getDefault().getDisplay().getSystemImage(2));
        cLabel.setText(AspectJPlugin.getResourceString("AspectPathLibrariesWorkbookPage.runtime.reminder"));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 1;
        cLabel.setLayoutData((Object)gridData);
        tabFolder.setSelection(this.fPageIndex);
        this.fCurrPage = (BuildPathBasePage)tabFolder.getItem(this.fPageIndex).getData();
        tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AspectPathBlock.this.tabChanged(selectionEvent.item);
            }
        });
        WorkbenchHelp.setHelp((Control)composite2, (String)"org.eclipse.jdt.ui.build_paths_context");
        Dialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    protected void tabChanged(Widget widget) {
        if (widget instanceof TabItem) {
            List list;
            TabItem tabItem = (TabItem)widget;
            BuildPathBasePage buildPathBasePage = (BuildPathBasePage)tabItem.getData();
            if (this.fCurrPage != null && !(list = this.fCurrPage.getSelection()).isEmpty()) {
                buildPathBasePage.setSelection(list);
            }
            this.fCurrPage = buildPathBasePage;
            this.fPageIndex = tabItem.getParent().getSelectionIndex();
        }
    }

    private class AspectPathAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private AspectPathAdapter() {
        }

        public void changeControlPressed(DialogField dialogField) {
        }

        public void dialogFieldChanged(DialogField dialogField) {
            AspectPathBlock.this.buildPathDialogFieldChanged(dialogField);
        }
    }
}

