/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathBasePage;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementSorter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListLabelProvider;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.SourceAttachmentBlock;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class AspectPathLibrariesWorkbookPage
extends BuildPathBasePage {
    private ListDialogField fAspectPathList;
    private IJavaProject fCurrJProject;
    protected TreeListDialogField fLibrariesList;
    private IWorkspaceRoot fWorkspaceRoot;
    private Control fSWTControl;
    private final int IDX_ADDJAR = 0;
    private final int IDX_ADDEXT = 1;
    private final int IDX_ADDVAR = 2;
    private final int IDX_ADDLIB = 3;
    private final int IDX_EDIT = 5;
    private final int IDX_REMOVE = 6;

    public AspectPathLibrariesWorkbookPage(IWorkspaceRoot iWorkspaceRoot, ListDialogField listDialogField) {
        this.fAspectPathList = listDialogField;
        this.fWorkspaceRoot = iWorkspaceRoot;
        this.fSWTControl = null;
        String[] stringArray = new String[]{AspectJPlugin.getResourceString("AspectPathLibrariesWorkbookPage.libraries.addjar.button"), AspectJPlugin.getResourceString("AspectPathLibrariesWorkbookPage.libraries.addextjar.button"), AspectJPlugin.getResourceString("AspectPathLibrariesWorkbookPage.libraries.addvariable.button"), AspectJPlugin.getResourceString("AspectPathLibrariesWorkbookPage.libraries.addlibrary.button"), null, AspectJPlugin.getResourceString("AspectPathLibrariesWorkbookPage.libraries.edit.button"), AspectJPlugin.getResourceString("AspectPathLibrariesWorkbookPage.libraries.remove.button")};
        LibrariesAdapter librariesAdapter = new LibrariesAdapter();
        this.fLibrariesList = new TreeListDialogField((ITreeListAdapter)librariesAdapter, stringArray, (ILabelProvider)new CPListLabelProvider());
        this.fLibrariesList.setDialogFieldListener((IDialogFieldListener)librariesAdapter);
        this.fLibrariesList.setLabelText(AspectJPlugin.getResourceString("AspectPathLibrariesWorkbookPage.libraries.aspectpath.label"));
        this.fLibrariesList.enableButton(6, false);
        this.fLibrariesList.enableButton(5, false);
        this.fLibrariesList.setViewerSorter((ViewerSorter)new CPListElementSorter());
    }

    public void init(IJavaProject iJavaProject) {
        this.fCurrJProject = iJavaProject;
        this.updateLibrariesList();
    }

    private void updateLibrariesList() {
        List list = this.fAspectPathList.getElements();
        ArrayList<CPListElement> arrayList = new ArrayList<CPListElement>(list.size());
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            CPListElement cPListElement = (CPListElement)list.get(i);
            if (!this.isEntryKind(cPListElement.getEntryKind())) continue;
            arrayList.add(cPListElement);
        }
        this.fLibrariesList.setElements(arrayList);
    }

    public Control getControl(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        LayoutUtil.doDefaultLayout((Composite)composite2, (DialogField[])new DialogField[]{this.fLibrariesList}, (boolean)true);
        LayoutUtil.setHorizontalGrabbing((Control)this.fLibrariesList.getTreeControl(null));
        int n = pixelConverter.convertWidthInCharsToPixels(24);
        this.fLibrariesList.setButtonsMinWidth(n);
        this.fLibrariesList.getTreeViewer().setSorter((ViewerSorter)new CPListElementSorter());
        this.fSWTControl = composite2;
        return composite2;
    }

    private Shell getShell() {
        if (this.fSWTControl != null) {
            return this.fSWTControl.getShell();
        }
        return AspectJPlugin.getDefault().getActiveWorkbenchWindow().getShell();
    }

    private void libaryPageCustomButtonPressed(DialogField dialogField, int n) {
        Object[] objectArray = null;
        switch (n) {
            case 0: {
                objectArray = this.openJarFileDialog(null);
                break;
            }
            case 1: {
                objectArray = this.openExtJarFileDialog(null);
                break;
            }
            case 2: {
                objectArray = this.openVariableSelectionDialog(null);
                break;
            }
            case 3: {
                objectArray = this.openContainerSelectionDialog(null);
                break;
            }
            case 5: {
                this.editEntry();
                return;
            }
            case 6: {
                this.removeEntry();
                return;
            }
        }
        if (objectArray != null) {
            int n2 = objectArray.length;
            List list = this.fLibrariesList.getElements();
            ArrayList<CPListElement> arrayList = new ArrayList<CPListElement>(n2);
            for (int i = 0; i < n2; ++i) {
                CPListElement cPListElement = objectArray[i];
                if (list.contains(cPListElement) || arrayList.contains(cPListElement)) continue;
                arrayList.add(cPListElement);
                cPListElement.setAttribute("sourcepath", (Object)BuildPathSupport.guessSourceAttachment((CPListElement)cPListElement));
                cPListElement.setAttribute("javadoc", (Object)JavaUI.getLibraryJavadocLocation((IPath)cPListElement.getPath()));
            }
            this.fLibrariesList.addElements(arrayList);
            if (n == 3) {
                this.fLibrariesList.refresh();
            }
            this.fLibrariesList.postSetSelection((ISelection)new StructuredSelection(objectArray));
        }
    }

    protected void libaryPageDoubleClicked(TreeListDialogField treeListDialogField) {
        List list = this.fLibrariesList.getSelectedElements();
        if (this.canEdit(list)) {
            this.editEntry();
        }
    }

    protected void libaryPageKeyPressed(TreeListDialogField treeListDialogField, KeyEvent keyEvent) {
        List list;
        if (treeListDialogField == this.fLibrariesList && keyEvent.character == '\u007f' && keyEvent.stateMask == 0 && this.canRemove(list = treeListDialogField.getSelectedElements())) {
            this.removeEntry();
        }
    }

    private void removeEntry() {
        List list = this.fLibrariesList.getSelectedElements();
        for (int i = list.size() - 1; i >= 0; --i) {
            Object e = list.get(i);
            if (!(e instanceof CPListElementAttribute)) continue;
            CPListElementAttribute cPListElementAttribute = (CPListElementAttribute)e;
            cPListElementAttribute.getParent().setAttribute(cPListElementAttribute.getKey(), null);
            list.remove(i);
        }
        if (list.isEmpty()) {
            this.fLibrariesList.refresh();
            this.fAspectPathList.dialogFieldChanged();
        } else {
            this.fLibrariesList.removeElements(list);
        }
    }

    private boolean canRemove(List list) {
        if (list.size() == 0) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            CPListElement cPListElement;
            Object e = list.get(i);
            if (!(e instanceof CPListElementAttribute ? ((CPListElementAttribute)e).getValue() == null : e instanceof CPListElement && (cPListElement = (CPListElement)e).getParentContainer() != null)) continue;
            return false;
        }
        return true;
    }

    private void editEntry() {
        List list = this.fLibrariesList.getSelectedElements();
        if (list.size() != 1) {
            return;
        }
        Object e = list.get(0);
        if (this.fLibrariesList.getIndexOfElement(e) != -1) {
            this.editElementEntry((CPListElement)e);
        } else if (e instanceof CPListElementAttribute) {
            this.editAttributeEntry((CPListElementAttribute)e);
        }
    }

    private void editAttributeEntry(CPListElementAttribute cPListElementAttribute) {
        String string = cPListElementAttribute.getKey();
        if (string.equals("sourcepath")) {
            Shell shell;
            IClasspathEntry iClasspathEntry;
            CPListElement cPListElement = cPListElementAttribute.getParent();
            IPath iPath = null;
            boolean bl = false;
            Object object = cPListElement.getParentContainer();
            if (object instanceof CPListElement) {
                iPath = ((CPListElement)object).getPath();
                bl = true;
            }
            if ((iClasspathEntry = BuildPathDialogAccess.configureSourceAttachment((Shell)(shell = this.getShell()), (IClasspathEntry)cPListElement.getClasspathEntry())) != null) {
                if (bl) {
                    try {
                        IRunnableWithProgress iRunnableWithProgress = SourceAttachmentBlock.getRunnable((Shell)shell, (IClasspathEntry)iClasspathEntry, (IJavaProject)this.fCurrJProject, (IPath)iPath);
                        PlatformUI.getWorkbench().getProgressService().run(true, true, iRunnableWithProgress);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        String string2 = AspectJPlugin.getResourceString("AspectPathLibrariesWorkbookPage.configurecontainer.error.title");
                        String string3 = AspectJPlugin.getResourceString("AspectPathLibrariesWorkbookPage.configurecontainer.error.message");
                        ExceptionHandler.handle((InvocationTargetException)invocationTargetException, (Shell)shell, (String)string2, (String)string3);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
                cPListElement.setAttribute("sourcepath", (Object)iClasspathEntry.getSourceAttachmentPath());
                this.fLibrariesList.refresh();
                this.fAspectPathList.refresh();
            }
        } else if (string.equals("javadoc")) {
            CPListElement cPListElement = cPListElementAttribute.getParent();
            URL uRL = (URL)cPListElement.getAttribute("javadoc");
            String string4 = new CPListLabelProvider().getText((Object)cPListElement);
            URL[] uRLArray = BuildPathDialogAccess.configureJavadocLocation((Shell)this.getShell(), (String)string4, (URL)uRL);
            if (uRLArray != null) {
                cPListElement.setAttribute("javadoc", (Object)uRLArray[0]);
                this.fLibrariesList.refresh();
            }
        }
    }

    private void editElementEntry(CPListElement cPListElement) {
        IResource iResource;
        CPListElement[] cPListElementArray = null;
        switch (cPListElement.getEntryKind()) {
            case 5: {
                cPListElementArray = this.openContainerSelectionDialog(cPListElement);
                break;
            }
            case 1: {
                iResource = cPListElement.getResource();
                if (iResource == null) {
                    cPListElementArray = this.openExtJarFileDialog(cPListElement);
                    break;
                }
                if (iResource.getType() != 1) break;
                cPListElementArray = this.openJarFileDialog(cPListElement);
                break;
            }
            case 4: {
                cPListElementArray = this.openVariableSelectionDialog(cPListElement);
            }
        }
        if (cPListElementArray != null && cPListElementArray.length > 0) {
            iResource = cPListElementArray[0];
            iResource.setExported(cPListElement.isExported());
            this.fLibrariesList.replaceElement((Object)cPListElement, (Object)iResource);
        }
    }

    private void libaryPageSelectionChanged(DialogField dialogField) {
        List list = this.fLibrariesList.getSelectedElements();
        this.fLibrariesList.enableButton(5, this.canEdit(list));
        this.fLibrariesList.enableButton(6, this.canRemove(list));
    }

    private boolean canEdit(List list) {
        if (list.size() != 1) {
            return false;
        }
        Object e = list.get(0);
        if (e instanceof CPListElement) {
            CPListElement cPListElement = (CPListElement)e;
            return !(cPListElement.getResource() instanceof IFolder) && cPListElement.getParentContainer() == null;
        }
        return e instanceof CPListElementAttribute;
    }

    private void libaryPageDialogFieldChanged(DialogField dialogField) {
        if (this.fCurrJProject != null) {
            this.updateAspectpathList();
        }
    }

    private void updateAspectpathList() {
        int n;
        List list = this.fLibrariesList.getElements();
        List list2 = this.fAspectPathList.getElements();
        int n2 = n = list2.size();
        for (int i = n - 1; i >= 0; --i) {
            CPListElement cPListElement = (CPListElement)list2.get(i);
            int n3 = cPListElement.getEntryKind();
            if (!this.isEntryKind(n3) || list.remove(cPListElement)) continue;
            list2.remove(i);
            n2 = i;
        }
        list2.addAll(n2, list);
        if (n2 != n || !list.isEmpty()) {
            this.fAspectPathList.setElements((Collection)list2);
        }
    }

    private CPListElement[] openClassFolderDialog(CPListElement cPListElement) {
        IPath[] iPathArray;
        if (cPListElement == null && (iPathArray = BuildPathDialogAccess.chooseClassFolderEntries((Shell)this.getShell(), (IPath)this.fCurrJProject.getPath(), (IPath[])this.getUsedContainers(cPListElement))) != null) {
            ArrayList<CPListElement> arrayList = new ArrayList<CPListElement>();
            for (int i = 0; i < iPathArray.length; ++i) {
                IPath iPath = iPathArray[i];
                IResource iResource = this.fWorkspaceRoot.findMember(iPath);
                if (!(iResource instanceof IContainer)) continue;
                arrayList.add(this.newCPLibraryElement(iResource));
            }
            return arrayList.toArray(new CPListElement[arrayList.size()]);
        }
        return null;
    }

    private CPListElement[] openJarFileDialog(CPListElement cPListElement) {
        if (cPListElement == null) {
            IPath[] iPathArray = BuildPathDialogAccess.chooseJAREntries((Shell)this.getShell(), (IPath)this.fCurrJProject.getPath(), (IPath[])this.getUsedContainers(cPListElement));
            if (iPathArray != null) {
                ArrayList<CPListElement> arrayList = new ArrayList<CPListElement>();
                for (int i = 0; i < iPathArray.length; ++i) {
                    IPath iPath = iPathArray[i];
                    IResource iResource = this.fWorkspaceRoot.findMember(iPath);
                    if (!(iResource instanceof IFile)) continue;
                    arrayList.add(this.newCPLibraryElement(iResource));
                }
                return arrayList.toArray(new CPListElement[arrayList.size()]);
            }
        } else {
            IResource iResource;
            IPath iPath = BuildPathDialogAccess.configureJAREntry((Shell)this.getShell(), (IPath)cPListElement.getPath(), (IPath[])this.getUsedJARFiles(cPListElement));
            if (iPath != null && (iResource = this.fWorkspaceRoot.findMember(iPath)) instanceof IFile) {
                return new CPListElement[]{this.newCPLibraryElement(iResource)};
            }
        }
        return null;
    }

    private IPath[] getUsedContainers(CPListElement cPListElement) {
        List list;
        ArrayList arrayList = new ArrayList();
        if (this.fCurrJProject.exists()) {
            try {
                list = this.fCurrJProject.getOutputLocation();
                if (list != null && list.segmentCount() > 1) {
                    arrayList.add(list);
                }
            }
            catch (JavaModelException javaModelException) {
                AspectJPlugin.getDefault().getLog().log(javaModelException.getStatus());
            }
        }
        list = this.fLibrariesList.getElements();
        for (int i = 0; i < list.size(); ++i) {
            IResource iResource;
            CPListElement cPListElement2 = (CPListElement)list.get(i);
            if (cPListElement2.getEntryKind() != 1 || cPListElement2 == cPListElement || !((iResource = cPListElement2.getResource()) instanceof IContainer) || iResource.equals(cPListElement)) continue;
            arrayList.add(iResource.getFullPath());
        }
        return arrayList.toArray(new IPath[arrayList.size()]);
    }

    private IPath[] getUsedJARFiles(CPListElement cPListElement) {
        ArrayList<IPath> arrayList = new ArrayList<IPath>();
        List list = this.fLibrariesList.getElements();
        for (int i = 0; i < list.size(); ++i) {
            IResource iResource;
            CPListElement cPListElement2 = (CPListElement)list.get(i);
            if (cPListElement2.getEntryKind() != 1 || cPListElement2 == cPListElement || !((iResource = cPListElement2.getResource()) instanceof IFile)) continue;
            arrayList.add(iResource.getFullPath());
        }
        return arrayList.toArray(new IPath[arrayList.size()]);
    }

    private CPListElement newCPLibraryElement(IResource iResource) {
        return new CPListElement(this.fCurrJProject, 1, iResource.getFullPath(), iResource);
    }

    private CPListElement[] openExtJarFileDialog(CPListElement cPListElement) {
        if (cPListElement == null) {
            IPath[] iPathArray = BuildPathDialogAccess.chooseExternalJAREntries((Shell)this.getShell());
            if (iPathArray != null) {
                ArrayList<CPListElement> arrayList = new ArrayList<CPListElement>();
                for (int i = 0; i < iPathArray.length; ++i) {
                    arrayList.add(new CPListElement(this.fCurrJProject, 1, iPathArray[i], null));
                }
                return arrayList.toArray(new CPListElement[arrayList.size()]);
            }
        } else {
            IPath iPath = BuildPathDialogAccess.configureExternalJAREntry((Shell)this.getShell(), (IPath)cPListElement.getPath());
            if (iPath != null) {
                return new CPListElement[]{new CPListElement(this.fCurrJProject, 1, iPath, null)};
            }
        }
        return null;
    }

    private CPListElement[] openVariableSelectionDialog(CPListElement cPListElement) {
        IPath iPath;
        List list = this.fLibrariesList.getElements();
        ArrayList<IPath> arrayList = new ArrayList<IPath>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            iPath = (IPath)list.get(i);
            if (iPath.getEntryKind() != 4) continue;
            arrayList.add(iPath.getPath());
        }
        IPath[] iPathArray = arrayList.toArray(new IPath[arrayList.size()]);
        if (cPListElement == null) {
            iPath = BuildPathDialogAccess.chooseVariableEntries((Shell)this.getShell(), (IPath[])iPathArray);
            if (iPath != null) {
                ArrayList<CPListElement> arrayList2 = new ArrayList<CPListElement>();
                for (int i = 0; i < ((IPath)iPath).length; ++i) {
                    CPListElement cPListElement2 = new CPListElement(this.fCurrJProject, 4, iPath[i], null);
                    IPath iPath2 = JavaCore.getResolvedVariablePath((IPath)iPath[i]);
                    cPListElement2.setIsMissing(iPath2 == null || !iPath2.toFile().exists());
                    if (list.contains(cPListElement2)) continue;
                    arrayList2.add(cPListElement2);
                }
                return arrayList2.toArray(new CPListElement[arrayList2.size()]);
            }
        } else {
            iPath = BuildPathDialogAccess.configureVariableEntry((Shell)this.getShell(), (IPath)cPListElement.getPath(), (IPath[])iPathArray);
            if (iPath != null) {
                CPListElement cPListElement3 = new CPListElement(this.fCurrJProject, 4, iPath, null);
                return new CPListElement[]{cPListElement3};
            }
        }
        return null;
    }

    private CPListElement[] openContainerSelectionDialog(CPListElement cPListElement) {
        if (cPListElement == null) {
            IClasspathEntry[] iClasspathEntryArray = BuildPathDialogAccess.chooseContainerEntries((Shell)this.getShell(), (IJavaProject)this.fCurrJProject, (IClasspathEntry[])this.getRawClasspath());
            if (iClasspathEntryArray != null) {
                CPListElement[] cPListElementArray = new CPListElement[iClasspathEntryArray.length];
                for (int i = 0; i < cPListElementArray.length; ++i) {
                    cPListElementArray[i] = new CPListElement(this.fCurrJProject, 5, iClasspathEntryArray[i].getPath(), null);
                }
                return cPListElementArray;
            }
        } else {
            IClasspathEntry iClasspathEntry = BuildPathDialogAccess.configureContainerEntry((Shell)this.getShell(), (IClasspathEntry)cPListElement.getClasspathEntry(), (IJavaProject)this.fCurrJProject, (IClasspathEntry[])this.getRawClasspath());
            if (iClasspathEntry != null) {
                CPListElement cPListElement2 = new CPListElement(this.fCurrJProject, 5, iClasspathEntry.getPath(), null);
                return new CPListElement[]{cPListElement2};
            }
        }
        return null;
    }

    private IClasspathEntry[] getRawClasspath() {
        IClasspathEntry[] iClasspathEntryArray = new IClasspathEntry[this.fAspectPathList.getSize()];
        for (int i = 0; i < iClasspathEntryArray.length; ++i) {
            CPListElement cPListElement = (CPListElement)this.fAspectPathList.getElement(i);
            iClasspathEntryArray[i] = cPListElement.getClasspathEntry();
        }
        return iClasspathEntryArray;
    }

    public boolean isEntryKind(int n) {
        return n == 1 || n == 4 || n == 5;
    }

    public List getSelection() {
        return this.fLibrariesList.getSelectedElements();
    }

    public void setSelection(List list) {
        this.fLibrariesList.selectElements((ISelection)new StructuredSelection(list));
    }

    private class LibrariesAdapter
    implements IDialogFieldListener,
    ITreeListAdapter {
        private final Object[] EMPTY_ARR = new Object[0];

        private LibrariesAdapter() {
        }

        public void customButtonPressed(TreeListDialogField treeListDialogField, int n) {
            AspectPathLibrariesWorkbookPage.this.libaryPageCustomButtonPressed((DialogField)treeListDialogField, n);
        }

        public void selectionChanged(TreeListDialogField treeListDialogField) {
            AspectPathLibrariesWorkbookPage.this.libaryPageSelectionChanged((DialogField)treeListDialogField);
        }

        public void doubleClicked(TreeListDialogField treeListDialogField) {
            AspectPathLibrariesWorkbookPage.this.libaryPageDoubleClicked(treeListDialogField);
        }

        public void keyPressed(TreeListDialogField treeListDialogField, KeyEvent keyEvent) {
            AspectPathLibrariesWorkbookPage.this.libaryPageKeyPressed(treeListDialogField, keyEvent);
        }

        public Object[] getChildren(TreeListDialogField treeListDialogField, Object object) {
            if (object instanceof CPListElement) {
                return ((CPListElement)object).getChildren(false);
            }
            return this.EMPTY_ARR;
        }

        public Object getParent(TreeListDialogField treeListDialogField, Object object) {
            if (object instanceof CPListElementAttribute) {
                return ((CPListElementAttribute)object).getParent();
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField treeListDialogField, Object object) {
            return this.getChildren(treeListDialogField, object).length > 0;
        }

        public void dialogFieldChanged(DialogField dialogField) {
            AspectPathLibrariesWorkbookPage.this.libaryPageDialogFieldChanged(dialogField);
        }
    }
}

