/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.internal.ui.ajde.ProjectProperties;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;

public class BuildConfigurationCreationPage
extends WizardNewFileCreationPage {
    private IWorkbench workbench;
    private Button includeProjectFilesCheckbox;
    private Button subsectionCheckbox;
    private Button openFileCheckbox;
    private static int nameCounter = 1;

    public BuildConfigurationCreationPage(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        super("CreateBuildConfigurationFilePage1", iStructuredSelection);
        this.setTitle(AspectJPlugin.getResourceString("BuildConfig.createLstFile"));
        this.setDescription(AspectJPlugin.getResourceString("BuildConfig.createLstDesc"));
        this.workbench = iWorkbench;
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        Composite composite2 = (Composite)this.getControl();
        GridData gridData = (GridData)composite2.getLayoutData();
        this.setFileName("buildConfig" + nameCounter + ".lst");
        new Label(composite2, 0);
        Group group = new Group(composite2, 0);
        group.setLayout((Layout)new GridLayout());
        group.setText(AspectJPlugin.getResourceString("BuildConfig.autoPopulate"));
        group.setLayoutData((Object)new GridData(768));
        this.includeProjectFilesCheckbox = new Button((Composite)group, 32);
        this.includeProjectFilesCheckbox.setText(AspectJPlugin.getResourceString("BuildConfig.includeAllSource"));
        this.includeProjectFilesCheckbox.setSelection(true);
        this.includeProjectFilesCheckbox.addListener(13, (Listener)this);
        new Label(composite2, 0);
        this.openFileCheckbox = new Button(composite2, 32);
        this.openFileCheckbox.setText(AspectJPlugin.getResourceString("BuildConfig.openForEdit"));
        this.openFileCheckbox.setSelection(true);
        this.setPageComplete(this.validatePage());
    }

    public boolean finish() {
        IFile iFile = this.createNewFile();
        if (iFile == null) {
            return false;
        }
        try {
            IWorkbenchWindow iWorkbenchWindow;
            IWorkbenchPage iWorkbenchPage;
            if (this.openFileCheckbox.getSelection() && (iWorkbenchPage = (iWorkbenchWindow = this.workbench.getActiveWorkbenchWindow()).getActivePage()) != null) {
                IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)iFile, (boolean)true);
            }
        }
        catch (PartInitException partInitException) {
            partInitException.printStackTrace();
            return false;
        }
        ++nameCounter;
        AJDTEventTrace.newConfigFileCreated(iFile);
        return true;
    }

    protected InputStream getInitialContents() {
        if (!this.includeProjectFilesCheckbox.getSelection()) {
            return null;
        }
        IProject iProject = AspectJPlugin.getDefault().getCurrentProject();
        String string = this.getContainerFullPath().makeAbsolute().toOSString();
        List list = AspectJPlugin.getDefault().getAjdtProjectProperties().getProjectSourceFiles(iProject, ProjectProperties.ASPECTJ_SOURCE_FILTER);
        String string2 = iProject.getFullPath().toOSString();
        IPath iPath = iProject.getLocation();
        iPath = iPath.removeLastSegments(1);
        String string3 = iPath.toOSString() + string;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            File file = (File)list.get(i);
            String string4 = file.getAbsolutePath();
            string4 = this.getRelativePath(string3, string4);
            stringBuffer.append(string4);
            stringBuffer.append("\n");
        }
        return new ByteArrayInputStream(stringBuffer.toString().getBytes());
    }

    private String getRelativePath(String string, String string2) {
        String string3;
        string = string.replace('/', '\\');
        string2 = string2.replace('/', '\\');
        int n = string.indexOf(92);
        int n2 = string2.indexOf(92);
        if (n2 != n || !string.startsWith(string2.substring(0, n2))) {
            return string2;
        }
        string = string.substring(n + 1).concat("\\");
        string2 = string2.substring(n2 + 1);
        String string4 = "";
        boolean bl = false;
        n = string.indexOf(92);
        n2 = string2.indexOf(92);
        while (n > 0 && n2 > 0) {
            string3 = string.substring(0, n);
            String string5 = string2.substring(0, n2);
            if (bl || !string3.equals(string5)) {
                bl = true;
                string4 = "..\\".concat(string4.concat(string5 + "\\"));
            }
            string = string.substring(n + 1);
            string2 = string2.substring(n2 + 1);
            n = string.indexOf(92);
            n2 = string2.indexOf(92);
        }
        if (n2 <= 0) {
            while (n > 0) {
                string3 = string.substring(0, n);
                string4 = "..\\".concat(string4);
                string = string.substring(n + 1);
                n = string.indexOf(92);
            }
        }
        return string4.concat(string2);
    }

    protected String getNewFileLabel() {
        return AspectJPlugin.getResourceString("BuildConfig.newLstFile");
    }
}

