/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICodeFormatter;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.ui.dialogs.TypeSelectionDialog;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewAspectCreationWizardPage
extends WizardPage
implements Listener {
    private Button includeProjectFilesCheckbox;
    private Button subsectionCheckbox;
    private Button openFileCheckbox;
    private Button createMainButton;
    private Button modPublicButton;
    private Button modAbstractButton;
    private Button modFinalButton;
    private Button modPrivilegedButton;
    private Button modStaticButton;
    private Button packageBrowseButton;
    private Button sourceBrowseButton;
    private Button enclosingTypeButton;
    private Button enclosingBrowseButton;
    private Button addInterfaceButton;
    private Button removeInterfaceButton;
    private Label packageLabel;
    private org.eclipse.swt.widgets.List interfaceList;
    private Text sourceText;
    private Text packageText;
    private Text nameText;
    private Text enclosingText;
    private Text extendsText;
    private Text implementsText;
    private String initialSourceString;
    private String initialPackageString;
    private String initialEnclosingTypeString;
    private IStructuredSelection currentSelection;
    private IWorkbench workbench;
    private IJavaProject jproject;
    private IPackageFragmentRoot fCurrRoot;
    private IJavaElement jelem;
    private IType fCurrEnclosingType;
    private IFile dotjavaFile;
    private static final Status okStatus = new Status(0, "org.eclipse.ajdt.ui", 0, "", null);
    private static final int SOURCE_STATUS = 0;
    private static final int PACKAGE_STATUS = 1;
    private static final int ENCLOSING_STATUS = 2;
    private static final int NAME_STATUS = 3;
    private Status[] statusArray = new Status[4];
    private static String lineDelimiter = System.getProperty("line.separator", "\n");
    private ImportManager imports;
    static /* synthetic */ Class class$org$eclipse$jdt$core$IJavaModel;
    static /* synthetic */ Class class$org$eclipse$jdt$core$IPackageFragmentRoot;
    static /* synthetic */ Class class$org$eclipse$jdt$core$IJavaProject;
    static /* synthetic */ Class class$org$eclipse$jdt$core$IJavaElement;
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

    public NewAspectCreationWizardPage(String string, IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        super(string);
        this.setPageComplete(false);
        this.currentSelection = iStructuredSelection;
        this.setTitle(AspectJPlugin.getResourceString("NewAspectCreationWizardPage.title"));
        this.setDescription(AspectJPlugin.getResourceString("NewAspectCreationWizardPage.description"));
        this.workbench = iWorkbench;
        this.init();
    }

    public void init() {
        this.jelem = NewAspectUtils.getInitialJavaElement(this.currentSelection);
        this.initSourceFolder(this.jelem);
        this.initPackage(this.jelem);
        this.initEnclosingType(this.jelem);
    }

    private void initSourceFolder(IJavaElement iJavaElement) {
        this.initialSourceString = "";
        if (iJavaElement != null) {
            this.fCurrRoot = JavaModelUtil.getPackageFragmentRoot((IJavaElement)iJavaElement);
            if (this.fCurrRoot == null || this.fCurrRoot.isArchive()) {
                this.jproject = iJavaElement.getJavaProject();
                if (this.jproject != null && this.jproject.exists()) {
                    this.fCurrRoot = null;
                    try {
                        IPackageFragmentRoot[] iPackageFragmentRootArray = this.jproject.getPackageFragmentRoots();
                        for (int i = 0; i < iPackageFragmentRootArray.length; ++i) {
                            if (iPackageFragmentRootArray[i].getKind() != 1) continue;
                            this.fCurrRoot = iPackageFragmentRootArray[i];
                            break;
                        }
                    }
                    catch (JavaModelException javaModelException) {
                        NewAspectUtils.LogException((Exception)((Object)javaModelException));
                    }
                }
            }
            if (this.fCurrRoot != null) {
                this.initialSourceString = this.fCurrRoot.getPath().makeRelative().toString();
            }
        }
    }

    private void initPackage(IJavaElement iJavaElement) {
        IPackageFragment iPackageFragment;
        this.initialPackageString = "";
        if (iJavaElement != null && (iPackageFragment = (IPackageFragment)iJavaElement.getAncestor(4)) != null) {
            this.initialPackageString = iPackageFragment.getElementName();
        }
    }

    private void initEnclosingType(IJavaElement iJavaElement) {
        IPackageFragment iPackageFragment = null;
        IType iType = null;
        if (iJavaElement != null) {
            iPackageFragment = (IPackageFragment)iJavaElement.getAncestor(4);
            IType iType2 = (IType)iJavaElement.getAncestor(7);
            if (iType2 != null) {
                if (iType2.getCompilationUnit() != null) {
                    iType = iType2;
                }
            } else {
                ICompilationUnit iCompilationUnit = (ICompilationUnit)iJavaElement.getAncestor(5);
                if (iCompilationUnit != null) {
                    iType = iCompilationUnit.findPrimaryType();
                }
            }
        }
        this.initialEnclosingTypeString = iType != null ? iType.getFullyQualifiedName() : "";
    }

    public void createControl(Composite composite) {
        int n;
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = n = 4;
        composite2.setLayout((Layout)gridLayout);
        new Label(composite2, 0).setText(AspectJPlugin.getResourceString("NewAspectCreationWizardPage.sourceFolder.label"));
        this.sourceText = new Text(composite2, 2048);
        this.sourceText.setText(this.initialSourceString);
        this.updateSourceStatus();
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = n - 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 350;
        this.sourceText.setLayoutData((Object)gridData);
        this.sourceBrowseButton = new Button(composite2, 8);
        this.sourceBrowseButton.setText(AspectJPlugin.getResourceString("NewAspectCreationWizardPage.sourceFolder.button"));
        this.sourceBrowseButton.addListener(13, (Listener)this);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = false;
        gridData.widthHint = NewAspectUtils.getButtonWidthHint(this.sourceBrowseButton);
        this.sourceBrowseButton.setLayoutData((Object)gridData);
        this.packageLabel = new Label(composite2, 0);
        this.packageLabel.setText(AspectJPlugin.getResourceString("NewAspectCreationWizardPage.package.label"));
        this.packageText = new Text(composite2, 2048);
        this.packageText.setText(this.initialPackageString);
        this.updatePackageStatus();
        gridData = new GridData(768);
        gridData.horizontalSpan = n - 2;
        gridData.grabExcessHorizontalSpace = true;
        this.packageText.setLayoutData((Object)gridData);
        this.packageBrowseButton = new Button(composite2, 8);
        this.packageBrowseButton.setText(AspectJPlugin.getResourceString("NewAspectCreationWizardPage.package.button"));
        this.packageBrowseButton.addListener(13, (Listener)this);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = false;
        gridData.widthHint = NewAspectUtils.getButtonWidthHint(this.packageBrowseButton);
        this.packageBrowseButton.setLayoutData((Object)gridData);
        if (this.statusArray[0] != okStatus) {
            this.packageBrowseButton.setEnabled(false);
        }
        this.enclosingTypeButton = new Button(composite2, 32);
        this.enclosingTypeButton.setText(AspectJPlugin.getResourceString("NewAspectCreationWizardPage.enclosingType.label"));
        this.enclosingTypeButton.addListener(13, (Listener)this);
        this.enclosingText = new Text(composite2, 2048);
        this.enclosingText.setText(this.initialEnclosingTypeString);
        this.enclosingText.setEnabled(false);
        this.updateEnclosingStatus();
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = n - 2;
        this.enclosingText.setLayoutData((Object)gridData);
        this.enclosingBrowseButton = new Button(composite2, 8);
        this.enclosingBrowseButton.setText(AspectJPlugin.getResourceString("NewAspectCreationWizardPage.enclosingType.button"));
        this.enclosingBrowseButton.addListener(13, (Listener)this);
        this.enclosingBrowseButton.setEnabled(false);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = false;
        gridData.widthHint = NewAspectUtils.getButtonWidthHint(this.enclosingBrowseButton);
        this.enclosingBrowseButton.setLayoutData((Object)gridData);
        NewAspectUtils.createLine(composite2, n);
        new Label(composite2, 0).setText(AspectJPlugin.getResourceString("NewAspectCreationWizardPage.typeName.label"));
        this.nameText = new Text(composite2, 2048);
        this.updateNameStatus();
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = n - 2;
        this.nameText.setLayoutData((Object)gridData);
        NewAspectUtils.createBlank(composite2);
        new Label(composite2, 0).setText(AspectJPlugin.getResourceString("NewAspectCreationWizardPage.modifiers.label"));
        Composite composite3 = new Composite(composite2, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = n - 2;
        composite3.setLayoutData((Object)gridData);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.marginWidth = 0;
        gridLayout2.marginHeight = 0;
        gridLayout2.numColumns = 5;
        composite3.setLayout((Layout)gridLayout2);
        this.modPublicButton = new Button(composite3, 32);
        this.modPublicButton.setSelection(true);
        this.modPublicButton.setText("public");
        this.modAbstractButton = new Button(composite3, 32);
        this.modAbstractButton.setSelection(false);
        this.modAbstractButton.setText("abstract");
        this.modFinalButton = new Button(composite3, 32);
        this.modFinalButton.setSelection(false);
        this.modFinalButton.setText("final");
        this.modPrivilegedButton = new Button(composite3, 32);
        this.modPrivilegedButton.setSelection(false);
        this.modPrivilegedButton.setText("privileged");
        this.modStaticButton = new Button(composite3, 32);
        this.modStaticButton.setSelection(false);
        this.modStaticButton.setEnabled(false);
        this.modStaticButton.setText("static");
        NewAspectUtils.createBlank(composite2);
        new Label(composite2, 0).setText(AspectJPlugin.getResourceString("NewAspectCreationWizardPage.supertype.label"));
        this.extendsText = new Text(composite2, 2048);
        this.extendsText.setText("java.lang.Object");
        gridData = new GridData(768);
        gridData.horizontalSpan = n - 2;
        gridData.grabExcessHorizontalSpace = true;
        this.extendsText.setLayoutData((Object)gridData);
        NewAspectUtils.createBlank(composite2);
        Label label = new Label(composite2, 0);
        label.setText(AspectJPlugin.getResourceString("NewAspectCreationWizardPage.interfaces.label"));
        gridData = new GridData(2);
        label.setLayoutData((Object)gridData);
        this.interfaceList = new org.eclipse.swt.widgets.List(composite2, 2050);
        gridData = new GridData(1808);
        gridData.horizontalSpan = n - 2;
        this.interfaceList.setLayoutData((Object)gridData);
        Composite composite4 = new Composite(composite2, 0);
        GridLayout gridLayout3 = new GridLayout();
        gridLayout3.marginWidth = 0;
        gridLayout3.marginHeight = 0;
        composite4.setLayout((Layout)gridLayout3);
        this.addInterfaceButton = new Button(composite4, 8);
        this.addInterfaceButton.setText(AspectJPlugin.getResourceString("NewAspectCreationWizardPage.interfaces.add.button"));
        this.addInterfaceButton.addListener(13, (Listener)this);
        gridData = new GridData(768);
        gridData.widthHint = NewAspectUtils.getButtonWidthHint(this.addInterfaceButton);
        this.addInterfaceButton.setLayoutData((Object)gridData);
        NewAspectUtils.createBlank(composite4);
        this.removeInterfaceButton = new Button(composite4, 8);
        this.removeInterfaceButton.setText(AspectJPlugin.getResourceString("NewAspectCreationWizardPage.interfaces.remove.button"));
        this.removeInterfaceButton.addListener(13, (Listener)this);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = false;
        gridData.widthHint = NewAspectUtils.getButtonWidthHint(this.removeInterfaceButton);
        this.sourceBrowseButton.setLayoutData((Object)gridData);
        this.removeInterfaceButton.setLayoutData((Object)gridData);
        Label label2 = new Label(composite2, 0);
        label2.setText(AspectJPlugin.getResourceString("NewAspectCreationWizardPage.methodStubs.label"));
        gridData = new GridData();
        gridData.horizontalSpan = n;
        label2.setLayoutData((Object)gridData);
        NewAspectUtils.createBlank(composite2);
        this.createMainButton = new Button(composite2, 32);
        this.createMainButton.setSelection(false);
        this.createMainButton.setText("public static void main(String[] args)");
        gridData = new GridData(768);
        gridData.horizontalSpan = n - 1;
        this.createMainButton.setLayoutData((Object)gridData);
        this.setControl((Control)composite2);
        this.sourceText.addListener(2, (Listener)this);
        this.packageText.addListener(2, (Listener)this);
        this.nameText.addListener(2, (Listener)this);
        this.enclosingText.addListener(2, (Listener)this);
    }

    public boolean isPageComplete() {
        if (this.statusArray[0] == null || this.statusArray[0].matches(4)) {
            return false;
        }
        if (this.statusArray[1] == null || this.statusArray[1].matches(4)) {
            return false;
        }
        return this.statusArray[3] != null && !this.statusArray[3].matches(4);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.nameText.setFocus();
        }
    }

    private void updateNameStatus() {
        this.statusArray[3] = okStatus;
        if (NewAspectUtils.isTextNonEmpty(this.nameText)) {
            String string = this.getTypeName();
            if (string.indexOf(46) != -1) {
                this.statusArray[3] = new Status(4, "org.eclipse.ajdt.ui", 0, AspectJPlugin.getResourceString("NewAspectCreationWizardPage.Name_field_cannot_be_qualified"), null);
            } else {
                IStatus iStatus = JavaConventions.validateJavaTypeName((String)string);
                if (iStatus.matches(4)) {
                    this.statusArray[3] = new Status(4, "org.eclipse.ajdt.ui", 0, iStatus.getMessage(), null);
                } else if (iStatus.matches(2)) {
                    this.statusArray[3] = new Status(2, "org.eclipse.ajdt.ui", 0, iStatus.getMessage(), null);
                }
            }
        } else {
            this.statusArray[3] = new Status(4, "org.eclipse.ajdt.ui", 0, AspectJPlugin.getResourceString("NewAspectCreationWizardPage.Name_field_cannot_be_empty"), null);
        }
    }

    private void updateSourceStatus() {
        this.statusArray[0] = okStatus;
        if (!NewAspectUtils.isTextNonEmpty(this.sourceText)) {
            this.statusArray[0] = new Status(4, "org.eclipse.ajdt.ui", 0, AspectJPlugin.getResourceString("NewAspectCreationWizardPage.Source_folder_cannot_be_empty"), null);
        } else {
            Path path = new Path(this.sourceText.getText());
            IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
            if (iResource == null) {
                this.statusArray[0] = new Status(4, "org.eclipse.ajdt.ui", 0, AspectJPlugin.getResourceString("NewAspectCreationWizardPage.Source_folder_does_not_exist"), null);
            }
        }
    }

    private void updatePackageStatus() {
        this.statusArray[1] = okStatus;
        if (NewAspectUtils.isTextNonEmpty(this.packageText)) {
            IStatus iStatus = JavaConventions.validatePackageName((String)this.packageText.getText());
            if (iStatus.matches(4)) {
                this.statusArray[1] = new Status(4, "org.eclipse.ajdt.ui", 0, iStatus.getMessage(), null);
            } else if (iStatus.matches(2)) {
                this.statusArray[1] = new Status(2, "org.eclipse.ajdt.ui", 0, iStatus.getMessage(), null);
            }
        }
    }

    private void updateEnclosingStatus() {
        this.statusArray[2] = okStatus;
        if (!this.enclosingTypeButton.getSelection()) {
            return;
        }
        this.fCurrEnclosingType = null;
        IPackageFragmentRoot iPackageFragmentRoot = this.getPackageFragmentRoot();
        if (iPackageFragmentRoot == null) {
            return;
        }
        String string = this.enclosingText.getText();
        if (string.length() == 0) {
            this.statusArray[2] = new Status(4, "org.eclipse.ajdt.ui", 0, AspectJPlugin.getResourceString("NewAspectCreationWizardPage.error.EnclosingTypeEnterName"), null);
            return;
        }
        try {
            IType iType = this.findType(iPackageFragmentRoot.getJavaProject(), string);
            if (iType == null) {
                this.statusArray[2] = new Status(4, "org.eclipse.ajdt.ui", 0, AspectJPlugin.getResourceString("NewAspectCreationWizardPage.error.EnclosingTypeNotExists"), null);
                return;
            }
            if (iType.getCompilationUnit() == null) {
                this.statusArray[2] = new Status(4, "org.eclipse.ajdt.ui", 0, AspectJPlugin.getResourceString("NewAspectCreationWizardPage.error.EnclosingNotInCU"), null);
                return;
            }
            if (!JavaModelUtil.isEditable((ICompilationUnit)iType.getCompilationUnit())) {
                this.statusArray[2] = new Status(4, "org.eclipse.ajdt.ui", 0, AspectJPlugin.getResourceString("NewAspectCreationWizardPage.error.EnclosingNotEditable"), null);
                return;
            }
            this.fCurrEnclosingType = iType;
            IPackageFragmentRoot iPackageFragmentRoot2 = JavaModelUtil.getPackageFragmentRoot((IJavaElement)iType);
            if (!iPackageFragmentRoot2.equals(iPackageFragmentRoot)) {
                this.statusArray[2] = new Status(2, "org.eclipse.ajdt.ui", 0, AspectJPlugin.getResourceString("NewAspectCreationWizardPage.warning.EnclosingNotInSourceFolder"), null);
            }
            return;
        }
        catch (JavaModelException javaModelException) {
            this.statusArray[2] = new Status(4, "org.eclipse.ajdt.ui", 0, AspectJPlugin.getResourceString("NewAspectCreationWizardPage.error.EnclosingTypeNotExists"), null);
            return;
        }
    }

    public void handleEvent(Event event) {
        IType iType;
        if (event.widget == this.nameText) {
            this.updateNameStatus();
        } else if (event.widget == this.sourceText) {
            this.updateSourceStatus();
            if (this.statusArray[0] == okStatus) {
                this.packageBrowseButton.setEnabled(true);
            } else {
                this.packageBrowseButton.setEnabled(false);
            }
        } else if (event.widget == this.packageText) {
            this.updatePackageStatus();
        } else if (event.widget == this.enclosingText) {
            this.updateEnclosingStatus();
        } else if (event.widget == this.sourceBrowseButton) {
            IPackageFragmentRoot iPackageFragmentRoot = this.chooseSourceContainer(this.jelem);
            if (iPackageFragmentRoot != null) {
                this.sourceText.setText(iPackageFragmentRoot.getPath().makeRelative().toString());
                this.fCurrRoot = iPackageFragmentRoot;
                this.updateSourceStatus();
            }
            if (this.statusArray[0] == okStatus) {
                this.packageBrowseButton.setEnabled(true);
            } else {
                this.packageBrowseButton.setEnabled(false);
            }
        } else if (event.widget == this.packageBrowseButton) {
            IPackageFragment iPackageFragment = this.choosePackage();
            if (iPackageFragment != null) {
                this.packageText.setText(iPackageFragment.getElementName());
                this.updatePackageStatus();
            }
        } else if (event.widget == this.enclosingTypeButton) {
            if (this.enclosingTypeButton.getSelection()) {
                this.enclosingText.setEnabled(true);
                this.enclosingBrowseButton.setEnabled(true);
                this.packageLabel.setEnabled(false);
                this.packageText.setEnabled(false);
                this.packageBrowseButton.setEnabled(false);
                this.modStaticButton.setEnabled(true);
                this.modStaticButton.setSelection(true);
            } else {
                this.enclosingText.setEnabled(false);
                this.enclosingBrowseButton.setEnabled(false);
                this.packageLabel.setEnabled(true);
                this.packageText.setEnabled(true);
                this.packageBrowseButton.setEnabled(true);
                this.modStaticButton.setEnabled(false);
                this.modStaticButton.setSelection(false);
            }
            this.updateEnclosingStatus();
        } else if (event.widget == this.addInterfaceButton) {
            SuperInterfaceSelectionDialog superInterfaceSelectionDialog = new SuperInterfaceSelectionDialog(this.getShell(), (IRunnableContext)this.getWizard().getContainer(), this.interfaceList, this.jproject);
            superInterfaceSelectionDialog.setTitle(AspectJPlugin.getResourceString("NewAspectCreationWizardPage.InterfacesDialog.class.title"));
            superInterfaceSelectionDialog.setMessage(AspectJPlugin.getResourceString("NewAspectCreationWizardPage.InterfacesDialog.message"));
            superInterfaceSelectionDialog.open();
        } else if (event.widget == this.removeInterfaceButton) {
            String[] stringArray = this.interfaceList.getSelection();
            for (int i = 0; i < stringArray.length; ++i) {
                this.interfaceList.remove(stringArray[i]);
            }
        } else if (event.widget == this.enclosingBrowseButton && (iType = this.chooseEnclosingType()) != null) {
            this.enclosingText.setText(iType.getFullyQualifiedName());
            this.updateEnclosingStatus();
        }
        this.applyToStatusLine(this.mostSevereStatus());
        this.getWizard().getContainer().updateButtons();
    }

    private IType findType(IJavaProject iJavaProject, String string) throws JavaModelException {
        if (iJavaProject.exists()) {
            return iJavaProject.findType(string);
        }
        return null;
    }

    private IStatus mostSevereStatus() {
        IStatus iStatus = this.severityMatch(4);
        if (iStatus != null) {
            return iStatus;
        }
        IStatus iStatus2 = this.severityMatch(2);
        if (iStatus2 != null) {
            return iStatus2;
        }
        IStatus iStatus3 = this.severityMatch(1);
        if (iStatus3 != null) {
            return iStatus3;
        }
        return okStatus;
    }

    private IStatus severityMatch(int n) {
        for (int i = 0; i < this.statusArray.length; ++i) {
            if (!this.statusArray[i].matches(n)) continue;
            return this.statusArray[i];
        }
        return null;
    }

    private void applyToStatusLine(IStatus iStatus) {
        String string = iStatus.getMessage();
        if (string.length() == 0) {
            string = null;
        }
        switch (iStatus.getSeverity()) {
            case 0: {
                this.setErrorMessage(null);
                this.setMessage(string);
                break;
            }
            case 2: {
                this.setErrorMessage(null);
                this.setMessage(string, 2);
                break;
            }
            case 1: {
                this.setErrorMessage(null);
                this.setMessage(string, 1);
                break;
            }
            default: {
                this.setErrorMessage(string);
                this.setMessage(null);
            }
        }
    }

    public String getTypeName() {
        return this.nameText.getText();
    }

    private IType chooseEnclosingType() {
        IPackageFragmentRoot iPackageFragmentRoot = this.getPackageFragmentRoot();
        if (iPackageFragmentRoot == null) {
            return null;
        }
        IJavaSearchScope iJavaSearchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{iPackageFragmentRoot});
        TypeSelectionDialog typeSelectionDialog = new TypeSelectionDialog(this.getShell(), (IRunnableContext)this.getWizard().getContainer(), 0, iJavaSearchScope);
        typeSelectionDialog.setTitle(AspectJPlugin.getResourceString("NewAspectCreationWizardPage.ChooseEnclosingTypeDialog.title"));
        typeSelectionDialog.setMessage(AspectJPlugin.getResourceString("NewAspectCreationWizardPage.ChooseEnclosingTypeDialog.description"));
        if (typeSelectionDialog.open() == 0) {
            return (IType)typeSelectionDialog.getFirstResult();
        }
        return null;
    }

    private IPackageFragmentRoot chooseSourceContainer(IJavaElement iJavaElement) {
        Class[] classArray = new Class[]{class$org$eclipse$jdt$core$IJavaModel == null ? (class$org$eclipse$jdt$core$IJavaModel = NewAspectCreationWizardPage.class$("org.eclipse.jdt.core.IJavaModel")) : class$org$eclipse$jdt$core$IJavaModel, class$org$eclipse$jdt$core$IPackageFragmentRoot == null ? (class$org$eclipse$jdt$core$IPackageFragmentRoot = NewAspectCreationWizardPage.class$("org.eclipse.jdt.core.IPackageFragmentRoot")) : class$org$eclipse$jdt$core$IPackageFragmentRoot, class$org$eclipse$jdt$core$IJavaProject == null ? (class$org$eclipse$jdt$core$IJavaProject = NewAspectCreationWizardPage.class$("org.eclipse.jdt.core.IJavaProject")) : class$org$eclipse$jdt$core$IJavaProject};
        TypedViewerFilter typedViewerFilter = new TypedViewerFilter(classArray){

            public boolean select(Viewer viewer, Object object, Object object2) {
                if (object2 instanceof IPackageFragmentRoot) {
                    try {
                        return ((IPackageFragmentRoot)object2).getKind() == 1;
                    }
                    catch (JavaModelException javaModelException) {
                        NewAspectUtils.LogException((Exception)((Object)javaModelException));
                        return false;
                    }
                }
                return super.select(viewer, object, object2);
            }
        };
        StandardJavaElementContentProvider standardJavaElementContentProvider = new StandardJavaElementContentProvider();
        JavaElementLabelProvider javaElementLabelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementTreeSelectionDialog elementTreeSelectionDialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)javaElementLabelProvider, (ITreeContentProvider)standardJavaElementContentProvider);
        elementTreeSelectionDialog.setSorter((ViewerSorter)new JavaElementSorter());
        elementTreeSelectionDialog.setTitle(AspectJPlugin.getResourceString("NewAspectCreationWizardPage.FolderSelectionDialog.title"));
        elementTreeSelectionDialog.setMessage(AspectJPlugin.getResourceString("NewAspectCreationWizardPage.FolderSelectionDialog.message"));
        elementTreeSelectionDialog.addFilter((ViewerFilter)typedViewerFilter);
        elementTreeSelectionDialog.setInput((Object)JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
        elementTreeSelectionDialog.setInitialSelection((Object)iJavaElement);
        if (elementTreeSelectionDialog.open() == 0) {
            Object object = elementTreeSelectionDialog.getFirstResult();
            if (object instanceof IJavaProject) {
                IJavaProject iJavaProject = (IJavaProject)object;
                return iJavaProject.getPackageFragmentRoot((IResource)iJavaProject.getProject());
            }
            if (object instanceof IPackageFragmentRoot) {
                return (IPackageFragmentRoot)object;
            }
            return null;
        }
        return null;
    }

    private IPackageFragment choosePackage() {
        IPackageFragmentRoot iPackageFragmentRoot = this.getPackageFragmentRoot();
        Object[] objectArray = null;
        try {
            if (iPackageFragmentRoot != null && iPackageFragmentRoot.exists()) {
                objectArray = iPackageFragmentRoot.getChildren();
            }
        }
        catch (JavaModelException javaModelException) {
            NewAspectUtils.LogException((Exception)((Object)javaModelException));
        }
        if (objectArray == null) {
            objectArray = new IJavaElement[]{};
        }
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT));
        elementListSelectionDialog.setIgnoreCase(false);
        elementListSelectionDialog.setTitle(AspectJPlugin.getResourceString("NewAspectCreationWizardPage.ChoosePackageDialog.title"));
        elementListSelectionDialog.setMessage(AspectJPlugin.getResourceString("NewAspectCreationWizardPage.ChoosePackageDialog.message"));
        elementListSelectionDialog.setEmptyListMessage(AspectJPlugin.getResourceString("NewAspectCreationWizardPage.ChoosePackageDialog.empty"));
        elementListSelectionDialog.setElements(objectArray);
        IPackageFragment iPackageFragment = this.getPackageFragment();
        if (iPackageFragment != null) {
            elementListSelectionDialog.setInitialSelections(new Object[]{iPackageFragment});
        }
        if (elementListSelectionDialog.open() == 0) {
            return (IPackageFragment)elementListSelectionDialog.getFirstResult();
        }
        return null;
    }

    private IPackageFragment getPackageFragment() {
        return this.fCurrRoot.getPackageFragment(this.packageText.getText());
    }

    public IType getEnclosingType() {
        if (this.enclosingTypeButton.getSelection()) {
            return this.fCurrEnclosingType;
        }
        return null;
    }

    public IPackageFragmentRoot getPackageFragmentRoot() {
        return this.fCurrRoot;
    }

    public boolean finish() {
        if (this.enclosingTypeButton.getSelection()) {
            this.createInnerType();
            return true;
        }
        IFile iFile = this.createNewFile();
        if (iFile == null) {
            return false;
        }
        InputStream inputStream = this.getInitialContents();
        this.createType(iFile, inputStream);
        try {
            IWorkbenchWindow iWorkbenchWindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
            if (iWorkbenchPage != null) {
                IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)iFile, (boolean)true);
            }
        }
        catch (PartInitException partInitException) {
            NewAspectUtils.LogException((Exception)((Object)partInitException));
            return false;
        }
        BasicNewResourceWizard.selectAndReveal((IResource)iFile, (IWorkbenchWindow)this.workbench.getActiveWorkbenchWindow());
        AJDTEventTrace.newAspectCreated(iFile);
        return true;
    }

    private IFile createNewFile() {
        IPackageFragment iPackageFragment;
        String string;
        Object object;
        String string2 = this.sourceText.getText();
        Path path = new Path(string2);
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource iResource = iWorkspaceRoot.findMember((IPath)path);
        IProject iProject = iResource.getProject();
        IResource iResource2 = null;
        String string3 = this.packageText.getText();
        if (iResource.getType() == 2) {
            object = (IFolder)iResource;
            iResource2 = object.findMember(string3);
        } else if (iResource.getType() == 4) {
            iResource2 = ((IProject)iResource).findMember(string3);
        } else {
            return null;
        }
        if (iResource2 == null) {
            object = JavaCore.create((IProject)iProject);
            string = object.getPackageFragmentRoot(iResource);
            try {
                iPackageFragment = string.createPackageFragment(string3, true, null);
                iResource2 = iPackageFragment.getResource();
            }
            catch (JavaModelException javaModelException) {
                NewAspectUtils.LogException((Exception)((Object)javaModelException));
            }
        }
        object = this.getTypeName();
        string = AspectJPreferences.getFileExt();
        iPackageFragment = iResource2.getFullPath().append((String)object + string);
        IFile iFile = iWorkspaceRoot.getFile((IPath)iPackageFragment);
        if (string.equals(".java")) {
            this.dotjavaFile = iFile;
        } else {
            IPath iPath = iPackageFragment.removeFileExtension().addFileExtension("java");
            this.dotjavaFile = iWorkspaceRoot.getFile(iPath);
        }
        return iFile;
    }

    protected InputStream getInitialContents() {
        String string = this.constructTypeStub();
        String string2 = this.doTemplate(string, lineDelimiter);
        return new ByteArrayInputStream(string2.getBytes());
    }

    private String getInnerTypeContents(ICompilationUnit iCompilationUnit, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(lineDelimiter);
        String string = this.getTypeComment(iCompilationUnit);
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append(lineDelimiter);
        }
        stringBuffer.append(this.constructTypeStub());
        return NewAspectUtils.codeFormat(stringBuffer.toString(), n, lineDelimiter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createInnerType() {
        try {
            IType iType = this.getEnclosingType();
            IFile iFile = null;
            if (iType.getResource().getType() == 1) {
                iFile = (IFile)iType.getResource();
            }
            ICompilationUnit iCompilationUnit = iType.getCompilationUnit();
            IEditorPart iEditorPart = JavaUI.openInEditor((IJavaElement)iCompilationUnit);
            IEditorInput iEditorInput = iEditorPart.getEditorInput();
            IWorkingCopyManager iWorkingCopyManager = JavaUI.getWorkingCopyManager();
            iWorkingCopyManager.connect(iEditorInput);
            try {
                ICompilationUnit iCompilationUnit2 = iWorkingCopyManager.getWorkingCopy(iEditorInput);
                IBuffer iBuffer = iCompilationUnit2.getBuffer();
                String string = iBuffer.getContents();
                int n = NewAspectUtils.getInnerInsertionPoint(string, iType.getElementName());
                int n2 = NewAspectUtils.getIndentUsed((IJavaElement)iType) + 1;
                String string2 = this.getInnerTypeContents(iCompilationUnit2, n2);
                iBuffer.replace(n, 0, string2);
                String string3 = this.imports.getImports();
                if (string3.length() > 0) {
                    int n3 = NewAspectUtils.getInnerImportsInsertionPoint(string.substring(0, n));
                    iBuffer.replace(n3, 0, lineDelimiter + string3);
                }
            }
            finally {
                iWorkingCopyManager.disconnect(iEditorInput);
            }
            AJDTEventTrace.newAspectCreated(iFile);
        }
        catch (CoreException coreException) {
            NewAspectUtils.LogException((Exception)((Object)coreException));
        }
    }

    public boolean createType(final IFile iFile, final InputStream inputStream) {
        WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void execute(IProgressMonitor iProgressMonitor) throws CoreException, InterruptedException {
                try {
                    iProgressMonitor.beginTask(AspectJPlugin.getResourceString("NewAspectCreationWizardPage.CreatingAspect.message"), 2000);
                    iFile.create(inputStream, false, iProgressMonitor);
                }
                catch (CoreException coreException) {
                    NewAspectUtils.LogException((Exception)((Object)coreException));
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)workspaceModifyOperation);
        }
        catch (InterruptedException interruptedException) {
            NewAspectUtils.LogException(interruptedException);
            return true;
        }
        catch (InvocationTargetException invocationTargetException) {
            NewAspectUtils.LogException(invocationTargetException);
            return true;
        }
        return true;
    }

    private String doTemplate(String string, String string2) {
        ICompilationUnit iCompilationUnit = JavaCore.createCompilationUnitFrom((IFile)this.dotjavaFile);
        try {
            String string3 = this.imports.getImports();
            String string4 = string3 + string2 + this.getTypeComment(iCompilationUnit);
            String string5 = CodeGeneration.getCompilationUnitContent((ICompilationUnit)iCompilationUnit, (String)string4, (String)string, (String)string2);
            return string5;
        }
        catch (CoreException coreException) {
            NewAspectUtils.LogException((Exception)((Object)coreException));
            return "";
        }
    }

    protected String getTypeComment(ICompilationUnit iCompilationUnit) {
        if (PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.jdt.ui.javadoc")) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                if (this.enclosingTypeButton.getSelection()) {
                    stringBuffer.append(JavaModelUtil.getTypeQualifiedName((IType)this.getEnclosingType())).append('.');
                }
                stringBuffer.append(this.getTypeName());
                String string = CodeGeneration.getTypeComment((ICompilationUnit)iCompilationUnit, (String)stringBuffer.toString(), (String)String.valueOf('\n'));
                if (string != null && this.isValidComment(string)) {
                    return string;
                }
            }
            catch (CoreException coreException) {
                NewAspectUtils.LogException((Exception)((Object)coreException));
            }
        }
        return "";
    }

    private boolean isValidComment(String string) {
        IScanner iScanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
        iScanner.setSource(string.toCharArray());
        try {
            int n = iScanner.getNextToken();
            while (n == 1001 || n == 1003 || n == 1002) {
                n = iScanner.getNextToken();
            }
            return n == 158;
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
    }

    private String getInterfaceString() {
        String[] stringArray = this.interfaceList.getItems();
        if (stringArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("implements ");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(this.imports.addImport(stringArray[i]));
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(" ");
        return stringBuffer.toString();
    }

    private String constructTypeStub() {
        String string;
        this.imports = new ImportManager();
        StringBuffer stringBuffer = new StringBuffer();
        if (this.modPublicButton.getSelection()) {
            stringBuffer.append("public ");
        }
        if (this.modAbstractButton.getSelection()) {
            stringBuffer.append("abstract ");
        }
        if (this.modFinalButton.getSelection()) {
            stringBuffer.append("final ");
        }
        if (this.modPrivilegedButton.getSelection()) {
            stringBuffer.append("privileged ");
        }
        if (this.modStaticButton.getSelection()) {
            stringBuffer.append("static ");
        }
        stringBuffer.append("aspect " + this.getTypeName() + " ");
        if (NewAspectUtils.isTextNonEmpty(this.extendsText) && !(string = this.extendsText.getText()).equals("java.lang.Object")) {
            stringBuffer.append("extends " + this.imports.addImport(string) + " ");
        }
        stringBuffer.append(this.getInterfaceString());
        stringBuffer.append("{");
        stringBuffer.append(lineDelimiter);
        if (this.createMainButton.getSelection()) {
            stringBuffer.append(lineDelimiter);
            stringBuffer.append("\tpublic static void main(String[] args) {");
            stringBuffer.append(lineDelimiter);
            stringBuffer.append("\t}");
        }
        stringBuffer.append(lineDelimiter);
        stringBuffer.append("}");
        stringBuffer.append(lineDelimiter);
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class SuperInterfaceSelectionDialog
    extends TypeSelectionDialog {
        private static final int ADD_ID = 1025;
        private org.eclipse.swt.widgets.List fList;
        private String[] fOldContent;

        public SuperInterfaceSelectionDialog(Shell shell, IRunnableContext iRunnableContext, org.eclipse.swt.widgets.List list, IJavaProject iJavaProject) {
            super(shell, iRunnableContext, 6, SuperInterfaceSelectionDialog.createSearchScope(iJavaProject));
            this.fList = list;
            this.fOldContent = this.fList.getItems();
            this.setStatusLineAboveButtons(true);
        }

        protected void createButtonsForButtonBar(Composite composite) {
            this.createButton(composite, 1025, "Add", true);
            super.createButtonsForButtonBar(composite);
        }

        protected void cancelPressed() {
            this.fList.setItems(this.fOldContent);
            super.cancelPressed();
        }

        protected void buttonPressed(int n) {
            if (n == 1025) {
                this.addSelectedInterface();
            }
            super.buttonPressed(n);
        }

        protected void okPressed() {
            this.addSelectedInterface();
            super.okPressed();
        }

        private void addSelectedInterface() {
            Object object = this.getLowerSelectedElement();
            if (object instanceof TypeInfo) {
                String string = ((TypeInfo)object).getFullyQualifiedName();
                if (this.fList.indexOf(string) == -1) {
                    this.fList.add(string);
                }
                this.updateStatus((IStatus)new Status(1, "org.eclipse.ajdt.ui", 0, AspectJPlugin.getResourceString("NewAspectCreationWizardPage.SuperInterfaceSelectionDialog.interfaceadded.info"), null));
            }
        }

        private static IJavaSearchScope createSearchScope(IJavaProject iJavaProject) {
            return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaProject[]{iJavaProject});
        }

        protected void handleDefaultSelected() {
            if (this.validateCurrentSelection()) {
                this.buttonPressed(1025);
            }
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
        }
    }

    class TypedViewerFilter
    extends ViewerFilter {
        private Class[] fAcceptedTypes;
        private Object[] fRejectedElements;

        public TypedViewerFilter(Class[] classArray) {
            this(classArray, null);
        }

        public TypedViewerFilter(Class[] classArray, Object[] objectArray) {
            Assert.isNotNull((Object)classArray);
            this.fAcceptedTypes = classArray;
            this.fRejectedElements = objectArray;
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            int n;
            if (this.fRejectedElements != null) {
                for (n = 0; n < this.fRejectedElements.length; ++n) {
                    if (!object2.equals(this.fRejectedElements[n])) continue;
                    return false;
                }
            }
            for (n = 0; n < this.fAcceptedTypes.length; ++n) {
                if (!this.fAcceptedTypes[n].isInstance(object2)) continue;
                return true;
            }
            return false;
        }
    }

    class ImportManager {
        private List importList = new ArrayList();

        ImportManager() {
        }

        public String addImport(String string) {
            int n = string.lastIndexOf(".");
            if (n == -1) {
                return string;
            }
            String string2 = string.substring(0, n + 1);
            if (!string2.equals("java.lang.")) {
                this.importList.add(string);
            }
            String string3 = string.substring(n + 1);
            return string3;
        }

        public String getImports() {
            if (this.importList.size() == 0) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.importList.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("import ");
                stringBuffer.append(iterator.next());
                stringBuffer.append(";");
                stringBuffer.append(lineDelimiter);
            }
            return stringBuffer.toString();
        }
    }

    public static class NewAspectUtils {
        public static void createBlank(Composite composite) {
            new Label(composite, 0);
        }

        public static void createLine(Composite composite, int n) {
            Label label = new Label(composite, 259);
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = n;
            label.setLayoutData((Object)gridData);
        }

        public static boolean isTextNonEmpty(Text text) {
            String string = text.getText();
            return string != null && string.trim().length() > 0;
        }

        public static int getButtonWidthHint(Button button) {
            if (button.getFont().equals((Object)JFaceResources.getDefaultFont())) {
                button.setFont(JFaceResources.getDialogFont());
            }
            GC gC = new GC((Drawable)button);
            gC.setFont(button.getFont());
            FontMetrics fontMetrics = gC.getFontMetrics();
            gC.dispose();
            int n = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
            return Math.max(n, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        }

        protected static IJavaElement getInitialJavaElement(IStructuredSelection iStructuredSelection) {
            IResource iResource;
            IAdaptable iAdaptable;
            IJavaProject[] iJavaProjectArray;
            IJavaProject iJavaProject = null;
            if (iStructuredSelection != null && !iStructuredSelection.isEmpty() && (iJavaProjectArray = iStructuredSelection.getFirstElement()) instanceof IAdaptable && (iJavaProject = (IJavaElement)(iAdaptable = (IAdaptable)iJavaProjectArray).getAdapter(class$org$eclipse$jdt$core$IJavaElement == null ? (class$org$eclipse$jdt$core$IJavaElement = NewAspectCreationWizardPage.class$("org.eclipse.jdt.core.IJavaElement")) : class$org$eclipse$jdt$core$IJavaElement)) == null && (iResource = (IResource)iAdaptable.getAdapter(class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = NewAspectCreationWizardPage.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource)) != null && iResource.getType() != 8) {
                while (iJavaProject == null && iResource.getType() != 4) {
                    iResource = iResource.getParent();
                    iJavaProject = (IJavaElement)iResource.getAdapter(class$org$eclipse$jdt$core$IJavaElement == null ? NewAspectCreationWizardPage.class$("org.eclipse.jdt.core.IJavaElement") : class$org$eclipse$jdt$core$IJavaElement);
                }
                if (iJavaProject == null) {
                    iJavaProject = JavaCore.create((IResource)iResource);
                }
            }
            if (iJavaProject == null || iJavaProject.getElementType() == 1) {
                try {
                    iJavaProjectArray = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
                    if (iJavaProjectArray.length == 1) {
                        iJavaProject = iJavaProjectArray[0];
                    }
                }
                catch (JavaModelException javaModelException) {
                    NewAspectUtils.LogException((Exception)((Object)javaModelException));
                }
            }
            return iJavaProject;
        }

        private static void LogException(Exception exception) {
            Status status = new Status(4, "org.eclipse.ajdt.ui", 0, exception.getMessage(), null);
            AspectJPlugin.getDefault().getLog().log((IStatus)status);
        }

        public static String codeFormat(String string, int n, String string2) {
            ICodeFormatter iCodeFormatter = ToolFactory.createDefaultCodeFormatter(null);
            return iCodeFormatter.format(string, n, null, string2);
        }

        public static int getTabWidth() {
            try {
                return Integer.parseInt((String)JavaCore.getOptions().get("org.eclipse.jdt.core.formatter.tabulation.size"));
            }
            catch (NumberFormatException numberFormatException) {
                return 4;
            }
        }

        public static int getIndentUsed(IJavaElement iJavaElement) throws JavaModelException {
            ICompilationUnit iCompilationUnit;
            if (iJavaElement instanceof ISourceReference && (iCompilationUnit = (ICompilationUnit)iJavaElement.getAncestor(5)) != null) {
                int n;
                int n2;
                IBuffer iBuffer = iCompilationUnit.getBuffer();
                for (n2 = n = ((ISourceReference)iJavaElement).getSourceRange().getOffset(); n2 > 0 && !NewAspectUtils.isLineDelimiterChar(iBuffer.getChar(n2 - 1)); --n2) {
                }
                return NewAspectUtils.computeIndent(iBuffer.getText(n2, n - n2), NewAspectUtils.getTabWidth());
            }
            return 0;
        }

        public static boolean isLineDelimiterChar(char c) {
            return c == '\n' || c == '\r';
        }

        public static boolean isIndentChar(char c) {
            return Character.isWhitespace(c) && !NewAspectUtils.isLineDelimiterChar(c);
        }

        public static int computeIndent(String string, int n) {
            int n2 = 0;
            int n3 = 0;
            int n4 = string.length();
            for (int i = 0; i < n4; ++i) {
                char c = string.charAt(i);
                if (c == '\t') {
                    ++n2;
                    n3 = 0;
                    continue;
                }
                if (NewAspectUtils.isIndentChar(c)) {
                    if (++n3 != n) continue;
                    ++n2;
                    n3 = 0;
                    continue;
                }
                return n2;
            }
            return n2;
        }

        public static int getInnerInsertionPoint(String string, String string2) {
            char c = '\u0000';
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < string.length(); ++i) {
                char c2 = string.charAt(i);
                if (c != '\u0000') {
                    int n;
                    if (c == '/' && c2 == '*') {
                        bl2 = true;
                    }
                    if (!bl2 && c == '/' && c2 == '/') {
                        bl = true;
                    }
                    if (!bl && !bl2 && string.regionMatches(i, string2, 0, string2.length()) && (n = string.indexOf("{", i + string2.length())) != -1) {
                        return n + 1;
                    }
                    if (c == '*' && c2 == '/') {
                        bl2 = false;
                    } else if (bl && c2 == '\n') {
                        bl = false;
                    }
                }
                c = c2;
            }
            return 0;
        }

        public static int getInnerImportsInsertionPoint(String string) {
            int n;
            char c = '\u0000';
            boolean bl = false;
            boolean bl2 = false;
            String string2 = "import";
            String string3 = "package";
            int n2 = -1;
            int n3 = -1;
            for (n = 0; n < string.length(); ++n) {
                char c2 = string.charAt(n);
                if (c != '\u0000') {
                    if (c == '/' && c2 == '*') {
                        bl2 = true;
                    }
                    if (!bl2 && c == '/' && c2 == '/') {
                        bl = true;
                    }
                    if (!bl && !bl2) {
                        if (string.regionMatches(n, string2, 0, string2.length())) {
                            n2 = n;
                        } else if (string.regionMatches(n, string3, 0, string3.length())) {
                            n3 = n;
                        }
                    }
                    if (c == '*' && c2 == '/') {
                        bl2 = false;
                    } else if (bl && c2 == '\n') {
                        bl = false;
                    }
                }
                c = c2;
            }
            if (n2 == -1 ? n3 != -1 && (n = string.indexOf(59, n3)) >= 0 : (n = string.indexOf(59, n2)) >= 0) {
                return n + 1;
            }
            return 0;
        }
    }
}

