/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ajdt.internal.ui.wizards.ResourceAddedPage;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class ResourceAddedWizard
extends Wizard
implements INewWizard {
    IWorkbench workbench;
    IStructuredSelection selection;
    ResourceAddedPage mainPage;
    List newResourcesList;

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.workbench = iWorkbench;
        this.selection = iStructuredSelection;
        this.setWindowTitle(AspectJPlugin.getResourceString("newResourcesWizard.wizardTitle"));
        this.newResourcesList = null;
    }

    public void setNewResources(List list) {
        this.newResourcesList = list;
    }

    public void addPages() {
        this.mainPage = new ResourceAddedPage(this.workbench, this.selection, this.newResourcesList);
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        Object object;
        IResource iResource;
        List list = this.mainPage.getSelectedResources();
        List list2 = this.mainPage.getSelectedBuildConfigFiles();
        if (list2.size() == 0 || list.size() == 0) {
            return true;
        }
        IProject iProject = ((IResource)list.get(0)).getProject();
        IPath iPath = iProject.getLocation();
        iPath = iPath.removeLastSegments(1);
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            iResource = (IResource)iterator.next();
            object = iPath.toOSString() + iResource.getFullPath().toOSString();
            if (((String)object).endsWith(".lst")) {
                stringBuffer.append("@");
            }
            stringBuffer.append((String)object);
            stringBuffer.append("\n");
        }
        iResource = list2.iterator();
        while (iResource.hasNext()) {
            object = (IResource)iResource.next();
            IFile iFile = (IFile)object;
            try {
                boolean bl = true;
                InputStream inputStream = iFile.getContents();
                byte[] byArray = new byte[inputStream.available()];
                inputStream.read(byArray);
                if (byArray[byArray.length - 1] == new String("\n").getBytes()[0]) {
                    bl = false;
                }
                ByteArrayInputStream byteArrayInputStream = null;
                byteArrayInputStream = bl ? new ByteArrayInputStream(new String("\n" + stringBuffer.toString()).getBytes()) : new ByteArrayInputStream(stringBuffer.toString().getBytes());
                iFile.appendContents((InputStream)byteArrayInputStream, true, false, null);
            }
            catch (Exception exception) {
                AspectJPlugin.getDefault().getErrorHandler().handleError(AspectJPlugin.getResourceString("newResourcesWizard.exceptionAppendingToBuildConfigFile") + iFile.getFullPath().toOSString(), exception);
            }
        }
        return true;
    }
}

