/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards.exports;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.ajdt.internal.ui.wizards.exports.AJModelBuildScriptGenerator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.AssemblyInformation;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.Policy;
import org.eclipse.pde.internal.build.SourceFeatureInformation;
import org.eclipse.pde.internal.build.SourceFeatureWriter;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.ant.FileSet;
import org.eclipse.pde.internal.build.builder.FeatureBuildScriptGenerator;
import org.eclipse.update.core.Feature;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.IPlatformEnvironment;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.PluginEntry;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.IncludedFeatureReferenceModel;
import org.eclipse.update.core.model.PluginEntryModel;
import org.eclipse.update.core.model.URLEntryModel;

public class AJFeatureBuildScriptGenerator
extends FeatureBuildScriptGenerator {
    protected boolean analyseIncludedFeatures = false;
    protected boolean analysePlugins = true;
    protected boolean sourceFeatureGeneration = false;
    protected boolean binaryFeature = true;
    private boolean scriptGeneration = true;
    protected String featureIdentifier;
    protected String searchedVersion;
    protected IFeature feature;
    protected String featureFullName;
    protected String featureFolderName;
    protected String featureRootLocation;
    protected String featureTempFolder;
    protected Feature sourceFeature;
    protected PluginEntry sourcePlugin;
    protected String sourceFeatureFullName;
    protected String sourceFeatureFullNameVersionned;
    protected SourceFeatureInformation sourceToGather;
    protected boolean sourcePluginOnly = false;
    private String[] extraPlugins = new String[0];

    public AJFeatureBuildScriptGenerator() {
    }

    public AJFeatureBuildScriptGenerator(String string, String string2, AssemblyInformation assemblyInformation) throws CoreException {
        if (string == null) {
            String string3 = Policy.bind((String)"error.missingFeatureId");
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 1, string3, null));
        }
        this.featureIdentifier = string;
        this.searchedVersion = string2;
        this.assemblyData = assemblyInformation;
    }

    protected List computeElements() throws CoreException {
        ArrayList<BundleDescription> arrayList = new ArrayList<BundleDescription>(5);
        IPluginEntry[] iPluginEntryArray = this.feature.getPluginEntries();
        for (int i = 0; i < iPluginEntryArray.length; ++i) {
            IPluginEntry iPluginEntry = iPluginEntryArray[i];
            VersionedIdentifier versionedIdentifier = iPluginEntry.getVersionedIdentifier();
            String string = versionedIdentifier.getVersion().toString();
            BundleDescription bundleDescription = this.getSite(false).getRegistry().getResolvedBundle(versionedIdentifier.getIdentifier(), string);
            if (bundleDescription == null && this.getBuildProperties().containsKey("generate.plugin@" + versionedIdentifier.getIdentifier())) {
                this.generateEmbeddedSource(versionedIdentifier.getIdentifier());
                bundleDescription = this.getSite(false).getRegistry().getResolvedBundle(versionedIdentifier.getIdentifier(), string);
            }
            if (bundleDescription == null) {
                String string2 = Policy.bind((String)"exception.missingPlugin", (String)iPluginEntry.getVersionedIdentifier().toString());
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 5, string2, null));
            }
            arrayList.add(bundleDescription);
            this.collectElementToAssemble(iPluginEntryArray[i]);
            this.collectSourcePlugins(iPluginEntryArray[i], bundleDescription);
        }
        return arrayList;
    }

    private void generateEmbeddedSource(String string) throws CoreException {
        AJFeatureBuildScriptGenerator aJFeatureBuildScriptGenerator = new AJFeatureBuildScriptGenerator(Utils.getArrayFromString((String)this.getBuildProperties().getProperty("generate.plugin@" + string))[0], null, this.assemblyData);
        aJFeatureBuildScriptGenerator.setGenerateIncludedFeatures(false);
        aJFeatureBuildScriptGenerator.setAnalyseChildren(this.analysePlugins);
        aJFeatureBuildScriptGenerator.setSourceFeatureGeneration(true);
        aJFeatureBuildScriptGenerator.setExtraPlugins(Utils.getArrayFromString((String)this.getBuildProperties().getProperty("generate.plugin@" + string)));
        aJFeatureBuildScriptGenerator.setBinaryFeatureGeneration(false);
        aJFeatureBuildScriptGenerator.setScriptGeneration(false);
        aJFeatureBuildScriptGenerator.setPluginPath(this.pluginPath);
        aJFeatureBuildScriptGenerator.setBuildSiteFactory(this.siteFactory);
        aJFeatureBuildScriptGenerator.setDevEntries(this.devEntries);
        aJFeatureBuildScriptGenerator.setCompiledElements(this.getCompiledElements());
        aJFeatureBuildScriptGenerator.setSourceToGather(this.sourceToGather);
        aJFeatureBuildScriptGenerator.setSourcePluginOnly(true);
        aJFeatureBuildScriptGenerator.setBuildingOSGi(AJFeatureBuildScriptGenerator.isBuildingOSGi());
        aJFeatureBuildScriptGenerator.generate();
    }

    public void setSourcePluginOnly(boolean bl) {
        this.sourcePluginOnly = bl;
    }

    private void collectSourcePlugins(IPluginEntry iPluginEntry, BundleDescription bundleDescription) {
        if (!this.sourceFeatureGeneration) {
            return;
        }
        if (iPluginEntry.getOS() == null && iPluginEntry.getWS() == null && iPluginEntry.getOSArch() == null) {
            this.sourceToGather.addElementEntry(Config.genericConfig(), bundleDescription);
            return;
        }
        List list = this.selectConfigs((IPlatformEnvironment)iPluginEntry);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.sourceToGather.addElementEntry((Config)iterator.next(), bundleDescription);
        }
    }

    public void setAnalyseChildren(boolean bl) {
        this.analysePlugins = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() throws CoreException {
        if (workingDirectory == null) {
            String string = Policy.bind((String)"error.missingInstallLocation");
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 2, string, null));
        }
        this.initializeVariables();
        String string = (String)this.getBuildProperties().get("custom");
        if ("true".equalsIgnoreCase(string)) {
            File file = new File(this.featureRootLocation, "build.xml");
            try {
                this.updateVersion(file, "feature.version.suffix", this.feature.getVersionedIdentifier().getVersion().toString());
            }
            catch (IOException iOException) {
                String string2 = Policy.bind((String)"exception.writeScript", (String)file.toString());
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 7, string2, (Throwable)iOException));
            }
            return;
        }
        if (this.sourceFeatureGeneration) {
            this.generateSourceFeature();
        }
        if (this.analysePlugins) {
            this.generateChildrenScripts();
        }
        if (this.sourceFeatureGeneration) {
            this.addSourceFragmentsToFeature();
            this.writeSourceFeature();
        }
        if (!this.sourcePluginOnly) {
            this.collectElementToAssemble(this.feature);
        }
        if (this.analyseIncludedFeatures) {
            this.generateIncludedFeatureBuildFile();
        }
        if (this.sourceFeatureGeneration) {
            this.generateSourceFeatureScripts();
        }
        if (this.scriptGeneration) {
            this.openScript(this.featureRootLocation, "build.xml");
            try {
                this.generateBuildScript();
            }
            finally {
                this.closeScript();
            }
        }
    }

    protected void generateIncludedFeatureBuildFile() throws CoreException {
        IIncludedFeatureReference[] iIncludedFeatureReferenceArray = this.feature.getIncludedFeatureReferences();
        for (int i = 0; i < iIncludedFeatureReferenceArray.length; ++i) {
            String string = ((IncludedFeatureReferenceModel)iIncludedFeatureReferenceArray[i]).getFeatureIdentifier();
            boolean bl = this.getBuildProperties().containsKey("generate.feature@" + string);
            AJFeatureBuildScriptGenerator aJFeatureBuildScriptGenerator = new AJFeatureBuildScriptGenerator(bl ? Utils.getArrayFromString((String)this.getBuildProperties().getProperty("generate.feature@" + string))[0] : string, null, this.assemblyData);
            aJFeatureBuildScriptGenerator.setGenerateIncludedFeatures(!bl);
            aJFeatureBuildScriptGenerator.setAnalyseChildren(this.analysePlugins);
            aJFeatureBuildScriptGenerator.setSourceFeatureGeneration(bl);
            aJFeatureBuildScriptGenerator.setBinaryFeatureGeneration(!bl);
            aJFeatureBuildScriptGenerator.setScriptGeneration(!bl);
            if (bl) {
                aJFeatureBuildScriptGenerator.setExtraPlugins(Utils.getArrayFromString((String)this.getBuildProperties().getProperty("generate.feature@" + string)));
            }
            aJFeatureBuildScriptGenerator.setPluginPath(this.pluginPath);
            aJFeatureBuildScriptGenerator.setBuildSiteFactory(this.siteFactory);
            aJFeatureBuildScriptGenerator.setDevEntries(this.devEntries);
            aJFeatureBuildScriptGenerator.setCompiledElements(this.getCompiledElements());
            aJFeatureBuildScriptGenerator.setSourceToGather(new SourceFeatureInformation());
            aJFeatureBuildScriptGenerator.setBuildingOSGi(AJFeatureBuildScriptGenerator.isBuildingOSGi());
            aJFeatureBuildScriptGenerator.generate();
        }
    }

    protected void setExtraPlugins(String[] stringArray) {
        this.extraPlugins = stringArray;
    }

    private void generateBuildScript() throws CoreException {
        if (BundleHelper.getDefault().isDebugging()) {
            System.out.println("Generating feature " + this.featureFullName);
        }
        this.generatePrologue();
        this.generateAllPluginsTarget();
        this.generateAllFeaturesTarget();
        this.generateUpdateFeatureFile();
        this.generateAllChildrenTarget();
        this.generateChildrenTarget();
        this.generateBuildJarsTarget();
        this.generateBuildZipsTarget();
        this.generateBuildUpdateJarTarget();
        this.generateGatherBinPartsTarget();
        this.generateZipDistributionWholeTarget();
        this.generateZipSourcesTarget();
        this.generateZipLogsTarget();
        this.generateCleanTarget();
        this.generateRefreshTarget();
        this.generateGatherSourcesTarget();
        this.generateGatherLogsTarget();
        this.generateEpilogue();
    }

    private void generateGatherSourcesTarget() throws CoreException {
        this.script.printTargetDeclaration("gather.sources", null, null, null, null);
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("destination.temp.folder", this.getPropertyFormat("feature.temp.folder") + '/' + "plugins" + '/' + this.sourceFeatureFullNameVersionned + '/' + "src");
        hashMap.put("target", "gather.sources");
        this.script.printAntCallTask("children", null, hashMap);
        this.script.printTargetEnd();
    }

    private void generateGatherLogsTarget() {
        this.script.println();
        this.script.printTargetDeclaration("gather.logs", "init", null, null, null);
        this.script.printMkdirTask(this.featureTempFolder);
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("target", "gather.logs");
        hashMap.put("destination.temp.folder", new Path(this.featureTempFolder).append("plugins").toString());
        this.script.printAntCallTask("all.children", "false", hashMap);
        this.script.printTargetEnd();
    }

    private void generateUpdateFeatureFile() {
        this.script.printTargetDeclaration("update.feature", "init", null, null, null);
        this.script.printTargetEnd();
    }

    private void generateBuildZipsTarget() throws CoreException {
        StringBuffer stringBuffer = new StringBuffer();
        Properties properties = this.getBuildProperties();
        Object object = properties.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry<Object, Object> entry = object.next();
            String string = (String)entry.getKey();
            if (!string.startsWith("source.") || !string.endsWith(".zip")) continue;
            String string2 = string.substring("source.".length());
            stringBuffer.append(',');
            stringBuffer.append(string2);
            this.generateZipIndividualTarget(string2, (String)entry.getValue());
        }
        this.script.println();
        this.script.printTargetDeclaration("build.zips", "init" + stringBuffer.toString(), null, null, null);
        object = new HashMap(2);
        object.put("target", "build.zips");
        this.script.printAntCallTask("all.children", null, (Map)object);
        this.script.printTargetEnd();
    }

    private void generateZipIndividualTarget(String string, String string2) throws CoreException {
        this.script.println();
        this.script.printTargetDeclaration(string, "init", null, null, null);
        this.script.printZipTask(this.getPropertyFormat("basedir") + '/' + string, this.getPropertyFormat("basedir") + '/' + string2, false, false, null);
        this.script.printTargetEnd();
    }

    private void generateCleanTarget() throws CoreException {
        this.script.println();
        this.script.printTargetDeclaration("clean", "init", null, null, Policy.bind((String)"build.feature.clean", (String)this.featureIdentifier));
        this.script.printDeleteTask(null, this.getPropertyFormat("feature.destination") + '/' + this.featureFullName + ".jar", null);
        this.script.printDeleteTask(null, this.getPropertyFormat("feature.destination") + '/' + this.featureFullName + ".bin.dist.zip", null);
        this.script.printDeleteTask(null, this.getPropertyFormat("feature.destination") + '/' + this.featureFullName + ".log.zip", null);
        this.script.printDeleteTask(null, this.getPropertyFormat("feature.destination") + '/' + this.featureFullName + ".src.zip", null);
        this.script.printDeleteTask(this.featureTempFolder, null, null);
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("target", "clean");
        this.script.printAntCallTask("all.children", null, hashMap);
        this.script.printTargetEnd();
    }

    private void generateZipLogsTarget() {
        this.script.println();
        this.script.printTargetDeclaration("zip.logs", "init", null, null, null);
        this.script.printDeleteTask(this.featureTempFolder, null, null);
        this.script.printMkdirTask(this.featureTempFolder);
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("include.children", "true");
        hashMap.put("target", "gather.logs");
        hashMap.put("destination.temp.folder", new Path(this.featureTempFolder).append("plugins").toString());
        this.script.printAntCallTask("all.children", "false", hashMap);
        IPath iPath = new Path(this.getPropertyFormat("feature.destination")).append(this.featureFullName + ".log.zip");
        this.script.printZipTask(iPath.toString(), this.featureTempFolder, true, false, null);
        this.script.printDeleteTask(this.featureTempFolder, null, null);
        this.script.printTargetEnd();
    }

    protected void generateZipSourcesTarget() {
        this.script.println();
        this.script.printTargetDeclaration("zip.sources", "init", null, null, null);
        this.script.printDeleteTask(this.featureTempFolder, null, null);
        this.script.printMkdirTask(this.featureTempFolder);
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("include.children", "true");
        hashMap.put("target", "gather.sources");
        hashMap.put("destination.temp.folder", this.featureTempFolder + '/' + "plugins" + '/' + this.sourceFeatureFullNameVersionned + '/' + "src");
        this.script.printAntCallTask("all.children", null, hashMap);
        this.script.printZipTask(this.getPropertyFormat("feature.destination") + '/' + this.featureFullName + ".src.zip", this.featureTempFolder, true, false, null);
        this.script.printDeleteTask(this.featureTempFolder, null, null);
        this.script.printTargetEnd();
    }

    private void generateGatherBinPartsTarget() throws CoreException {
        this.script.println();
        this.script.printTargetDeclaration("gather.bin.parts", "init", "feature.base", null, null);
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("target", "gather.bin.parts");
        hashMap.put("destination.temp.folder", new Path(this.getPropertyFormat("feature.base")).append("plugins").toString());
        this.script.printAntCallTask("children", null, hashMap);
        String string = (String)this.getBuildProperties().get("bin.includes");
        String string2 = (String)this.getBuildProperties().get("bin.excludes");
        String string3 = this.getPropertyFormat("feature.base") + '/' + this.featureFolderName;
        if (AbstractScriptGenerator.outputFormat.equalsIgnoreCase("folder") && string != null) {
            this.script.printMkdirTask(string3);
        }
        if (AbstractScriptGenerator.outputFormat.equalsIgnoreCase("antzip") && AbstractScriptGenerator.outputFormat.equalsIgnoreCase("zip") && string != null) {
            this.script.printMkdirTask(string3);
        }
        if (string != null) {
            VersionedIdentifier versionedIdentifier;
            Object object;
            String string4;
            if (string != null || string2 != null) {
                string4 = new FileSet(this.getPropertyFormat("basedir"), null, string, null, string2, null, null);
                this.script.printCopyTask(null, string3, new FileSet[]{string4}, true);
            }
            string4 = "";
            IIncludedFeatureReference[] iIncludedFeatureReferenceArray = this.feature.getRawIncludedFeatureReferences();
            for (int i = 0; i < iIncludedFeatureReferenceArray.length; ++i) {
                object = iIncludedFeatureReferenceArray[i].getVersionedIdentifier().getVersion().toString();
                IFeature iFeature = this.getSite(false).findFeature(iIncludedFeatureReferenceArray[i].getVersionedIdentifier().getIdentifier(), (String)object, true);
                versionedIdentifier = iFeature.getVersionedIdentifier();
                string4 = string4 + versionedIdentifier.getIdentifier() + ',' + versionedIdentifier.getVersion().toString() + ',';
            }
            String string5 = "";
            object = this.feature.getRawPluginEntries();
            for (int i = 0; i < ((IPluginEntry[])object).length; ++i) {
                versionedIdentifier = object[i].getVersionedIdentifier();
                String string6 = versionedIdentifier.getVersion().toString();
                String string7 = versionedIdentifier.getIdentifier();
                BundleDescription bundleDescription = this.getSite(false).getRegistry().getResolvedBundle(string7, string6);
                if (bundleDescription == null) continue;
                string5 = string5 + string7 + ',' + bundleDescription.getVersion() + ',';
            }
            this.script.println("<eclipse.idReplacer featureFilePath=\"" + string3 + '/' + "feature.xml" + "\"  selfVersion=\"" + this.feature.getVersionedIdentifier().getVersion() + "\" featureIds=\"" + string4 + "\" pluginIds=\"" + string5 + "\"/>");
        }
        this.generateRootFilesAndPermissionsCalls();
        this.script.printTargetEnd();
        this.generateRootFilesAndPermissions();
    }

    private void generateRootFilesAndPermissionsCalls() {
        this.script.printAntCallTask("rootFiles" + this.getPropertyFormat("os") + '_' + this.getPropertyFormat("ws") + '_' + this.getPropertyFormat("arch"), null, null);
    }

    private void generateRootFilesAndPermissions() throws CoreException {
        Iterator iterator = AJFeatureBuildScriptGenerator.getConfigInfos().iterator();
        while (iterator.hasNext()) {
            Config config = (Config)iterator.next();
            this.script.printTargetDeclaration("rootFiles" + config.toString("_"), null, null, null, null);
            this.generateCopyRootFiles(config);
            this.generatePermissions(config);
            this.script.printTargetEnd();
        }
    }

    private void generateCopyRootFiles(Config config) throws CoreException {
        String string = this.getBuildProperties().getProperty("root", "");
        String string2 = this.getBuildProperties().getProperty("root." + config.toString("."), "");
        if ((string2 = (string2.length() == 0 ? "" : string2 + ',') + string).equals("")) {
            return;
        }
        this.assemblyData.addRootFileProvider(config, this.feature);
        String string3 = config.toStringReplacingAny(".", "ANY");
        this.script.printMkdirTask(this.getPropertyFormat("feature.base") + '/' + string3 + '/' + this.getPropertyFormat("collectingFolder"));
        String[] stringArray = Utils.getArrayFromString((String)string2, (String)",");
        FileSet[] fileSetArray = new FileSet[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = this.getPropertyFormat("basedir") + '/';
            String string5 = stringArray[i];
            if (string5.startsWith("absolute:")) {
                string5 = string5.substring(9);
                string4 = "";
            }
            if (string5.startsWith("file:")) {
                Path path = new Path(string5.substring(5));
                fileSetArray[i] = new FileSet(string4 + path.removeLastSegments(1), null, path.lastSegment(), null, null, null, null);
                continue;
            }
            fileSetArray[i] = new FileSet(string4 + string5, null, "**", null, null, null, null);
        }
        this.script.printCopyTask(null, this.getPropertyFormat("feature.base") + '/' + string3 + '/' + this.getPropertyFormat("collectingFolder"), fileSetArray, true);
    }

    private void generatePermissions(Config config) throws CoreException {
        String string = config.toString(".");
        Properties properties = this.getBuildProperties();
        String string2 = "root." + string + '.' + "permissions" + '.';
        String string3 = "root." + string + '.' + "link";
        String string4 = "root.permissions.";
        String string5 = "root.link";
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String string6 = (String)entry.getKey();
            String string7 = (String)entry.getValue();
            if (string6.startsWith(string2)) {
                this.generateChmodInstruction(this.getPropertyFormat("feature.base") + '/' + string + '/' + this.getPropertyFormat("collectingFolder"), string6.substring(string2.length()), string7);
                continue;
            }
            if (string6.startsWith(string3)) {
                this.generateLinkInstruction(this.getPropertyFormat("feature.base") + '/' + string + '/' + this.getPropertyFormat("collectingFolder"), string7);
                continue;
            }
            if (string6.startsWith(string4)) {
                this.generateChmodInstruction(this.getPropertyFormat("feature.base") + '/' + string + '/' + this.getPropertyFormat("collectingFolder"), string6.substring(string4.length()), string7);
                continue;
            }
            if (!string6.startsWith(string5)) continue;
            this.generateLinkInstruction(this.getPropertyFormat("feature.base") + '/' + string + '/' + this.getPropertyFormat("collectingFolder"), string7);
        }
    }

    private void generateChmodInstruction(String string, String string2, String string3) {
        if (string2.equals("executable")) {
            string2 = "755";
        }
        this.script.printChmod(string, string2, string3);
    }

    private void generateLinkInstruction(String string, String string2) {
        String[] stringArray = Utils.getArrayFromString((String)string2, (String)",");
        ArrayList<String> arrayList = new ArrayList<String>(2);
        for (int i = 0; i < stringArray.length; i += 2) {
            arrayList.add("-s");
            arrayList.add(stringArray[i]);
            arrayList.add(stringArray[i + 1]);
            this.script.printExecTask("ln", string, arrayList, "Linux");
            arrayList.clear();
        }
    }

    private void generateBuildUpdateJarTarget() {
        this.script.println();
        this.script.printTargetDeclaration("build.update.jar", "init", null, null, Policy.bind((String)"build.feature.buildUpdateJar", (String)this.featureIdentifier));
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("target", "build.update.jar");
        this.script.printAntCallTask("all.children", null, hashMap);
        this.script.printProperty("feature.base", this.featureTempFolder);
        this.script.printDeleteTask(this.featureTempFolder, null, null);
        this.script.printMkdirTask(this.featureTempFolder);
        hashMap.clear();
        hashMap.put("feature.base", this.featureTempFolder);
        hashMap.put("os", this.feature.getOS() == null ? Config.ANY : this.feature.getOS());
        hashMap.put("ws", this.feature.getWS() == null ? Config.ANY : this.feature.getWS());
        hashMap.put("arch", this.feature.getOSArch() == null ? Config.ANY : this.feature.getOSArch());
        hashMap.put("nl", this.feature.getNL() == null ? Config.ANY : this.feature.getNL());
        this.script.printAntCallTask("gather.bin.parts", "false", hashMap);
        this.script.printJarTask(this.getPropertyFormat("feature.destination") + '/' + this.featureFullName + ".jar", this.featureTempFolder + '/' + this.featureFolderName);
        this.script.printDeleteTask(this.featureTempFolder, null, null);
        this.script.printTargetEnd();
    }

    protected void generateZipDistributionWholeTarget() {
        this.script.println();
        this.script.printTargetDeclaration("zip.distribution", "init", null, null, Policy.bind((String)"build.feature.zips", (String)this.featureIdentifier));
        this.script.printDeleteTask(this.featureTempFolder, null, null);
        this.script.printMkdirTask(this.featureTempFolder);
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("feature.base", this.featureTempFolder);
        hashMap.put("include.children", "true");
        hashMap.put("os", this.feature.getOS() == null ? Config.ANY : this.feature.getOS());
        hashMap.put("ws", this.feature.getWS() == null ? Config.ANY : this.feature.getWS());
        hashMap.put("arch", this.feature.getOSArch() == null ? Config.ANY : this.feature.getOSArch());
        hashMap.put("nl", this.feature.getNL() == null ? Config.ANY : this.feature.getNL());
        this.script.printAntCallTask("gather.bin.parts", null, hashMap);
        this.script.printZipTask(this.getPropertyFormat("feature.destination") + '/' + this.featureFullName + ".bin.dist.zip", this.featureTempFolder, false, false, null);
        this.script.printDeleteTask(this.featureTempFolder, null, null);
        this.script.printTargetEnd();
    }

    private void generateAllChildrenTarget() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("init");
        stringBuffer.append(',');
        stringBuffer.append("all.features");
        stringBuffer.append(',');
        stringBuffer.append("all.plugins");
        stringBuffer.append(',');
        stringBuffer.append("update.feature");
        this.script.println();
        this.script.printTargetDeclaration("all.children", stringBuffer.toString(), null, null, null);
        this.script.printTargetEnd();
    }

    protected void generateAllPluginsTarget() throws CoreException {
        List list = this.computeElements();
        list = Utils.extractPlugins((List)this.getSite(false).getRegistry().getSortedBundles(), (List)list);
        this.script.println();
        this.script.printTargetDeclaration("all.plugins", "init", null, null, null);
        HashSet<BundleDescription> hashSet = new HashSet<BundleDescription>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            BundleDescription bundleDescription = (BundleDescription)iterator.next();
            if (hashSet.contains(bundleDescription)) continue;
            hashSet.add(bundleDescription);
            IPluginEntry[] iPluginEntryArray = Utils.getPluginEntry((IFeature)this.feature, (String)bundleDescription.getSymbolicName(), (boolean)false);
            for (int i = 0; i < iPluginEntryArray.length; ++i) {
                List list2 = this.selectConfigs((IPlatformEnvironment)iPluginEntryArray[i]);
                if (list2.size() == 0) continue;
                HashMap<String, String> hashMap = null;
                Config config = (Config)list2.get(0);
                hashMap = new HashMap<String, String>(3);
                if (!config.getOs().equals(Config.ANY)) {
                    hashMap.put("os", config.getOs());
                }
                if (!config.getWs().equals(Config.ANY)) {
                    hashMap.put("ws", config.getWs());
                }
                if (!config.getArch().equals(Config.ANY)) {
                    hashMap.put("arch", config.getArch());
                }
                IPath iPath = Utils.makeRelative((IPath)new Path(this.getLocation(bundleDescription)), (IPath)new Path(this.featureRootLocation));
                this.script.printAntTask("build.xml", iPath.toString(), this.getPropertyFormat("target"), null, null, hashMap);
            }
        }
        this.script.printTargetEnd();
    }

    private void generateAllFeaturesTarget() throws CoreException {
        this.script.printTargetDeclaration("all.features", "init", null, null, null);
        if (this.analyseIncludedFeatures) {
            IIncludedFeatureReference[] iIncludedFeatureReferenceArray = this.feature.getIncludedFeatureReferences();
            for (int i = 0; i < iIncludedFeatureReferenceArray.length; ++i) {
                String string = iIncludedFeatureReferenceArray[i].getVersionedIdentifier().getIdentifier();
                String string2 = iIncludedFeatureReferenceArray[i].getVersionedIdentifier().getVersion().toString();
                IFeature iFeature = this.getSite(false).findFeature(string, string2, false);
                String string3 = iFeature.getURL().getPath();
                int n = string3.lastIndexOf("feature.xml");
                if (n != -1) {
                    string3 = string3.substring(0, n);
                }
                IPath iPath = Utils.makeRelative((IPath)new Path(string3), (IPath)new Path(this.featureRootLocation));
                this.script.printAntTask("build.xml", iPath.toString(), this.getPropertyFormat("target"), null, null, null);
            }
        }
        this.script.printTargetEnd();
    }

    private void generateEpilogue() {
        this.script.println();
        this.script.printProjectEnd();
    }

    private void generatePrologue() {
        this.script.printProjectDeclaration(this.feature.getVersionedIdentifier().getIdentifier(), "build.update.jar", ".");
        this.script.println();
        this.script.printTargetDeclaration("init", null, null, null, null);
        this.script.printProperty("feature.temp.folder", this.getPropertyFormat("basedir") + '/' + "feature.temp.folder");
        this.script.printProperty("feature.destination", this.getPropertyFormat("basedir"));
        this.script.printTargetEnd();
    }

    private void generateChildrenScripts() throws CoreException {
        List list = this.computeElements();
        this.generateModels(Utils.extractPlugins((List)this.getSite(false).getRegistry().getSortedBundles(), (List)list));
    }

    private void generateModels(List list) throws CoreException {
        if (!this.scriptGeneration) {
            return;
        }
        if (!this.binaryFeature || list.isEmpty()) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            BundleDescription bundleDescription = (BundleDescription)iterator.next();
            AJModelBuildScriptGenerator aJModelBuildScriptGenerator = new AJModelBuildScriptGenerator();
            aJModelBuildScriptGenerator.setBuildSiteFactory(this.siteFactory);
            aJModelBuildScriptGenerator.setCompiledElements(this.getCompiledElements());
            aJModelBuildScriptGenerator.setModel(bundleDescription);
            aJModelBuildScriptGenerator.setFeatureGenerator(this);
            aJModelBuildScriptGenerator.setPluginPath(this.getPluginPath());
            aJModelBuildScriptGenerator.setBuildingOSGi(AJFeatureBuildScriptGenerator.isBuildingOSGi());
            aJModelBuildScriptGenerator.setDevEntries(this.devEntries);
            aJModelBuildScriptGenerator.generate();
        }
    }

    public void setFeature(String string) throws CoreException {
        if (string == null) {
            String string2 = Policy.bind((String)"error.missingFeatureId");
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 1, string2, null));
        }
        this.featureIdentifier = string;
    }

    private void initializeVariables() throws CoreException {
        this.feature = this.getSite(false).findFeature(this.featureIdentifier, this.searchedVersion, true);
        if (this.featureRootLocation == null) {
            this.featureRootLocation = this.feature.getURL().getPath();
            int n = this.featureRootLocation.lastIndexOf("feature.xml");
            if (n != -1) {
                this.featureRootLocation = this.featureRootLocation.substring(0, n);
            }
        }
        this.featureFullName = this.feature.getVersionedIdentifier().toString();
        this.featureFolderName = "features/" + this.featureFullName;
        this.sourceFeatureFullName = this.computeSourceFeatureName(this.feature, false);
        this.sourceFeatureFullNameVersionned = this.computeSourceFeatureName(this.feature, true);
        this.featureTempFolder = this.getPropertyFormat("feature.temp.folder");
    }

    private String computeSourceFeatureName(IFeature iFeature, boolean bl) throws CoreException {
        String string = this.getBuildProperties().getProperty("sourceFeature.name");
        if (string == null) {
            string = iFeature.getVersionedIdentifier().getIdentifier() + ".source";
        }
        return string + (bl ? "_" + iFeature.getVersionedIdentifier().getVersion().toString() : "");
    }

    protected Properties getBuildProperties() throws CoreException {
        if (this.buildProperties == null) {
            this.buildProperties = AJFeatureBuildScriptGenerator.readProperties((String)this.featureRootLocation, (String)"build.properties", (int)2);
        }
        return this.buildProperties;
    }

    private void generateChildrenTarget() {
        this.script.println();
        this.script.printTargetDeclaration("children", null, "include.children", null, null);
        this.script.printAntCallTask("all.children", null, null);
        this.script.printTargetEnd();
    }

    private void generateBuildJarsTarget() throws CoreException {
        this.script.println();
        this.script.printTargetDeclaration("build.jars", "init", null, null, Policy.bind((String)"build.feature.buildJars", (String)this.featureIdentifier));
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("target", "build.jars");
        this.script.printAntCallTask("all.children", null, hashMap);
        this.script.printTargetEnd();
        this.script.println();
        this.script.printTargetDeclaration("build.sources", "init", null, null, null);
        hashMap.clear();
        hashMap.put("target", "build.sources");
        this.script.printAntCallTask("all.children", null, hashMap);
        this.script.printTargetEnd();
    }

    private void generateRefreshTarget() {
        this.script.println();
        this.script.printTargetDeclaration("refresh", "init", "eclipse.running", null, Policy.bind((String)"build.feature.refresh", (String)this.featureIdentifier));
        this.script.printConvertPathTask(new Path(this.featureRootLocation).removeLastSegments(0).toOSString().replace('\\', '/'), "resourcePath", false);
        this.script.printRefreshLocalTask(this.getPropertyFormat("resourcePath"), "infinite");
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("target", "refresh");
        this.script.printAntCallTask("all.children", null, hashMap);
        this.script.printTargetEnd();
    }

    public void setGenerateIncludedFeatures(boolean bl) {
        this.analyseIncludedFeatures = bl;
    }

    protected void collectElementToAssemble(IFeature iFeature) throws CoreException {
        if (this.assemblyData == null || this.getBuildProperties().get("bin.includes") == null) {
            return;
        }
        List list = this.selectConfigs((IPlatformEnvironment)iFeature);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Config config = (Config)iterator.next();
            this.assemblyData.addFeature(config, this.feature);
        }
    }

    private void generateSourceFeature() throws CoreException {
        Feature feature = (Feature)this.feature;
        this.sourceFeature = this.createSourceFeature(feature);
        this.associateExtraPlugins();
        this.sourcePlugin = this.createSourcePlugin();
        this.generateSourceFragment();
    }

    private void generateSourceFragment() throws CoreException {
        Map map = this.sourceToGather.getElementEntries();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Config config = (Config)entry.getKey();
            if (config.equals((Object)Config.genericConfig())) continue;
            PluginEntry pluginEntry = new PluginEntry();
            String string = this.sourceFeature.getFeatureIdentifier() + "." + config.toString(".");
            pluginEntry.setPluginIdentifier(string);
            pluginEntry.setPluginVersion(this.sourceFeature.getFeatureVersion());
            pluginEntry.setOS(config.getOs());
            pluginEntry.setWS(config.getWs());
            pluginEntry.setArch(config.getArch());
            pluginEntry.isFragment(true);
            this.createSourceFragment(pluginEntry, this.sourcePlugin);
        }
    }

    private void addSourceFragmentsToFeature() throws CoreException {
        Map map = this.sourceToGather.getElementEntries();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Set set;
            Map.Entry entry = iterator.next();
            Config config = (Config)entry.getKey();
            if (config.equals((Object)Config.genericConfig()) || (set = (Set)entry.getValue()).size() == 0) continue;
            PluginEntry pluginEntry = new PluginEntry();
            String string = this.sourceFeature.getFeatureIdentifier() + "." + config.toString(".");
            pluginEntry.setPluginIdentifier(string);
            pluginEntry.setPluginVersion(this.sourceFeature.getFeatureVersion());
            pluginEntry.setOS(config.getOs());
            pluginEntry.setWS(config.getWs());
            pluginEntry.setArch(config.getArch());
            pluginEntry.isFragment(true);
            this.sourceFeature.addPluginEntryModel((PluginEntryModel)pluginEntry);
        }
    }

    private void generateSourceFeatureScripts() throws CoreException {
        AJFeatureBuildScriptGenerator aJFeatureBuildScriptGenerator = new AJFeatureBuildScriptGenerator(this.sourceFeatureFullName, null, this.assemblyData);
        aJFeatureBuildScriptGenerator.setGenerateIncludedFeatures(false);
        aJFeatureBuildScriptGenerator.setAnalyseChildren(true);
        aJFeatureBuildScriptGenerator.setSourceToGather(this.sourceToGather);
        aJFeatureBuildScriptGenerator.setBinaryFeatureGeneration(true);
        aJFeatureBuildScriptGenerator.setSourceFeatureGeneration(false);
        aJFeatureBuildScriptGenerator.setScriptGeneration(true);
        aJFeatureBuildScriptGenerator.setPluginPath(this.pluginPath);
        aJFeatureBuildScriptGenerator.setBuildSiteFactory(this.siteFactory);
        aJFeatureBuildScriptGenerator.setDevEntries(this.devEntries);
        aJFeatureBuildScriptGenerator.setCompiledElements(this.getCompiledElements());
        aJFeatureBuildScriptGenerator.setSourcePluginOnly(this.sourcePluginOnly);
        aJFeatureBuildScriptGenerator.setBuildingOSGi(AJFeatureBuildScriptGenerator.isBuildingOSGi());
        aJFeatureBuildScriptGenerator.generate();
    }

    private void associateExtraPlugins() throws CoreException {
        for (int i = 1; i < this.extraPlugins.length; ++i) {
            Object object;
            BundleDescription bundleDescription = this.getSite(false).getRegistry().getResolvedBundle(this.extraPlugins[i].startsWith("plugin@") ? this.extraPlugins[i].substring(7) : this.extraPlugins[i].substring(8));
            if (bundleDescription == null) {
                object = Policy.bind((String)"exception.missingPlugin", (String)this.extraPlugins[i]);
                BundleHelper.getDefault().getLog().log((IStatus)new Status(2, this.extraPlugins[i], 5, (String)object, null));
                continue;
            }
            object = new PluginEntry();
            object.setPluginIdentifier(bundleDescription.getSymbolicName());
            object.setPluginVersion(bundleDescription.getVersion().toString());
            this.sourceFeature.addPluginEntryModel((PluginEntryModel)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluginEntry createSourcePlugin() throws CoreException {
        StringBuffer stringBuffer;
        PluginEntry pluginEntry = new PluginEntry();
        String string = this.sourceFeature.getFeatureIdentifier();
        pluginEntry.setPluginIdentifier(string);
        pluginEntry.setPluginVersion(this.sourceFeature.getFeatureVersion());
        this.sourceFeature.addPluginEntryModel((PluginEntryModel)pluginEntry);
        Path path = new Path(workingDirectory + '/' + "plugins" + '/' + this.getSourcePluginName(pluginEntry, false));
        File file = path.toFile();
        file.mkdir();
        Path path2 = new Path("templates/plugin/plugin.xml");
        URL uRL = BundleHelper.getDefault().find((IPath)path2);
        if (uRL == null) {
            Status status = new Status(2, "org.eclipse.pde.build", 10, Policy.bind((String)"error.readingDirectory", (String)uRL.toExternalForm()), null);
            BundleHelper.getDefault().getLog().log((IStatus)status);
            return null;
        }
        try {
            stringBuffer = this.readFile(uRL.openStream());
        }
        catch (IOException iOException) {
            String string2 = Policy.bind((String)"exception.readingFile", (String)uRL.toExternalForm());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 10, string2, (Throwable)iOException));
        }
        int n = this.scan(stringBuffer, 0, "PLUGIN_ID");
        stringBuffer.replace(n, n + "PLUGIN_ID".length(), pluginEntry.getPluginIdentifier());
        n = this.scan(stringBuffer, n, "PLUGIN_VERSION");
        stringBuffer.replace(n, n + "PLUGIN_VERSION".length(), pluginEntry.getPluginVersion());
        try {
            Utils.transferStreams((InputStream)new ByteArrayInputStream(stringBuffer.toString().getBytes()), (OutputStream)new FileOutputStream(path.append("plugin.xml").toOSString()));
        }
        catch (IOException iOException) {
            String string3 = Policy.bind((String)"exception.readingFile", (String)uRL.toExternalForm());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 10, string3, (Throwable)iOException));
        }
        Collection collection = Utils.copyFiles((String)(this.featureRootLocation + '/' + "sourceTemplatePlugin"), (String)file.getAbsolutePath());
        File file2 = path.append("build.properties").toFile();
        if (!file2.exists()) {
            collection.add("plugin.xml");
            collection.add("src/**/*.zip");
            Properties properties = new Properties();
            properties.put("bin.includes", Utils.getStringFromCollection((Collection)collection, (String)","));
            properties.put("sourcePlugin", "true");
            try {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                try {
                    properties.store(bufferedOutputStream, null);
                }
                finally {
                    ((OutputStream)bufferedOutputStream).close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string4 = Policy.bind((String)"exception.writingFile", (String)file2.getAbsolutePath());
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, string4, (Throwable)fileNotFoundException));
            }
            catch (IOException iOException) {
                String string5 = Policy.bind((String)"exception.writingFile", (String)file2.getAbsolutePath());
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, string5, (Throwable)iOException));
            }
        }
        this.getSite(false).getRegistry().addBundle(file);
        return pluginEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSourceFragment(PluginEntry pluginEntry, PluginEntry pluginEntry2) throws CoreException {
        File file;
        block9: {
            Path path = new Path(workingDirectory + '/' + "plugins" + '/' + this.getSourcePluginName(pluginEntry, false));
            file = new File(path.toOSString());
            file.mkdir();
            try {
                Path path2 = new Path("templates/fragment/fragment.xml");
                URL uRL = BundleHelper.getDefault().find((IPath)path2);
                if (uRL == null) {
                    Status status = new Status(2, "org.eclipse.pde.build", 10, Policy.bind((String)"error.readingDirectory", (String)path2.toString()), null);
                    BundleHelper.getDefault().getLog().log((IStatus)status);
                    return;
                }
                StringBuffer stringBuffer = this.readFile(uRL.openStream());
                int n = this.scan(stringBuffer, 0, "FRAGMENT_ID");
                stringBuffer.replace(n, n + "FRAGMENT_ID".length(), pluginEntry.getPluginIdentifier());
                n = this.scan(stringBuffer, n, "FRAGMENT_VERSION");
                stringBuffer.replace(n, n + "FRAGMENT_VERSION".length(), pluginEntry.getPluginVersion());
                n = this.scan(stringBuffer, n, "PLUGIN_ID");
                stringBuffer.replace(n, n + "PLUGIN_ID".length(), pluginEntry2.getPluginIdentifier());
                n = this.scan(stringBuffer, n, "PLUGIN_VERSION");
                stringBuffer.replace(n, n + "PLUGIN_VERSION".length(), pluginEntry2.getPluginVersion());
                Utils.transferStreams((InputStream)new ByteArrayInputStream(stringBuffer.toString().getBytes()), (OutputStream)new FileOutputStream(path.append("fragment.xml").toOSString()));
                Collection collection = Utils.copyFiles((String)(this.featureRootLocation + '/' + "sourceTemplateFragment"), (String)file.getAbsolutePath());
                File file2 = path.append("build.properties").toFile();
                if (file2.exists()) break block9;
                collection.add("fragment.xml");
                collection.add("src/**");
                Properties properties = new Properties();
                properties.put("bin.includes", Utils.getStringFromCollection((Collection)collection, (String)","));
                properties.put("sourcePlugin", "true");
                try {
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                    try {
                        properties.store(bufferedOutputStream, null);
                    }
                    finally {
                        ((OutputStream)bufferedOutputStream).close();
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    String string = Policy.bind((String)"exception.writingFile", (String)file2.getAbsolutePath());
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, string, (Throwable)fileNotFoundException));
                }
                catch (IOException iOException) {
                    String string = Policy.bind((String)"exception.writingFile", (String)file2.getAbsolutePath());
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, string, (Throwable)iOException));
                }
            }
            catch (IOException iOException) {
                String string = Policy.bind((String)"exception.writingFile", (String)file.getName());
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, string, null));
            }
        }
        this.getSite(false).getRegistry().addBundle(file);
    }

    public String getSourcePluginName(PluginEntry pluginEntry, boolean bl) {
        return pluginEntry.getPluginIdentifier() + (bl ? "_" + pluginEntry.getPluginVersion() : "");
    }

    public void setFeatureRootLocation(String string) {
        this.featureRootLocation = string;
    }

    public void setSourceToGather(SourceFeatureInformation sourceFeatureInformation) {
        this.sourceToGather = sourceFeatureInformation;
    }

    public void setSourceFeatureGeneration(boolean bl) {
        this.sourceFeatureGeneration = bl;
    }

    public void setBinaryFeatureGeneration(boolean bl) {
        this.binaryFeature = bl;
    }

    public void setScriptGeneration(boolean bl) {
        this.scriptGeneration = bl;
    }

    public boolean isSourceFeatureGeneration() {
        return this.sourceFeatureGeneration;
    }

    protected void collectElementToAssemble(IPluginEntry iPluginEntry) throws CoreException {
        if (this.assemblyData == null) {
            return;
        }
        List list = this.selectConfigs((IPlatformEnvironment)iPluginEntry);
        String string = iPluginEntry.getVersionedIdentifier().getVersion().toString();
        BundleDescription bundleDescription = null;
        bundleDescription = this.getSite(false).getRegistry().getResolvedBundle(iPluginEntry.getVersionedIdentifier().getIdentifier(), string);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.assemblyData.addPlugin((Config)iterator.next(), bundleDescription);
        }
    }

    private Feature createSourceFeature(Feature feature) throws CoreException {
        Feature feature2 = new Feature();
        feature2.setFeatureIdentifier(this.computeSourceFeatureName((IFeature)feature, false));
        feature2.setFeatureVersion(feature.getVersionedIdentifier().getVersion().toString());
        feature2.setLabel(feature.getLabelNonLocalized());
        feature2.setProvider(feature.getProviderNonLocalized());
        feature2.setImageURLString(feature.getImageURLString());
        feature2.setInstallHandlerModel(feature.getInstallHandlerModel());
        feature2.setDescriptionModel(feature.getDescriptionModel());
        feature2.setCopyrightModel(feature.getCopyrightModel());
        feature2.setLicenseModel(feature.getLicenseModel());
        feature2.setUpdateSiteEntryModel(feature.getUpdateSiteEntryModel());
        URLEntryModel[] uRLEntryModelArray = feature.getDiscoverySiteEntryModels();
        feature2.setDiscoverySiteEntryModels(uRLEntryModelArray == null || uRLEntryModelArray.length == 0 ? null : uRLEntryModelArray);
        feature2.setOS(feature.getOS());
        feature2.setArch(feature.getOSArch());
        feature2.setWS(feature.getWS());
        return feature2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSourceFeature() throws CoreException {
        Object object;
        String string = workingDirectory + '/' + "features" + '/' + this.sourceFeatureFullName;
        File file = new File(string);
        file.mkdir();
        File file2 = new File(string + '/' + "feature.xml");
        try {
            object = new SourceFeatureWriter((OutputStream)new FileOutputStream(file2), this.sourceFeature, (FeatureBuildScriptGenerator)this);
            try {
                object.printFeature();
            }
            finally {
                object.close();
            }
        }
        catch (IOException iOException) {
            String string2 = Policy.bind((String)"error.creatingFeature", (String)this.sourceFeature.getFeatureIdentifier());
            throw new CoreException((IStatus)new Status(0, "org.eclipse.pde.build", 12, string2, (Throwable)iOException));
        }
        object = Utils.copyFiles((String)(this.featureRootLocation + '/' + "sourceTemplateFeature"), (String)string);
        File file3 = new File(string + '/' + "build.properties");
        if (file3.exists()) {
            this.getSite(false).addFeatureReferenceModel(file);
            return;
        }
        object.add("feature.xml");
        Properties properties = new Properties();
        properties.put("bin.includes", Utils.getStringFromCollection((Collection)object, (String)","));
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file3);
            try {
                properties.store(fileOutputStream, null);
            }
            finally {
                ((OutputStream)fileOutputStream).close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string3 = Policy.bind((String)"exception.writingFile", (String)file3.getAbsolutePath());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, string3, (Throwable)fileNotFoundException));
        }
        catch (IOException iOException) {
            String string4 = Policy.bind((String)"exception.writingFile", (String)file3.getAbsolutePath());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, string4, (Throwable)iOException));
        }
        this.getSite(false).addFeatureReferenceModel(file);
    }
}

