/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards.exports;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.ajdt.internal.ui.wizards.exports.AJAntScript;
import org.eclipse.ajdt.internal.ui.wizards.exports.AJCTask;
import org.eclipse.ajdt.internal.ui.wizards.exports.AJFeatureBuildScriptGenerator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.Policy;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.ant.FileSet;
import org.eclipse.pde.internal.build.ant.ITask;
import org.eclipse.pde.internal.build.builder.ClasspathComputer2_1;
import org.eclipse.pde.internal.build.builder.ClasspathComputer3_0;
import org.eclipse.pde.internal.build.builder.ModelBuildScriptGenerator;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IPluginEntry;

public class AJModelBuildScriptGenerator
extends ModelBuildScriptGenerator {
    public static final String EXPANDED_DOT = "@dot";
    public static final String DOT = ".";
    protected BundleDescription model;
    protected String fullName;
    protected String pluginZipDestination;
    protected String pluginUpdateJarDestination;
    private AJFeatureBuildScriptGenerator featureGenerator;
    protected final String PLUGIN_DESTINATION = this.getPropertyFormat("plugin.destination");
    private Properties permissionProperties;
    private String propertiesFileName = "build.properties";
    private String buildScriptFileName = "build.xml";
    private ArrayList compiledJarNames;
    private boolean dotOnTheClasspath = false;
    private boolean binaryPlugin = false;

    public void openScript(String string, String string2) throws CoreException {
        if (this.script != null) {
            return;
        }
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string + '/' + string2));
            try {
                this.script = new AJAntScript(bufferedOutputStream);
            }
            catch (IOException iOException) {
                try {
                    ((OutputStream)bufferedOutputStream).close();
                    String string3 = Policy.bind((String)"exception.writingFile", (String)(string + '/' + string2));
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, string3, (Throwable)iOException));
                }
                catch (IOException iOException2) {}
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string4 = Policy.bind((String)"exception.writingFile", (String)(string + '/' + string2));
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, string4, (Throwable)fileNotFoundException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() throws CoreException {
        String string;
        if (this.model == null) {
            String string2 = Policy.bind((String)"error.missingElement");
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 8, string2, null));
        }
        if (this.featureGenerator != null && !this.featureGenerator.isSourceFeatureGeneration() && this.featureGenerator.getBuildProperties().containsKey("generate.plugin@" + this.model.getSymbolicName())) {
            return;
        }
        if (!AbstractScriptGenerator.isBuildingOSGi()) {
            this.checkBootAndRuntime();
        }
        this.initializeVariables();
        if (BundleHelper.getDefault().isDebugging()) {
            System.out.println("Generating plugin " + this.model.getSymbolicName());
        }
        if ((string = (String)this.getBuildProperties().get("custom")) != null && string.equalsIgnoreCase("true")) {
            this.updateExistingScript();
            return;
        }
        this.openScript(this.getLocation(this.model), this.buildScriptFileName);
        try {
            this.generateBuildScript();
        }
        finally {
            this.closeScript();
        }
    }

    private void checkBootAndRuntime() throws CoreException {
        if (this.getSite(false).getRegistry().getResolvedBundle("org.eclipse.core.boot") == null) {
            Status status = new Status(4, "org.eclipse.pde.build", 5, Policy.bind((String)"exception.missingPlugin", (String)"org.eclipse.core.boot"), null);
            throw new CoreException((IStatus)status);
        }
        if (this.getSite(false).getRegistry().getResolvedBundle("org.eclipse.core.runtime") == null) {
            Status status = new Status(4, "org.eclipse.pde.build", 5, Policy.bind((String)"exception.missingPlugin", (String)"org.eclipse.core.runtime"), null);
            throw new CoreException((IStatus)status);
        }
    }

    private void initializeVariables() throws CoreException {
        this.fullName = this.model.getSymbolicName() + "_" + this.model.getVersion();
        this.pluginZipDestination = this.PLUGIN_DESTINATION + '/' + this.fullName + ".zip";
        this.pluginUpdateJarDestination = this.PLUGIN_DESTINATION + '/' + this.fullName + ".jar";
        String[] stringArray = this.getClasspathEntries(this.model);
        if (!this.binaryPlugin) {
            this.specialDotProcessing(stringArray);
        }
    }

    protected static boolean findAndReplaceDot(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!DOT.equals(stringArray[i])) continue;
            stringArray[i] = EXPANDED_DOT;
            return true;
        }
        return false;
    }

    private void specialDotProcessing(String[] stringArray) throws CoreException {
        if (AJModelBuildScriptGenerator.findAndReplaceDot(stringArray)) {
            String string;
            String[] stringArray2;
            String string2;
            String string3;
            String string4 = this.getBuildProperties().getProperty("source..");
            if (string4 != null) {
                this.getBuildProperties().setProperty("source.@dot", string4);
                this.getBuildProperties().remove("source..");
            }
            if ((string3 = this.getBuildProperties().getProperty("output..")) != null) {
                this.getBuildProperties().setProperty("output.@dot", string3);
                this.getBuildProperties().remove("output..");
            }
            if ((string2 = this.getBuildProperties().getProperty("jars.compile.order")) != null) {
                stringArray2 = Utils.getArrayFromString((String)string2);
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (!stringArray2[i].equals(DOT)) continue;
                    stringArray2[i] = EXPANDED_DOT;
                }
                this.getBuildProperties().setProperty("jars.compile.order", Utils.getStringFromArray((String[])stringArray2, (String)","));
            }
            if ((stringArray2 = this.getBuildProperties().getProperty("extra..")) != null) {
                this.getBuildProperties().setProperty("extra.@dot", (String)stringArray2);
            }
            if ((string = this.getBuildProperties().getProperty("bin.includes")) != null) {
                String[] stringArray3 = Utils.getArrayFromString((String)string);
                for (int i = 0; i < stringArray3.length; ++i) {
                    if (!stringArray3[i].equals(DOT)) continue;
                    stringArray3[i] = null;
                }
                this.getBuildProperties().setProperty("bin.includes", Utils.getStringFromArray((String[])stringArray3, (String)","));
            }
            this.dotOnTheClasspath = true;
        }
    }

    private void generateBuildScript() throws CoreException {
        this.generatePrologue();
        this.generateBuildUpdateJarTarget();
        if (this.getBuildProperties().getProperty("sourcePlugin", null) == null) {
            this.generateBuildJarsTarget(this.model);
        } else {
            this.generateBuildJarsTargetForSourceGathering();
            this.generateEmptyBuildSourcesTarget();
        }
        this.generateGatherBinPartsTarget();
        this.generateBuildZipsTarget();
        this.generateGatherSourcesTarget();
        this.generateGatherLogTarget();
        this.generateCleanTarget();
        this.generateRefreshTarget();
        this.generateZipPluginTarget();
        this.generateEpilogue();
    }

    private void generateEmptyBuildSourcesTarget() {
        this.script.printTargetDeclaration("build.sources", null, null, null, null);
        this.script.printTargetEnd();
    }

    private void generateBuildJarsTargetForSourceGathering() throws CoreException {
        this.script.printTargetDeclaration("build.jars", null, null, null, null);
        this.compiledJarNames = new ArrayList(0);
        IPluginEntry iPluginEntry = Utils.getPluginEntry((IFeature)this.featureGenerator.feature, (String)this.model.getSymbolicName(), (boolean)false)[0];
        Config config = iPluginEntry.getOS() == null && iPluginEntry.getWS() == null && iPluginEntry.getOSArch() == null ? Config.genericConfig() : new Config(iPluginEntry.getOS(), iPluginEntry.getWS(), iPluginEntry.getOSArch());
        Set set = (Set)this.featureGenerator.sourceToGather.getElementEntries().get(config);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                BundleDescription bundleDescription = (BundleDescription)iterator.next();
                if (bundleDescription.getSymbolicName().equals(this.model.getSymbolicName())) continue;
                IPath iPath = Utils.makeRelative((IPath)new Path(this.getLocation(bundleDescription)), (IPath)new Path(this.getLocation(this.model)));
                this.script.printAntTask(iPath.append(this.buildScriptFileName).toString(), iPath.toOSString(), "build.sources", null, null, null);
                HashMap<String, String> hashMap = new HashMap<String, String>(1);
                hashMap.put("destination.temp.folder", this.getPropertyFormat("basedir") + "/src");
                this.script.printAntTask(iPath.append(this.buildScriptFileName).toString(), iPath.toOSString(), "gather.sources", null, null, hashMap);
            }
        }
        this.script.printTargetEnd();
    }

    private void generateCleanTarget() throws CoreException {
        this.script.println();
        Properties properties = this.getBuildProperties();
        ModelBuildScriptGenerator.CompiledEntry[] compiledEntryArray = this.extractEntriesToCompile(properties);
        this.script.printTargetDeclaration("clean", "init", null, null, Policy.bind((String)"build.plugin.clean", (String)this.model.getSymbolicName()));
        if (!this.binaryPlugin) {
            for (int i = 0; i < compiledEntryArray.length; ++i) {
                String string = ((CompiledEntry)compiledEntryArray[i]).getName(true);
                if (((CompiledEntry)compiledEntryArray[i]).type == 0) {
                    this.script.printDeleteTask(null, this.getJARLocation(string), null);
                } else {
                    this.script.printDeleteTask(this.getJARLocation(string), null, null);
                }
                this.script.printDeleteTask(null, this.getSRCLocation(string), null);
            }
            this.script.printDeleteTask(null, this.pluginUpdateJarDestination, null);
            this.script.printDeleteTask(null, this.pluginZipDestination, null);
            this.script.printDeleteTask(this.getPropertyFormat("temp.folder"), null, null);
        }
        this.script.printTargetEnd();
    }

    private void generateGatherLogTarget() throws CoreException {
        this.script.println();
        this.script.printTargetDeclaration("gather.logs", "init", "destination.temp.folder", null, null);
        Path path = new Path(this.getPropertyFormat("destination.temp.folder"));
        path = path.append(this.fullName);
        ArrayList<IPath> arrayList = new ArrayList<IPath>(5);
        Properties properties = this.getBuildProperties();
        ModelBuildScriptGenerator.CompiledEntry[] compiledEntryArray = this.extractEntriesToCompile(properties);
        for (int i = 0; i < compiledEntryArray.length; ++i) {
            String string = ((CompiledEntry)compiledEntryArray[i]).getName(true);
            IPath iPath = path.append(string).removeLastSegments(1);
            if (!arrayList.contains(iPath)) {
                this.script.printMkdirTask(iPath.toString());
                arrayList.add(iPath);
            }
            this.script.printCopyTask(this.getTempJARFolderLocation(string) + ".log", iPath.toString(), null, false);
        }
        this.script.printTargetEnd();
    }

    private void generateZipIndividualTarget(String string, String string2) throws CoreException {
        this.script.println();
        this.script.printTargetDeclaration(string, "init", null, null, null);
        Path path = new Path(this.getPropertyFormat("basedir"));
        this.script.printZipTask(path.append(string).toString(), path.append(string2).toString(), false, false, null);
        this.script.printTargetEnd();
    }

    private void generateGatherSourcesTarget() throws CoreException {
        this.script.println();
        this.script.printTargetDeclaration("gather.sources", "init", "destination.temp.folder", null, null);
        if (!this.binaryPlugin) {
            IPath iPath;
            String string;
            Path path = new Path(this.getPropertyFormat("destination.temp.folder"));
            path = path.append(this.fullName);
            ArrayList<IPath> arrayList = new ArrayList<IPath>(5);
            Properties properties = this.getBuildProperties();
            ModelBuildScriptGenerator.CompiledEntry[] compiledEntryArray = this.extractEntriesToCompile(properties);
            for (int i = 0; i < compiledEntryArray.length; ++i) {
                string = ((CompiledEntry)compiledEntryArray[i]).getName(true);
                iPath = path.append(string).removeLastSegments(1);
                if (!arrayList.contains(iPath)) {
                    this.script.printMkdirTask(iPath.toString());
                    arrayList.add(iPath);
                }
                this.script.printCopyTask(this.getSRCLocation(string), iPath.toString(), null, false);
            }
            String string2 = (String)this.getBuildProperties().get("src.includes");
            string = (String)this.getBuildProperties().get("src.excludes");
            if (string2 != null || string != null) {
                iPath = new FileSet(this.getPropertyFormat("basedir"), null, string2, null, string, null, null);
                this.script.printCopyTask(null, path.toString(), new FileSet[]{iPath}, false);
            }
        }
        this.script.printTargetEnd();
    }

    private boolean containsStarDotJar(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith("*.jar")) continue;
            return true;
        }
        return false;
    }

    private void generateGatherBinPartsTarget() throws CoreException {
        FileSet fileSet;
        this.script.println();
        this.script.printTargetDeclaration("gather.bin.parts", "init", "destination.temp.folder", null, null);
        Path path = new Path(this.getPropertyFormat("destination.temp.folder"));
        path = path.append(this.fullName);
        String string = path.toString();
        this.script.printMkdirTask(string);
        ArrayList<Path> arrayList = new ArrayList<Path>(5);
        arrayList.add(path);
        String string2 = (String)this.getBuildProperties().get("bin.includes");
        String string3 = (String)this.getBuildProperties().get("bin.excludes");
        if (!this.binaryPlugin) {
            fileSet = Utils.getArrayFromString((String)string2);
            boolean bl = this.containsStarDotJar((String[])fileSet);
            String[] stringArray = new String[this.compiledJarNames.size()];
            int n = 0;
            FileSet fileSet2 = this.compiledJarNames.iterator();
            while (fileSet2.hasNext()) {
                CompiledEntry compiledEntry = (CompiledEntry)((Object)fileSet2.next());
                String string4 = compiledEntry.getName(false) + (compiledEntry.getType() == 1 ? "/" : "");
                if (!bl && !Utils.isStringIn((String[])fileSet, (String)string4)) continue;
                stringArray[n++] = string4;
            }
            if (n != 0) {
                fileSet2 = new FileSet(this.getPropertyFormat("build.result.folder"), null, Utils.getStringFromArray((String[])stringArray, (String)","), null, this.replaceVariables(string3, true), null, null);
                this.script.printCopyTask(null, string, new FileSet[]{fileSet2}, true);
            }
            if (this.dotOnTheClasspath) {
                fileSet2 = new FileSet(this.getPropertyFormat("build.result.folder") + '/' + EXPANDED_DOT, null, "**", null, null, null, null);
                this.script.printCopyTask(null, string, new FileSet[]{fileSet2}, true);
            }
        }
        if (string2 != null || string3 != null) {
            fileSet = new FileSet(this.getPropertyFormat("basedir"), null, this.replaceVariables(string2, true), null, this.replaceVariables(string3, true), null, null);
            this.script.printCopyTask(null, string, new FileSet[]{fileSet}, true);
        }
        this.generatePermissionProperties(string);
        this.genarateIdReplacementCall(path.toString());
        this.script.printTargetEnd();
    }

    private void genarateIdReplacementCall(String string) throws CoreException {
        String string2 = this.getBuildProperties().getProperty("qualifier");
        if (string2 == null) {
            return;
        }
        this.script.print("<eclipse.versionReplacer path=\"" + string + "\" version=\"" + this.model.getVersion() + "\"/>");
    }

    private void generatePermissionProperties(String string) throws CoreException {
        this.getPermissionProperties();
        Iterator<Map.Entry<Object, Object>> iterator = this.permissionProperties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String string2 = (String)entry.getKey();
            String string3 = (String)entry.getValue();
            int n = string2.indexOf("permissions");
            if (n != -1) {
                this.generateChmodInstruction(string, string2.substring(n + "permissions".length() + 1), string3);
                continue;
            }
            if (!string2.startsWith("link")) continue;
            this.generateLinkInstruction(string, string3);
        }
    }

    private void generateChmodInstruction(String string, String string2, String string3) {
        if (string2.equals("executable")) {
            string2 = "755";
        }
        this.script.printChmod(string, string2, string3);
    }

    private void generateLinkInstruction(String string, String string2) {
        String[] stringArray = Utils.getArrayFromString((String)string2, (String)",");
        ArrayList<String> arrayList = new ArrayList<String>(2);
        for (int i = 0; i < stringArray.length; i += 2) {
            arrayList.add(stringArray[i]);
            arrayList.add(stringArray[i + 1]);
            this.script.printExecTask("ln -s", string, arrayList, "Linux");
            arrayList.clear();
        }
    }

    protected Properties getPermissionProperties() throws CoreException {
        if (this.permissionProperties == null) {
            this.permissionProperties = AJModelBuildScriptGenerator.readProperties((String)this.getLocation(this.model), (String)"permissions.properties", (int)1);
        }
        return this.permissionProperties;
    }

    private void generateZipPluginTarget() throws CoreException {
        this.script.println();
        this.script.printTargetDeclaration("zip.plugin", "init", null, null, Policy.bind((String)"build.plugin.zipPlugin", (String)this.model.getSymbolicName()));
        this.script.printDeleteTask(this.getPropertyFormat("temp.folder"), null, null);
        this.script.printMkdirTask(this.getPropertyFormat("temp.folder"));
        this.script.printAntCallTask("build.jars", null, null);
        this.script.printAntCallTask("build.sources", null, null);
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("destination.temp.folder", this.getPropertyFormat("temp.folder") + '/');
        this.script.printAntCallTask("gather.bin.parts", null, hashMap);
        this.script.printAntCallTask("gather.sources", null, hashMap);
        FileSet fileSet = new FileSet(this.getPropertyFormat("temp.folder"), null, "**/*.bin.log", null, null, null, null);
        this.script.printDeleteTask(null, null, new FileSet[]{fileSet});
        this.script.printZipTask(this.pluginZipDestination, this.getPropertyFormat("temp.folder"), true, false, null);
        this.script.printDeleteTask(this.getPropertyFormat("temp.folder"), null, null);
        this.script.printTargetEnd();
    }

    private void generateBuildUpdateJarTarget() {
        this.script.println();
        this.script.printTargetDeclaration("build.update.jar", "init", null, null, Policy.bind((String)"build.plugin.buildUpdateJar", (String)this.model.getSymbolicName()));
        this.script.printDeleteTask(this.getPropertyFormat("temp.folder"), null, null);
        this.script.printMkdirTask(this.getPropertyFormat("temp.folder"));
        this.script.printAntCallTask("build.jars", null, null);
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("destination.temp.folder", this.getPropertyFormat("temp.folder") + '/');
        this.script.printAntCallTask("gather.bin.parts", null, hashMap);
        this.script.printZipTask(this.pluginUpdateJarDestination, this.getPropertyFormat("temp.folder") + '/' + this.fullName, false, false, null);
        this.script.printDeleteTask(this.getPropertyFormat("temp.folder"), null, null);
        this.script.printTargetEnd();
    }

    private void generateRefreshTarget() throws CoreException {
        this.script.println();
        this.script.printTargetDeclaration("refresh", "init", "eclipse.running", null, Policy.bind((String)"build.plugin.refresh"));
        this.script.printConvertPathTask(new Path(this.getLocation(this.model)).removeLastSegments(0).toOSString().replace('\\', '/'), "resourcePath", false);
        this.script.printRefreshLocalTask(this.getPropertyFormat("resourcePath"), "infinite");
        this.script.printTargetEnd();
    }

    private void generateEpilogue() {
        this.script.println();
        this.script.printProjectEnd();
    }

    private void generatePrologue() {
        this.script.printProjectDeclaration(this.model.getSymbolicName(), "build.jars", DOT);
        this.script.println();
        this.script.printProperty("bootclasspath", "");
        this.script.printProperty("basews", this.getPropertyFormat("ws"));
        this.script.printProperty("baseos", this.getPropertyFormat("os"));
        this.script.printProperty("basearch", this.getPropertyFormat("arch"));
        this.script.printProperty("basenl", this.getPropertyFormat("nl"));
        this.script.printProperty("javacFailOnError", "false");
        this.script.printProperty("javacDebugInfo", "on");
        this.script.printProperty("javacVerbose", "true");
        this.script.printProperty("javacSource", "1.3");
        this.script.printProperty("javacTarget", "1.2");
        this.script.printProperty("compilerArg", "");
        this.script.println();
        this.script.printTargetDeclaration("init", "properties", null, null, null);
        this.script.println("<condition property=\"pluginTemp\" value=\"" + this.getPropertyFormat("buildTempFolder") + '/' + "plugins" + "\">");
        this.script.println("\t<isset property=\"buildTempFolder\"/>");
        this.script.println("</condition>");
        this.script.printProperty("pluginTemp", this.getPropertyFormat("basedir"));
        this.script.println("<condition property=\"build.result.folder\" value=\"" + this.getPropertyFormat("pluginTemp") + '/' + new Path(this.model.getLocation()).lastSegment() + "\">");
        this.script.println("\t<isset property=\"buildTempFolder\"/>");
        this.script.println("</condition>");
        this.script.printProperty("build.result.folder", this.getPropertyFormat("basedir"));
        this.script.printProperty("temp.folder", this.getPropertyFormat("basedir") + '/' + "temp.folder");
        this.script.printProperty("plugin.destination", this.getPropertyFormat("basedir"));
        this.script.printTargetEnd();
        this.script.println();
        this.script.printTargetDeclaration("properties", null, "eclipse.running", null, null);
        this.script.printProperty("build.compiler", "org.eclipse.jdt.core.JDTCompilerAdapter");
        this.script.printTargetEnd();
    }

    public void setModel(BundleDescription bundleDescription) throws CoreException {
        if (bundleDescription == null) {
            String string = Policy.bind((String)"error.missingElement");
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 8, string, null));
        }
        this.model = bundleDescription;
        if (this.getBuildProperties().size() != 0) {
            this.getCompiledElements().add(bundleDescription.getSymbolicName());
        } else {
            this.binaryPlugin = true;
            this.buildProperties.put("bin.includes", "**/**");
            this.buildProperties.put("bin.excludes", ".project, .classpath, build.xml");
        }
    }

    public void setModelId(String string) throws CoreException {
        BundleDescription bundleDescription = this.getModel(string);
        if (bundleDescription == null) {
            String string2 = Policy.bind((String)"exception.missingElement", (String)string);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 8, string2, null));
        }
        this.setModel(bundleDescription);
    }

    private void generateBuildZipsTarget() throws CoreException {
        StringBuffer stringBuffer = new StringBuffer();
        Properties properties = this.getBuildProperties();
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String string = (String)entry.getKey();
            if (!string.startsWith("source.") || !string.endsWith(".zip")) continue;
            String string2 = string.substring("source.".length());
            stringBuffer.append(',');
            stringBuffer.append(string2);
            this.generateZipIndividualTarget(string2, (String)entry.getValue());
        }
        this.script.println();
        this.script.printTargetDeclaration("build.zips", "init" + stringBuffer.toString(), null, null, null);
        this.script.printTargetEnd();
    }

    public void setFeatureGenerator(AJFeatureBuildScriptGenerator aJFeatureBuildScriptGenerator) {
        this.featureGenerator = aJFeatureBuildScriptGenerator;
    }

    private void generateBuildJarsTarget(BundleDescription bundleDescription) throws CoreException {
        Object object;
        Object object2;
        Properties properties = this.getBuildProperties();
        ModelBuildScriptGenerator.CompiledEntry[] compiledEntryArray = this.binaryPlugin ? new ModelBuildScriptGenerator.CompiledEntry[]{} : this.extractEntriesToCompile(properties);
        this.compiledJarNames = new ArrayList(compiledEntryArray.length);
        HashMap<String, ModelBuildScriptGenerator.CompiledEntry> hashMap = new HashMap<String, ModelBuildScriptGenerator.CompiledEntry>(compiledEntryArray.length);
        for (int i = 0; i < compiledEntryArray.length; ++i) {
            hashMap.put(((CompiledEntry)compiledEntryArray[i]).getName(false), compiledEntryArray[i]);
        }
        String string = (String)this.getBuildProperties().get("jars.compile.order");
        Object object3 = AbstractScriptGenerator.isBuildingOSGi() ? new ClasspathComputer3_0((ModelBuildScriptGenerator)this) : new ClasspathComputer2_1((ModelBuildScriptGenerator)this);
        if (string != null) {
            object2 = Utils.getArrayFromString((String)string);
            for (int i = 0; i < ((Object)object2).length; ++i) {
                object = (CompiledEntry)((Object)hashMap.get(object2[i]));
                if (object == null) continue;
                this.compiledJarNames.add(object);
                this.generateCompilationTarget(object3.getClasspath(bundleDescription, (ModelBuildScriptGenerator.CompiledEntry)object), (CompiledEntry)((Object)object));
                this.generateSRCTarget((CompiledEntry)((Object)object));
                hashMap.remove(object2[i]);
            }
        }
        object2 = hashMap.values().iterator();
        while (object2.hasNext()) {
            CompiledEntry compiledEntry = (CompiledEntry)((Object)object2.next());
            this.compiledJarNames.add(compiledEntry);
            this.generateCompilationTarget(object3.getClasspath(bundleDescription, (ModelBuildScriptGenerator.CompiledEntry)compiledEntry), compiledEntry);
            this.generateSRCTarget(compiledEntry);
        }
        this.script.println();
        this.script.printTargetDeclaration("build.jars", "init", null, null, Policy.bind((String)"build.plugin.buildJars", (String)bundleDescription.getSymbolicName()));
        object2 = this.compiledJarNames.iterator();
        while (object2.hasNext()) {
            String string2 = ((CompiledEntry)((Object)object2.next())).getName(false);
            this.script.printAvailableTask(string2, this.replaceVariables(this.getJARLocation(string2), true));
            this.script.printAntCallTask(string2, null, null);
        }
        this.script.printTargetEnd();
        this.script.println();
        this.script.printTargetDeclaration("build.sources", "init", null, null, null);
        object2 = this.compiledJarNames.iterator();
        while (object2.hasNext()) {
            String string3 = ((CompiledEntry)((Object)object2.next())).getName(false);
            object = this.getSRCName(string3);
            this.script.printAvailableTask((String)object, this.getSRCLocation(string3));
            this.script.printAntCallTask((String)object, null, null);
        }
        this.script.printTargetEnd();
    }

    private void generateCompilationTarget(List list, CompiledEntry compiledEntry) throws CoreException {
        this.script.println();
        String string = compiledEntry.getName(false);
        this.script.printTargetDeclaration(string, "init", null, compiledEntry.getName(true), Policy.bind((String)"build.plugin.jar", (String)string));
        String string2 = this.getTempJARFolderLocation(compiledEntry.getName(true));
        this.script.printDeleteTask(string2, null, null);
        this.script.printMkdirTask(string2);
        this.script.printComment("compile the source code");
        AJCTask aJCTask = new AJCTask();
        aJCTask.setClasspath(list);
        aJCTask.setBootClasspath(this.getPropertyFormat("bootclasspath"));
        aJCTask.setDestdir(string2);
        aJCTask.setFailOnError(this.getPropertyFormat("javacFailOnError"));
        aJCTask.setDebug(this.getPropertyFormat("javacDebugInfo"));
        aJCTask.setVerbose(this.getPropertyFormat("javacVerbose"));
        aJCTask.setIncludeAntRuntime("no");
        aJCTask.setSource(this.getPropertyFormat("javacSource"));
        aJCTask.setTarget(this.getPropertyFormat("javacTarget"));
        aJCTask.setCompileArgs(this.getPropertyFormat("compilerArg"));
        String[] stringArray = compiledEntry.getSource();
        aJCTask.setSrcdir(stringArray);
        this.script.print((ITask)aJCTask);
        this.script.printComment("Copy necessary resources");
        FileSet[] fileSetArray = new FileSet[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            fileSetArray[i] = new FileSet(stringArray[i], null, null, null, "**/*.aj, **/*.java, **/package.htm*", null, null);
        }
        this.script.printCopyTask(null, string2, fileSetArray, true);
        String string3 = this.getJARLocation(compiledEntry.getName(true));
        this.script.printMkdirTask(new Path(string3).removeLastSegments(1).toString());
        if (compiledEntry.getType() == 1) {
            FileSet[] fileSetArray2 = new FileSet[]{new FileSet(string2, null, null, null, null, null, null)};
            this.script.printCopyTask(null, string3, fileSetArray2, true);
        } else {
            this.script.printJarTask(string3, string2);
        }
        this.script.printDeleteTask(string2, null, null);
        this.script.printTargetEnd();
    }

    protected ModelBuildScriptGenerator.CompiledEntry[] extractEntriesToCompile(Properties properties) {
        ArrayList<CompiledEntry> arrayList = new ArrayList<CompiledEntry>(5);
        int n = "source.".length();
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String string = (String)entry.getKey();
            if (!string.startsWith("source.")) continue;
            string = string.substring(n);
            String[] stringArray = Utils.getArrayFromString((String)((String)entry.getValue()));
            String[] stringArray2 = Utils.getArrayFromString((String)properties.getProperty("output." + string));
            String[] stringArray3 = Utils.getArrayFromString((String)properties.getProperty("extra." + string));
            CompiledEntry compiledEntry = new CompiledEntry(string, stringArray, stringArray2, stringArray3, string.endsWith(".jar") ? (byte)0 : 1);
            arrayList.add(compiledEntry);
        }
        return arrayList.toArray(new CompiledEntry[arrayList.size()]);
    }

    private void generateSRCTarget(CompiledEntry compiledEntry) throws CoreException {
        this.script.println();
        String string = compiledEntry.getName(false);
        String string2 = this.getSRCName(string);
        this.script.printTargetDeclaration(string2, "init", null, string2, null);
        String[] stringArray = compiledEntry.getSource();
        this.filterNonExistingSourceFolders(stringArray);
        FileSet[] fileSetArray = new FileSet[stringArray.length];
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            fileSetArray[n++] = new FileSet(stringArray[i], null, "**/*.java, **/*.aj", null, null, null, null);
        }
        String string3 = this.getSRCLocation(string);
        this.script.printMkdirTask(new Path(string3).removeLastSegments(1).toString());
        if (n != 0) {
            this.script.printZipTask(string3, null, false, false, fileSetArray);
        }
        this.script.printTargetEnd();
    }

    private void filterNonExistingSourceFolders(String[] stringArray) {
        File file;
        try {
            file = new File(this.getLocation(this.model));
        }
        catch (CoreException coreException) {
            BundleHelper.getDefault().getLog().log(coreException.getStatus());
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            if (file2.exists()) continue;
            stringArray[i] = null;
            Status status = new Status(2, "org.eclipse.pde.build", 11, Policy.bind((String)"warning.cannotLocateSource", (String)file2.getAbsolutePath()), null);
            BundleHelper.getDefault().getLog().log((IStatus)status);
        }
    }

    protected String getSRCLocation(String string) {
        return this.getJARLocation(this.getSRCName(string));
    }

    protected String getTempJARFolderLocation(String string) {
        Path path = new Path(this.getPropertyFormat("temp.folder"));
        path = path.append(string + ".bin");
        return path.toString();
    }

    protected String getJARLocation(String string) {
        return new Path(this.getPropertyFormat("build.result.folder")).append(string).toString();
    }

    protected String[] getClasspathEntries(BundleDescription bundleDescription) throws CoreException {
        return (String[])this.getSite(false).getRegistry().getExtraData().get(new Long(bundleDescription.getBundleId()));
    }

    protected Properties getBuildProperties() throws CoreException {
        if (this.buildProperties == null) {
            this.buildProperties = AJModelBuildScriptGenerator.readProperties((String)this.model.getLocation(), (String)this.propertiesFileName, (int)2);
            return this.buildProperties;
        }
        return this.buildProperties;
    }

    protected String getSRCName(String string) {
        if (string.endsWith(".jar")) {
            return string.substring(0, string.length() - 4) + "src.zip";
        }
        return string.replace('/', '.') + "src.zip";
    }

    private void updateExistingScript() throws CoreException {
        String string = this.getLocation(this.model);
        File file = new File(string, this.buildScriptFileName);
        try {
            this.updateVersion(file, "version.suffix", this.model.getVersion().toString());
        }
        catch (IOException iOException) {
            String string2 = Policy.bind((String)"exception.writeScript", (String)file.toString());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 7, string2, (Throwable)iOException));
        }
    }

    protected String replaceVariables(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        int n = -1;
        String string2 = string;
        while ((n = string2.indexOf("$ws$")) >= 0) {
            string2 = string2.substring(0, n) + "ws/" + this.getPropertyFormat(bl ? "ws" : "basews") + string2.substring(n + "$ws$".length());
        }
        while ((n = string2.indexOf("$os$")) >= 0) {
            string2 = string2.substring(0, n) + "os/" + this.getPropertyFormat(bl ? "os" : "baseos") + string2.substring(n + "$os$".length());
        }
        while ((n = string2.indexOf("$arch$")) >= 0) {
            string2 = string2.substring(0, n) + "arch/" + this.getPropertyFormat(bl ? "arch" : "basearch") + string2.substring(n + "$os$".length());
        }
        while ((n = string2.indexOf("$nl$")) >= 0) {
            string2 = string2.substring(0, n) + "nl/" + this.getPropertyFormat(bl ? "nl" : "basenl") + string2.substring(n + "$nl$".length());
        }
        return string2;
    }

    public BundleDescription getModel() {
        return this.model;
    }

    public String getPropertiesFileName() {
        return this.propertiesFileName;
    }

    public void setPropertiesFileName(String string) {
        this.propertiesFileName = string;
    }

    public String getBuildScriptFileName() {
        return this.buildScriptFileName;
    }

    public void setBuildScriptFileName(String string) {
        this.buildScriptFileName = string;
    }

    protected BundleDescription getModel(String string) throws CoreException {
        return this.getSite(false).getRegistry().getResolvedBundle(string);
    }

    protected class CompiledEntry
    extends ModelBuildScriptGenerator.CompiledEntry {
        static final byte JAR = 0;
        static final byte FOLDER = 1;
        private String name;
        private String resolvedName;
        private String[] source;
        private String[] output;
        private String[] extraClasspath;
        private byte type;

        protected CompiledEntry(String string, String[] stringArray, String[] stringArray2, String[] stringArray3, byte by) {
            super((ModelBuildScriptGenerator)AJModelBuildScriptGenerator.this, string, stringArray, stringArray2, stringArray3, by);
            this.name = string;
            this.source = stringArray;
            this.output = stringArray2;
            this.extraClasspath = stringArray3;
            this.type = by;
        }

        protected String getName(boolean bl) {
            if (!bl) {
                return this.name;
            }
            if (this.resolvedName == null) {
                this.resolvedName = AJModelBuildScriptGenerator.this.replaceVariables(this.name, true);
            }
            return this.resolvedName;
        }

        protected String[] getSource() {
            return this.source;
        }

        public String[] getOutput() {
            return this.output;
        }

        public String[] getExtraClasspath() {
            return this.extraClasspath;
        }

        public byte getType() {
            return this.type;
        }
    }
}

