/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.ui;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.BuildOptionsAdapter;
import org.aspectj.ajde.BuildProgressMonitor;
import org.aspectj.ajde.ProjectPropertiesAdapter;
import org.aspectj.ajde.TaskListManager;
import org.aspectj.ajde.ui.StructureViewNodeFactory;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.internal.core.AJDTStructureViewNodeFactory;
import org.eclipse.ajdt.internal.core.AJDTUtils;
import org.eclipse.ajdt.internal.core.AspectJResourceChangeListener;
import org.eclipse.ajdt.internal.core.resources.AspectJImages;
import org.eclipse.ajdt.internal.ui.ajde.CompilerMonitor;
import org.eclipse.ajdt.internal.ui.ajde.EditorAdapter;
import org.eclipse.ajdt.internal.ui.ajde.ErrorHandler;
import org.eclipse.ajdt.internal.ui.ajde.IdeUIAdapter;
import org.eclipse.ajdt.internal.ui.ajde.ProjectProperties;
import org.eclipse.ajdt.internal.ui.editor.AspectJTextTools;
import org.eclipse.ajdt.internal.ui.preferences.AJCompilerPreferencePage;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferencePage;
import org.eclipse.ajdt.ui.visualiser.AspectVisualiserPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateReaderWriter;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.UIPlugin;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class AspectJPlugin
extends AbstractUIPlugin
implements ISelectionListener {
    public static String VERSION = "unset";
    public static final String PLUGIN_ID = "org.eclipse.ajdt.ui";
    public static final String ID_BUILDER = "org.eclipse.ajdt.ui.ajbuilder";
    public static final String ID_OUTLINE = "org.eclipse.ajdt.ui.ajoutlineview";
    public static final String ID_NATURE = "org.eclipse.ajdt.ui.ajnature";
    public static final String RUNTIME_PLUGIN_ID = "org.aspectj.ajde";
    private static final String AJDE_VERSION_KEY_CURRENT = "ajde.version";
    private static final String AJDE_VERSION_KEY_PREVIOUS = "ajde.version.at.previous.startup";
    public static final String NON_OS_SPECIFIC_SEPARATOR = "/";
    public static boolean isDebugging = false;
    public static boolean DEBUG_BUILDER = false;
    public static boolean DEBUG_COMPILER = false;
    public static boolean DEBUG_OUTLINE = false;
    private static AspectJPlugin plugin;
    private static Hashtable projectToBuildChoice;
    private ResourceBundle resourceBundle;
    private ProjectProperties ajdtProjectProperties;
    private CompilerMonitor ajdtCompilerMonitor;
    private EditorAdapter ajdtEditorAdapter;
    private org.eclipse.ajdt.internal.ui.ajde.BuildOptionsAdapter ajdtBuildOptions;
    private AspectJImages ajdtImages;
    private AJDTStructureViewNodeFactory ajdtStructureFactory;
    private IdeUIAdapter ajdtUIAdapter;
    private ErrorHandler ajdtErrorHandler;
    private AspectJTextTools aspectJTextTools;
    private IProject currentProject;
    private IResource currentResource;
    private Display display;
    IResourceChangeListener resourceChangeListener;
    public static final String ADVICE_MARKER = "org.eclipse.ajdt.ui.advicemarker";
    public static final String DECLARATION_MARKER = "org.eclipse.ajdt.ui.declarationmarker";
    public static final String SOURCE_LOCATION_ATTRIBUTE = "sourceLocationOfAdvice";
    public static final String RELATED_LOCATIONS_ATTRIBUTE_PREFIX = "relatedLocations-";
    private static final String defaultLstShouldBeUsed = "org.eclipse.ajdt.ui.buildConfig.useDefaultLst";
    public static final int PROGRESS_MONITOR_MAX = 100;

    public static AspectJPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String string) {
        ResourceBundle resourceBundle = AspectJPlugin.getDefault().getResourceBundle();
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    public static String getFormattedResourceString(String string, String string2) {
        return AspectJPlugin.getFormattedResourceString(string, new String[]{string2});
    }

    public static String getFormattedResourceString(String string, String[] stringArray) {
        return MessageFormat.format(AspectJPlugin.getResourceString(string), stringArray);
    }

    public static void setBuildConfigurationFile(IProject iProject, IFile iFile) {
        IPreferenceStore iPreferenceStore = AspectJPlugin.getDefault().getPreferenceStore();
        String string = "org.eclipse.ajdt.ui." + iProject.getName() + ".lst";
        if (iFile == null) {
            iPreferenceStore.setValue(string, defaultLstShouldBeUsed);
        } else {
            iPreferenceStore.setValue(string, iFile.getLocation().toOSString());
        }
        String string2 = AspectJPlugin.getBuildConfigurationFile(iProject);
        Ajde.getDefault().getConfigurationManager().setActiveConfigFile(string2);
        AJDTEventTrace.buildConfigSelected(string2, iProject);
    }

    public static void setBuildConfigurationFile(IProject iProject, IResource iResource) {
        if (iResource == null) {
            AspectJPlugin.setBuildConfigurationFile(iProject, (IFile)null);
        } else if (iResource instanceof IFile) {
            AspectJPlugin.setBuildConfigurationFile(iProject, (IFile)iResource);
        }
    }

    public static String getBuildConfigurationFile(IProject iProject) {
        String string = AJDTUtils.getProjectRootDirectory(iProject) + File.separator + ".generated.lst";
        return string;
    }

    public AspectJPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.ajdt.internal.core.resources.AspectJPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    private void checkAspectJVersion() {
        IPreferenceStore iPreferenceStore = AspectJPlugin.getDefault().getPreferenceStore();
        String string = AspectJPlugin.getResourceString(AJDE_VERSION_KEY_CURRENT);
        String string2 = iPreferenceStore.getString(AJDE_VERSION_KEY_PREVIOUS);
        try {
            if (string2 == null || !string.equals(string2)) {
                AJDTEventTrace.generalEvent("New version of AJDE detected (now:" + string + ") - checking aspectjrt.jar for each project.");
                IProject[] iProjectArray = AspectJPlugin.getWorkspace().getRoot().getProjects();
                for (int i = 0; i < iProjectArray.length; ++i) {
                    IProject iProject;
                    if (!iProjectArray[i].isOpen() || !(iProject = iProjectArray[i]).hasNature(ID_NATURE)) continue;
                    AJDTUtils.verifyAjrtVersion(iProject);
                }
                this.checkTemplatesInstalled();
                this.checkProblemMarkersVisible();
                iPreferenceStore.putValue(AJDE_VERSION_KEY_PREVIOUS, string);
            }
        }
        catch (CoreException coreException) {
            AJDTEventTrace.generalEvent("Problem attempting to check aspectjrt.jar for");
            coreException.printStackTrace();
        }
    }

    private void checkProblemMarkersVisible() {
        IDialogSettings iDialogSettings;
        String string;
        String string2 = "org.eclipse.ui.views.problem";
        String string3 = "org.eclipse.ajdt.ui.problemmarker:";
        UIPlugin uIPlugin = UIPlugin.getDefault();
        IDialogSettings iDialogSettings2 = uIPlugin.getDialogSettings();
        IDialogSettings iDialogSettings3 = iDialogSettings2.getSection(string2);
        if (iDialogSettings3 != null && (string = (iDialogSettings = iDialogSettings3.getSection("filter")).get("selectedType")).indexOf(string3) == -1) {
            string = string + string3;
            iDialogSettings.put("selectedType", string);
        }
    }

    private void checkTemplatesInstalled() {
        TemplateStore templateStore = JavaPlugin.getDefault().getTemplateStore();
        try {
            URL uRL = this.getBundle().getEntry("/aspectj_code_templates.xml");
            TemplateReaderWriter templateReaderWriter = new TemplateReaderWriter();
            TemplatePersistenceData[] templatePersistenceDataArray = templateReaderWriter.read(uRL.openStream(), null);
            if (templatePersistenceDataArray == null || templatePersistenceDataArray.length == 0) {
                AJDTEventTrace.generalEvent(AspectJPlugin.getResourceString("codeTemplates.couldNotLoad"));
            } else {
                for (int i = 0; i < templatePersistenceDataArray.length; ++i) {
                    templateStore.add(templatePersistenceDataArray[i]);
                }
                templateStore.save();
            }
        }
        catch (IOException iOException) {
            AJDTEventTrace.generalEvent(AspectJPlugin.getResourceString("codeTemplates.couldNotLoad"));
            iOException.printStackTrace();
        }
    }

    public ErrorHandler getErrorHandler() {
        return this.ajdtErrorHandler;
    }

    public static void logException(Throwable throwable) {
        IStatus iStatus = null;
        if (throwable instanceof CoreException) {
            iStatus = ((CoreException)throwable).getStatus();
        } else {
            String string = throwable.getMessage();
            if (string == null) {
                string = throwable.toString();
            }
            iStatus = new Status(4, PLUGIN_ID, 0, string, throwable);
        }
        AspectJPlugin.getDefault().getLog().log(iStatus);
    }

    public CompilerMonitor getCompilerMonitor() {
        return this.ajdtCompilerMonitor;
    }

    public ProjectProperties getAjdtProjectProperties() {
        return this.ajdtProjectProperties;
    }

    public org.eclipse.ajdt.internal.ui.ajde.BuildOptionsAdapter getAjdtBuildOptionsAdapter() {
        return this.ajdtBuildOptions;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        this.display = Display.getDefault();
        if (this.resourceChangeListener == null) {
            this.resourceChangeListener = new AspectJResourceChangeListener();
            AspectJPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
        }
        Bundle bundle = AspectJPlugin.getDefault().getBundle();
        String string = (String)bundle.getHeaders().get("Bundle-Version");
        PluginVersionIdentifier pluginVersionIdentifier = new PluginVersionIdentifier(string);
        VERSION = pluginVersionIdentifier.getMajorComponent() + "." + pluginVersionIdentifier.getMinorComponent() + "." + pluginVersionIdentifier.getServiceComponent();
        this.initDebugging();
        this.ajdtProjectProperties = new ProjectProperties();
        this.ajdtCompilerMonitor = new CompilerMonitor();
        this.ajdtEditorAdapter = new EditorAdapter();
        this.ajdtErrorHandler = new ErrorHandler();
        this.ajdtBuildOptions = new org.eclipse.ajdt.internal.ui.ajde.BuildOptionsAdapter();
        this.ajdtImages = AspectJImages.registry();
        this.ajdtUIAdapter = new IdeUIAdapter();
        this.ajdtStructureFactory = new AJDTStructureViewNodeFactory(this.ajdtImages);
        Ajde.init((org.aspectj.ajde.EditorAdapter)this.ajdtEditorAdapter, (TaskListManager)this.ajdtCompilerMonitor, (BuildProgressMonitor)this.ajdtCompilerMonitor, (ProjectPropertiesAdapter)this.ajdtProjectProperties, (BuildOptionsAdapter)this.ajdtBuildOptions, (StructureViewNodeFactory)this.ajdtStructureFactory, (org.aspectj.ajde.ui.IdeUIAdapter)this.ajdtUIAdapter, (org.aspectj.ajde.ErrorHandler)this.ajdtErrorHandler);
        AJDTEventTrace.startup();
        new AspectVisualiserPlugin();
        this.checkAspectJVersion();
    }

    public IWorkbenchWindow getActiveWorkbenchWindow() {
        return plugin.getWorkbench().getActiveWorkbenchWindow();
    }

    public Display getDisplay() {
        return this.display;
    }

    public AspectJTextTools getAspectJTextTools() {
        if (this.aspectJTextTools == null) {
            IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
            this.aspectJTextTools = new AspectJTextTools(iPreferenceStore);
        }
        return this.aspectJTextTools;
    }

    public IProject getCurrentProject() {
        IProject iProject = null;
        if (this.currentProject != null) {
            iProject = this.currentProject;
        } else {
            IProject[] iProjectArray = AspectJPlugin.getWorkspace().getRoot().getProjects();
            for (int i = 0; i < iProjectArray.length; ++i) {
                if (!iProjectArray[i].isOpen()) continue;
                iProject = iProjectArray[i];
                break;
            }
        }
        return iProject;
    }

    public IResource getCurrentResource() {
        return this.currentResource;
    }

    public void setCurrentProject(IProject iProject) {
        this.currentProject = iProject;
    }

    public void setCurrentProject(String string) {
        boolean bl = false;
        IProject[] iProjectArray = AspectJPlugin.getWorkspace().getRoot().getProjects();
        for (int i = 0; i < iProjectArray.length; ++i) {
            if (!iProjectArray[i].getName().equals(string)) continue;
            this.currentProject = iProjectArray[i];
            bl = true;
            break;
        }
        if (!bl) {
            this.getErrorHandler().handleWarning(AspectJPlugin.getResourceString("bad.project") + " " + string);
        }
    }

    protected void initializeDefaultPreferences(IPreferenceStore iPreferenceStore) {
        AspectJPreferencePage.initDefaults(iPreferenceStore);
        AJCompilerPreferencePage.initDefaults(iPreferenceStore);
    }

    protected void initializeImageRegistry(ImageRegistry imageRegistry) {
    }

    private void initDebugging() {
        if (this.isDebugging()) {
            System.out.println("AJP START: org.eclipse.ajdt.ui " + VERSION);
            isDebugging = true;
            String string = Platform.getDebugOption((String)"org.eclipse.ajdt.ui/builderDebug");
            if (string != null && string.equals("true")) {
                System.out.println("AJP builderDebug ON");
                DEBUG_BUILDER = true;
            } else {
                System.out.println("AJP builderDebug OFF");
            }
            string = Platform.getDebugOption((String)"org.eclipse.ajdt.ui/compilerDebug");
            if (string != null && string.equals("true")) {
                System.out.println("AJP compilerDebug ON");
                DEBUG_COMPILER = true;
            } else {
                System.out.println("AJP compilerDebug OFF");
            }
            string = Platform.getDebugOption((String)"org.eclipse.ajdt.ui/outlineDebug");
            if (string != null && string.equals("true")) {
                System.out.println("AJP outlineDebug ON");
                DEBUG_OUTLINE = true;
            } else {
                System.out.println("AJP outlineDebug OFF");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        try {
            if (iSelection instanceof IStructuredSelection) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
                Object object = iStructuredSelection.getFirstElement();
                if (object == null) return;
                if (object instanceof IResource) {
                    this.currentResource = (IResource)object;
                    this.currentProject = this.currentResource.getProject();
                    return;
                } else {
                    IJavaElement iJavaElement;
                    if (!(object instanceof IJavaElement) || (iJavaElement = (IJavaElement)object).getJavaProject() == null) return;
                    this.currentResource = iJavaElement.getUnderlyingResource();
                    this.currentProject = iJavaElement.getJavaProject().getProject();
                }
                return;
            }
            if (!(iSelection instanceof ITextSelection)) return;
        }
        catch (JavaModelException javaModelException) {
            this.getErrorHandler().handleError("Exception in AspectJPlugin.selectionChanged processing", javaModelException);
        }
    }

    public List getListOfConfigFilesForCurrentProject() {
        if (this.currentProject == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        try {
            IResource[] iResourceArray = this.currentProject.members();
            this.getLstFiles(iResourceArray, arrayList);
        }
        catch (CoreException coreException) {
            AspectJPlugin.getDefault().getErrorHandler().handleError("Exception occurred whilst retrieving all .lst files in a project", coreException);
        }
        return arrayList;
    }

    private void getLstFiles(IResource[] iResourceArray, List list) {
        try {
            for (int i = 0; i < iResourceArray.length; ++i) {
                IResource iResource = iResourceArray[i];
                if (iResource.getName().endsWith(".lst") && !iResource.getName().equals("default.lst")) {
                    list.add(iResource);
                }
                if (!(iResource instanceof IContainer)) continue;
                this.getLstFiles(((IContainer)iResource).members(), list);
            }
        }
        catch (CoreException coreException) {
            AspectJPlugin.getDefault().getErrorHandler().handleError("Exception occurred whilst retrieiving all .lst files in a project", coreException);
        }
    }

    static {
        projectToBuildChoice = new Hashtable();
    }
}

