/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.ui.tests;

import junit.framework.TestCase;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.ajdt.ui.tests.AllAJPluginTests;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.osgi.framework.Bundle;

public class AspectJPluginTest
extends TestCase {
    public AspectJPluginTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testGetDefault() {
        AspectJPlugin aspectJPlugin = AspectJPlugin.getDefault();
        AspectJPluginTest.assertNotNull((String)"AspectJPlugin default must be set", (Object)((Object)aspectJPlugin));
        AspectJPlugin aspectJPlugin2 = AspectJPlugin.getDefault();
        AspectJPluginTest.assertEquals((String)"AspectJPlugin must be a singleton", (Object)((Object)aspectJPlugin), (Object)((Object)aspectJPlugin2));
    }

    public void testBundle() {
        Bundle bundle = AspectJPlugin.getDefault().getBundle();
        AspectJPluginTest.assertNotNull((String)"Plugin bundle must be available", (Object)bundle);
    }

    public void testResourceBundle() {
        String string = AspectJPlugin.getResourceString("test.message");
        AspectJPluginTest.assertEquals((String)"Resource key lookup failed", (String)string, (String)"A test message");
        String string2 = "missing.key";
        AspectJPluginTest.assertEquals((String)"Missing resource key lookup failed", (String)string2, (String)AspectJPlugin.getResourceString(string2));
    }

    public void testProjectBuildFile() {
        AspectJPlugin aspectJPlugin = AspectJPlugin.getDefault();
        aspectJPlugin.setCurrentProject("Examples");
        IProject iProject = aspectJPlugin.getCurrentProject();
        AspectJPluginTest.assertEquals((String)"Project should be set to 'Examples'", (String)"Examples", (String)iProject.getName());
        aspectJPlugin.setCurrentProject("The unknown project");
        AspectJPluginTest.assertTrue((boolean)AllAJPluginTests.confirmWithUser("Did you see a warning dialog for the unknown project?\n(look behind this dialog! ;-))"));
        iProject = aspectJPlugin.getCurrentProject();
        AspectJPluginTest.assertEquals((String)"Project should be set to 'Examples'", (String)"Examples", (String)iProject.getName());
    }

    public void testMultiBuildFilesInSingleProject() {
        IProject[] iProjectArray = AspectJPlugin.getWorkspace().getRoot().getProjects();
        AspectJPluginTest.assertTrue((String)"Must be at least one project in workspace for this test", (iProjectArray.length > 0 ? 1 : 0) != 0);
        IProject iProject = iProjectArray[0];
        AspectJPluginTest.assertEquals((String)"Project should be set to 'Examples'", (String)"Examples", (String)iProject.getName());
        IResource iResource = this.findRequiredResource(iProject, ".generated.lst");
        IResource iResource2 = this.findRequiredResource(iProject, "custom1.lst");
        IResource iResource3 = this.findRequiredResource(iProject, "custom2.lst");
        AspectJPlugin aspectJPlugin = AspectJPlugin.getDefault();
        AspectJPlugin.setBuildConfigurationFile(iProject, iResource);
        String string = AspectJPlugin.getBuildConfigurationFile(iProject);
        String string2 = AspectJPlugin.getWorkspace().getRoot().getLocation().toOSString();
        String string3 = string2 + iResource.getFullPath().toOSString();
        AspectJPluginTest.assertEquals((String)"Project should be using default config", (String)string, (String)string3);
        AspectJPlugin.setBuildConfigurationFile(iProject, iResource2);
        string = AspectJPlugin.getBuildConfigurationFile(iProject);
        AspectJPluginTest.assertEquals((String)"Project should be using custom1.lst", (String)string, (String)(string2 + iResource2.getFullPath().toOSString()));
        AspectJPlugin.setBuildConfigurationFile(iProject, iResource3);
        string = AspectJPlugin.getBuildConfigurationFile(iProject);
        AspectJPluginTest.assertEquals((String)"Project should be using custom2.lst", (String)string, (String)(string2 + iResource3.getFullPath().toOSString()));
    }

    public void testMultiBuildFilesInMultiProjects() {
        IProject[] iProjectArray = AspectJPlugin.getWorkspace().getRoot().getProjects();
        AspectJPluginTest.assertTrue((String)"Must be at least two projects in workspace for this test", (iProjectArray.length >= 2 ? 1 : 0) != 0);
        IProject iProject = iProjectArray[0];
        AspectJPluginTest.assertEquals((String)"Project one should be set to 'Examples'", (String)"Examples", (String)iProject.getName());
        IProject iProject2 = iProjectArray[1];
        AspectJPluginTest.assertEquals((String)"Project one should be set to 'More Examples'", (String)"More Examples", (String)iProject2.getName());
        IResource iResource = this.findRequiredResource(iProject, "custom1.lst");
        IResource iResource2 = this.findRequiredResource(iProject2, "custom3.lst");
        AspectJPlugin aspectJPlugin = AspectJPlugin.getDefault();
        AspectJPlugin.setBuildConfigurationFile(iProject, iResource);
        String string = AspectJPlugin.getBuildConfigurationFile(iProject);
        String string2 = AspectJPlugin.getWorkspace().getRoot().getLocation().toOSString();
        String string3 = string2 + iResource.getFullPath().toOSString();
        AspectJPluginTest.assertEquals((String)"Project should be using custom config1", (String)string, (String)string3);
        AspectJPlugin.setBuildConfigurationFile(iProject2, iResource2);
        string = AspectJPlugin.getBuildConfigurationFile(iProject2);
        string3 = string2 + iResource2.getFullPath().toOSString();
        AspectJPluginTest.assertEquals((String)"Project should be using custom config3", (String)string, (String)string3);
        string = AspectJPlugin.getBuildConfigurationFile(iProject);
        string3 = string2 + iResource.getFullPath().toOSString();
        AspectJPluginTest.assertEquals((String)"Project should be using custom config1", (String)string, (String)string3);
    }

    private IResource findRequiredResource(IProject iProject, String string) {
        IResource iResource = null;
        IResource[] iResourceArray = null;
        try {
            iResourceArray = iProject.members();
        }
        catch (CoreException coreException) {
            AspectJPluginTest.fail((String)("Exception listing project contents: " + coreException.getMessage()));
        }
        for (int i = 0; i < iResourceArray.length; ++i) {
            IResource iResource2 = iResourceArray[i];
            if (!iResource2.getName().endsWith(string)) continue;
            iResource = iResource2;
            break;
        }
        if (iResource == null) {
            AspectJPluginTest.fail((String)("Missing required project resource: " + string + "in project " + iProject.getName()));
        }
        return iResource;
    }
}

