/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.ui.visualiser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.ui.visualiser.AJDTMarkupProvider;
import org.eclipse.ajdt.ui.visualiser.AspectVisualiserPlugin;
import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.core.ProviderManager;
import org.eclipse.contribution.visualiser.interfaces.IMember;
import org.eclipse.contribution.visualiser.interfaces.simpleImpl.SimpleMember;
import org.eclipse.contribution.visualiser.jdtimpl.JDTContentProvider;
import org.eclipse.contribution.visualiser.jdtimpl.JDTGroup;
import org.eclipse.contribution.visualiser.jdtimpl.JDTMember;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;

public class AJDTContentProvider
extends JDTContentProvider {
    List currentGroups;
    List currentMembers;

    public List getAllGroups() {
        if (this.currentGroups != null) {
            return this.currentGroups;
        }
        this.updateData();
        return this.currentGroups;
    }

    public List getAllMembers() {
        if (this.currentMembers != null) {
            return this.currentMembers;
        }
        this.updateData();
        return this.currentMembers;
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        IStructuredSelection iStructuredSelection;
        Object object;
        if (!ProviderManager.getContentProvider().equals((Object)this)) {
            return;
        }
        boolean bl = false;
        if (iSelection instanceof IStructuredSelection && (object = (iStructuredSelection = (IStructuredSelection)iSelection).getFirstElement()) != null && object instanceof IJavaElement) {
            IJavaElement iJavaElement = (IJavaElement)object;
            if (this.currentlySelectedJE == iJavaElement) {
                return;
            }
            this.currentlySelectedJE = iJavaElement;
            bl = true;
            if (iJavaElement.getJavaProject() != null) {
                this.setCurrentProject(iJavaElement.getJavaProject());
            }
        }
        if (bl) {
            AJDTEventTrace.generalEvent("AJDTContentProvider.selectionChanged(): Marking visualiser content as out of date");
            this.currentGroups = null;
            this.currentMembers = null;
            VisualiserPlugin.refresh();
        }
    }

    private void updateData() {
        if (ProviderManager.getMarkupProvider() instanceof AJDTMarkupProvider) {
            ((AJDTMarkupProvider)ProviderManager.getMarkupProvider()).resetMarkups();
        }
        long l = System.currentTimeMillis();
        this.currentGroups = new ArrayList();
        this.currentMembers = new ArrayList();
        try {
            Object object;
            if (this.currentlySelectedJE instanceof IJavaProject) {
                object = ((IJavaProject)this.currentlySelectedJE).getPackageFragments();
                for (int i = 0; i < ((IPackageFragment)object).length; ++i) {
                    if (object[i].isReadOnly()) continue;
                    boolean bl = object[i].isDefaultPackage();
                    JDTGroup jDTGroup = new JDTGroup(object[i].getElementName());
                    if (bl) {
                        jDTGroup.setName("(default package)");
                        jDTGroup.setTooltip("(default package)");
                    }
                    List list = AspectVisualiserPlugin.getDefault().getAllClasses((IPackageFragment)object[i]);
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        Object[] objectArray = (Object[])iterator.next();
                        IResource iResource = (IResource)objectArray[0];
                        IJavaElement iJavaElement = JavaCore.create((IResource)iResource);
                        if (iResource == null) continue;
                        String string = iResource.getName();
                        string = string.substring(0, string.lastIndexOf("."));
                        JDTMember jDTMember = new JDTMember(string, iJavaElement);
                        jDTMember.setSize(((Integer)objectArray[1]).intValue());
                        jDTGroup.add((IMember)jDTMember);
                        this.currentMembers.add(jDTMember);
                        if (!bl) continue;
                        ((SimpleMember)jDTMember).setFullName(jDTMember.getName());
                    }
                    if (jDTGroup.getSize() <= 0) continue;
                    this.currentGroups.add(jDTGroup);
                }
            } else if (this.currentlySelectedJE instanceof IPackageFragment) {
                object = (IPackageFragment)this.currentlySelectedJE;
                boolean bl = object.isDefaultPackage();
                JDTGroup jDTGroup = new JDTGroup(object.getElementName());
                if (bl) {
                    jDTGroup.setName("(default package)");
                    jDTGroup.setTooltip("(default package)");
                }
                List list = AspectVisualiserPlugin.getDefault().getAllClasses((IPackageFragment)object);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Object[] objectArray = (Object[])iterator.next();
                    IResource iResource = (IResource)objectArray[0];
                    if (iResource == null) continue;
                    IJavaElement iJavaElement = JavaCore.create((IResource)iResource);
                    String string = iResource.getName();
                    string = string.substring(0, string.lastIndexOf("."));
                    JDTMember jDTMember = new JDTMember(string, iJavaElement);
                    jDTMember.setSize(((Integer)objectArray[1]).intValue());
                    jDTGroup.add((IMember)jDTMember);
                    this.currentMembers.add(jDTMember);
                    if (!bl) continue;
                    ((SimpleMember)jDTMember).setFullName(jDTMember.getName());
                }
                if (jDTGroup.getSize() > 0) {
                    this.currentGroups.add(jDTGroup);
                }
            } else if (this.currentlySelectedJE instanceof ICompilationUnit) {
                object = AspectVisualiserPlugin.getDefault().getAllClasses((ICompilationUnit)this.currentlySelectedJE);
                IPackageFragment iPackageFragment = (IPackageFragment)((ICompilationUnit)this.currentlySelectedJE).getParent();
                boolean bl = iPackageFragment.isDefaultPackage();
                JDTGroup jDTGroup = new JDTGroup(iPackageFragment.getElementName());
                if (bl) {
                    jDTGroup.setName("(default package)");
                    jDTGroup.setTooltip("(default package)");
                }
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object[] objectArray = (Object[])iterator.next();
                    IResource iResource = (IResource)objectArray[0];
                    IJavaElement iJavaElement = JavaCore.create((IResource)iResource);
                    String string = iResource.getName();
                    string = string.substring(0, string.lastIndexOf("."));
                    JDTMember jDTMember = new JDTMember(string, iJavaElement);
                    jDTMember.setSize(((Integer)objectArray[1]).intValue());
                    jDTGroup.add((IMember)jDTMember);
                    this.currentMembers.add(jDTMember);
                    if (!bl) continue;
                    ((SimpleMember)jDTMember).setFullName(jDTMember.getName());
                }
                if (jDTGroup.getSize() > 0) {
                    this.currentGroups.add(jDTGroup);
                }
            }
        }
        catch (JavaModelException javaModelException) {
            javaModelException.printStackTrace();
        }
        long l2 = System.currentTimeMillis();
        AJDTEventTrace.generalEvent("AJDTContentProvider.updateData() executed - took " + (l2 - l) + "ms");
    }

    protected void setCurrentProject(IJavaProject iJavaProject) {
        if (this.currentProject == null || !this.currentProject.equals(iJavaProject)) {
            if (ProviderManager.getMarkupProvider() instanceof AJDTMarkupProvider) {
                ((AJDTMarkupProvider)ProviderManager.getMarkupProvider()).resetColours();
            }
            this.currentProject = iJavaProject;
        }
    }

    public void reset() {
        this.currentGroups = null;
        this.currentMembers = null;
    }
}

