/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.ui.visualiser;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import org.aspectj.ajde.Ajde;
import org.aspectj.asm.IProgramElement;
import org.aspectj.bridge.ISourceLocation;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.internal.ui.ajde.ProjectProperties;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.ajdt.ui.visualiser.StructureModelUtil;
import org.eclipse.ajdt.ui.visualiser.menu.Menu;
import org.eclipse.ajdt.ui.visualiser.views.AV;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class AspectVisualiserPlugin {
    private static AspectVisualiserPlugin plugin;
    private ResourceBundle resourceBundle;
    public AV visualiser;
    public Menu menu;
    String lastLoadedConfigFile = null;
    IProject project;

    public AspectVisualiserPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("aspectVisualiser.aspectVisualiserPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public static AspectVisualiserPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String string) {
        ResourceBundle resourceBundle = AspectVisualiserPlugin.getDefault().getResourceBundle();
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void refreshView() {
        if (this.visualiser != null) {
            IJavaProject iJavaProject = JavaCore.create((IProject)AspectJPlugin.getDefault().getCurrentProject());
            this.visualiser.refresh(iJavaProject);
        }
    }

    public void setVisualiser(AV aV) {
        this.visualiser = aV;
    }

    public void removeVisualiser() {
        this.visualiser = null;
    }

    public void setMenu(Menu menu) {
        this.menu = menu;
    }

    public void removeMenu() {
        this.menu = null;
    }

    public Set getAllAspects(IJavaProject iJavaProject) {
        this.project = iJavaProject.getProject();
        this.initialiseAJDE();
        List list = StructureModelUtil.getPackagesInModel();
        HashSet hashSet = new HashSet();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object[] objectArray = (Object[])iterator.next();
            IProgramElement iProgramElement = (IProgramElement)objectArray[0];
            Set set = StructureModelUtil.getAspectsAffectingPackage(iProgramElement);
            hashSet.addAll(set);
        }
        return this.changeSet(hashSet);
    }

    public List getAllClasses(IJavaProject iJavaProject) {
        LinkedList<Object[]> linkedList = new LinkedList<Object[]>();
        this.project = iJavaProject.getProject();
        this.initialiseAJDE();
        List list = StructureModelUtil.getPackagesInModel();
        List list2 = this.sortArray(list);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Object[] objectArray = (Object[])iterator.next();
            IProgramElement iProgramElement = (IProgramElement)objectArray[0];
            List list3 = StructureModelUtil.getFilesInPackage(iProgramElement);
            List list4 = this.sortElements(list3);
            Iterator iterator2 = list4.iterator();
            while (iterator2.hasNext()) {
                IProgramElement iProgramElement2 = (IProgramElement)iterator2.next();
                try {
                    ISourceLocation iSourceLocation = iProgramElement2.getSourceLocation();
                    String string = iSourceLocation.getSourceFile().getAbsolutePath();
                    Map map = StructureModelUtil.getLinesToAspectMap(string);
                    Object[] objectArray2 = new Object[3];
                    IResource iResource = AspectJPlugin.getDefault().getAjdtProjectProperties().findResource(string, this.project);
                    int n = iSourceLocation.getEndLine();
                    objectArray2[0] = iResource;
                    objectArray2[1] = new Integer(n);
                    objectArray2[2] = this.changeMap(map, 0);
                    linkedList.add(objectArray2);
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
            }
        }
        return linkedList;
    }

    public List getAllClasses(IPackageFragment iPackageFragment) {
        IJavaProject iJavaProject = iPackageFragment.getJavaProject();
        this.project = iJavaProject.getProject();
        this.initialiseAJDE();
        LinkedList<Object[]> linkedList = new LinkedList<Object[]>();
        List list = StructureModelUtil.getPackagesInModel();
        String string = iPackageFragment.toString();
        boolean bl = false;
        String string2 = "";
        if (string.startsWith("<default>")) {
            bl = true;
        } else {
            int n = string.indexOf("[");
            string2 = iPackageFragment.toString().substring(0, n - 1);
            if (string2.indexOf("(not open)") != -1) {
                string2 = string2.substring(0, string2.length() - 10).trim();
            }
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object[] objectArray = (Object[])iterator.next();
            if ((!bl || !objectArray[1].equals("<default>")) && !string2.equals(objectArray[1])) continue;
            IProgramElement iProgramElement = (IProgramElement)objectArray[0];
            List list2 = StructureModelUtil.getFilesInPackage(iProgramElement);
            List list3 = this.sortElements(list2);
            for (int i = 0; i < list3.size(); ++i) {
                try {
                    IProgramElement iProgramElement2 = (IProgramElement)list3.get(i);
                    ISourceLocation iSourceLocation = iProgramElement2.getSourceLocation();
                    String string3 = iSourceLocation.getSourceFile().getAbsolutePath();
                    Map map = StructureModelUtil.getLinesToAspectMap(string3);
                    Object[] objectArray2 = new Object[3];
                    IResource iResource = AspectJPlugin.getDefault().getAjdtProjectProperties().findResource(string3, this.project);
                    int n = iSourceLocation.getEndLine();
                    objectArray2[0] = iResource;
                    objectArray2[1] = new Integer(n);
                    objectArray2[2] = this.changeMap(map, 0);
                    linkedList.add(objectArray2);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
            }
        }
        return linkedList;
    }

    public List getAllClasses(ICompilationUnit iCompilationUnit) {
        this.project = iCompilationUnit.getJavaProject().getProject();
        this.initialiseAJDE();
        LinkedList<Object[]> linkedList = new LinkedList<Object[]>();
        List list = StructureModelUtil.getPackagesInModel();
        String string = iCompilationUnit.getParent().toString();
        int n = string.startsWith("<default>") ? string.substring(1).indexOf("[") + 1 : string.indexOf("[");
        String string2 = string.substring(0, n - 1);
        if (string2.indexOf("(not open)") != -1) {
            string2 = string2.substring(0, string2.length() - 10).trim();
        }
        String string3 = iCompilationUnit.getPath().toString();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object[] objectArray = (Object[])iterator.next();
            if (!string2.equals(objectArray[1])) continue;
            IProgramElement iProgramElement = (IProgramElement)objectArray[0];
            List list2 = StructureModelUtil.getFilesInPackage(iProgramElement);
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                IProgramElement iProgramElement2 = (IProgramElement)iterator2.next();
                ISourceLocation iSourceLocation = iProgramElement2.getSourceLocation();
                String string4 = iSourceLocation.getSourceFile().getAbsolutePath();
                if (!(string4 = string4.replace('\\', '/')).endsWith(string3)) continue;
                try {
                    String string5 = iSourceLocation.getSourceFile().getAbsolutePath();
                    Map map = StructureModelUtil.getLinesToAspectMap(string5);
                    Object[] objectArray2 = new Object[3];
                    IResource iResource = AspectJPlugin.getDefault().getAjdtProjectProperties().findResource(string5, this.project);
                    int n2 = iSourceLocation.getEndLine();
                    objectArray2[0] = iResource;
                    objectArray2[1] = new Integer(n2);
                    objectArray2[2] = this.changeMap(map, 0);
                    linkedList.add(objectArray2);
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
            }
        }
        return linkedList;
    }

    public List getAllPackages(IJavaProject iJavaProject) {
        this.project = iJavaProject.getProject();
        this.initialiseAJDE();
        LinkedList<Object[]> linkedList = new LinkedList<Object[]>();
        List list = StructureModelUtil.getPackagesInModel();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ISourceLocation iSourceLocation;
            Object[] objectArray = (Object[])iterator.next();
            IProgramElement iProgramElement = (IProgramElement)objectArray[0];
            int n = 0;
            HashMap hashMap = new HashMap();
            List list2 = StructureModelUtil.getFilesInPackage(iProgramElement);
            list2 = this.sortElements(list2);
            String string = null;
            for (int i = 0; i < list2.size(); ++i) {
                IProgramElement iProgramElement2 = (IProgramElement)list2.get(i);
                iSourceLocation = iProgramElement2.getSourceLocation();
                string = iSourceLocation.getSourceFile().getAbsolutePath();
                Map map = StructureModelUtil.getLinesToAspectMap(string);
                map = this.changeMap(map, n);
                hashMap.putAll(map);
                n += iSourceLocation.getEndLine();
            }
            if (string == null) continue;
            Object[] objectArray2 = new Object[3];
            int n2 = string.lastIndexOf(File.separator);
            string = new String(string.substring(0, n2));
            iSourceLocation = AspectJPlugin.getDefault().getAjdtProjectProperties().findResource(string, this.project);
            objectArray2[0] = iSourceLocation;
            objectArray2[1] = new Integer(n);
            objectArray2[2] = hashMap;
            linkedList.add(objectArray2);
        }
        return linkedList;
    }

    public List getAllPackages(IPackageFragment iPackageFragment) {
        IJavaProject iJavaProject = iPackageFragment.getJavaProject();
        this.project = iJavaProject.getProject();
        this.initialiseAJDE();
        LinkedList<Object[]> linkedList = new LinkedList<Object[]>();
        List list = StructureModelUtil.getPackagesInModel();
        int n = iPackageFragment.toString().indexOf("[");
        String string = iPackageFragment.toString().substring(0, n - 1);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ISourceLocation iSourceLocation;
            Object[] objectArray = (Object[])iterator.next();
            String string2 = (String)objectArray[1];
            if (!string.equals(string2)) continue;
            IProgramElement iProgramElement = (IProgramElement)objectArray[0];
            int n2 = 0;
            HashMap hashMap = new HashMap();
            List list2 = StructureModelUtil.getFilesInPackage(iProgramElement);
            list2 = this.sortElements(list2);
            String string3 = null;
            for (int i = 0; i < list2.size(); ++i) {
                IProgramElement iProgramElement2 = (IProgramElement)list2.get(i);
                iSourceLocation = iProgramElement2.getSourceLocation();
                string3 = iSourceLocation.getSourceFile().getAbsolutePath();
                Map map = StructureModelUtil.getLinesToAspectMap(string3);
                map = this.changeMap(map, n2);
                hashMap.putAll(map);
                n2 += iSourceLocation.getEndLine();
            }
            if (string3 == null) continue;
            Object[] objectArray2 = new Object[3];
            int n3 = string3.lastIndexOf(File.separator);
            string3 = new String(string3.substring(0, n3));
            iSourceLocation = AspectJPlugin.getDefault().getAjdtProjectProperties().findResource(string3, this.project);
            objectArray2[0] = iSourceLocation;
            objectArray2[1] = new Integer(n2);
            objectArray2[2] = hashMap;
            linkedList.add(objectArray2);
        }
        return linkedList;
    }

    public List getSelectedClasses(List list) {
        ProjectProperties projectProperties = AspectJPlugin.getDefault().getAjdtProjectProperties();
        LinkedList<Object[]> linkedList = new LinkedList<Object[]>();
        Iterator iterator = list.iterator();
        block4: while (iterator.hasNext()) {
            try {
                IResource iResource = (IResource)iterator.next();
                IJavaProject iJavaProject = JavaCore.create((IProject)iResource.getProject());
                IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
                IClasspathEntry iClasspathEntry = iClasspathEntryArray[0];
                String string = iClasspathEntry.toString();
                int n = string.indexOf(91);
                string = new String(string.substring(0, n));
                String string2 = iResource.getFullPath().toString();
                String string3 = string.endsWith("/") ? string2.substring(string.length()) : string2.substring(string.length() + 1);
                String string4 = new String(string3.replace('/', '.'));
                List list2 = StructureModelUtil.getPackagesInModel();
                Iterator iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    Object[] objectArray = (Object[])iterator2.next();
                    String string5 = (String)objectArray[1];
                    if (!string5.equals(string4)) continue;
                    IProgramElement iProgramElement = (IProgramElement)objectArray[0];
                    List list3 = StructureModelUtil.getFilesInPackage(iProgramElement);
                    List list4 = this.sortElements(list3);
                    for (int i = 0; i < list4.size(); ++i) {
                        try {
                            IProgramElement iProgramElement2 = (IProgramElement)list4.get(i);
                            ISourceLocation iSourceLocation = iProgramElement2.getSourceLocation();
                            String string6 = iSourceLocation.getSourceFile().getAbsolutePath();
                            Map map = StructureModelUtil.getLinesToAspectMap(string6);
                            Object[] objectArray2 = new Object[3];
                            IResource iResource2 = AspectJPlugin.getDefault().getAjdtProjectProperties().findResource(string6);
                            int n2 = iSourceLocation.getEndLine();
                            objectArray2[0] = iResource2;
                            objectArray2[1] = new Integer(n2);
                            objectArray2[2] = this.changeMap(map, 0);
                            linkedList.add(objectArray2);
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            numberFormatException.printStackTrace();
                        }
                    }
                    continue block4;
                }
            }
            catch (JavaModelException javaModelException) {
                javaModelException.printStackTrace();
            }
        }
        return linkedList;
    }

    public List getSelectedPackages(List list) {
        String string;
        Object object;
        IPath iPath;
        int n;
        String string2;
        Object object2;
        Object[] objectArray;
        IJavaProject iJavaProject;
        List list2;
        LinkedList<Object[]> linkedList = new LinkedList<Object[]>();
        TreeSet<String> treeSet = new TreeSet<String>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                list2 = (IResource)iterator.next();
                iJavaProject = JavaCore.create((IProject)list2.getProject());
                objectArray = iJavaProject.getRawClasspath();
                object2 = objectArray[0];
                string2 = object2.toString();
                n = string2.indexOf(91);
                string2 = new String(string2.substring(0, n));
                iPath = list2.getFullPath();
                iPath = iPath.removeLastSegments(1);
                object = string2.endsWith("/") ? iPath.toString().substring(string2.length()) : iPath.toString().substring(string2.length() + 1);
                string = new String(((String)object).replace('/', '.'));
                treeSet.add(string);
            }
            catch (JavaModelException javaModelException) {
                javaModelException.printStackTrace();
            }
        }
        list2 = StructureModelUtil.getPackagesInModel();
        iJavaProject = list2.iterator();
        while (iJavaProject.hasNext()) {
            ISourceLocation iSourceLocation;
            objectArray = (Object[])iJavaProject.next();
            object2 = (String)objectArray[1];
            if (!treeSet.contains(object2)) continue;
            string2 = (IProgramElement)objectArray[0];
            n = 0;
            iPath = new HashMap();
            object = StructureModelUtil.getFilesInPackage((IProgramElement)string2);
            object = this.sortElements((List)object);
            string = null;
            for (int i = 0; i < object.size(); ++i) {
                IProgramElement iProgramElement = (IProgramElement)object.get(i);
                iSourceLocation = iProgramElement.getSourceLocation();
                string = iSourceLocation.getSourceFile().getAbsolutePath();
                Map map = StructureModelUtil.getLinesToAspectMap(string);
                map = this.changeMap(map, n);
                iPath.putAll(map);
                n += iSourceLocation.getEndLine();
            }
            if (string == null) continue;
            Object[] objectArray2 = new Object[3];
            int n2 = string.lastIndexOf(File.separator);
            string = new String(string.substring(0, n2));
            iSourceLocation = AspectJPlugin.getDefault().getAjdtProjectProperties().findResource(string, this.project);
            objectArray2[0] = iSourceLocation;
            objectArray2[1] = new Integer(n);
            objectArray2[2] = iPath;
            linkedList.add(objectArray2);
        }
        return linkedList;
    }

    private Set changeSet(Set set) {
        HashSet<IResource> hashSet = new HashSet<IResource>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            List list = (List)e;
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                Object e2 = iterator2.next();
                IProgramElement iProgramElement = (IProgramElement)e2;
                String string = iProgramElement.getSourceLocation().getSourceFile().getAbsolutePath();
                IResource iResource = AspectJPlugin.getDefault().getAjdtProjectProperties().findResource(string, this.project);
                hashSet.add(iResource);
            }
        }
        return hashSet;
    }

    private Map changeMap(Map map, int n) {
        HashMap hashMap = new HashMap();
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Integer n2 = (Integer)iterator.next();
            Object v = map.get(n2);
            List list = (List)v;
            LinkedList<String> linkedList = new LinkedList<String>();
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                IProgramElement iProgramElement = (IProgramElement)iterator2.next();
                String string = iProgramElement.getSourceLocation().getSourceFile().getAbsolutePath();
                Path path = new Path(string);
                String string2 = path.removeFileExtension().lastSegment();
                linkedList.add(string2);
            }
            if (linkedList.isEmpty()) continue;
            n2 = new Integer(n2 + n);
            hashMap.put(n2, linkedList);
        }
        return hashMap;
    }

    private void initialiseAJDE() {
        String string = AspectJPlugin.getBuildConfigurationFile(this.project);
        if (!string.equals(this.lastLoadedConfigFile)) {
            AJDTEventTrace.generalEvent("initialiseAJDE: switching configs - from:" + this.lastLoadedConfigFile + " to:" + string);
            Ajde.getDefault().getConfigurationManager().setActiveConfigFile(string);
            this.lastLoadedConfigFile = string;
        }
    }

    private List sortElements(List list) {
        Object[] objectArray = list.toArray();
        SortingComparator sortingComparator = new SortingComparator();
        Arrays.sort(objectArray, sortingComparator);
        List<Object> list2 = Arrays.asList(objectArray);
        return list2;
    }

    private List sortArray(List list) {
        Object[] objectArray = list.toArray();
        SortArrayComparator sortArrayComparator = new SortArrayComparator();
        Arrays.sort(objectArray, sortArrayComparator);
        List<Object> list2 = Arrays.asList(objectArray);
        return list2;
    }

    private class SortArrayComparator
    implements Comparator {
        private SortArrayComparator() {
        }

        public int compare(Object object, Object object2) {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])object2;
            IProgramElement iProgramElement = (IProgramElement)objectArray[0];
            IProgramElement iProgramElement2 = (IProgramElement)objectArray2[0];
            String string = iProgramElement.getName();
            String string2 = iProgramElement2.getName();
            return string.compareTo(string2);
        }
    }

    private class SortingComparator
    implements Comparator {
        private SortingComparator() {
        }

        public int compare(Object object, Object object2) {
            IProgramElement iProgramElement = (IProgramElement)object;
            IProgramElement iProgramElement2 = (IProgramElement)object2;
            String string = iProgramElement.getName();
            String string2 = iProgramElement2.getName();
            return string.compareTo(string2);
        }
    }
}

