/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.ui.visualiser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.aspectj.ajde.Ajde;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.IHierarchy;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.IRelationship;
import org.aspectj.asm.IRelationshipMap;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.ui.visualiser.NodeHolder;

public class StructureModelUtil {
    private static String activeConfigFile = "";
    private static Hashtable annotationsCache = new Hashtable();
    private static Hashtable processedAnnotationsCache = new Hashtable();

    public static Map getLinesToAspectMap(String string) {
        return StructureModelUtil.getLinesToAspectMap(string, false);
    }

    public static void wipeCache() {
        AJDTEventTrace.generalEvent("Wiping StructureModelUtil caches");
        annotationsCache.clear();
        processedAnnotationsCache.clear();
        activeConfigFile = Ajde.getDefault().getConfigurationManager().getActiveConfigFile();
    }

    public static Map getLinesToAspectMap(String string, boolean bl) {
        String string2;
        HashMap hashMap;
        if (activeConfigFile == null || !activeConfigFile.equals(Ajde.getDefault().getConfigurationManager().getActiveConfigFile())) {
            StructureModelUtil.wipeCache();
        }
        if ((hashMap = (HashMap)processedAnnotationsCache.get(string2 = string + (bl ? "T" : "F"))) != null) {
            return hashMap;
        }
        try {
            Map map = null;
            map = (Map)annotationsCache.get(string);
            if (map == null) {
                map = AsmManager.getDefault().getInlineAnnotations(string, true, true);
                if (string != null && map != null) {
                    annotationsCache.put(string, map);
                }
            }
            hashMap = new HashMap();
            if (map == null) {
                return hashMap;
            }
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                List list = (List)map.get(k);
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    IProgramElement iProgramElement = (IProgramElement)iterator2.next();
                    IRelationshipMap iRelationshipMap = AsmManager.getDefault().getRelationshipMap();
                    Vector vector = new Vector();
                    IRelationship iRelationship = iRelationshipMap.get(iProgramElement, IRelationship.Kind.ADVICE, "advised by", false, false);
                    List list2 = StructureModelUtil.processTargets(iRelationship, bl);
                    vector.addAll(list2);
                    iRelationship = iRelationshipMap.get(iProgramElement, IRelationship.Kind.ADVICE, "advised by", true, false);
                    List list3 = StructureModelUtil.processTargets(iRelationship, bl);
                    vector.addAll(list3);
                    IRelationship iRelationship2 = iRelationshipMap.get(iProgramElement, IRelationship.Kind.DECLARE_INTER_TYPE, "aspect declarations", false, false);
                    if (iRelationship2 != null) {
                        List list4 = StructureModelUtil.processTargets(iRelationship2, bl);
                        vector.addAll(list4);
                    }
                    if (vector == null || vector.size() == 0) continue;
                    hashMap.put(k, vector);
                }
            }
            processedAnnotationsCache.put(string2, hashMap);
            return hashMap;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    private static List processTargets(IRelationship iRelationship, boolean bl) {
        Vector<NodeHolder> vector = new Vector<NodeHolder>();
        if (iRelationship != null) {
            List list = iRelationship.getTargets();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                IProgramElement iProgramElement;
                String string = (String)iterator.next();
                if (string == null || (iProgramElement = AsmManager.getDefault().getHierarchy().findElementForHandle(string)) == null) continue;
                if (iProgramElement.getKind() == IProgramElement.Kind.ADVICE || StructureModelUtil.isIntertypeKind(iProgramElement.getKind()) || iProgramElement.getKind() == IProgramElement.Kind.FILE_JAVA) {
                    IProgramElement iProgramElement2 = null;
                    if (bl) {
                        NodeHolder nodeHolder = new NodeHolder(iProgramElement, iRelationship.hasRuntimeTest());
                        vector.add(nodeHolder);
                        continue;
                    }
                    iProgramElement2 = iProgramElement.getKind() == IProgramElement.Kind.FILE_JAVA ? iProgramElement : iProgramElement.getParent();
                    vector.add((NodeHolder)iProgramElement2);
                    continue;
                }
                if (iProgramElement.getKind() == IProgramElement.Kind.DECLARE_ERROR) {
                    vector.add((NodeHolder)iProgramElement.getParent());
                    continue;
                }
                if (iProgramElement.getKind() != IProgramElement.Kind.DECLARE_WARNING) continue;
                vector.add((NodeHolder)iProgramElement.getParent());
            }
        }
        return vector;
    }

    private static boolean isIntertypeKind(IProgramElement.Kind kind) {
        if (kind == IProgramElement.Kind.INTER_TYPE_METHOD) {
            return true;
        }
        if (kind == IProgramElement.Kind.INTER_TYPE_FIELD) {
            return true;
        }
        if (kind == IProgramElement.Kind.INTER_TYPE_PARENT) {
            return true;
        }
        return kind == IProgramElement.Kind.INTER_TYPE_CONSTRUCTOR;
    }

    public static Set getAspectsAffectingPackage(IProgramElement iProgramElement) {
        List list = StructureModelUtil.getFilesInPackage(iProgramElement);
        HashSet hashSet = new HashSet();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IProgramElement iProgramElement2 = (IProgramElement)iterator.next();
            Map map = StructureModelUtil.getLinesToAspectMap(iProgramElement2.getSourceLocation().getSourceFile().getAbsolutePath());
            Collection collection = map.values();
            Iterator iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                hashSet.add(iterator2.next());
            }
        }
        return hashSet;
    }

    public static List getPackagesInModel() {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        IHierarchy iHierarchy = Ajde.getDefault().getStructureModelManager().getHierarchy();
        if (iHierarchy.equals(IHierarchy.NO_STRUCTURE)) {
            return null;
        }
        Object[] objectArray = new Object[]{iHierarchy.getRoot(), "<default>"};
        arrayList.add(objectArray);
        return StructureModelUtil.getPackagesHelper(iHierarchy.getRoot(), IProgramElement.Kind.PACKAGE, null, arrayList);
    }

    private static List getPackagesHelper(IProgramElement iProgramElement, IProgramElement.Kind kind, String string, List list) {
        Object[] objectArray;
        if (kind == null || iProgramElement.getKind().equals(kind)) {
            string = string == null ? new String(iProgramElement.toString()) : new String(string + "." + iProgramElement);
            objectArray = new Object[]{iProgramElement, string};
            list.add(objectArray);
        }
        if (iProgramElement.getChildren() != null) {
            objectArray = iProgramElement.getChildren().iterator();
            while (objectArray.hasNext()) {
                IProgramElement iProgramElement2 = (IProgramElement)objectArray.next();
                StructureModelUtil.getPackagesHelper(iProgramElement2, kind, string, list);
            }
        }
        return list;
    }

    private List sortElements(List list) {
        Object[] objectArray = list.toArray();
        SortingComparator sortingComparator = new SortingComparator();
        Arrays.sort(objectArray, sortingComparator);
        List<Object> list2 = Arrays.asList(objectArray);
        return list2;
    }

    private static List sortArray(List list) {
        Object[] objectArray = list.toArray();
        SortArrayComparator sortArrayComparator = new SortArrayComparator();
        Arrays.sort(objectArray, sortArrayComparator);
        List<Object> list2 = Arrays.asList(objectArray);
        return list2;
    }

    public static List getFilesInPackage(IProgramElement iProgramElement) {
        if (iProgramElement == null) {
            return null;
        }
        List list = iProgramElement.getChildren();
        ArrayList<IProgramElement> arrayList = new ArrayList<IProgramElement>();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                IProgramElement iProgramElement2 = (IProgramElement)iterator.next();
                if (iProgramElement2.getKind() != IProgramElement.Kind.FILE_JAVA && iProgramElement2.getKind() != IProgramElement.Kind.FILE_ASPECTJ) continue;
                arrayList.add(iProgramElement2);
            }
        }
        return arrayList;
    }

    private static class SortArrayComparator
    implements Comparator {
        private SortArrayComparator() {
        }

        public int compare(Object object, Object object2) {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])object2;
            IProgramElement iProgramElement = (IProgramElement)objectArray[1];
            IProgramElement iProgramElement2 = (IProgramElement)objectArray2[1];
            String string = iProgramElement.getName();
            String string2 = iProgramElement2.getName();
            return string.compareTo(string2);
        }
    }

    private class SortingComparator
    implements Comparator {
        private SortingComparator() {
        }

        public int compare(Object object, Object object2) {
            IProgramElement iProgramElement = (IProgramElement)object;
            IProgramElement iProgramElement2 = (IProgramElement)object2;
            String string = iProgramElement.getName();
            String string2 = iProgramElement2.getName();
            return string.compareTo(string2);
        }
    }
}

