/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.ui.visualiser.menu;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.ajdt.ui.visualiser.AspectVisualiserPlugin;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ViewPart;

public class Menu
extends ViewPart {
    Button[] buttons;
    Button[] checkboxes;
    Label[] labels;
    Shell[] shells;
    ColorDialog[] colorDialogs;
    Image[] images;
    Color[] colors;
    SelectionAdapter selectionListener;
    MouseListener mouseListener;
    MouseListener labelListener;
    Composite canvas;
    ScrolledComposite scrollpane;
    GridLayout layout = new GridLayout(3, false);
    AspectVisualiserPlugin plugin = AspectVisualiserPlugin.getDefault();
    private static Map colourMemory = new HashMap();
    private static Map availableColours = new HashMap();

    public Menu() {
        this.plugin.setMenu(this);
    }

    private void drawImage(Image image, Color color) {
        GC gC = new GC((Drawable)image);
        gC.setBackground(color);
        Rectangle rectangle = image.getBounds();
        gC.fillRectangle(0, 0, rectangle.width, rectangle.height);
        gC.drawRectangle(0, 0, rectangle.width - 1, rectangle.height - 1);
        gC.dispose();
    }

    public void createPartControl(Composite composite) {
        this.scrollpane = new ScrolledComposite(composite, 2816);
        this.canvas = new Composite((Composite)this.scrollpane, 0);
        this.scrollpane.setContent((Control)this.canvas);
        this.canvas.setLayout((Layout)this.layout);
        this.labelListener = new MouseListener(){

            public void mouseUp(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
            }

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                for (int i = 0; i < Menu.this.labels.length; ++i) {
                    if ((Label)mouseEvent.getSource() != Menu.this.labels[i]) continue;
                    Menu.this.plugin.visualiser.openAspectSource(i);
                    return;
                }
            }
        };
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (selectionEvent.getSource() instanceof Button) {
                    Button button = (Button)selectionEvent.getSource();
                    int n = 0;
                    for (int i = 0; i < Menu.this.buttons.length; ++i) {
                        if (!Menu.this.buttons[i].equals(button)) continue;
                        n = i;
                    }
                    RGB rGB = Menu.this.colorDialogs[n].open();
                    if (rGB == null) {
                        return;
                    }
                    Menu.this.colors[n] = new Color((Device)Menu.this.buttons[n].getDisplay(), rGB);
                    Image image = Menu.this.buttons[n].getImage();
                    Menu.this.drawImage(image, Menu.this.colors[n]);
                    Menu.this.buttons[n].setImage(image);
                    if (Menu.this.plugin.visualiser != null) {
                        Color[] colorArray = new Color[Menu.this.colors.length];
                        for (int i = 0; i < Menu.this.colors.length; ++i) {
                            if (!Menu.this.checkboxes[i].getSelection()) continue;
                            colorArray[i] = Menu.this.colors[i];
                        }
                        Menu.this.plugin.visualiser.draw(colorArray);
                    }
                }
            }
        };
        this.mouseListener = new MouseListener(){

            public void mouseUp(MouseEvent mouseEvent) {
                if (Menu.this.plugin.visualiser != null) {
                    Color[] colorArray = new Color[Menu.this.colors.length];
                    for (int i = 0; i < Menu.this.colors.length; ++i) {
                        if (!Menu.this.checkboxes[i].getSelection()) continue;
                        colorArray[i] = Menu.this.colors[i];
                    }
                    Menu.this.plugin.visualiser.draw(colorArray);
                }
            }

            public void mouseDown(MouseEvent mouseEvent) {
            }

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }
        };
    }

    public void addAspects(IJavaProject iJavaProject, Vector vector) {
        this.clearCanvas();
        this.buttons = new Button[vector.size()];
        this.checkboxes = new Button[vector.size()];
        this.labels = new Label[vector.size()];
        this.shells = new Shell[vector.size()];
        this.images = new Image[vector.size()];
        this.colorDialogs = new ColorDialog[vector.size()];
        this.colors = new Color[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            int n = 12;
            this.colors[i] = this.getColorFor(iJavaProject, (String)vector.elementAt(i));
            this.buttons[i] = new Button(this.canvas, 8);
            this.shells[i] = this.buttons[i].getShell();
            this.colorDialogs[i] = new ColorDialog(this.shells[i]);
            Display display = this.shells[i].getDisplay();
            this.images[i] = new Image((Device)display, n, n);
            this.buttons[i].setImage(this.images[i]);
            this.buttons[i].addSelectionListener((SelectionListener)this.selectionListener);
            Image image = this.buttons[i].getImage();
            this.drawImage(image, this.colors[i]);
            this.buttons[i].setImage(image);
            this.checkboxes[i] = new Button(this.canvas, 32);
            this.checkboxes[i].addMouseListener(this.mouseListener);
            this.checkboxes[i].setSelection(true);
            this.labels[i] = new Label(this.canvas, 0);
            this.labels[i].setText((String)vector.elementAt(i));
            this.labels[i].addMouseListener(this.labelListener);
        }
        this.canvas.layout();
        this.canvas.setSize(this.canvas.computeSize(-1, -1, true));
        if (this.plugin.visualiser != null) {
            this.plugin.visualiser.draw(this.colors);
        }
    }

    private Color getColor(int n) {
        switch (n) {
            case 0: {
                return ColorConstants.red;
            }
            case 1: {
                return ColorConstants.blue;
            }
            case 2: {
                return ColorConstants.yellow;
            }
            case 3: {
                return ColorConstants.green;
            }
            case 4: {
                return ColorConstants.darkBlue;
            }
            case 5: {
                return ColorConstants.cyan;
            }
            case 6: {
                return ColorConstants.orange;
            }
            case 7: {
                return ColorConstants.lightBlue;
            }
            case 8: {
                return ColorConstants.darkGreen;
            }
            case 9: {
                return ColorConstants.darkGray;
            }
        }
        return ColorConstants.gray;
    }

    private Color getColorFor(IJavaProject iJavaProject, String string) {
        Color color;
        String string2 = new String(iJavaProject + ":" + string);
        if (colourMemory.containsKey(string2)) {
            color = (Color)colourMemory.get(string2);
        } else {
            color = this.getNextColourFor(iJavaProject);
            colourMemory.put(string2, color);
        }
        return color;
    }

    private Color getNextColourFor(IJavaProject iJavaProject) {
        List<Color> list;
        Color color = ColorConstants.gray;
        if (!availableColours.containsKey(iJavaProject.toString())) {
            list = new ArrayList<Color>();
            list.add(ColorConstants.red);
            list.add(ColorConstants.blue);
            list.add(ColorConstants.yellow);
            list.add(ColorConstants.green);
            list.add(ColorConstants.darkBlue);
            list.add(ColorConstants.cyan);
            list.add(ColorConstants.orange);
            list.add(ColorConstants.lightBlue);
            list.add(ColorConstants.darkGreen);
            list.add(ColorConstants.darkGray);
            availableColours.put(iJavaProject.toString(), list);
        }
        if (!(list = (List)availableColours.get(iJavaProject.toString())).isEmpty()) {
            color = (Color)list.get(0);
            list.remove(0);
        }
        return color;
    }

    private void clearCanvas() {
        Control[] controlArray = this.canvas.getChildren();
        if (controlArray.length > 0) {
            for (int i = 0; i < controlArray.length; ++i) {
                controlArray[i].dispose();
            }
        }
    }

    public void setFocus() {
    }

    public void dispose() {
        this.plugin.removeMenu();
    }
}

