/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.ui.visualiser.views;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.ajdt.ui.visualiser.AspectVisualiserPlugin;
import org.eclipse.ajdt.ui.visualiser.views.AspectDrawing;
import org.eclipse.ajdt.ui.visualiser.views.Messages;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;

public class AV
extends ViewPart
implements ISelectionListener {
    AspectVisualiserPlugin plugin = AspectVisualiserPlugin.getDefault();
    AspectDrawing aspectDrawing = new AspectDrawing();
    private Action package_view;
    private Action class_view;
    private Action sub_select;
    private Action doubleClickAction;
    private Action limit;
    private Action zoom_in;
    private Action zoom_out;
    private IWorkbenchPart part;
    private ISelection sel;
    boolean in_package_view = false;
    boolean in_sub_select_mode = false;
    boolean limit_mode = false;
    private Object nowShowing = null;
    Canvas canvas;
    Vector vector;
    Vector elements;
    Vector aspects;
    Color[] colors;
    Vector names;
    Vector tooltips;
    Map[] map;
    public boolean justOpenedFile = false;
    Listener canvasListener;
    Set aspectSet;
    List list;
    Rectangle viewsize;

    public AV() {
        this.plugin.setVisualiser(this);
    }

    public void createPartControl(Composite composite) {
        this.canvas = new Canvas(composite, 0);
        this.vector = new Vector();
        this.elements = new Vector();
        this.aspects = new Vector();
        this.names = new Vector();
        this.tooltips = new Vector();
        this.makeActions();
        this.class_view.setChecked(true);
        this.zoom_out.setEnabled(false);
        this.hookContextMenu();
        this.contributeToActionBars();
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        this.canvasListener = new Listener(){

            public void handleEvent(Event event) {
                int n = AV.this.aspectDrawing.location;
                if (!AV.this.in_package_view) {
                    IMarker iMarker = n != -1 ? AV.this.getMarker(n) : AV.this.getMarker(AV.this.aspectDrawing.classNum, AV.this.aspectDrawing.lineNum);
                    if (iMarker != null) {
                        try {
                            IDE.openEditor((IWorkbenchPage)AV.this.part.getSite().getWorkbenchWindow().getActivePage(), (IMarker)iMarker, (boolean)true);
                        }
                        catch (Exception exception) {
                            System.err.println(exception);
                        }
                    }
                } else if (n >= 0) {
                    AV.this.in_package_view = false;
                    AV.this.class_view.setChecked(true);
                    AV.this.package_view.setChecked(false);
                    AV.this.in_package_view = false;
                    AV.this.in_sub_select_mode = true;
                    AV.this.sub_select.setChecked(true);
                    Vector vector = new Vector();
                    vector.add(AV.this.elements.elementAt(n));
                    AV.this.list = AV.this.plugin.getSelectedClasses(vector);
                    AV.this.vector.removeAllElements();
                    AV.this.elements.removeAllElements();
                    AV.this.aspects.removeAllElements();
                    AV.this.names.removeAllElements();
                    AV.this.tooltips.removeAllElements();
                    AV.this.map = new Map[AV.this.list.size()];
                    for (int i = 0; i < AV.this.list.size(); ++i) {
                        Object[] objectArray = new Object[3];
                        objectArray = (Object[])AV.this.list.get(i);
                        AV.this.addToVectors((Integer)objectArray[1], (IResource)objectArray[0]);
                        AV.this.map[i] = (Map)objectArray[2];
                    }
                    IJavaProject iJavaProject = JavaCore.create((IProject)AspectJPlugin.getDefault().getCurrentProject());
                    AV.this.aspectStuff(iJavaProject);
                }
            }
        };
        this.aspectDrawing.addListener(this.canvasListener);
        this.selectionChanged(null, this.getSite().getPage().getSelection());
        this.canvas.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                if (AV.this.in_sub_select_mode) {
                    AV.this.selectionChanged(AV.this.part, AV.this.sel);
                } else if (AV.this.part != null && AV.this.sel != null) {
                    AV.this.aspectDrawing.draw(AV.this.names, AV.this.tooltips, AV.this.vector, AV.this.aspects, AV.this.map, AV.this.colors, AV.this.canvas);
                }
            }
        });
    }

    public void draw(Color[] colorArray) {
        this.colors = colorArray;
        if (this.map != null && this.aspects != null) {
            this.aspectDrawing.draw(this.names, this.tooltips, this.vector, this.aspects, this.map, colorArray, this.canvas);
        } else {
            this.aspectDrawing.draw(this.names, this.tooltips, this.vector, this.canvas);
        }
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (!(iSelection instanceof IStructuredSelection)) {
            return;
        }
        this.part = iWorkbenchPart;
        this.sel = iSelection;
        if (this.in_sub_select_mode) {
            return;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof IJavaElement) {
            this.nowShowing = object;
            this.updateDisplay();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateDisplay() {
        if (null == this.nowShowing) {
            this.nowShowing = JavaCore.create((IProject)AspectJPlugin.getDefault().getCurrentProject());
        }
        if (this.in_package_view) {
            if (this.nowShowing instanceof IPackageFragment) {
                this.clearVectors();
                IPackageFragment iPackageFragment = (IPackageFragment)this.nowShowing;
                this.list = this.plugin.getAllPackages(iPackageFragment);
                this.map = new Map[this.list.size()];
                for (int i = 0; i < this.list.size(); ++i) {
                    Object[] objectArray = new Object[3];
                    objectArray = (Object[])this.list.get(i);
                    this.addToVectors((int)((Integer)objectArray[1]), (IResource)objectArray[0]);
                    this.map[i] = (Map)objectArray[2];
                }
                this.aspectStuff(iPackageFragment.getJavaProject());
                return;
            } else if (this.nowShowing instanceof IJavaProject) {
                this.clearVectors();
                IJavaProject iJavaProject = (IJavaProject)this.nowShowing;
                this.aspectSet = this.plugin.getAllAspects(iJavaProject);
                this.list = this.plugin.getAllPackages(iJavaProject);
                this.map = new Map[this.list.size()];
                for (int i = 0; i < this.list.size(); ++i) {
                    Object[] objectArray = new Object[3];
                    objectArray = (Object[])this.list.get(i);
                    this.addToVectors((int)((Integer)objectArray[1]), (IResource)objectArray[0]);
                    this.map[i] = (Map)objectArray[2];
                }
                this.aspectStuff(iJavaProject.getJavaProject());
                return;
            } else {
                if (!(this.nowShowing instanceof ICompilationUnit)) return;
                this.clearVectors();
                this.in_package_view = false;
                this.package_view.setChecked(false);
                this.class_view.setChecked(true);
                ICompilationUnit iCompilationUnit = (ICompilationUnit)this.nowShowing;
                this.aspectSet = this.plugin.getAllAspects(iCompilationUnit.getJavaProject());
                this.list = this.plugin.getAllClasses(iCompilationUnit);
                this.map = new Map[this.list.size()];
                for (int i = 0; i < this.list.size(); ++i) {
                    Object[] objectArray = new Object[3];
                    objectArray = (Object[])this.list.get(i);
                    this.addToVectors((int)((Integer)objectArray[1]), (IResource)objectArray[0]);
                    this.map[i] = (Map)objectArray[2];
                }
                this.aspectStuff(iCompilationUnit.getJavaProject());
            }
            return;
        } else {
            Object[] objectArray;
            int n;
            ICompilationUnit iCompilationUnit;
            if (this.in_package_view) return;
            if (this.nowShowing instanceof ICompilationUnit) {
                this.clearVectors();
                iCompilationUnit = (ICompilationUnit)this.nowShowing;
                this.aspectSet = this.plugin.getAllAspects(iCompilationUnit.getJavaProject());
                this.list = this.plugin.getAllClasses(iCompilationUnit);
                this.map = new Map[this.list.size()];
                for (n = 0; n < this.list.size(); ++n) {
                    objectArray = new Object[3];
                    objectArray = (Object[])this.list.get(n);
                    this.addToVectors((int)((Integer)objectArray[1]), (IResource)objectArray[0]);
                    this.map[n] = (Map)objectArray[2];
                }
                this.aspectStuff(iCompilationUnit.getJavaProject());
            }
            if (this.nowShowing instanceof IPackageFragment) {
                this.clearVectors();
                iCompilationUnit = (IPackageFragment)this.nowShowing;
                this.list = this.plugin.getAllClasses((IPackageFragment)iCompilationUnit);
                this.aspectSet = this.plugin.getAllAspects(iCompilationUnit.getJavaProject());
                this.map = new Map[this.list.size()];
                for (n = 0; n < this.list.size(); ++n) {
                    objectArray = new Object[3];
                    objectArray = (Object[])this.list.get(n);
                    this.addToVectors((int)((Integer)objectArray[1]), (IResource)objectArray[0]);
                    this.map[n] = (Map)objectArray[2];
                }
                this.aspectStuff(iCompilationUnit.getJavaProject());
                return;
            } else {
                if (!(this.nowShowing instanceof IJavaProject)) return;
                this.clearVectors();
                iCompilationUnit = (IJavaProject)this.nowShowing;
                this.aspectSet = this.plugin.getAllAspects((IJavaProject)iCompilationUnit);
                this.list = this.plugin.getAllClasses((IJavaProject)iCompilationUnit);
                this.map = new Map[this.list.size()];
                for (n = 0; n < this.list.size(); ++n) {
                    objectArray = new Object[3];
                    objectArray = (Object[])this.list.get(n);
                    this.addToVectors((int)((Integer)objectArray[1]), (IResource)objectArray[0]);
                    this.map[n] = (Map)objectArray[2];
                }
                this.aspectStuff((IJavaProject)iCompilationUnit);
            }
        }
    }

    private void clearVectors() {
        this.map = null;
        this.vector.removeAllElements();
        this.elements.removeAllElements();
        this.aspects.removeAllElements();
        this.names.removeAllElements();
        this.tooltips.removeAllElements();
    }

    private void aspectStuff(IJavaProject iJavaProject) {
        if (this.aspectSet != null) {
            int n = this.aspectSet.size();
            Object[] objectArray = this.aspectSet.toArray();
            IPath[] iPathArray = new IPath[n];
            for (int i = 0; i < n; ++i) {
                if (!(objectArray[i] instanceof IResource)) continue;
                iPathArray[i] = ((IResource)objectArray[i]).getLocation();
                iPathArray[i] = iPathArray[i].removeFileExtension();
                this.aspects.add(iPathArray[i].lastSegment());
            }
        }
        if (this.plugin.menu != null) {
            this.plugin.menu.addAspects(iJavaProject, this.aspects);
        }
        if (this.map != null && this.aspects != null) {
            this.aspectDrawing.draw(this.names, this.tooltips, this.vector, this.aspects, this.map, this.colors, this.canvas);
        }
    }

    public void openAspectSource(int n) {
        Iterator iterator = this.aspectSet.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            IResource iResource = (IResource)iterator.next();
            if (n == n2) {
                if (iResource != null) {
                    try {
                        IMarker iMarker = iResource.createMarker("org.eclipse.core.resources.marker");
                        if (iMarker != null) {
                            IDE.openEditor((IWorkbenchPage)this.part.getSite().getWorkbenchWindow().getActivePage(), (IMarker)iMarker, (boolean)true);
                        }
                    }
                    catch (Exception exception) {
                        System.err.println(exception);
                    }
                    return;
                }
            } else {
                ++n2;
            }
            this.selectionChanged(this.part, this.sel);
        }
    }

    private IMarker getMarker(int n) {
        IResource iResource;
        IMarker iMarker = null;
        if (this.elements.elementAt(n) instanceof IResource && (iResource = (IResource)this.elements.elementAt(n)) != null) {
            try {
                iMarker = iResource.createMarker("org.eclipse.core.resources.marker");
            }
            catch (CoreException coreException) {
                System.err.println((Object)coreException);
            }
        }
        return iMarker;
    }

    private IMarker getMarker(int n, int n2) {
        IResource iResource;
        IMarker iMarker = null;
        if (this.elements.elementAt(n) instanceof IResource && (iResource = (IResource)this.elements.elementAt(n)) != null) {
            try {
                iMarker = iResource.createMarker("org.eclipse.core.resources.marker");
                iMarker.setAttribute("lineNumber", n2);
            }
            catch (CoreException coreException) {
                System.err.println((Object)coreException);
            }
        }
        return iMarker;
    }

    private void addToVectors(int n, IJavaElement iJavaElement) {
        if (n > 0 && iJavaElement != null) {
            Integer n2 = new Integer(n);
            this.vector.addElement(n2);
            this.elements.addElement(iJavaElement);
            this.names.addElement(iJavaElement.getElementName());
            this.tooltips.addElement(iJavaElement.getPath().toString());
        }
    }

    private void addToVectors(int n, IResource iResource) {
        if (n > 0 && iResource != null) {
            Integer n2 = new Integer(n);
            this.vector.addElement(n2);
            this.elements.addElement(iResource);
            if (this.in_package_view) {
                try {
                    IJavaProject iJavaProject = JavaCore.create((IProject)iResource.getProject());
                    IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
                    IClasspathEntry iClasspathEntry = iClasspathEntryArray[0];
                    String string = iClasspathEntry.toString();
                    int n3 = string.indexOf(91);
                    string = new String(string.substring(0, n3));
                    String string2 = iResource.getFullPath().toString();
                    String string3 = string.endsWith("/") ? string2.substring(string.length()) : string2.substring(string.length() + 1);
                    String string4 = new String(string3.replace('/', '.'));
                    this.names.addElement(string4);
                }
                catch (JavaModelException javaModelException) {
                    System.err.println((Object)javaModelException);
                }
            } else {
                this.names.addElement(iResource.getName());
            }
            this.tooltips.addElement(iResource.getFullPath().toString());
        }
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                AV.this.fillContextMenu(iMenuManager);
            }
        });
    }

    private void contributeToActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(iActionBars.getMenuManager());
        this.fillLocalToolBar(iActionBars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.zoom_in);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.zoom_out);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.limit);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.sub_select);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.package_view);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.class_view);
    }

    private void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.zoom_in);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.zoom_out);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.limit);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.sub_select);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.package_view);
        iMenuManager.add((IContributionItem)new Separator("Additions"));
        iMenuManager.add((IAction)this.class_view);
    }

    private void fillLocalToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IAction)this.zoom_in);
        iToolBarManager.add((IAction)this.zoom_out);
        iToolBarManager.add((IAction)this.limit);
        iToolBarManager.add((IAction)this.sub_select);
        iToolBarManager.add((IAction)this.package_view);
        iToolBarManager.add((IAction)this.class_view);
    }

    private void makeActions() {
        this.zoom_in = new Action(){

            public void run() {
                AV.this.zoom_out.setEnabled(true);
                boolean bl = AV.this.aspectDrawing.zoomIn(AV.this.canvas);
                this.setEnabled(bl);
            }
        };
        this.zoom_in.setText(Messages.getString("Zoom_In_3"));
        this.zoom_in.setToolTipText(Messages.getString("Zooms_in_on_visualisation_4"));
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)Messages.getString("zoomIn.gif_5"));
        this.zoom_in.setImageDescriptor(imageDescriptor);
        this.zoom_out = new Action(){

            public void run() {
                boolean bl = AV.this.aspectDrawing.zoomOut(AV.this.canvas);
                this.setEnabled(bl);
                AV.this.zoom_in.setEnabled(true);
            }
        };
        this.zoom_out.setText(Messages.getString("Zoom_Out_6"));
        this.zoom_out.setToolTipText(Messages.getString("Zooms_out_7"));
        ImageDescriptor imageDescriptor2 = ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)Messages.getString("zoomOut.gif_8"));
        this.zoom_out.setImageDescriptor(imageDescriptor2);
        this.limit = new Action(){

            public int getStyle() {
                return 2;
            }

            public void run() {
                if (!AV.this.limit_mode) {
                    AV.this.limit_mode = true;
                    AV.this.aspectDrawing.Limit(AV.this.canvas, AV.this.limit_mode);
                    Vector vector = AV.this.aspectDrawing.lengths;
                    Vector vector2 = new Vector();
                    int n = 0;
                    for (int i = 0; i < AV.this.vector.size(); ++i) {
                        if (n >= vector.size() || !AV.this.vector.elementAt(i).equals(vector.elementAt(n))) continue;
                        vector2.add(AV.this.elements.elementAt(i));
                        ++n;
                    }
                    AV.this.elements = vector2;
                    AV.this.vector = vector;
                    AV.this.names = AV.this.aspectDrawing.names;
                    AV.this.tooltips = AV.this.aspectDrawing.tooltips;
                } else {
                    AV.this.limit_mode = false;
                    AV.this.aspectDrawing.Limit(AV.this.canvas, AV.this.limit_mode);
                }
            }
        };
        this.limit.setText(Messages.getString("Limit_view_9"));
        this.limit.setToolTipText(Messages.getString("Limits_visualisation_to_affected_bars_only_10"));
        ImageDescriptor imageDescriptor3 = ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"graph_mode.gif");
        this.limit.setImageDescriptor(imageDescriptor3);
        this.package_view = new Action(){

            public int getStyle() {
                return 2;
            }

            public void run() {
                if (AV.this.in_sub_select_mode) {
                    if (!AV.this.in_package_view) {
                        this.setChecked(true);
                        AV.this.class_view.setChecked(false);
                        AV.this.in_package_view = true;
                        AV.this.list = AV.this.plugin.getSelectedPackages(AV.this.elements);
                        AV.this.vector.removeAllElements();
                        AV.this.elements.removeAllElements();
                        AV.this.aspects.removeAllElements();
                        AV.this.names.removeAllElements();
                        AV.this.tooltips.removeAllElements();
                        AV.this.map = null;
                        AV.this.map = new Map[AV.this.list.size()];
                        for (int i = 0; i < AV.this.list.size(); ++i) {
                            Object[] objectArray = new Object[3];
                            objectArray = (Object[])AV.this.list.get(i);
                            AV.this.addToVectors((Integer)objectArray[1], (IResource)objectArray[0]);
                            AV.this.map[i] = (Map)objectArray[2];
                        }
                        IJavaProject iJavaProject = JavaCore.create((IProject)AspectJPlugin.getDefault().getCurrentProject());
                        AV.this.aspectStuff(iJavaProject);
                    } else {
                        this.setChecked(true);
                    }
                } else {
                    this.setChecked(true);
                }
                AV.this.class_view.setChecked(false);
                AV.this.in_package_view = true;
                AV.this.selectionChanged(AV.this.part, AV.this.sel);
            }
        };
        this.package_view.setText(Messages.getString("Package_View_12"));
        this.package_view.setToolTipText(Messages.getString("Changes_to_package_view_13"));
        ImageDescriptor imageDescriptor4 = ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"packages.gif");
        this.package_view.setImageDescriptor(imageDescriptor4);
        this.class_view = new Action(){

            public int getStyle() {
                return 2;
            }

            public void run() {
                if (AV.this.in_sub_select_mode && AV.this.in_package_view) {
                    AV.this.list = AV.this.plugin.getSelectedClasses(AV.this.elements);
                    AV.this.vector.removeAllElements();
                    AV.this.elements.removeAllElements();
                    AV.this.aspects.removeAllElements();
                    AV.this.names.removeAllElements();
                    AV.this.tooltips.removeAllElements();
                    AV.this.map = new Map[AV.this.list.size()];
                    for (int i = 0; i < AV.this.list.size(); ++i) {
                        Object[] objectArray = new Object[3];
                        objectArray = (Object[])AV.this.list.get(i);
                        AV.this.addToVectors((Integer)objectArray[1], (IResource)objectArray[0]);
                        AV.this.map[i] = (Map)objectArray[2];
                    }
                    IJavaProject iJavaProject = JavaCore.create((IProject)AspectJPlugin.getDefault().getCurrentProject());
                    AV.this.aspectStuff(iJavaProject);
                }
                this.setChecked(true);
                AV.this.package_view.setChecked(false);
                AV.this.in_package_view = false;
                AV.this.selectionChanged(AV.this.part, AV.this.sel);
            }
        };
        this.class_view.setText(Messages.getString("Class_View_15"));
        this.class_view.setToolTipText(Messages.getString("Changes_to_class_view_16"));
        ImageDescriptor imageDescriptor5 = ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"class_obj.gif");
        this.class_view.setImageDescriptor(imageDescriptor5);
        this.sub_select = new Action(){

            public int getStyle() {
                return 2;
            }

            public void run() {
                boolean bl = AV.this.aspectDrawing.subSelect(AV.this.canvas);
                AV.this.sub_select.setChecked(bl);
                AV.this.in_sub_select_mode = bl;
                if (!bl) {
                    AV.this.selectionChanged(null, AV.this.getSite().getPage().getSelection());
                } else {
                    Vector vector = AV.this.aspectDrawing.lengths;
                    Vector vector2 = new Vector();
                    int n = 0;
                    for (int i = 0; i < AV.this.vector.size(); ++i) {
                        if (n >= vector.size() || !AV.this.vector.elementAt(i).equals(vector.elementAt(n))) continue;
                        vector2.add(AV.this.elements.elementAt(i));
                        ++n;
                    }
                    AV.this.elements = vector2;
                    AV.this.vector = vector;
                    AV.this.names = AV.this.aspectDrawing.names;
                    AV.this.tooltips = AV.this.aspectDrawing.tooltips;
                }
            }
        };
        this.sub_select.setText(Messages.getString("Subselect_18"));
        this.sub_select.setToolTipText(Messages.getString("Subselects_chosen_packages/classes_19"));
        ImageDescriptor imageDescriptor6 = ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"next_nav.gif");
        this.sub_select.setImageDescriptor(imageDescriptor6);
    }

    public void setFocus() {
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        this.aspectDrawing.removeListener(this.canvasListener);
        this.plugin.removeVisualiser();
    }

    public void refresh(IJavaProject iJavaProject) {
        this.updateDisplay();
    }
}

