/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.ui.visualiser.views;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Button;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class AspectDrawing {
    int spacing = 3;
    int maxBarWidth = 60;
    int minBarWidth = 20;
    int highlightDepth = 3;
    int location = -1;
    int classNum = -1;
    int lineNum = -1;
    float zoom = 1.0f;
    float max_zoom = 4.0f;
    float scale;
    Shape[] rectangles;
    Vector[] highlights;
    Vector[] lineNums;
    Vector lengths;
    Vector names;
    Vector tooltips;
    Vector aspects;
    Map[] map;
    IFigure panel = new Figure();
    MouseListener mouseListener = new MouseListener(){

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseDoubleClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() instanceof RectangleFigure) {
                int n;
                AspectDrawing.this.location = -1;
                RectangleFigure rectangleFigure = (RectangleFigure)mouseEvent.getSource();
                for (n = 0; n < AspectDrawing.this.lengths.size(); ++n) {
                    if (!((RectangleFigure)AspectDrawing.this.rectangles[n]).equals(rectangleFigure)) continue;
                    AspectDrawing.this.location = n;
                    AspectDrawing.this.listener.handleEvent(new Event());
                    return;
                }
                if (AspectDrawing.this.location == -1) {
                    for (n = 0; n < AspectDrawing.this.highlights.length; ++n) {
                        for (int i = 0; i < AspectDrawing.this.highlights[n].size(); ++i) {
                            if (!((RectangleFigure)AspectDrawing.this.highlights[n].elementAt(i)).equals(rectangleFigure)) continue;
                            AspectDrawing.this.classNum = n;
                            Point point = rectangleFigure.getLocation();
                            AspectDrawing.this.lineNum = (Integer)AspectDrawing.this.lineNums[n].elementAt(i);
                            AspectDrawing.this.listener.handleEvent(new Event());
                            return;
                        }
                    }
                }
            }
        }
    };
    Button[] buttons;
    Color[] colors;
    Listener listener;
    boolean limit_mode = false;
    public Rectangle viewsize;

    public void addListener(Listener listener) {
        this.listener = listener;
    }

    public void removeListener(Listener listener) {
        if (this.listener == listener) {
            this.listener = null;
        }
    }

    public void draw(Vector vector, Vector vector2, Vector vector3, Vector vector4, Map[] mapArray, Color[] colorArray, Canvas canvas) {
        this.clearPanel();
        this.lengths = vector3;
        this.names = vector;
        this.tooltips = vector2;
        this.map = mapArray;
        this.colors = colorArray;
        this.aspects = vector4;
        int n = vector.size();
        this.rectangles = new Shape[n];
        this.highlights = new Vector[n];
        this.lineNums = new Vector[n];
        this.panel = new Figure();
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setMinorSpacing(this.spacing);
        this.panel.setLayoutManager((LayoutManager)flowLayout);
        ScrollPane scrollPane = new ScrollPane();
        this.panel.setBorder((Border)new LineBorder(ColorConstants.menuBackground, 5));
        this.viewsize = canvas.getClientArea();
        if (this.zoom > 1.0f) {
            this.viewsize.width = (int)((float)this.viewsize.width * this.zoom);
            this.viewsize.height = (int)((float)this.viewsize.height * this.zoom);
        }
        int n2 = this.viewsize.height - 30;
        LightweightSystem lightweightSystem = new LightweightSystem(canvas);
        scrollPane.setView(this.panel);
        lightweightSystem.setContents((IFigure)scrollPane);
        this.addShapes(n2, n, this.viewsize);
        scrollPane.setBounds(this.panel.getBounds());
        scrollPane.add(this.panel);
    }

    public void draw(Vector vector, Vector vector2, Vector vector3, Canvas canvas) {
        this.clearPanel();
        this.lengths = vector3;
        this.names = vector;
        this.tooltips = vector2;
        int n = vector3.size();
        this.rectangles = new Shape[n];
        this.highlights = new Vector[n];
        this.lineNums = new Vector[n];
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setMinorSpacing(this.spacing);
        this.panel.setLayoutManager((LayoutManager)flowLayout);
        this.panel.setBorder((Border)new LineBorder(ColorConstants.menuBackground, 5));
        ScrollPane scrollPane = new ScrollPane();
        this.viewsize = canvas.getClientArea();
        if (this.zoom > 1.0f) {
            this.viewsize.width = (int)((float)this.viewsize.width * this.zoom - 30.0f);
            this.viewsize.height = (int)((float)this.viewsize.height * this.zoom - 30.0f);
        }
        int n2 = this.viewsize.height - 30;
        LightweightSystem lightweightSystem = new LightweightSystem(canvas);
        scrollPane.setView(this.panel);
        lightweightSystem.setContents((IFigure)scrollPane);
        this.addShapes(n2, n, this.viewsize);
        scrollPane.setBounds(this.panel.getBounds());
        scrollPane.add(this.panel);
    }

    private void addShapes(int n, int n2, Rectangle rectangle) {
        Iterator<Object> iterator;
        Point point;
        int n3;
        int n4 = 0;
        boolean bl = false;
        int n5 = 0;
        int n6 = 0;
        Point[] pointArray = new Point[n2];
        this.buttons = new Button[n2];
        for (n3 = 0; n3 < n2; ++n3) {
            if (this.limit_mode) {
                if (this.map[n3].isEmpty()) continue;
                point = this.map[n3].values();
                boolean bl2 = false;
                iterator = point.iterator();
                while (iterator.hasNext()) {
                    if (this.getColor((String)((List)iterator.next()).get(0)) == null) continue;
                    bl2 = true;
                }
                if (!bl2) continue;
                ++n6;
                if ((Integer)this.lengths.elementAt(n3) <= n5) continue;
                n5 = (Integer)this.lengths.elementAt(n3);
                continue;
            }
            if ((Integer)this.lengths.elementAt(n3) <= n5) continue;
            n5 = (Integer)this.lengths.elementAt(n3);
        }
        if (!this.limit_mode) {
            n6 = n2;
        }
        if (n6 * (this.minBarWidth + this.spacing) > rectangle.width - 10) {
            n4 = this.minBarWidth;
            bl = true;
        } else {
            n4 = n6 * (this.maxBarWidth + this.spacing) < rectangle.width - 10 ? this.maxBarWidth : (int)((float)rectangle.width - 10.0f) / n6 - this.spacing;
        }
        if (bl) {
            n -= 20;
        }
        this.scale = (float)n / (float)n5;
        for (n3 = 0; n3 < n2; ++n3) {
            this.rectangles[n3] = new RectangleFigure();
            this.highlights[n3] = new Vector();
            this.lineNums[n3] = new Vector();
            this.rectangles[n3].setSize(n4, (int)((float)((Integer)this.lengths.elementAt(n3)).intValue() * this.scale) + 20);
            this.rectangles[n3].addMouseListener(this.mouseListener);
            this.rectangles[n3].setToolTip((IFigure)new Label((String)this.tooltips.elementAt(n3)));
            this.buttons[n3] = new Button((String)this.names.elementAt(n3));
            this.buttons[n3].setBackgroundColor(ColorConstants.buttonDarker);
            this.buttons[n3].setSize(this.rectangles[n3].getSize().width, 20);
            this.buttons[n3].setStyle(Clickable.STYLE_TOGGLE);
            this.rectangles[n3].add((IFigure)this.buttons[n3]);
            point = this.rectangles[n3].getLocation();
            if (this.map != null) {
                Set set = this.map[n3].entrySet();
                this.rectangles[n3].setBackgroundColor(ColorConstants.buttonDarkest);
                if (!set.isEmpty()) {
                    iterator = set.iterator();
                    while (iterator.hasNext()) {
                        Object object;
                        Map.Entry entry = (Map.Entry)iterator.next();
                        List list = (List)entry.getValue();
                        int n7 = 0;
                        int n8 = -1;
                        for (int i = 0; i < list.size(); ++i) {
                            object = this.getColor((String)list.get(i));
                            if (object == null) continue;
                            if (n8 == -1) {
                                n8 = i;
                            }
                            ++n7;
                        }
                        if (n8 == -1) continue;
                        Color color = this.getColor((String)list.get(n8));
                        if (this.rectangles[n3].getBackgroundColor() != ColorConstants.white) {
                            this.rectangles[n3].setBackgroundColor(ColorConstants.white);
                        }
                        object = (Integer)entry.getKey();
                        RectangleFigure rectangleFigure = new RectangleFigure();
                        rectangleFigure.setLocation(new Point((double)(point.x + 1), (double)((float)((Integer)object).intValue() * this.scale + 20.0f + (float)point.y)));
                        if (rectangleFigure.getLocation().y + this.highlightDepth >= this.rectangles[n3].getLocation().y + this.rectangles[n3].getSize().height) {
                            rectangleFigure.setLocation(new Point(point.x + 1, this.rectangles[n3].getLocation().y + this.rectangles[n3].getSize().height - this.highlightDepth - 1));
                        }
                        if (this.rectangles[n3].findFigureAt(rectangleFigure.getLocation()) != this.rectangles[n3] || this.rectangles[n3].findFigureAt(rectangleFigure.getLocation().x, rectangleFigure.getLocation().y + this.highlightDepth - 1) != this.rectangles[n3]) {
                            rectangleFigure.setSize(n4 - 2, this.highlightDepth * 2 / 3);
                        } else {
                            rectangleFigure.setSize(n4 - 2, this.highlightDepth);
                        }
                        rectangleFigure.setOutline(false);
                        rectangleFigure.setBackgroundColor(color);
                        rectangleFigure.addMouseListener(this.mouseListener);
                        this.rectangles[n3].add((IFigure)rectangleFigure);
                        this.highlights[n3].add(rectangleFigure);
                        this.lineNums[n3].add(object);
                        if (n7 < 1) continue;
                        int n9 = 1;
                        for (int i = n8; i < list.size(); ++i) {
                            Color color2 = this.getColor((String)list.get(i));
                            if (color2 == null) continue;
                            RectangleFigure rectangleFigure2 = new RectangleFigure();
                            rectangleFigure2.setBackgroundColor(color2);
                            rectangleFigure2.setLocation(new Point(rectangleFigure.getLocation().x + rectangleFigure.getSize().width / n7 * (n9 - 1), rectangleFigure.getLocation().y));
                            rectangleFigure2.setSize(rectangleFigure.getSize().width / n7, rectangleFigure.getSize().height);
                            rectangleFigure2.setOutline(false);
                            rectangleFigure.add((IFigure)rectangleFigure2);
                            ++n9;
                        }
                    }
                }
            }
            if (this.limit_mode) {
                if (this.rectangles[n3].getBackgroundColor() != ColorConstants.white) continue;
                this.panel.add((IFigure)this.rectangles[n3]);
                continue;
            }
            this.panel.add((IFigure)this.rectangles[n3]);
        }
    }

    public boolean subSelect(Canvas canvas) {
        if (this.map != null) {
            int n = 0;
            for (int i = 0; i < this.lengths.size(); ++i) {
                if (!this.buttons[i].isSelected()) continue;
                ++n;
            }
            if (n == 0) {
                return false;
            }
            Vector vector = new Vector();
            Vector vector2 = new Vector();
            Vector vector3 = new Vector();
            Map[] mapArray = new Map[n];
            n = 0;
            for (int i = 0; i < this.lengths.size(); ++i) {
                if (!this.buttons[i].isSelected()) continue;
                vector.add(this.lengths.elementAt(i));
                vector2.add(this.names.elementAt(i));
                vector3.add(this.tooltips.elementAt(i));
                mapArray[n] = this.map[i];
                ++n;
            }
            this.draw(vector2, vector3, vector, this.aspects, mapArray, this.colors, canvas);
            return true;
        }
        int n = 0;
        for (int i = 0; i < this.lengths.size(); ++i) {
            if (!this.buttons[i].isSelected()) continue;
            ++n;
        }
        if (n == 0) {
            return false;
        }
        Vector vector = new Vector();
        Vector vector4 = new Vector();
        Vector vector5 = new Vector();
        n = 0;
        for (int i = 0; i < this.lengths.size(); ++i) {
            if (!this.buttons[i].isSelected()) continue;
            vector.add(this.lengths.elementAt(i));
            vector4.add(this.names.elementAt(i));
            vector5.add(this.tooltips.elementAt(i));
            ++n;
        }
        this.draw(vector4, vector5, vector, canvas);
        return true;
    }

    public void Limit(Canvas canvas, boolean bl) {
        this.limit_mode = bl;
        this.draw(this.names, this.tooltips, this.lengths, this.aspects, this.map, this.colors, canvas);
    }

    private void clearPanel() {
        List list = this.panel.getChildren();
        if (list.size() > 0) {
            int n = 0;
            while (n < list.size()) {
                this.panel.remove((IFigure)list.get(n));
            }
        }
    }

    public boolean zoomIn(Canvas canvas) {
        if (this.zoom + 0.5f <= this.max_zoom) {
            float f = this.zoom;
            this.zoom += 0.5f;
            this.maxBarWidth = (int)((float)this.maxBarWidth / f * this.zoom);
            this.minBarWidth = (int)((float)this.minBarWidth / f * this.zoom);
            this.highlightDepth = (int)((float)this.highlightDepth / f * this.zoom);
            this.draw(this.names, this.tooltips, this.lengths, this.aspects, this.map, this.colors, canvas);
        }
        return this.zoom + 0.5f <= this.max_zoom;
    }

    public boolean zoomOut(Canvas canvas) {
        if (this.zoom - 0.5f <= 1.0f) {
            this.zoom = 1.0f;
            this.maxBarWidth = 60;
            this.minBarWidth = 20;
            this.highlightDepth = 3;
        } else {
            float f = this.zoom;
            this.zoom -= 0.5f;
            this.maxBarWidth = (int)((float)this.maxBarWidth / f * this.zoom);
            this.minBarWidth = (int)((float)this.minBarWidth / f * this.zoom);
            this.highlightDepth = (int)((float)this.highlightDepth / f * this.zoom);
        }
        this.draw(this.names, this.tooltips, this.lengths, this.aspects, this.map, this.colors, canvas);
        return this.zoom > 1.0f;
    }

    private Color getColor(String string) {
        if (this.aspects != null && this.colors != null) {
            for (int i = 0; i < this.aspects.size(); ++i) {
                if (!string.equals((String)this.aspects.elementAt(i)) || this.colors.length < i) continue;
                return this.colors[i];
            }
        }
        return null;
    }
}

