/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler;

import java.util.ArrayList;
import java.util.List;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseSourceLocation;
import org.aspectj.bridge.AbortException;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.ISourceLocation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;

public class WeaverMessageHandler
implements IMessageHandler {
    private IMessageHandler sink;
    private CompilationResult currentlyWeaving;
    private Compiler compiler;

    public WeaverMessageHandler(IMessageHandler handler, Compiler compiler) {
        this.sink = handler;
        this.compiler = compiler;
    }

    public void setCurrentResult(CompilationResult result) {
        this.currentlyWeaving = result;
    }

    public boolean handleMessage(IMessage message) throws AbortException {
        CompilationResult problemSource;
        if (!message.isError() && !message.isWarning()) {
            return this.sink.handleMessage(message);
        }
        ISourceLocation sLoc = message.getSourceLocation();
        if (sLoc instanceof EclipseSourceLocation) {
            EclipseSourceLocation esLoc = (EclipseSourceLocation)sLoc;
            if (this.currentlyWeaving != null && esLoc.getCompilationResult() != null && !this.currentlyWeaving.equals(((EclipseSourceLocation)sLoc).getCompilationResult())) {
                return this.sink.handleMessage(message);
            }
        }
        if ((problemSource = this.currentlyWeaving) == null) {
            if (sLoc instanceof EclipseSourceLocation) {
                problemSource = ((EclipseSourceLocation)sLoc).getCompilationResult();
            }
            if (problemSource == null) {
                return this.sink.handleMessage(message);
            }
        }
        int startPos = this.getStartPos(sLoc, problemSource);
        int endPos = this.getEndPos(sLoc, problemSource);
        int severity = message.isError() ? 1 : 0;
        char[] filename = problemSource.fileName;
        boolean usedBinarySourceFileName = false;
        if (problemSource.isFromBinarySource() && sLoc != null) {
            filename = sLoc.getSourceFile().getPath().toCharArray();
            usedBinarySourceFileName = true;
        }
        ReferenceContext referenceContext = this.findReferenceContextFor(problemSource);
        IProblem problem = this.compiler.problemReporter.createProblem(filename, 0, new String[]{}, new String[]{message.getMessage()}, severity, startPos, endPos, sLoc != null ? sLoc.getLine() : 0);
        IProblem[] seeAlso = this.buildSeeAlsoProblems(message.getExtraSourceLocations(), problemSource, usedBinarySourceFileName);
        problem.setSeeAlsoProblems(seeAlso);
        StringBuffer details = new StringBuffer();
        if (message.getDetails() != null) {
            details.append(message.getDetails());
        }
        if (message.getDeclared()) {
            details.append("[deow=true]");
        }
        if (details.length() != 0) {
            problem.setSupplementaryMessageInfo(details.toString());
        }
        this.compiler.problemReporter.record(problem, problemSource, referenceContext);
        return true;
    }

    public boolean isIgnoring(IMessage.Kind kind) {
        return this.sink.isIgnoring(kind);
    }

    private int getStartPos(ISourceLocation sLoc, CompilationResult result) {
        int pos = 0;
        if (sLoc == null) {
            return 0;
        }
        int line = sLoc.getLine();
        if (sLoc instanceof EclipseSourceLocation) {
            pos = ((EclipseSourceLocation)sLoc).getStartPos();
        } else {
            if (line <= 1) {
                return 0;
            }
            if (result != null && result.lineSeparatorPositions != null && result.lineSeparatorPositions.length >= line - 1) {
                pos = result.lineSeparatorPositions[line - 2] + 1;
            }
        }
        return pos;
    }

    private int getEndPos(ISourceLocation sLoc, CompilationResult result) {
        int pos = 0;
        if (sLoc == null) {
            return 0;
        }
        int line = sLoc.getLine();
        if (line <= 0) {
            line = 1;
        }
        if (sLoc instanceof EclipseSourceLocation) {
            pos = ((EclipseSourceLocation)sLoc).getEndPos();
        } else if (result != null && result.lineSeparatorPositions != null && result.lineSeparatorPositions.length >= line) {
            pos = result.lineSeparatorPositions[line - 1] - 1;
        }
        return pos;
    }

    private ReferenceContext findReferenceContextFor(CompilationResult result) {
        CompilationUnitDeclaration context = null;
        if (this.compiler.unitsToProcess == null) {
            return null;
        }
        for (int i = 0; i < this.compiler.unitsToProcess.length; ++i) {
            if (this.compiler.unitsToProcess[i] == null || this.compiler.unitsToProcess[i].compilationResult != result) continue;
            context = this.compiler.unitsToProcess[i];
            break;
        }
        return context;
    }

    private IProblem[] buildSeeAlsoProblems(List sourceLocations, CompilationResult problemSource, boolean usedBinarySourceFileName) {
        ArrayList<DefaultProblem> ret = new ArrayList<DefaultProblem>();
        for (int i = 0; i < sourceLocations.size(); ++i) {
            ISourceLocation loc = (ISourceLocation)sourceLocations.get(i);
            if (loc == null) {
                throw new RuntimeException("Internal Compiler Error: Unexpected null source location passed as 'see also' location.");
            }
            DefaultProblem dp = new DefaultProblem(loc.getSourceFile().getPath().toCharArray(), "see also", 0, new String[0], -1, this.getStartPos(loc, null), this.getEndPos(loc, null), loc.getLine());
            ret.add(dp);
        }
        if (usedBinarySourceFileName) {
            DefaultProblem dp = new DefaultProblem(problemSource.fileName, "see also", 0, new String[0], -1, 0, 0, 0);
            ret.add(dp);
        }
        IProblem[] retValue = ret.toArray(new IProblem[0]);
        return retValue;
    }
}

