/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.aspectj.ajdt.internal.compiler.ast.AspectDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.PointcutDeclaration;
import org.aspectj.ajdt.internal.compiler.lookup.AsmInterTypeRelationshipProvider;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseSourceType;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseTypeMunger;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.WeaveMessage;
import org.aspectj.weaver.AsmRelationshipProvider;
import org.aspectj.weaver.ConcreteTypeMunger;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.WeaverStateInfo;
import org.aspectj.weaver.World;
import org.aspectj.weaver.bcel.LazyClassGen;
import org.aspectj.weaver.patterns.DeclareParents;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class AjLookupEnvironment
extends LookupEnvironment {
    public EclipseFactory factory = null;
    private List pendingTypesToWeave = new ArrayList();
    private Map dangerousInterfaces = new HashMap();
    private List pendingTypesToFinish = new ArrayList();
    boolean inBinaryTypeCreationAndWeaving = false;
    boolean processingTheQueue = false;

    public AjLookupEnvironment(ITypeRequestor typeRequestor, CompilerOptions options, ProblemReporter problemReporter, INameEnvironment nameEnvironment) {
        super(typeRequestor, options, problemReporter, nameEnvironment);
    }

    public void completeTypeBindings() {
        int j;
        SourceTypeBinding[] b;
        int i;
        int j2;
        SourceTypeBinding[] b2;
        int i2;
        this.stepCompleted = 1;
        for (i2 = this.lastCompletedUnitIndex + 1; i2 <= this.lastUnitIndex; ++i2) {
            this.units[i2].scope.checkAndSetImports();
        }
        this.stepCompleted = 2;
        for (i2 = this.lastCompletedUnitIndex + 1; i2 <= this.lastUnitIndex; ++i2) {
            this.units[i2].scope.connectTypeHierarchy();
        }
        this.stepCompleted = 3;
        for (i2 = this.lastCompletedUnitIndex + 1; i2 <= this.lastUnitIndex; ++i2) {
            this.units[i2].scope.buildFieldsAndMethods();
        }
        for (i2 = this.lastCompletedUnitIndex + 1; i2 <= this.lastUnitIndex; ++i2) {
            b2 = this.units[i2].scope.topLevelTypes;
            for (j2 = 0; j2 < b2.length; ++j2) {
                this.factory.addSourceTypeBinding(b2[j2]);
            }
        }
        for (i2 = this.lastCompletedUnitIndex + 1; i2 <= this.lastUnitIndex; ++i2) {
            b2 = this.units[i2].scope.topLevelTypes;
            for (j2 = 0; j2 < b2.length; ++j2) {
                this.buildInterTypeAndPerClause(b2[j2].scope);
                this.addCrosscuttingStructures(b2[j2].scope);
            }
        }
        this.factory.finishTypeMungers();
        Collection typeMungers = this.factory.getTypeMungers();
        Collection declareParents = this.factory.getDeclareParents();
        this.doPendingWeaves();
        for (i = this.lastCompletedUnitIndex + 1; i <= this.lastUnitIndex; ++i) {
            this.weaveInterTypeDeclarations(this.units[i].scope, typeMungers, declareParents);
        }
        for (i = this.lastCompletedUnitIndex + 1; i <= this.lastUnitIndex; ++i) {
            b = this.units[i].scope.topLevelTypes;
            for (j = 0; j < b.length; ++j) {
                this.resolvePointcutDeclarations(b[j].scope);
            }
        }
        for (i = this.lastCompletedUnitIndex + 1; i <= this.lastUnitIndex; ++i) {
            b = this.units[i].scope.topLevelTypes;
            for (j = 0; j < b.length; ++j) {
                this.addAdviceLikeDeclares(b[j].scope);
            }
        }
        for (i = this.lastCompletedUnitIndex + 1; i <= this.lastUnitIndex; ++i) {
            this.units[i] = null;
        }
        this.stepCompleted = 4;
        this.lastCompletedUnitIndex = this.lastUnitIndex;
    }

    private void doPendingWeaves() {
        Iterator i = this.pendingTypesToWeave.iterator();
        while (i.hasNext()) {
            SourceTypeBinding t = (SourceTypeBinding)i.next();
            this.weaveInterTypeDeclarations(t);
        }
        this.pendingTypesToWeave.clear();
    }

    private void addAdviceLikeDeclares(ClassScope s) {
        TypeDeclaration dec = s.referenceContext;
        if (dec instanceof AspectDeclaration) {
            ResolvedTypeX typeX = this.factory.fromEclipse(dec.binding);
            this.factory.getWorld().getCrosscuttingMembersSet().addAdviceLikeDeclares(typeX);
        }
        SourceTypeBinding sourceType = s.referenceContext.binding;
        ReferenceBinding[] memberTypes = sourceType.memberTypes;
        int length = memberTypes.length;
        for (int i = 0; i < length; ++i) {
            this.addAdviceLikeDeclares(((SourceTypeBinding)memberTypes[i]).scope);
        }
    }

    private void addCrosscuttingStructures(ClassScope s) {
        TypeDeclaration dec = s.referenceContext;
        if (dec instanceof AspectDeclaration) {
            ResolvedTypeX typeX = this.factory.fromEclipse(dec.binding);
            this.factory.getWorld().getCrosscuttingMembersSet().addOrReplaceAspect(typeX);
            if (typeX.getSuperclass().isAspect() && !typeX.getSuperclass().isExposedToWeaver()) {
                this.factory.getWorld().getCrosscuttingMembersSet().addOrReplaceAspect(typeX.getSuperclass());
            }
        }
        SourceTypeBinding sourceType = s.referenceContext.binding;
        ReferenceBinding[] memberTypes = sourceType.memberTypes;
        int length = memberTypes.length;
        for (int i = 0; i < length; ++i) {
            this.addCrosscuttingStructures(((SourceTypeBinding)memberTypes[i]).scope);
        }
    }

    private void resolvePointcutDeclarations(ClassScope s) {
        TypeDeclaration dec = s.referenceContext;
        SourceTypeBinding sourceType = s.referenceContext.binding;
        boolean hasPointcuts = false;
        AbstractMethodDeclaration[] methods = dec.methods;
        boolean initializedMethods = false;
        if (methods != null) {
            for (int i = 0; i < methods.length; ++i) {
                if (!(methods[i] instanceof PointcutDeclaration)) continue;
                hasPointcuts = true;
                if (!initializedMethods) {
                    sourceType.methods();
                    initializedMethods = true;
                }
                ((PointcutDeclaration)methods[i]).resolvePointcut(s);
            }
        }
        if (hasPointcuts || dec instanceof AspectDeclaration) {
            ResolvedTypeX.Name name = (ResolvedTypeX.Name)this.factory.fromEclipse(sourceType);
            EclipseSourceType eclipseSourceType = (EclipseSourceType)name.getDelegate();
            eclipseSourceType.checkPointcutDeclarations();
        }
        ReferenceBinding[] memberTypes = sourceType.memberTypes;
        int length = memberTypes.length;
        for (int i = 0; i < length; ++i) {
            this.resolvePointcutDeclarations(((SourceTypeBinding)memberTypes[i]).scope);
        }
    }

    private void buildInterTypeAndPerClause(ClassScope s) {
        ResolvedTypeX parent;
        TypeDeclaration dec = s.referenceContext;
        if (dec instanceof AspectDeclaration) {
            ((AspectDeclaration)dec).buildInterTypeAndPerClause(s);
        }
        SourceTypeBinding sourceType = s.referenceContext.binding;
        if (sourceType.superclass != null && (parent = this.factory.fromEclipse(sourceType.superclass)).isAspect() && !(dec instanceof AspectDeclaration)) {
            this.factory.showMessage(IMessage.ERROR, "class '" + new String(sourceType.sourceName) + "' can not extend aspect '" + parent.getName() + "'", this.factory.fromEclipse(sourceType).getSourceLocation(), null);
        }
        ReferenceBinding[] memberTypes = sourceType.memberTypes;
        int length = memberTypes.length;
        for (int i = 0; i < length; ++i) {
            this.buildInterTypeAndPerClause(((SourceTypeBinding)memberTypes[i]).scope);
        }
    }

    private void weaveInterTypeDeclarations(CompilationUnitScope unit, Collection typeMungers, Collection declareParents) {
        int length = unit.topLevelTypes.length;
        for (int i = 0; i < length; ++i) {
            this.weaveInterTypeDeclarations(unit.topLevelTypes[i], typeMungers, declareParents, false);
        }
    }

    private void weaveInterTypeDeclarations(SourceTypeBinding sourceType) {
        if (!this.factory.areTypeMungersFinished()) {
            if (!this.pendingTypesToWeave.contains(sourceType)) {
                this.pendingTypesToWeave.add(sourceType);
            }
        } else {
            this.weaveInterTypeDeclarations(sourceType, this.factory.getTypeMungers(), this.factory.getDeclareParents(), true);
        }
    }

    private void weaveInterTypeDeclarations(SourceTypeBinding sourceType, Collection typeMungers, Collection declareParents, boolean skipInners) {
        EclipseTypeMunger munger;
        ResolvedTypeX onType = this.factory.fromEclipse(sourceType);
        WeaverStateInfo info = onType.getWeaverState();
        if (info != null && !info.isOldStyle()) {
            List mungers = onType.getWeaverState().getTypeMungers(onType);
            Iterator i = mungers.iterator();
            while (i.hasNext()) {
                ConcreteTypeMunger m = (ConcreteTypeMunger)i.next();
                EclipseTypeMunger munger2 = this.factory.makeEclipseTypeMunger(m);
                if (!munger2.munge(sourceType) || !onType.isInterface() || !munger2.getMunger().needsAccessToTopmostImplementor() || onType.getWorld().getCrosscuttingMembersSet().containsAspect(munger2.getAspectType())) continue;
                this.dangerousInterfaces.put(onType, "implementors of " + onType + " must be woven by " + munger2.getAspectType());
            }
            return;
        }
        Iterator i = this.dangerousInterfaces.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            ResolvedTypeX interfaceType = (ResolvedTypeX)entry.getKey();
            if (!onType.isTopmostImplementor(interfaceType)) continue;
            this.factory.showMessage(IMessage.ERROR, onType + ": " + entry.getValue(), onType.getSourceLocation(), null);
        }
        boolean needOldStyleWarning = info != null && info.isOldStyle();
        onType.clearInterTypeMungers();
        Iterator i2 = declareParents.iterator();
        while (i2.hasNext()) {
            this.doDeclareParents((DeclareParents)i2.next(), sourceType);
        }
        i2 = typeMungers.iterator();
        while (i2.hasNext()) {
            munger = (EclipseTypeMunger)i2.next();
            if (!munger.matches(onType)) continue;
            if (needOldStyleWarning) {
                this.factory.showMessage(IMessage.WARNING, "The class for " + onType + " should be recompiled with ajc-1.1.1 for best results", onType.getSourceLocation(), null);
                needOldStyleWarning = false;
            }
            onType.addInterTypeMunger(munger);
            if (ResolvedTypeMunger.persistSourceLocation) continue;
            AsmInterTypeRelationshipProvider.addRelationship(onType, munger);
        }
        onType.checkInterTypeMungers();
        i2 = onType.getInterTypeMungers().iterator();
        while (i2.hasNext()) {
            munger = (EclipseTypeMunger)i2.next();
            munger.munge(sourceType);
        }
        if (skipInners) {
            return;
        }
        ReferenceBinding[] memberTypes = sourceType.memberTypes;
        int length = memberTypes.length;
        for (int i3 = 0; i3 < length; ++i3) {
            if (!(memberTypes[i3] instanceof SourceTypeBinding)) continue;
            this.weaveInterTypeDeclarations((SourceTypeBinding)memberTypes[i3], typeMungers, declareParents, false);
        }
    }

    private void doDeclareParents(DeclareParents declareParents, SourceTypeBinding sourceType) {
        List newParents = declareParents.findMatchingNewParents(this.factory.fromEclipse(sourceType));
        if (!newParents.isEmpty()) {
            Iterator i = newParents.iterator();
            while (i.hasNext()) {
                ResolvedTypeX parent = (ResolvedTypeX)i.next();
                if (this.dangerousInterfaces.containsKey(parent)) {
                    ResolvedTypeX onType = this.factory.fromEclipse(sourceType);
                    this.factory.showMessage(IMessage.ERROR, onType + ": " + this.dangerousInterfaces.get(parent), onType.getSourceLocation(), null);
                }
                AsmRelationshipProvider.addDeclareParentsRelationship(declareParents.getSourceLocation(), this.factory.fromEclipse(sourceType));
                this.addParent(sourceType, parent);
            }
        }
    }

    private void reportDeclareParentsMessage(WeaveMessage.WeaveMessageKind wmk, SourceTypeBinding sourceType, ResolvedTypeX parent) {
        if (!this.factory.getWorld().getMessageHandler().isIgnoring(IMessage.WEAVEINFO)) {
            String filename = new String(sourceType.getFileName());
            int takefrom = filename.lastIndexOf(47);
            if (takefrom == -1) {
                takefrom = filename.lastIndexOf(92);
            }
            filename = filename.substring(takefrom + 1);
            this.factory.getWorld().getMessageHandler().handleMessage(WeaveMessage.constructWeavingMessage(wmk, new String[]{CharOperation.toString(sourceType.compoundName), filename, parent.getClassName(), this.getShortname(parent.getSourceLocation().getSourceFile().getPath())}));
        }
    }

    private String getShortname(String path) {
        int takefrom = path.lastIndexOf(47);
        if (takefrom == -1) {
            takefrom = path.lastIndexOf(92);
        }
        return path.substring(takefrom + 1);
    }

    private void addParent(SourceTypeBinding sourceType, ResolvedTypeX parent) {
        ReferenceBinding parentBinding = (ReferenceBinding)this.factory.makeTypeBinding(parent);
        if (parentBinding.isClass()) {
            sourceType.superclass = parentBinding;
            this.reportDeclareParentsMessage(WeaveMessage.WEAVEMESSAGE_DECLAREPARENTSEXTENDS, sourceType, parent);
        } else {
            ReferenceBinding[] newI;
            ReferenceBinding[] oldI = sourceType.superInterfaces;
            if (oldI == null) {
                newI = new ReferenceBinding[]{parentBinding};
            } else {
                int n = oldI.length;
                newI = new ReferenceBinding[n + 1];
                System.arraycopy(oldI, 0, newI, 0, n);
                newI[n] = parentBinding;
            }
            sourceType.superInterfaces = newI;
            this.warnOnAddedInterface(this.factory.fromEclipse(sourceType), parent);
            this.reportDeclareParentsMessage(WeaveMessage.WEAVEMESSAGE_DECLAREPARENTSIMPLEMENTS, sourceType, parent);
        }
    }

    public void warnOnAddedInterface(ResolvedTypeX type, ResolvedTypeX parent) {
        World world = this.factory.getWorld();
        ResolvedTypeX serializable = world.getCoreType(TypeX.SERIALIZABLE);
        if (serializable.isAssignableFrom(type) && !serializable.isAssignableFrom(parent) && !LazyClassGen.hasSerialVersionUIDField(type)) {
            world.getLint().needsSerialVersionUIDField.signal(new String[]{type.getName().toString(), "added interface " + parent.getName().toString()}, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BinaryTypeBinding createBinaryTypeFrom(IBinaryType binaryType, PackageBinding packageBinding, boolean needFieldsAndMethods) {
        BinaryTypeBinding binaryTypeBinding;
        block5: {
            if (this.inBinaryTypeCreationAndWeaving) {
                BinaryTypeBinding ret = super.createBinaryTypeFrom(binaryType, packageBinding, needFieldsAndMethods);
                this.pendingTypesToFinish.add(ret);
                return ret;
            }
            this.inBinaryTypeCreationAndWeaving = true;
            try {
                BinaryTypeBinding ret = super.createBinaryTypeFrom(binaryType, packageBinding, needFieldsAndMethods);
                this.weaveInterTypeDeclarations(ret);
                binaryTypeBinding = ret;
                Object var7_7 = null;
                this.inBinaryTypeCreationAndWeaving = false;
                if (this.pendingTypesToFinish.size() <= 0) break block5;
                this.processingTheQueue = true;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var7_8 = null;
                    this.inBinaryTypeCreationAndWeaving = false;
                    if (this.pendingTypesToFinish.size() <= 0) break block6;
                    this.processingTheQueue = true;
                    while (!this.pendingTypesToFinish.isEmpty()) {
                        BinaryTypeBinding nextVictim = (BinaryTypeBinding)this.pendingTypesToFinish.remove(0);
                        this.weaveInterTypeDeclarations(nextVictim);
                    }
                    this.processingTheQueue = false;
                }
                throw throwable;
            }
            while (!this.pendingTypesToFinish.isEmpty()) {
                BinaryTypeBinding nextVictim = (BinaryTypeBinding)this.pendingTypesToFinish.remove(0);
                this.weaveInterTypeDeclarations(nextVictim);
            }
            this.processingTheQueue = false;
        }
        return binaryTypeBinding;
    }
}

