/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.core.builder;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.aspectj.ajdt.internal.core.builder.AjCompilerOptions;
import org.aspectj.util.FileUtil;

public class AjBuildConfig {
    private boolean shouldProceed = true;
    public static final String AJLINT_IGNORE = "ignore";
    public static final String AJLINT_WARN = "warn";
    public static final String AJLINT_ERROR = "error";
    public static final String AJLINT_DEFAULT = "default";
    private File outputDir;
    private File outputJar;
    private List sourceRoots = new ArrayList();
    private List files = new ArrayList();
    private List binaryFiles = new ArrayList();
    private List inJars = new ArrayList();
    private List inPath = new ArrayList();
    private Map sourcePathResources = new HashMap();
    private List aspectpath = new ArrayList();
    private List classpath = new ArrayList();
    private File configFile;
    private String lintMode = "default";
    private File lintSpecFile = null;
    private AjCompilerOptions options = new AjCompilerOptions();
    private boolean override = true;
    private boolean incrementalMode;
    private File incrementalFile;

    public List getFiles() {
        return this.files;
    }

    public List getBinaryFiles() {
        return this.binaryFiles;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public void setFiles(List files) {
        this.files = files;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public AjCompilerOptions getOptions() {
        return this.options;
    }

    public List getClasspath() {
        return this.classpath;
    }

    public void setClasspath(List classpath) {
        this.classpath = classpath;
    }

    public File getOutputJar() {
        return this.outputJar;
    }

    public List getInpath() {
        return this.inPath;
    }

    public List getInJars() {
        return this.inJars;
    }

    public Map getSourcePathResources() {
        return this.sourcePathResources;
    }

    public void setOutputJar(File outputJar) {
        this.outputJar = outputJar;
    }

    public void setInJars(List sourceJars) {
        this.inJars = sourceJars;
    }

    public void setInPath(List dirsOrJars) {
        this.inPath = dirsOrJars;
        this.binaryFiles = new ArrayList();
        FileFilter filter = new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getPath().endsWith(".class");
            }
        };
        Iterator iter = dirsOrJars.iterator();
        while (iter.hasNext()) {
            File inpathElement = (File)iter.next();
            if (!inpathElement.isDirectory()) continue;
            File[] files = FileUtil.listFiles(inpathElement, filter);
            for (int i = 0; i < files.length; ++i) {
                this.binaryFiles.add(new BinarySourceFile(inpathElement, files[i]));
            }
        }
    }

    public List getSourceRoots() {
        return this.sourceRoots;
    }

    public void setSourceRoots(List sourceRootDir) {
        this.sourceRoots = sourceRootDir;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(File configFile) {
        this.configFile = configFile;
    }

    public void setIncrementalMode(boolean incrementalMode) {
        this.incrementalMode = incrementalMode;
    }

    public boolean isIncrementalMode() {
        return this.incrementalMode;
    }

    public void setIncrementalFile(File incrementalFile) {
        this.incrementalFile = incrementalFile;
    }

    public boolean isIncrementalFileMode() {
        return null != this.incrementalFile;
    }

    public List getFullClasspath() {
        ArrayList<String> full = new ArrayList<String>();
        Iterator i = this.inJars.iterator();
        while (i.hasNext()) {
            full.add(((File)i.next()).getAbsolutePath());
        }
        i = this.inPath.iterator();
        while (i.hasNext()) {
            full.add(((File)i.next()).getAbsolutePath());
        }
        i = this.aspectpath.iterator();
        while (i.hasNext()) {
            full.add(((File)i.next()).getAbsolutePath());
        }
        full.addAll(this.getClasspath());
        return full;
    }

    public File getLintSpecFile() {
        return this.lintSpecFile;
    }

    public void setLintSpecFile(File lintSpecFile) {
        this.lintSpecFile = lintSpecFile;
    }

    public List getAspectpath() {
        return this.aspectpath;
    }

    public void setAspectpath(List aspectpath) {
        this.aspectpath = aspectpath;
    }

    public boolean hasSources() {
        return null != this.configFile || 0 < this.sourceRoots.size() || 0 < this.files.size() || 0 < this.inJars.size() || 0 < this.inPath.size();
    }

    public void installGlobals(AjBuildConfig global) {
        this.join(this.aspectpath, global.aspectpath);
        this.join(this.classpath, global.classpath);
        if (null == this.configFile) {
            this.configFile = global.configFile;
        }
        if (!this.isEmacsSymMode() && global.isEmacsSymMode()) {
            this.setEmacsSymMode(true);
        }
        this.join(this.files, global.files);
        if (!this.isGenerateModelMode() && global.isGenerateModelMode()) {
            this.setGenerateModelMode(true);
        }
        if (null == this.incrementalFile) {
            this.incrementalFile = global.incrementalFile;
        }
        if (!this.incrementalMode && global.incrementalMode) {
            this.incrementalMode = true;
        }
        this.join(this.inJars, global.inJars);
        this.join(this.inPath, global.inPath);
        if (null == this.lintMode || AJLINT_DEFAULT.equals(this.lintMode)) {
            this.setLintMode(global.lintMode);
        }
        if (null == this.lintSpecFile) {
            this.lintSpecFile = global.lintSpecFile;
        }
        if (!this.isNoWeave() && global.isNoWeave()) {
            this.setNoWeave(true);
        }
        if (null == this.outputDir && null == this.outputJar) {
            if (null != global.outputDir) {
                this.outputDir = global.outputDir;
            }
            if (null != global.outputJar) {
                this.outputJar = global.outputJar;
            }
        }
        this.join(this.sourceRoots, global.sourceRoots);
        if (!this.isXnoInline() && global.isXnoInline()) {
            this.setXnoInline(true);
        }
        if (!this.isXserializableAspects() && global.isXserializableAspects()) {
            this.setXserializableAspects(true);
        }
        if (!this.isXlazyTjp() && global.isXlazyTjp()) {
            this.setXlazyTjp(true);
        }
        if (!this.isXreweavable() && global.isXreweavable()) {
            this.setXreweavable(true);
        }
        if (!this.getXreweavableCompressClasses() && global.getXreweavableCompressClasses()) {
            this.setXreweavableCompressClasses(true);
        }
    }

    void join(Collection local, Collection global) {
        Iterator iter = global.iterator();
        while (iter.hasNext()) {
            Object next = iter.next();
            if (local.contains(next)) continue;
            local.add(next);
        }
    }

    void join(Map local, Map global) {
        Iterator iter = global.keySet().iterator();
        while (iter.hasNext()) {
            Object value;
            Object key = iter.next();
            if (!this.override && null != local.get(key) || null == (value = global.get(key))) continue;
            local.put(key, value);
        }
    }

    public void setSourcePathResources(Map map) {
        this.sourcePathResources = map;
    }

    public boolean shouldProceed() {
        return this.shouldProceed;
    }

    public void doNotProceed() {
        this.shouldProceed = false;
    }

    public String getLintMode() {
        return this.lintMode;
    }

    public void setLintMode(String lintMode) {
        this.lintMode = lintMode;
        String lintValue = null;
        if (AJLINT_IGNORE.equals(lintMode)) {
            lintValue = AJLINT_IGNORE;
        } else if (AJLINT_WARN.equals(lintMode)) {
            lintValue = "warning";
        } else if (AJLINT_ERROR.equals(lintMode)) {
            lintValue = AJLINT_ERROR;
        }
        if (lintValue != null) {
            HashMap<String, String> lintOptions = new HashMap<String, String>();
            lintOptions.put("org.aspectj.ajdt.core.compiler.lint.InvalidAbsoluteTypeName", lintValue);
            lintOptions.put("org.aspectj.ajdt.core.compiler.lint.WildcardTypeName", lintValue);
            lintOptions.put("org.aspectj.ajdt.core.compiler.lint.UnresolvableMember", lintValue);
            lintOptions.put("org.aspectj.ajdt.core.compiler.lint.TypeNotExposedToWeaver", lintValue);
            lintOptions.put("org.aspectj.ajdt.core.compiler.lint.ShadowNotInStructure", lintValue);
            lintOptions.put("org.aspectj.ajdt.core.compiler.list.UnmatchedSuperTypeInCall", lintValue);
            lintOptions.put("org.aspectj.ajdt.core.compiler.lint.CannotImplementLazyTJP", lintValue);
            lintOptions.put("org.aspectj.ajdt.core.compiler.lint.NeedSerialVersionUIDField", lintValue);
            lintOptions.put("org.aspectj.ajdt.core.compiler.lint.BrokeSerialVersionCompatibility", lintValue);
            this.options.set(lintOptions);
        }
    }

    public boolean isNoWeave() {
        return this.options.noWeave;
    }

    public void setNoWeave(boolean noWeave) {
        this.options.noWeave = noWeave;
    }

    public boolean isXserializableAspects() {
        return this.options.xSerializableAspects;
    }

    public void setXserializableAspects(boolean xserializableAspects) {
        this.options.xSerializableAspects = xserializableAspects;
    }

    public boolean isXnoInline() {
        return this.options.xNoInline;
    }

    public void setXnoInline(boolean xnoInline) {
        this.options.xNoInline = xnoInline;
    }

    public boolean isXlazyTjp() {
        return this.options.xLazyThisJoinPoint;
    }

    public void setXlazyTjp(boolean b) {
        this.options.xLazyThisJoinPoint = b;
    }

    public void setXreweavable(boolean b) {
        this.options.xReweavable = b;
    }

    public boolean isXreweavable() {
        return this.options.xReweavable;
    }

    public void setXreweavableCompressClasses(boolean b) {
        this.options.xReweavableCompress = b;
    }

    public boolean getXreweavableCompressClasses() {
        return this.options.xReweavableCompress;
    }

    public boolean isGenerateJavadocsInModelMode() {
        return this.options.generateJavaDocsInModel;
    }

    public void setGenerateJavadocsInModelMode(boolean generateJavadocsInModelMode) {
        this.options.generateJavaDocsInModel = generateJavadocsInModelMode;
    }

    public boolean isEmacsSymMode() {
        return this.options.generateEmacsSymFiles;
    }

    public void setEmacsSymMode(boolean emacsSymMode) {
        this.options.generateEmacsSymFiles = emacsSymMode;
    }

    public boolean isGenerateModelMode() {
        return this.options.generateModel;
    }

    public void setGenerateModelMode(boolean structureModelMode) {
        this.options.generateModel = structureModelMode;
    }

    public void setShowWeavingInformation(boolean b) {
        this.options.showWeavingInformation = true;
    }

    public boolean getShowWeavingInformation() {
        return this.options.showWeavingInformation;
    }

    public static class BinarySourceFile {
        public File fromInPathDirectory;
        public File binSrc;

        public BinarySourceFile(File dir, File src) {
            this.fromInPathDirectory = dir;
            this.binSrc = src;
        }

        public boolean equals(Object obj) {
            if (obj instanceof BinarySourceFile && obj != null) {
                BinarySourceFile other = (BinarySourceFile)obj;
                return this.binSrc.equals(other.binSrc);
            }
            return false;
        }

        public int hashCode() {
            return this.binSrc != null ? this.binSrc.hashCode() : 0;
        }
    }
}

