/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.core.builder;

import java.util.ArrayList;
import org.aspectj.ajdt.internal.compiler.ast.AdviceDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.DeclareDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.InterTypeConstructorDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.InterTypeDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.InterTypeFieldDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.InterTypeMethodDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.PointcutDeclaration;
import org.aspectj.ajdt.internal.compiler.lookup.AjLookupEnvironment;
import org.aspectj.asm.IProgramElement;
import org.aspectj.weaver.AdviceKind;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.patterns.AndPointcut;
import org.aspectj.weaver.patterns.DeclareErrorOrWarning;
import org.aspectj.weaver.patterns.DeclareParents;
import org.aspectj.weaver.patterns.DeclarePrecedence;
import org.aspectj.weaver.patterns.DeclareSoft;
import org.aspectj.weaver.patterns.OrPointcut;
import org.aspectj.weaver.patterns.ReferencePointcut;
import org.aspectj.weaver.patterns.TypePattern;
import org.aspectj.weaver.patterns.TypePatternList;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;

public class AsmElementFormatter {
    public static final String DECLARE_PRECEDENCE = "precedence";
    public static final String DECLARE_SOFT = "soft";
    public static final String DECLARE_PARENTS = "parents";
    public static final String DECLARE_WARNING = "warning";
    public static final String DECLARE_ERROR = "error";
    public static final String DECLARE_UNKNONWN = "<unknown declare>";
    public static final String POINTCUT_ABSTRACT = "<abstract pointcut>";
    public static final String POINTCUT_ANONYMOUS = "<anonymous pointcut>";
    public static final int MAX_MESSAGE_LENGTH = 18;
    public static final String DEC_LABEL = "declare";

    public void genLabelAndKind(MethodDeclaration methodDeclaration, IProgramElement node) {
        if (methodDeclaration instanceof AdviceDeclaration) {
            AdviceDeclaration ad = (AdviceDeclaration)methodDeclaration;
            node.setKind(IProgramElement.Kind.ADVICE);
            if (ad.kind == AdviceKind.Around) {
                node.setCorrespondingType(ad.returnType.toString());
            }
            String details = "";
            if (ad.pointcutDesignator != null) {
                if (ad.pointcutDesignator.getPointcut() instanceof ReferencePointcut) {
                    ReferencePointcut rp = (ReferencePointcut)ad.pointcutDesignator.getPointcut();
                    details = details + rp.name + "..";
                } else {
                    OrPointcut op;
                    AndPointcut ap;
                    details = ad.pointcutDesignator.getPointcut() instanceof AndPointcut ? ((ap = (AndPointcut)ad.pointcutDesignator.getPointcut()).getLeft() instanceof ReferencePointcut ? details + ap.getLeft().toString() + ".." : details + "<anonymous pointcut>..") : (ad.pointcutDesignator.getPointcut() instanceof OrPointcut ? ((op = (OrPointcut)ad.pointcutDesignator.getPointcut()).getLeft() instanceof ReferencePointcut ? details + op.getLeft().toString() + ".." : details + "<anonymous pointcut>..") : details + POINTCUT_ANONYMOUS);
                }
            } else {
                details = details + POINTCUT_ABSTRACT;
            }
            node.setName(ad.kind.toString());
            node.setDetails(details);
            this.setParameters(methodDeclaration, node);
        } else if (methodDeclaration instanceof PointcutDeclaration) {
            node.setKind(IProgramElement.Kind.POINTCUT);
            node.setName(this.translatePointcutName(new String(methodDeclaration.selector)));
            this.setParameters(methodDeclaration, node);
        } else if (methodDeclaration instanceof DeclareDeclaration) {
            DeclareDeclaration declare = (DeclareDeclaration)methodDeclaration;
            String name = "declare ";
            if (declare.declareDecl instanceof DeclareErrorOrWarning) {
                DeclareErrorOrWarning deow = (DeclareErrorOrWarning)declare.declareDecl;
                if (deow.isError()) {
                    node.setKind(IProgramElement.Kind.DECLARE_ERROR);
                    name = name + DECLARE_ERROR;
                } else {
                    node.setKind(IProgramElement.Kind.DECLARE_WARNING);
                    name = name + DECLARE_WARNING;
                }
                node.setName(name);
                node.setDetails("\"" + this.genDeclareMessage(deow.getMessage()) + "\"");
            } else if (declare.declareDecl instanceof DeclareParents) {
                node.setKind(IProgramElement.Kind.DECLARE_PARENTS);
                DeclareParents dp = (DeclareParents)declare.declareDecl;
                node.setName(name + DECLARE_PARENTS);
                String kindOfDP = null;
                StringBuffer details = new StringBuffer("");
                TypePattern[] newParents = dp.getParents().getTypePatterns();
                for (int i = 0; i < newParents.length; ++i) {
                    String typename;
                    TypePattern tp = newParents[i];
                    TypeX tx = tp.getExactType();
                    if (kindOfDP == null) {
                        kindOfDP = "implements ";
                        try {
                            ResolvedTypeX rtx = tx.resolve(((AjLookupEnvironment)declare.scope.environment()).factory.getWorld());
                            if (!rtx.isInterface()) {
                                kindOfDP = "extends ";
                            }
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    if ((typename = tp.toString()).lastIndexOf(".") != -1) {
                        typename = typename.substring(typename.lastIndexOf(".") + 1);
                    }
                    details.append(typename);
                    if (i + 1 >= newParents.length) continue;
                    details.append(",");
                }
                node.setDetails(kindOfDP + details.toString());
            } else if (declare.declareDecl instanceof DeclareSoft) {
                node.setKind(IProgramElement.Kind.DECLARE_SOFT);
                DeclareSoft ds = (DeclareSoft)declare.declareDecl;
                node.setName(name + DECLARE_SOFT);
                node.setDetails(this.genTypePatternLabel(ds.getException()));
            } else if (declare.declareDecl instanceof DeclarePrecedence) {
                node.setKind(IProgramElement.Kind.DECLARE_PRECEDENCE);
                DeclarePrecedence ds = (DeclarePrecedence)declare.declareDecl;
                node.setName(name + DECLARE_PRECEDENCE);
                node.setDetails(this.genPrecedenceListLabel(ds.getPatterns()));
            } else {
                node.setKind(IProgramElement.Kind.ERROR);
                node.setName(DECLARE_UNKNONWN);
            }
        } else if (methodDeclaration instanceof InterTypeDeclaration) {
            InterTypeDeclaration itd = (InterTypeDeclaration)methodDeclaration;
            String name = itd.onType.toString() + "." + new String(itd.getDeclaredSelector());
            if (methodDeclaration instanceof InterTypeFieldDeclaration) {
                node.setKind(IProgramElement.Kind.INTER_TYPE_FIELD);
                node.setName(name);
            } else if (methodDeclaration instanceof InterTypeMethodDeclaration) {
                node.setKind(IProgramElement.Kind.INTER_TYPE_METHOD);
                node.setName(name);
            } else if (methodDeclaration instanceof InterTypeConstructorDeclaration) {
                node.setKind(IProgramElement.Kind.INTER_TYPE_CONSTRUCTOR);
                node.setName(itd.onType.toString() + "." + itd.onType.toString());
            } else {
                node.setKind(IProgramElement.Kind.ERROR);
                node.setName(name);
            }
            node.setCorrespondingType(itd.returnType.toString());
            if (node.getKind() != IProgramElement.Kind.INTER_TYPE_FIELD) {
                this.setParameters(methodDeclaration, node);
            }
        } else {
            if (methodDeclaration.isConstructor()) {
                node.setKind(IProgramElement.Kind.CONSTRUCTOR);
            } else {
                node.setKind(IProgramElement.Kind.METHOD);
            }
            String label = new String(methodDeclaration.selector);
            node.setName(label);
            this.setParameters(methodDeclaration, node);
        }
    }

    private String genPrecedenceListLabel(TypePatternList list) {
        String tpList = "";
        for (int i = 0; i < list.size(); ++i) {
            tpList = tpList + this.genTypePatternLabel(list.get(i));
            if (i >= list.size() - 1) continue;
            tpList = tpList + ", ";
        }
        return tpList;
    }

    private void setParameters(MethodDeclaration md, IProgramElement pe) {
        Argument[] argArray = md.arguments;
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> types = new ArrayList<String>();
        pe.setParameterNames(names);
        pe.setParameterTypes(types);
        if (argArray == null) {
            return;
        }
        for (int i = 0; i < argArray.length; ++i) {
            String argName = new String(argArray[i].name);
            String argType = argArray[i].type.toString();
            if (!this.acceptArgument(argName, argType)) continue;
            names.add(argName);
            types.add(argType);
        }
    }

    private boolean acceptArgument(String name, String type) {
        return !name.startsWith("ajc$this_") && !type.equals("org.aspectj.lang.JoinPoint.StaticPart") && !type.equals("org.aspectj.lang.JoinPoint") && !type.equals("org.aspectj.runtime.internal.AroundClosure");
    }

    public String genTypePatternLabel(TypePattern tp) {
        String label;
        String TYPE_PATTERN_LITERAL = "<type pattern>";
        TypeX typeX = tp.getExactType();
        if (typeX != ResolvedTypeX.MISSING) {
            label = typeX.getName();
            if (tp.isIncludeSubtypes()) {
                label = label + "+";
            }
        } else {
            label = "<type pattern>";
        }
        return label;
    }

    public String genDeclareMessage(String message) {
        int length = message.length();
        if (length < 18) {
            return message;
        }
        return message.substring(0, 17) + "..";
    }

    private String translatePointcutName(String name) {
        int index = name.indexOf("$$") + 2;
        int endIndex = name.lastIndexOf(36);
        if (index != -1 && endIndex != -1) {
            return name.substring(index, endIndex);
        }
        return name;
    }
}

