/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.bridge.IMessage;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.patterns.Declare;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.Pointcut;
import org.aspectj.weaver.patterns.TypePattern;

public class DeclareSoft
extends Declare {
    private TypePattern exception;
    private Pointcut pointcut;

    public DeclareSoft(TypePattern exception, Pointcut pointcut) {
        this.exception = exception;
        this.pointcut = pointcut;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("declare soft: ");
        buf.append(this.exception);
        buf.append(": ");
        buf.append(this.pointcut);
        buf.append(";");
        return buf.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof DeclareSoft)) {
            return false;
        }
        DeclareSoft o = (DeclareSoft)other;
        return o.pointcut.equals(this.pointcut) && o.exception.equals(this.exception);
    }

    public int hashCode() {
        int result = 19;
        result = 37 * result + this.pointcut.hashCode();
        result = 37 * result + this.exception.hashCode();
        return result;
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeByte(3);
        this.exception.write(s);
        this.pointcut.write(s);
        this.writeLocation(s);
    }

    public static Declare read(DataInputStream s, ISourceContext context) throws IOException {
        DeclareSoft ret = new DeclareSoft(TypePattern.read(s, context), Pointcut.read(s, context));
        ret.readLocation(context, s);
        return ret;
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public TypePattern getException() {
        return this.exception;
    }

    public void resolve(IScope scope) {
        this.exception = this.exception.resolveBindings(scope, null, false, true);
        TypeX excType = this.exception.getExactType();
        if (excType != ResolvedTypeX.MISSING && !scope.getWorld().getCoreType(TypeX.THROWABLE).isAssignableFrom(excType)) {
            scope.getWorld().showMessage(IMessage.ERROR, WeaverMessages.format("notThrowable", excType.getName()), this.exception.getSourceLocation(), null);
            this.pointcut = Pointcut.makeMatchesNothing(Pointcut.RESOLVED);
            return;
        }
        this.pointcut = this.pointcut.resolve(scope);
    }

    public boolean isAdviceLike() {
        return true;
    }
}

