/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.IntMap;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.PatternNode;
import org.aspectj.weaver.patterns.TypePattern;

public class TypePatternList
extends PatternNode {
    private TypePattern[] typePatterns;
    int ellipsisCount = 0;
    public static final TypePatternList EMPTY = new TypePatternList(new TypePattern[0]);
    public static final TypePatternList ANY = new TypePatternList(new TypePattern[]{TypePattern.ELLIPSIS});

    public TypePatternList() {
        this.typePatterns = new TypePattern[0];
        this.ellipsisCount = 0;
    }

    public TypePatternList(TypePattern[] arguments) {
        this.typePatterns = arguments;
        for (int i = 0; i < arguments.length; ++i) {
            if (arguments[i] != TypePattern.ELLIPSIS) continue;
            ++this.ellipsisCount;
        }
    }

    public TypePatternList(List l) {
        this(l.toArray(new TypePattern[l.size()]));
    }

    public int size() {
        return this.typePatterns.length;
    }

    public TypePattern get(int index) {
        return this.typePatterns[index];
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("(");
        int len = this.typePatterns.length;
        for (int i = 0; i < len; ++i) {
            TypePattern type = this.typePatterns[i];
            if (i > 0) {
                buf.append(", ");
            }
            if (type == TypePattern.ELLIPSIS) {
                buf.append("..");
                continue;
            }
            buf.append(type.toString());
        }
        buf.append(")");
        return buf.toString();
    }

    public FuzzyBoolean matches(ResolvedTypeX[] types, TypePattern.MatchKind kind) {
        int nameLength = types.length;
        int patternLength = this.typePatterns.length;
        int nameIndex = 0;
        int patternIndex = 0;
        if (this.ellipsisCount == 0) {
            if (nameLength != patternLength) {
                return FuzzyBoolean.NO;
            }
            FuzzyBoolean finalReturn = FuzzyBoolean.YES;
            while (patternIndex < patternLength) {
                FuzzyBoolean ret;
                if ((ret = this.typePatterns[patternIndex++].matches(types[nameIndex++], kind)) == FuzzyBoolean.NO) {
                    return ret;
                }
                if (ret != FuzzyBoolean.MAYBE) continue;
                finalReturn = ret;
            }
            return finalReturn;
        }
        if (this.ellipsisCount == 1) {
            if (nameLength < patternLength - 1) {
                return FuzzyBoolean.NO;
            }
            FuzzyBoolean finalReturn = FuzzyBoolean.YES;
            while (patternIndex < patternLength) {
                FuzzyBoolean ret;
                TypePattern p;
                if ((p = this.typePatterns[patternIndex++]) == TypePattern.ELLIPSIS) {
                    nameIndex = nameLength - (patternLength - patternIndex);
                    continue;
                }
                if ((ret = p.matches(types[nameIndex++], kind)) == FuzzyBoolean.NO) {
                    return ret;
                }
                if (ret != FuzzyBoolean.MAYBE) continue;
                finalReturn = ret;
            }
            return finalReturn;
        }
        FuzzyBoolean b = TypePatternList.outOfStar(this.typePatterns, types, 0, 0, patternLength - this.ellipsisCount, nameLength, this.ellipsisCount, kind);
        return b;
    }

    public FuzzyBoolean matches(Object[] objs, TypePattern.MatchKind kind) {
        int nameLength = objs.length;
        int patternLength = this.typePatterns.length;
        int nameIndex = 0;
        int patternIndex = 0;
        if (this.ellipsisCount == 0) {
            if (nameLength != patternLength) {
                return FuzzyBoolean.NO;
            }
            FuzzyBoolean finalReturn = FuzzyBoolean.YES;
            while (patternIndex < patternLength) {
                FuzzyBoolean ret;
                if ((ret = this.typePatterns[patternIndex++].matches(objs[nameIndex++], kind)) == FuzzyBoolean.NO) {
                    return ret;
                }
                if (ret != FuzzyBoolean.MAYBE) continue;
                finalReturn = ret;
            }
            return finalReturn;
        }
        if (this.ellipsisCount == 1) {
            if (nameLength < patternLength - 1) {
                return FuzzyBoolean.NO;
            }
            FuzzyBoolean finalReturn = FuzzyBoolean.YES;
            while (patternIndex < patternLength) {
                FuzzyBoolean ret;
                TypePattern p;
                if ((p = this.typePatterns[patternIndex++]) == TypePattern.ELLIPSIS) {
                    nameIndex = nameLength - (patternLength - patternIndex);
                    continue;
                }
                if ((ret = p.matches(objs[nameIndex++], kind)) == FuzzyBoolean.NO) {
                    return ret;
                }
                if (ret != FuzzyBoolean.MAYBE) continue;
                finalReturn = ret;
            }
            return finalReturn;
        }
        FuzzyBoolean b = TypePatternList.outOfStar(this.typePatterns, objs, 0, 0, patternLength - this.ellipsisCount, nameLength, this.ellipsisCount, kind);
        return b;
    }

    public FuzzyBoolean matches(Class[] types, TypePattern.MatchKind kind) {
        int nameLength = types.length;
        int patternLength = this.typePatterns.length;
        int nameIndex = 0;
        int patternIndex = 0;
        if (this.ellipsisCount == 0) {
            if (nameLength != patternLength) {
                return FuzzyBoolean.NO;
            }
            FuzzyBoolean finalReturn = FuzzyBoolean.YES;
            while (patternIndex < patternLength) {
                FuzzyBoolean ret;
                if ((ret = this.typePatterns[patternIndex++].matches(types[nameIndex++], kind)) == FuzzyBoolean.NO) {
                    return ret;
                }
                if (ret != FuzzyBoolean.MAYBE) continue;
                finalReturn = ret;
            }
            return finalReturn;
        }
        if (this.ellipsisCount == 1) {
            if (nameLength < patternLength - 1) {
                return FuzzyBoolean.NO;
            }
            FuzzyBoolean finalReturn = FuzzyBoolean.YES;
            while (patternIndex < patternLength) {
                FuzzyBoolean ret;
                TypePattern p;
                if ((p = this.typePatterns[patternIndex++]) == TypePattern.ELLIPSIS) {
                    nameIndex = nameLength - (patternLength - patternIndex);
                    continue;
                }
                if ((ret = p.matches(types[nameIndex++], kind)) == FuzzyBoolean.NO) {
                    return ret;
                }
                if (ret != FuzzyBoolean.MAYBE) continue;
                finalReturn = ret;
            }
            return finalReturn;
        }
        FuzzyBoolean b = TypePatternList.outOfStar(this.typePatterns, types, 0, 0, patternLength - this.ellipsisCount, nameLength, this.ellipsisCount, kind);
        return b;
    }

    private static FuzzyBoolean outOfStar(TypePattern[] pattern, ResolvedTypeX[] target, int pi, int ti, int pLeft, int tLeft, int starsLeft, TypePattern.MatchKind kind) {
        if (pLeft > tLeft) {
            return FuzzyBoolean.NO;
        }
        FuzzyBoolean finalReturn = FuzzyBoolean.YES;
        while (tLeft != 0) {
            if (pLeft == 0) {
                if (starsLeft > 0) {
                    return finalReturn;
                }
                return FuzzyBoolean.NO;
            }
            if (pattern[pi] == TypePattern.ELLIPSIS) {
                return TypePatternList.inStar(pattern, target, pi + 1, ti, pLeft, tLeft, starsLeft - 1, kind);
            }
            FuzzyBoolean ret = pattern[pi].matches(target[ti], kind);
            if (ret == FuzzyBoolean.NO) {
                return ret;
            }
            if (ret == FuzzyBoolean.MAYBE) {
                finalReturn = ret;
            }
            ++pi;
            ++ti;
            --pLeft;
            --tLeft;
        }
        return finalReturn;
    }

    private static FuzzyBoolean inStar(TypePattern[] pattern, ResolvedTypeX[] target, int pi, int ti, int pLeft, int tLeft, int starsLeft, TypePattern.MatchKind kind) {
        TypePattern patternChar = pattern[pi];
        while (patternChar == TypePattern.ELLIPSIS) {
            --starsLeft;
            patternChar = pattern[++pi];
        }
        while (pLeft <= tLeft) {
            FuzzyBoolean xx;
            FuzzyBoolean ff = patternChar.matches(target[ti], kind);
            if (ff.maybeTrue() && (xx = TypePatternList.outOfStar(pattern, target, pi + 1, ti + 1, pLeft - 1, tLeft - 1, starsLeft, kind)).maybeTrue()) {
                return ff.and(xx);
            }
            ++ti;
            --tLeft;
        }
        return FuzzyBoolean.NO;
    }

    private static FuzzyBoolean outOfStar(TypePattern[] pattern, Class[] target, int pi, int ti, int pLeft, int tLeft, int starsLeft, TypePattern.MatchKind kind) {
        if (pLeft > tLeft) {
            return FuzzyBoolean.NO;
        }
        FuzzyBoolean finalReturn = FuzzyBoolean.YES;
        while (tLeft != 0) {
            if (pLeft == 0) {
                if (starsLeft > 0) {
                    return finalReturn;
                }
                return FuzzyBoolean.NO;
            }
            if (pattern[pi] == TypePattern.ELLIPSIS) {
                return TypePatternList.inStar(pattern, target, pi + 1, ti, pLeft, tLeft, starsLeft - 1, kind);
            }
            FuzzyBoolean ret = pattern[pi].matches(target[ti], kind);
            if (ret == FuzzyBoolean.NO) {
                return ret;
            }
            if (ret == FuzzyBoolean.MAYBE) {
                finalReturn = ret;
            }
            ++pi;
            ++ti;
            --pLeft;
            --tLeft;
        }
        return finalReturn;
    }

    private static FuzzyBoolean inStar(TypePattern[] pattern, Class[] target, int pi, int ti, int pLeft, int tLeft, int starsLeft, TypePattern.MatchKind kind) {
        TypePattern patternChar = pattern[pi];
        while (patternChar == TypePattern.ELLIPSIS) {
            --starsLeft;
            patternChar = pattern[++pi];
        }
        while (pLeft <= tLeft) {
            FuzzyBoolean xx;
            FuzzyBoolean ff = patternChar.matches(target[ti], kind);
            if (ff.maybeTrue() && (xx = TypePatternList.outOfStar(pattern, target, pi + 1, ti + 1, pLeft - 1, tLeft - 1, starsLeft, kind)).maybeTrue()) {
                return ff.and(xx);
            }
            ++ti;
            --tLeft;
        }
        return FuzzyBoolean.NO;
    }

    private static FuzzyBoolean outOfStar(TypePattern[] pattern, Object[] target, int pi, int ti, int pLeft, int tLeft, int starsLeft, TypePattern.MatchKind kind) {
        if (pLeft > tLeft) {
            return FuzzyBoolean.NO;
        }
        FuzzyBoolean finalReturn = FuzzyBoolean.YES;
        while (tLeft != 0) {
            if (pLeft == 0) {
                if (starsLeft > 0) {
                    return finalReturn;
                }
                return FuzzyBoolean.NO;
            }
            if (pattern[pi] == TypePattern.ELLIPSIS) {
                return TypePatternList.inStar(pattern, target, pi + 1, ti, pLeft, tLeft, starsLeft - 1, kind);
            }
            FuzzyBoolean ret = pattern[pi].matches(target[ti], kind);
            if (ret == FuzzyBoolean.NO) {
                return ret;
            }
            if (ret == FuzzyBoolean.MAYBE) {
                finalReturn = ret;
            }
            ++pi;
            ++ti;
            --pLeft;
            --tLeft;
        }
        return finalReturn;
    }

    private static FuzzyBoolean inStar(TypePattern[] pattern, Object[] target, int pi, int ti, int pLeft, int tLeft, int starsLeft, TypePattern.MatchKind kind) {
        TypePattern patternChar = pattern[pi];
        while (patternChar == TypePattern.ELLIPSIS) {
            --starsLeft;
            patternChar = pattern[++pi];
        }
        while (pLeft <= tLeft) {
            FuzzyBoolean xx;
            FuzzyBoolean ff = patternChar.matches(target[ti], kind);
            if (ff.maybeTrue() && (xx = TypePatternList.outOfStar(pattern, target, pi + 1, ti + 1, pLeft - 1, tLeft - 1, starsLeft, kind)).maybeTrue()) {
                return ff.and(xx);
            }
            ++ti;
            --tLeft;
        }
        return FuzzyBoolean.NO;
    }

    public TypePatternList resolveBindings(IScope scope, Bindings bindings, boolean allowBinding, boolean requireExactType) {
        for (int i = 0; i < this.typePatterns.length; ++i) {
            TypePattern p = this.typePatterns[i];
            if (p == null) continue;
            this.typePatterns[i] = this.typePatterns[i].resolveBindings(scope, bindings, allowBinding, requireExactType);
        }
        return this;
    }

    public TypePatternList resolveBindingsFromRTTI(boolean allowBinding, boolean requireExactType) {
        for (int i = 0; i < this.typePatterns.length; ++i) {
            TypePattern p = this.typePatterns[i];
            if (p == null) continue;
            this.typePatterns[i] = this.typePatterns[i].resolveBindingsFromRTTI(allowBinding, requireExactType);
        }
        return this;
    }

    public TypePatternList resolveReferences(IntMap bindings) {
        int len = this.typePatterns.length;
        TypePattern[] ret = new TypePattern[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = this.typePatterns[i].remapAdviceFormals(bindings);
        }
        return new TypePatternList(ret);
    }

    public void postRead(ResolvedTypeX enclosingType) {
        for (int i = 0; i < this.typePatterns.length; ++i) {
            TypePattern p = this.typePatterns[i];
            p.postRead(enclosingType);
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof TypePatternList)) {
            return false;
        }
        TypePatternList o = (TypePatternList)other;
        int len = o.typePatterns.length;
        if (len != this.typePatterns.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.typePatterns[i].equals(o.typePatterns[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 41;
        int len = this.typePatterns.length;
        for (int i = 0; i < len; ++i) {
            result = 37 * result + this.typePatterns[i].hashCode();
        }
        return result;
    }

    public static TypePatternList read(DataInputStream s, ISourceContext context) throws IOException {
        int len = s.readShort();
        TypePattern[] arguments = new TypePattern[len];
        for (int i = 0; i < len; ++i) {
            arguments[i] = TypePattern.read(s, context);
        }
        TypePatternList ret = new TypePatternList(arguments);
        ret.readLocation(context, s);
        return ret;
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeShort(this.typePatterns.length);
        for (int i = 0; i < this.typePatterns.length; ++i) {
            this.typePatterns[i].write(s);
        }
        this.writeLocation(s);
    }

    public TypePattern[] getTypePatterns() {
        return this.typePatterns;
    }

    public Collection getExactTypes() {
        ArrayList<TypeX> ret = new ArrayList<TypeX>();
        for (int i = 0; i < this.typePatterns.length; ++i) {
            TypeX t = this.typePatterns[i].getExactType();
            if (t == ResolvedTypeX.MISSING) continue;
            ret.add(t);
        }
        return ret;
    }
}

