/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import org.eclipse.core.internal.localstore.CoreFileSystemLibrary;
import org.eclipse.core.internal.localstore.ILocalStoreConstants;
import org.eclipse.core.internal.localstore.IUnifiedTreeVisitor;
import org.eclipse.core.internal.localstore.UnifiedTreeNode;
import org.eclipse.core.internal.resources.Container;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.internal.resources.Folder;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;

public class RefreshLocalVisitor
implements IUnifiedTreeVisitor,
ILocalStoreConstants {
    protected IProgressMonitor monitor;
    protected Workspace workspace;
    protected boolean resourceChanged;
    protected MultiStatus errors;
    public static final int TOTAL_WORK = 250;
    private int halfWay = 125;
    private int currentIncrement;
    private int nextProgress = this.currentIncrement = 4;
    private int worked = 0;
    protected static final int RL_UNKNOWN = 0;
    protected static final int RL_IN_SYNC = 1;
    protected static final int RL_NOT_IN_SYNC = 2;

    public RefreshLocalVisitor(IProgressMonitor monitor) {
        this.monitor = monitor;
        this.workspace = (Workspace)ResourcesPlugin.getWorkspace();
        this.resourceChanged = false;
        String msg = Policy.bind("resources.errorMultiRefresh");
        this.errors = new MultiStatus("org.eclipse.core.resources", 271, msg, null);
    }

    protected void contentAdded(UnifiedTreeNode node, Resource target) throws CoreException {
        this.resourceChanged(node, target);
    }

    protected void createResource(UnifiedTreeNode node, Resource target) throws CoreException {
        IContainer parent;
        ResourceInfo info = target.getResourceInfo(false, false);
        int flags = target.getFlags(info);
        if (target.exists(flags, false)) {
            return;
        }
        if (node.getLevel() == 0 && (parent = target.getParent()).getType() == 2) {
            ((Folder)target.getParent()).ensureExists(this.monitor);
        }
        info = this.workspace.createResource(target, false);
        target.getLocalManager().updateLocalSync(info, node.getLastModified());
    }

    protected void deleteResource(UnifiedTreeNode node, Resource target) throws CoreException {
        ResourceInfo info = target.getResourceInfo(false, false);
        int flags = target.getFlags(info);
        if (ResourceInfo.isSet(flags, 65536)) {
            return;
        }
        if (target.exists(flags, false)) {
            target.deleteResource(true, null);
        }
        node.setExistsWorkspace(false);
    }

    protected void fileToFolder(UnifiedTreeNode node, Resource target) throws CoreException {
        ResourceInfo info = target.getResourceInfo(false, false);
        int flags = target.getFlags(info);
        if (target.exists(flags, true)) {
            target = (Folder)((File)target).changeToFolder();
        } else if (!target.exists(flags, false)) {
            target = (Resource)((Object)this.workspace.getRoot().getFolder(target.getFullPath()));
            this.workspace.createResource(target, false);
        }
        node.setResource(target);
        info = target.getResourceInfo(false, true);
        target.getLocalManager().updateLocalSync(info, node.getLastModified());
    }

    protected void folderToFile(UnifiedTreeNode node, Resource target) throws CoreException {
        ResourceInfo info = target.getResourceInfo(false, false);
        int flags = target.getFlags(info);
        if (target.exists(flags, true)) {
            target = (File)((Folder)target).changeToFile();
        } else if (!target.exists(flags, false)) {
            target = (Resource)((Object)this.workspace.getRoot().getFile(target.getFullPath()));
            this.workspace.createResource(target, false);
        }
        node.setResource(target);
        info = target.getResourceInfo(false, true);
        target.getLocalManager().updateLocalSync(info, node.getLastModified());
    }

    public IStatus getErrorStatus() {
        return this.errors;
    }

    protected void refresh(Container parent) throws CoreException {
        parent.getLocalManager().refresh(parent, 0, false, null);
    }

    protected void resourceChanged(UnifiedTreeNode node, Resource target) throws CoreException {
        ResourceInfo info = target.getResourceInfo(false, true);
        if (info == null) {
            return;
        }
        target.getLocalManager().updateLocalSync(info, node.getLastModified());
        info.incrementContentId();
        info.clear(393216);
        this.workspace.updateModificationStamp(info);
    }

    public boolean resourcesChanged() {
        return this.resourceChanged;
    }

    protected int synchronizeExistence(UnifiedTreeNode node, Resource target, int level) throws CoreException {
        boolean existsInWorkspace = node.existsInWorkspace();
        if (!existsInWorkspace) {
            IResource variant;
            if (!CoreFileSystemLibrary.isCaseSensitive() && level == 0 && (variant = target.findExistingResourceVariant(target.getFullPath())) != null) {
                return 0;
            }
            IResource genderVariant = this.workspace.getRoot().findMember(target.getFullPath());
            if (genderVariant != null) {
                return 0;
            }
        }
        if (existsInWorkspace) {
            if (!node.existsInFileSystem()) {
                if (target.isLocal(0)) {
                    this.deleteResource(node, target);
                    this.resourceChanged = true;
                    return 2;
                }
                return 1;
            }
        } else if (node.existsInFileSystem()) {
            if (!CoreFileSystemLibrary.isCaseSensitive()) {
                Container parent = (Container)target.getParent();
                if (!parent.exists()) {
                    this.refresh(parent);
                    if (!parent.exists()) {
                        return 2;
                    }
                }
                if (!target.getName().equals(node.getLocalName())) {
                    return 1;
                }
            }
            this.createResource(node, target);
            this.resourceChanged = true;
            return 2;
        }
        return 0;
    }

    protected boolean synchronizeGender(UnifiedTreeNode node, Resource target) throws CoreException {
        IResource genderVariant;
        if (!node.existsInWorkspace() && (genderVariant = this.workspace.getRoot().findMember(target.getFullPath())) != null) {
            target = (Resource)genderVariant;
        }
        if (target.getType() == 1) {
            if (!node.isFile()) {
                this.fileToFolder(node, target);
                this.resourceChanged = true;
                return false;
            }
        } else if (!node.isFolder()) {
            this.folderToFile(node, target);
            this.resourceChanged = true;
            return false;
        }
        return true;
    }

    protected void synchronizeLastModified(UnifiedTreeNode node, Resource target) throws CoreException {
        if (target.isLocal(0)) {
            this.resourceChanged(node, target);
        } else {
            this.contentAdded(node, target);
        }
        this.resourceChanged = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean visit(UnifiedTreeNode node) throws CoreException {
        block31: {
            block30: {
                block29: {
                    block28: {
                        block26: {
                            block27: {
                                block24: {
                                    block25: {
                                        Policy.checkCanceled(this.monitor);
                                        try {
                                            Resource target = (Resource)node.getResource();
                                            int targetType = target.getType();
                                            if (targetType == 4) {
                                                Object var6_4 = null;
                                                if (--this.nextProgress > 0) return true;
                                                this.monitor.worked(1);
                                                ++this.worked;
                                                if (this.worked < this.halfWay) break block24;
                                                this.currentIncrement *= 2;
                                                break block25;
                                            }
                                            if (node.existsInWorkspace() && node.existsInFileSystem()) {
                                                ResourceInfo info;
                                                if (targetType == 2 && node.isFolder()) {
                                                    if (target.isLocal(0)) break block26;
                                                    ResourceInfo info2 = target.getResourceInfo(false, true);
                                                    if (info2 == null) {
                                                        break block27;
                                                    }
                                                    target.getLocalManager().updateLocalSync(info2, node.getLastModified());
                                                    break block26;
                                                }
                                                if (targetType == 1 && node.isFile() && (info = target.getResourceInfo(false, false)) != null && info.getLocalSyncInfo() == node.getLastModified()) {
                                                    break block28;
                                                }
                                            } else {
                                                if (node.existsInFileSystem() && !Path.EMPTY.isValidSegment(node.getLocalName())) {
                                                    String message = Policy.bind("resources.invalidResourceName", node.getLocalName());
                                                    this.errors.merge(new ResourceStatus(278, message));
                                                    break block29;
                                                }
                                                int state = this.synchronizeExistence(node, target, node.getLevel());
                                                if (state == 1 || state == 2) {
                                                    if (targetType == 1) {
                                                        try {
                                                            ((File)target).updateProjectDescription();
                                                        }
                                                        catch (CoreException e) {
                                                            this.errors.merge(e.getStatus());
                                                        }
                                                    }
                                                    break block30;
                                                }
                                            }
                                            if (this.synchronizeGender(node, target)) {
                                                this.synchronizeLastModified(node, target);
                                            }
                                            if (targetType == 1) {
                                                try {
                                                    ((File)target).updateProjectDescription();
                                                }
                                                catch (CoreException e) {
                                                    this.errors.merge(e.getStatus());
                                                }
                                            }
                                            break block31;
                                        }
                                        catch (Throwable throwable) {
                                            Object var6_11 = null;
                                            if (--this.nextProgress > 0) throw throwable;
                                            this.monitor.worked(1);
                                            ++this.worked;
                                            if (this.worked >= this.halfWay) {
                                                this.currentIncrement *= 2;
                                                this.halfWay += (250 - this.halfWay) / 2;
                                            }
                                            this.nextProgress = this.currentIncrement;
                                            throw throwable;
                                        }
                                    }
                                    this.halfWay += (250 - this.halfWay) / 2;
                                }
                                this.nextProgress = this.currentIncrement;
                                return true;
                            }
                            Object var6_5 = null;
                            if (--this.nextProgress > 0) return true;
                            this.monitor.worked(1);
                            ++this.worked;
                            if (this.worked >= this.halfWay) {
                                this.currentIncrement *= 2;
                                this.halfWay += (250 - this.halfWay) / 2;
                            }
                            this.nextProgress = this.currentIncrement;
                            return true;
                        }
                        Object var6_6 = null;
                        if (--this.nextProgress > 0) return true;
                        this.monitor.worked(1);
                        ++this.worked;
                        if (this.worked >= this.halfWay) {
                            this.currentIncrement *= 2;
                            this.halfWay += (250 - this.halfWay) / 2;
                        }
                        this.nextProgress = this.currentIncrement;
                        return true;
                    }
                    Object var6_7 = null;
                    if (--this.nextProgress > 0) return true;
                    this.monitor.worked(1);
                    ++this.worked;
                    if (this.worked >= this.halfWay) {
                        this.currentIncrement *= 2;
                        this.halfWay += (250 - this.halfWay) / 2;
                    }
                    this.nextProgress = this.currentIncrement;
                    return true;
                }
                Object var6_8 = null;
                if (--this.nextProgress > 0) return false;
                this.monitor.worked(1);
                ++this.worked;
                if (this.worked >= this.halfWay) {
                    this.currentIncrement *= 2;
                    this.halfWay += (250 - this.halfWay) / 2;
                }
                this.nextProgress = this.currentIncrement;
                return false;
            }
            Object var6_9 = null;
            if (--this.nextProgress > 0) return true;
            this.monitor.worked(1);
            ++this.worked;
            if (this.worked >= this.halfWay) {
                this.currentIncrement *= 2;
                this.halfWay += (250 - this.halfWay) / 2;
            }
            this.nextProgress = this.currentIncrement;
            return true;
        }
        Object var6_10 = null;
        if (--this.nextProgress > 0) return true;
        this.monitor.worked(1);
        ++this.worked;
        if (this.worked >= this.halfWay) {
            this.currentIncrement *= 2;
            this.halfWay += (250 - this.halfWay) / 2;
        }
        this.nextProgress = this.currentIncrement;
        return true;
    }
}

