/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.plugins;

import org.eclipse.core.runtime.IPluginPrerequisite;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.Version;
import org.eclipse.osgi.service.resolver.VersionRange;

public class PluginPrerequisite
implements IPluginPrerequisite {
    private BundleSpecification prereq = null;

    public PluginPrerequisite(BundleSpecification b) {
        this.prereq = b;
    }

    public PluginVersionIdentifier getResolvedVersionIdentifier() {
        Version actualVersion = this.prereq.getActualVersion();
        if (actualVersion == null) {
            return null;
        }
        return new PluginVersionIdentifier(actualVersion.toString());
    }

    public String getUniqueIdentifier() {
        return this.prereq.getName();
    }

    public PluginVersionIdentifier getVersionIdentifier() {
        Version specifiedVersion;
        Version version = specifiedVersion = this.prereq.getVersionRange() == null ? null : this.prereq.getVersionRange().getMinimum();
        if (specifiedVersion == null) {
            return null;
        }
        return new PluginVersionIdentifier(specifiedVersion.toString());
    }

    public boolean isExported() {
        return this.prereq.isExported();
    }

    public boolean isMatchedAsGreaterOrEqual() {
        return PluginPrerequisite.isMatchedAsGreaterOrEqual(this.prereq.getVersionRange());
    }

    public boolean isMatchedAsCompatible() {
        return PluginPrerequisite.isMatchedAsCompatible(this.prereq.getVersionRange());
    }

    public boolean isMatchedAsEquivalent() {
        return PluginPrerequisite.isMatchedAsEquivalent(this.prereq.getVersionRange());
    }

    public boolean isMatchedAsPerfect() {
        return PluginPrerequisite.isMatchedAsPerfect(this.prereq.getVersionRange());
    }

    public boolean isMatchedAsExact() {
        return this.isMatchedAsEquivalent();
    }

    public boolean isOptional() {
        return this.prereq.isOptional();
    }

    private static boolean isMatchedAsGreaterOrEqual(VersionRange versionRange) {
        Version maximum;
        if (versionRange == null || versionRange.getMinimum() == null) {
            return false;
        }
        versionRange.getMinimum();
        Version version = maximum = versionRange.getMaximum() == null ? Version.maxVersion : versionRange.getMaximum();
        return maximum.equals(Version.maxVersion);
    }

    private static boolean isMatchedAsPerfect(VersionRange versionRange) {
        Version maximum;
        if (versionRange == null || versionRange.getMinimum() == null) {
            return false;
        }
        Version minimum = versionRange.getMinimum();
        Version version = maximum = versionRange.getMaximum() == null ? Version.maxVersion : versionRange.getMaximum();
        return minimum.equals(maximum);
    }

    private static boolean isMatchedAsEquivalent(VersionRange versionRange) {
        Version maximum;
        if (versionRange == null || versionRange.getMinimum() == null) {
            return false;
        }
        Version minimum = versionRange.getMinimum();
        Version version = maximum = versionRange.getMaximum() == null ? Version.maxVersion : versionRange.getMaximum();
        if (!minimum.isInclusive() || maximum.isInclusive()) {
            return false;
        }
        if (minimum.getMajorComponent() == maximum.getMajorComponent() - 1) {
            return false;
        }
        if (minimum.getMajorComponent() != maximum.getMajorComponent()) {
            return false;
        }
        return minimum.getMinorComponent() == maximum.getMinorComponent() - 1;
    }

    private static boolean isMatchedAsCompatible(VersionRange versionRange) {
        Version maximum;
        if (versionRange == null || versionRange.getMinimum() == null) {
            return false;
        }
        Version minimum = versionRange.getMinimum();
        Version version = maximum = versionRange.getMaximum() == null ? Version.maxVersion : versionRange.getMaximum();
        if (!minimum.isInclusive() || maximum.isInclusive()) {
            return false;
        }
        return minimum.getMajorComponent() == maximum.getMajorComponent() - 1;
    }
}

