/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core;

import java.util.StringTokenizer;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.JavaModelStatus;

public final class JavaConventions {
    private static final char DOT = '.';
    private static final Scanner SCANNER = new Scanner();

    private JavaConventions() {
    }

    public static boolean isOverlappingRoots(IPath rootPath1, IPath rootPath2) {
        if (rootPath1 == null || rootPath2 == null) {
            return false;
        }
        String extension1 = rootPath1.getFileExtension();
        String extension2 = rootPath2.getFileExtension();
        if (extension1 != null && (extension1.equalsIgnoreCase("JAR") || extension1.equalsIgnoreCase("ZIP"))) {
            return false;
        }
        if (extension2 != null && (extension2.equalsIgnoreCase("JAR") || extension2.equalsIgnoreCase("ZIP"))) {
            return false;
        }
        return rootPath1.isPrefixOf(rootPath2) || rootPath2.isPrefixOf(rootPath1);
    }

    private static synchronized char[] scannedIdentifier(String id) {
        if (id == null) {
            return null;
        }
        String trimmed = id.trim();
        if (!trimmed.equals(id)) {
            return null;
        }
        try {
            char[] currentIdentifier;
            SCANNER.setSource(id.toCharArray());
            int token = SCANNER.getNextToken();
            try {
                currentIdentifier = SCANNER.getCurrentIdentifierSource();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
            int nextToken = SCANNER.getNextToken();
            if (token == 24 && nextToken == 75 && JavaConventions.SCANNER.startPosition == JavaConventions.SCANNER.source.length) {
                return currentIdentifier;
            }
            return null;
        }
        catch (InvalidInputException e) {
            return null;
        }
    }

    public static IStatus validateCompilationUnitName(String name) {
        IStatus status;
        if (name == null) {
            return new Status(4, "org.eclipse.ajdt.core.plugin", -1, org.eclipse.jdt.internal.core.util.Util.bind("convention.unit.nullName"), null);
        }
        if (!Util.isJavaFileName(name)) {
            return new Status(4, "org.eclipse.ajdt.core.plugin", -1, org.eclipse.jdt.internal.core.util.Util.bind("convention.unit.notJavaName"), null);
        }
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return new Status(4, "org.eclipse.ajdt.core.plugin", -1, org.eclipse.jdt.internal.core.util.Util.bind("convention.unit.notJavaName"), null);
        }
        String identifier = name.substring(0, index);
        if (!identifier.equals("package-info") && !(status = JavaConventions.validateIdentifier(identifier)).isOK()) {
            return status;
        }
        status = ResourcesPlugin.getWorkspace().validateName(name, 1);
        if (!status.isOK()) {
            return status;
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    public static IStatus validateClassFileName(String name) {
        if (name == null) {
            return new Status(4, "org.eclipse.ajdt.core.plugin", -1, org.eclipse.jdt.internal.core.util.Util.bind("convention.classFile.nullName"), null);
        }
        if (!Util.isClassFileName(name)) {
            return new Status(4, "org.eclipse.ajdt.core.plugin", -1, org.eclipse.jdt.internal.core.util.Util.bind("convention.classFile.notClassFileName"), null);
        }
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return new Status(4, "org.eclipse.ajdt.core.plugin", -1, org.eclipse.jdt.internal.core.util.Util.bind("convention.classFile.notClassFileName"), null);
        }
        String identifier = name.substring(0, index);
        IStatus status = JavaConventions.validateIdentifier(identifier);
        if (!status.isOK()) {
            return status;
        }
        status = ResourcesPlugin.getWorkspace().validateName(name, 1);
        if (!status.isOK()) {
            return status;
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    public static IStatus validateFieldName(String name) {
        return JavaConventions.validateIdentifier(name);
    }

    public static IStatus validateIdentifier(String id) {
        if (JavaConventions.scannedIdentifier(id) != null) {
            return JavaModelStatus.VERIFIED_OK;
        }
        return new Status(4, "org.eclipse.ajdt.core.plugin", -1, org.eclipse.jdt.internal.core.util.Util.bind("convention.illegalIdentifier", id), null);
    }

    public static IStatus validateImportDeclaration(String name) {
        if (name == null || name.length() == 0) {
            return new Status(4, "org.eclipse.ajdt.core.plugin", -1, org.eclipse.jdt.internal.core.util.Util.bind("convention.import.nullImport"), null);
        }
        if (name.charAt(name.length() - 1) == '*') {
            if (name.charAt(name.length() - 2) == '.') {
                return JavaConventions.validatePackageName(name.substring(0, name.length() - 2));
            }
            return new Status(4, "org.eclipse.ajdt.core.plugin", -1, org.eclipse.jdt.internal.core.util.Util.bind("convention.import.unqualifiedImport"), null);
        }
        return JavaConventions.validatePackageName(name);
    }

    public static IStatus validateJavaTypeName(String name) {
        char[] scannedID;
        if (name == null) {
            return new Status(4, "org.eclipse.ajdt.core.plugin", -1, org.eclipse.jdt.internal.core.util.Util.bind("convention.type.nullName"), null);
        }
        String trimmed = name.trim();
        if (!name.equals(trimmed)) {
            return new Status(4, "org.eclipse.ajdt.core.plugin", -1, org.eclipse.jdt.internal.core.util.Util.bind("convention.type.nameWithBlanks"), null);
        }
        int index = name.lastIndexOf(46);
        if (index == -1) {
            scannedID = JavaConventions.scannedIdentifier(name);
        } else {
            String pkg = name.substring(0, index).trim();
            IStatus status = JavaConventions.validatePackageName(pkg);
            if (!status.isOK()) {
                return status;
            }
            String type = name.substring(index + 1).trim();
            scannedID = JavaConventions.scannedIdentifier(type);
        }
        if (scannedID != null) {
            IStatus status = ResourcesPlugin.getWorkspace().validateName(new String(scannedID), 1);
            if (!status.isOK()) {
                return status;
            }
            if (CharOperation.contains('$', scannedID)) {
                return new Status(2, "org.eclipse.ajdt.core.plugin", -1, org.eclipse.jdt.internal.core.util.Util.bind("convention.type.dollarName"), null);
            }
            if (scannedID.length > 0 && Character.isLowerCase(scannedID[0])) {
                return new Status(2, "org.eclipse.ajdt.core.plugin", -1, org.eclipse.jdt.internal.core.util.Util.bind("convention.type.lowercaseName"), null);
            }
            return JavaModelStatus.VERIFIED_OK;
        }
        return new Status(4, "org.eclipse.ajdt.core.plugin", -1, org.eclipse.jdt.internal.core.util.Util.bind("convention.type.invalidName", name), null);
    }

    public static IStatus validateMethodName(String name) {
        return JavaConventions.validateIdentifier(name);
    }

    public static IStatus validatePackageName(String name) {
        if (name == null) {
            return new Status(4, "org.eclipse.ajdt.core.plugin", -1, org.eclipse.jdt.internal.core.util.Util.bind("convention.package.nullName"), null);
        }
        int length = name.length();
        if (length == 0) {
            return new Status(4, "org.eclipse.ajdt.core.plugin", -1, org.eclipse.jdt.internal.core.util.Util.bind("convention.package.emptyName"), null);
        }
        if (name.charAt(0) == '.' || name.charAt(length - 1) == '.') {
            return new Status(4, "org.eclipse.ajdt.core.plugin", -1, org.eclipse.jdt.internal.core.util.Util.bind("convention.package.dotName"), null);
        }
        if (CharOperation.isWhitespace(name.charAt(0)) || CharOperation.isWhitespace(name.charAt(name.length() - 1))) {
            return new Status(4, "org.eclipse.ajdt.core.plugin", -1, org.eclipse.jdt.internal.core.util.Util.bind("convention.package.nameWithBlanks"), null);
        }
        int dot = 0;
        while (dot != -1 && dot < length - 1) {
            if ((dot = name.indexOf(46, dot + 1)) == -1 || dot >= length - 1 || name.charAt(dot + 1) != '.') continue;
            return new Status(4, "org.eclipse.ajdt.core.plugin", -1, org.eclipse.jdt.internal.core.util.Util.bind("convention.package.consecutiveDotsName"), null);
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        StringTokenizer st = new StringTokenizer(name, new String(new char[]{'.'}));
        boolean firstToken = true;
        while (st.hasMoreTokens()) {
            String typeName = st.nextToken();
            char[] scannedID = JavaConventions.scannedIdentifier(typeName = typeName.trim());
            if (scannedID == null) {
                return new Status(4, "org.eclipse.ajdt.core.plugin", -1, org.eclipse.jdt.internal.core.util.Util.bind("convention.illegalIdentifier", typeName), null);
            }
            IStatus status = workspace.validateName(new String(scannedID), 2);
            if (!status.isOK()) {
                return status;
            }
            if (firstToken && scannedID.length > 0 && Character.isUpperCase(scannedID[0])) {
                return new Status(2, "org.eclipse.ajdt.core.plugin", -1, org.eclipse.jdt.internal.core.util.Util.bind("convention.package.uppercaseName"), null);
            }
            firstToken = false;
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    public static IJavaModelStatus validateClasspath(IJavaProject javaProject, IClasspathEntry[] rawClasspath, IPath projectOutputLocation) {
        return ClasspathEntry.validateClasspath(javaProject, rawClasspath, projectOutputLocation);
    }

    public static IJavaModelStatus validateClasspathEntry(IJavaProject project, IClasspathEntry entry, boolean checkSourceAttachment) {
        return ClasspathEntry.validateClasspathEntry(project, entry, checkSourceAttachment, true);
    }
}

