/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.NodeSearcher;
import org.eclipse.jdt.internal.codeassist.ISearchRequestor;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.parser.SourceTypeConverter;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.core.BasicCompilationUnit;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.core.util.CommentRecorderParser;

class CompilationUnitResolver
extends Compiler {
    public CompilationUnitResolver(INameEnvironment environment, IErrorHandlingPolicy policy, Map settings, ICompilerRequestor requestor, IProblemFactory problemFactory) {
        super(environment, policy, settings, requestor, problemFactory, false);
    }

    public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding) {
        CompilationResult result = new CompilationResult(sourceTypes[0].getFileName(), 1, 1, this.options.maxProblemsPerUnit);
        CompilationUnitDeclaration unit = SourceTypeConverter.buildCompilationUnit(sourceTypes, 31, this.lookupEnvironment.problemReporter, result);
        if (unit != null) {
            this.lookupEnvironment.buildTypeBindings(unit);
            this.lookupEnvironment.completeTypeBindings(unit, true);
        }
    }

    protected static IErrorHandlingPolicy getHandlingPolicy() {
        return new IErrorHandlingPolicy(){

            public boolean stopOnFirstError() {
                return false;
            }

            public boolean proceedOnErrors() {
                return false;
            }
        };
    }

    protected static ICompilerRequestor getRequestor() {
        return new ICompilerRequestor(){

            public void acceptResult(CompilationResult compilationResult) {
            }
        };
    }

    public void initializeParser() {
        this.parser = new CommentRecorderParser(this.problemReporter, false);
    }

    protected void handleInternalException(Throwable internalException, CompilationUnitDeclaration unit, CompilationResult result) {
        super.handleInternalException(internalException, unit, result);
        if (unit != null) {
            this.removeUnresolvedBindings(unit);
        }
    }

    protected void handleInternalException(AbortCompilation abortException, CompilationUnitDeclaration unit) {
        super.handleInternalException(abortException, unit);
        if (unit != null) {
            this.removeUnresolvedBindings(unit);
        }
    }

    public static CompilationUnitDeclaration parse(char[] source, NodeSearcher nodeSearcher, Map settings) {
        CompilationUnitDeclaration compilationUnitDeclaration;
        block10: {
            CommentRecorderParser parser;
            block8: {
                TypeDeclaration enclosingTypeDeclaration;
                ASTNode node;
                block9: {
                    if (source == null) {
                        throw new IllegalArgumentException();
                    }
                    CompilerOptions compilerOptions = new CompilerOptions(settings);
                    parser = new CommentRecorderParser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), compilerOptions, new DefaultProblemFactory()), false);
                    CompilationUnit sourceUnit = new CompilationUnit(source, "", compilerOptions.defaultEncoding);
                    compilationUnitDeclaration = parser.dietParse(sourceUnit, new CompilationResult(sourceUnit, 0, 0, compilerOptions.maxProblemsPerUnit));
                    if (compilationUnitDeclaration.ignoreMethodBodies) {
                        compilationUnitDeclaration.ignoreFurtherInvestigation = true;
                        return null;
                    }
                    if (nodeSearcher == null) break block8;
                    int searchPosition = nodeSearcher.position;
                    if (searchPosition < 0 || searchPosition > source.length) {
                        return compilationUnitDeclaration;
                    }
                    compilationUnitDeclaration.traverse((ASTVisitor)nodeSearcher, compilationUnitDeclaration.scope);
                    node = nodeSearcher.found;
                    if (node == null) {
                        return compilationUnitDeclaration;
                    }
                    enclosingTypeDeclaration = nodeSearcher.enclosingType;
                    if (!(node instanceof AbstractMethodDeclaration)) break block9;
                    ((AbstractMethodDeclaration)node).parseStatements(parser, compilationUnitDeclaration);
                    break block10;
                }
                if (enclosingTypeDeclaration == null) break block10;
                if (node instanceof Initializer) {
                    ((Initializer)node).parseStatements(parser, enclosingTypeDeclaration, compilationUnitDeclaration);
                } else {
                    ((TypeDeclaration)node).parseMethod(parser, compilationUnitDeclaration);
                }
                break block10;
            }
            parser.scanner.setSource(source);
            TypeDeclaration[] types = compilationUnitDeclaration.types;
            if (types != null) {
                int i = types.length;
                while (--i >= 0) {
                    types[i].parseMethod(parser, compilationUnitDeclaration);
                }
            }
        }
        return compilationUnitDeclaration;
    }

    public static CompilationUnitDeclaration resolve(char[] source, char[][] packageName, String unitName, IJavaProject javaProject, NodeSearcher nodeSearcher, Map options, boolean cleanUp, WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaModelException {
        CompilationUnitDeclaration unit = null;
        CancelableNameEnvironment environment = null;
        CancelableProblemFactory problemFactory = null;
        try {
            environment = new CancelableNameEnvironment((JavaProject)javaProject, owner, monitor);
            problemFactory = new CancelableProblemFactory(monitor);
            CompilationUnitResolver resolver = new CompilationUnitResolver(environment, CompilationUnitResolver.getHandlingPolicy(), options, CompilationUnitResolver.getRequestor(), problemFactory);
            CompilationUnitDeclaration compilationUnitDeclaration = unit = resolver.resolve(null, new BasicCompilationUnit(source, packageName, unitName, javaProject), nodeSearcher, true, true, true);
            Object var13_14 = null;
            if (environment != null) {
                environment.monitor = null;
            }
            if (problemFactory != null) {
                problemFactory.monitor = null;
            }
            if (cleanUp && unit != null) {
                unit.cleanUp();
            }
            return compilationUnitDeclaration;
        }
        catch (Throwable throwable) {
            block7: {
                Object var13_15 = null;
                if (environment != null) {
                    environment.monitor = null;
                }
                if (problemFactory != null) {
                    problemFactory.monitor = null;
                }
                if (!cleanUp || unit == null) break block7;
                unit.cleanUp();
            }
            throw throwable;
        }
    }

    public void removeUnresolvedBindings(CompilationUnitDeclaration compilationUnitDeclaration) {
        TypeDeclaration[] types = compilationUnitDeclaration.types;
        if (types != null) {
            int i = 0;
            int max = types.length;
            while (i < max) {
                this.removeUnresolvedBindings(types[i]);
                ++i;
            }
        }
    }

    private void removeUnresolvedBindings(TypeDeclaration type) {
        AbstractMethodDeclaration[] methods;
        FieldDeclaration[] fields;
        TypeDeclaration[] memberTypes = type.memberTypes;
        if (memberTypes != null) {
            int i = 0;
            int max = memberTypes.length;
            while (i < max) {
                this.removeUnresolvedBindings(memberTypes[i]);
                ++i;
            }
        }
        if (type.binding != null && (type.binding.modifiers & 0x2000000) != 0) {
            type.binding = null;
        }
        if ((fields = type.fields) != null) {
            int i = 0;
            int max = fields.length;
            while (i < max) {
                if (fields[i].binding != null && (fields[i].binding.modifiers & 0x2000000) != 0) {
                    fields[i].binding = null;
                }
                ++i;
            }
        }
        if ((methods = type.methods) != null) {
            int i = 0;
            int max = methods.length;
            while (i < max) {
                if (methods[i].binding != null && (methods[i].binding.modifiers & 0x2000000) != 0) {
                    methods[i].binding = null;
                }
                ++i;
            }
        }
    }

    private CompilationUnitDeclaration resolve(CompilationUnitDeclaration unit, ICompilationUnit sourceUnit, NodeSearcher nodeSearcher, boolean verifyMethods, boolean analyzeCode, boolean generateCode) {
        try {
            if (unit == null) {
                this.parseThreshold = 0;
                this.beginToCompile(new ICompilationUnit[]{sourceUnit});
                unit = this.unitsToProcess[0];
            } else {
                this.lookupEnvironment.buildTypeBindings(unit);
                this.lookupEnvironment.completeTypeBindings();
            }
            if (nodeSearcher == null) {
                this.parser.getMethodBodies(unit);
            } else {
                int searchPosition = nodeSearcher.position;
                if (searchPosition >= 0 && searchPosition <= sourceUnit.getContents().length) {
                    unit.traverse((ASTVisitor)nodeSearcher, unit.scope);
                    ASTNode node = nodeSearcher.found;
                    if (node != null) {
                        TypeDeclaration enclosingTypeDeclaration = nodeSearcher.enclosingType;
                        if (node instanceof AbstractMethodDeclaration) {
                            ((AbstractMethodDeclaration)node).parseStatements(this.parser, unit);
                        } else if (enclosingTypeDeclaration != null) {
                            if (node instanceof Initializer) {
                                ((Initializer)node).parseStatements(this.parser, enclosingTypeDeclaration, unit);
                            } else if (node instanceof TypeDeclaration) {
                                ((TypeDeclaration)node).parseMethod(this.parser, unit);
                            }
                        }
                    }
                }
            }
            if (unit.scope != null) {
                unit.scope.faultInTypes();
                if (unit.scope != null && verifyMethods) {
                    unit.scope.verifyMethods(this.lookupEnvironment.methodVerifier());
                }
                unit.resolve();
                if (analyzeCode) {
                    unit.analyseCode();
                }
                if (generateCode) {
                    unit.generateCode();
                }
            }
            if (this.unitsToProcess != null) {
                this.unitsToProcess[0] = null;
            }
            this.requestor.acceptResult(unit.compilationResult.tagAsAccepted());
            return unit;
        }
        catch (AbortCompilation e) {
            this.handleInternalException(e, unit);
            return unit == null ? this.unitsToProcess[0] : unit;
        }
        catch (Error e) {
            this.handleInternalException(e, unit, null);
            throw e;
        }
        catch (RuntimeException e) {
            this.handleInternalException(e, unit, null);
            throw e;
        }
    }

    public CompilationUnitDeclaration resolve(ICompilationUnit sourceUnit, boolean verifyMethods, boolean analyzeCode, boolean generateCode) {
        return this.resolve(null, sourceUnit, null, verifyMethods, analyzeCode, generateCode);
    }

    public CompilationUnitDeclaration resolve(CompilationUnitDeclaration unit, ICompilationUnit sourceUnit, boolean verifyMethods, boolean analyzeCode, boolean generateCode) {
        return this.resolve(unit, sourceUnit, null, verifyMethods, analyzeCode, generateCode);
    }

    static class CancelableNameEnvironment
    extends SearchableEnvironment {
        IProgressMonitor monitor;

        CancelableNameEnvironment(JavaProject project, WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaModelException {
            super(project, owner);
            this.monitor = monitor;
        }

        private void checkCanceled() {
            if (this.monitor != null && this.monitor.isCanceled()) {
                throw new AbortCompilation(true, new OperationCanceledException());
            }
        }

        public void findPackages(char[] prefix, ISearchRequestor requestor) {
            this.checkCanceled();
            super.findPackages(prefix, requestor);
        }

        public NameEnvironmentAnswer findType(char[] name, char[][] packageName) {
            this.checkCanceled();
            return super.findType(name, packageName);
        }

        public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
            this.checkCanceled();
            return super.findType(compoundTypeName);
        }

        public void findTypes(char[] prefix, ISearchRequestor storage) {
            this.checkCanceled();
            super.findTypes(prefix, storage);
        }
    }

    static class CancelableProblemFactory
    extends DefaultProblemFactory {
        IProgressMonitor monitor;

        CancelableProblemFactory(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public IProblem createProblem(char[] originatingFileName, int problemId, String[] problemArguments, String[] messageArguments, int severity, int startPosition, int endPosition, int lineNumber) {
            if (this.monitor != null && this.monitor.isCanceled()) {
                throw new AbortCompilation(true, new OperationCanceledException());
            }
            return super.createProblem(originatingFileName, problemId, problemArguments, messageArguments, severity, startPosition, endPosition, lineNumber);
        }
    }
}

