/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticAccessMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

public class MethodBinding
extends Binding
implements BaseTypes,
TypeConstants {
    public int modifiers;
    public char[] selector;
    public TypeBinding returnType;
    public TypeBinding[] parameters;
    public ReferenceBinding[] thrownExceptions;
    public ReferenceBinding declaringClass;
    char[] signature;

    protected MethodBinding() {
    }

    public MethodBinding(int modifiers, char[] selector, TypeBinding returnType, TypeBinding[] args, ReferenceBinding[] exceptions, ReferenceBinding declaringClass) {
        this.modifiers = modifiers;
        this.selector = selector;
        this.returnType = returnType;
        this.parameters = args == null || args.length == 0 ? TypeConstants.NoParameters : args;
        this.thrownExceptions = exceptions == null || exceptions.length == 0 ? TypeConstants.NoExceptions : exceptions;
        this.declaringClass = declaringClass;
        if (this.declaringClass != null) {
            if (this.declaringClass.isStrictfp() && !this.isNative() && !this.isAbstract()) {
                this.modifiers |= 0x800;
            }
            if (this.declaringClass.isViewedAsDeprecated() && !this.isDeprecated()) {
                this.modifiers |= 0x200000;
            }
        }
    }

    public MethodBinding(int modifiers, TypeBinding[] args, ReferenceBinding[] exceptions, ReferenceBinding declaringClass) {
        this(modifiers, ConstructorDeclaration.ConstantPoolName, BaseTypes.VoidBinding, args, exceptions, declaringClass);
    }

    public MethodBinding(MethodBinding initialMethodBinding, ReferenceBinding declaringClass) {
        this.modifiers = initialMethodBinding.modifiers;
        this.selector = initialMethodBinding.selector;
        this.returnType = initialMethodBinding.returnType;
        this.parameters = initialMethodBinding.parameters;
        this.thrownExceptions = initialMethodBinding.thrownExceptions;
        this.declaringClass = declaringClass;
    }

    public final boolean areParametersEqual(MethodBinding method) {
        TypeBinding[] args = method.parameters;
        if (this.parameters == args) {
            return true;
        }
        int length = this.parameters.length;
        if (length != args.length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (this.parameters[i] != args[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final int bindingType() {
        return 8;
    }

    public boolean canBeSeenBy(InvocationSite invocationSite, Scope scope) {
        if (this.isPublic()) {
            return true;
        }
        SourceTypeBinding invocationType = scope.invocationType();
        if (invocationType == this.declaringClass) {
            return true;
        }
        if (this.isProtected()) {
            if (invocationType.fPackage == this.declaringClass.fPackage) {
                return true;
            }
            return invocationSite.isSuperAccess();
        }
        if (this.isPrivate()) {
            ReferenceBinding outerInvocationType = invocationType;
            ReferenceBinding temp = outerInvocationType.enclosingType();
            while (temp != null) {
                outerInvocationType = temp;
                temp = temp.enclosingType();
            }
            ReferenceBinding outerDeclaringClass = this.declaringClass;
            temp = outerDeclaringClass.enclosingType();
            while (temp != null) {
                outerDeclaringClass = temp;
                temp = temp.enclosingType();
            }
            return outerInvocationType == outerDeclaringClass;
        }
        return invocationType.fPackage == this.declaringClass.fPackage;
    }

    public MethodBinding getVisibleBinding(TypeBinding receiverType, InvocationSite invocationSite, Scope scope) {
        if (this.canBeSeenBy(receiverType, invocationSite, scope)) {
            return this;
        }
        return this.findPrivilegedBinding(scope.invocationType(), (ASTNode)((Object)invocationSite));
    }

    public MethodBinding getVisibleBinding(InvocationSite invocationSite, Scope scope) {
        if (this.canBeSeenBy(invocationSite, scope)) {
            return this;
        }
        return this.findPrivilegedBinding(scope.invocationType(), (ASTNode)((Object)invocationSite));
    }

    public MethodBinding findPrivilegedBinding(SourceTypeBinding invocationType, ASTNode location) {
        if (Scope.findPrivilegedHandler(invocationType) != null) {
            return Scope.findPrivilegedHandler(invocationType).getPrivilegedAccessMethod(this, location);
        }
        return null;
    }

    public boolean canBeSeenBy(TypeBinding receiverType, InvocationSite invocationSite, Scope scope) {
        if (this.isPublic()) {
            return true;
        }
        SourceTypeBinding invocationType = scope.invocationType();
        if (invocationType == this.declaringClass && invocationType == receiverType) {
            return true;
        }
        if (this.isProtected()) {
            if (invocationType == this.declaringClass) {
                return true;
            }
            if (invocationType.fPackage == this.declaringClass.fPackage) {
                return true;
            }
            ReferenceBinding currentType = scope.enclosingSourceType();
            int depth = 0;
            do {
                if (this.declaringClass.isSuperclassOf(currentType)) {
                    if (invocationSite.isSuperAccess()) {
                        return true;
                    }
                    if (receiverType instanceof ArrayBinding) {
                        return false;
                    }
                    if (this.isStatic()) {
                        if (depth > 0) {
                            invocationSite.setDepth(depth);
                        }
                        return true;
                    }
                    if (currentType == receiverType || currentType.isSuperclassOf((ReferenceBinding)receiverType)) {
                        if (depth > 0) {
                            invocationSite.setDepth(depth);
                        }
                        return true;
                    }
                }
                ++depth;
            } while ((currentType = currentType.enclosingType()) != null);
            return false;
        }
        if (this.isPrivate()) {
            if (receiverType != this.declaringClass) {
                return false;
            }
            if (invocationType != this.declaringClass) {
                ReferenceBinding outerInvocationType = invocationType;
                ReferenceBinding temp = outerInvocationType.enclosingType();
                while (temp != null) {
                    outerInvocationType = temp;
                    temp = temp.enclosingType();
                }
                ReferenceBinding outerDeclaringClass = this.declaringClass;
                temp = outerDeclaringClass.enclosingType();
                while (temp != null) {
                    outerDeclaringClass = temp;
                    temp = temp.enclosingType();
                }
                if (outerInvocationType != outerDeclaringClass) {
                    return false;
                }
            }
            return true;
        }
        if (invocationType.fPackage != this.declaringClass.fPackage) {
            return false;
        }
        if (receiverType instanceof ArrayBinding) {
            return false;
        }
        ReferenceBinding type = (ReferenceBinding)receiverType;
        PackageBinding declaringPackage = this.declaringClass.fPackage;
        do {
            if (this.declaringClass == type) {
                return true;
            }
            if (declaringPackage == type.fPackage) continue;
            return false;
        } while ((type = type.superclass()) != null);
        return false;
    }

    public TypeBinding constantPoolDeclaringClass() {
        return this.declaringClass;
    }

    public final char[] constantPoolName() {
        return this.selector;
    }

    public final int getAccessFlags() {
        return this.modifiers & 0xFFFF;
    }

    public final boolean isAbstract() {
        return (this.modifiers & 0x400) != 0;
    }

    public final boolean isBridge() {
        return (this.modifiers & 0x40) != 0;
    }

    public final boolean isConstructor() {
        return this.selector == ConstructorDeclaration.ConstantPoolName;
    }

    protected boolean isConstructorRelated() {
        return this.isConstructor();
    }

    public final boolean isDefault() {
        return !this.isPublic() && !this.isProtected() && !this.isPrivate();
    }

    public final boolean isDefaultAbstract() {
        return (this.modifiers & 0x80000) != 0;
    }

    public final boolean isDeprecated() {
        return (this.modifiers & 0x100000) != 0;
    }

    public final boolean isFinal() {
        return (this.modifiers & 0x10) != 0;
    }

    public final boolean isImplementing() {
        return (this.modifiers & 0x20000000) != 0;
    }

    public final boolean isNative() {
        return (this.modifiers & 0x100) != 0;
    }

    public final boolean isOverriding() {
        return (this.modifiers & 0x10000000) != 0;
    }

    public final boolean isMain() {
        TypeBinding paramType;
        return this.selector.length == 4 && CharOperation.equals(this.selector, TypeConstants.MAIN) && (this.modifiers & 9) != 0 && BaseTypes.VoidBinding == this.returnType && this.parameters.length == 1 && (paramType = this.parameters[0]).dimensions() == 1 && paramType.leafComponentType().id == 11;
    }

    public final boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    public final boolean isPrivateUsed() {
        return (this.modifiers & 0x8000000) != 0;
    }

    public final boolean isProtected() {
        return (this.modifiers & 4) != 0;
    }

    public final boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public final boolean isRequiredToClearPrivateModifier() {
        return (this.modifiers & 0x4000000) != 0;
    }

    public final boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public final boolean isStrictfp() {
        return (this.modifiers & 0x800) != 0;
    }

    public final boolean isSynchronized() {
        return (this.modifiers & 0x20) != 0;
    }

    public final boolean isSynthetic() {
        return (this.modifiers & 0x1000) != 0;
    }

    public final boolean isVararg() {
        return (this.modifiers & 0x80) != 0;
    }

    public final boolean isViewedAsDeprecated() {
        return (this.modifiers & 0x100000) != 0 || (this.modifiers & 0x200000) != 0;
    }

    public char[] readableName() {
        StringBuffer buffer = new StringBuffer(this.parameters.length + 20);
        if (this.isConstructor()) {
            buffer.append(this.declaringClass.sourceName());
        } else {
            buffer.append(this.selector);
        }
        buffer.append('(');
        if (this.parameters != TypeConstants.NoParameters) {
            int i = 0;
            int length = this.parameters.length;
            while (i < length) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(this.parameters[i].sourceName());
                ++i;
            }
        }
        buffer.append(')');
        return buffer.toString().toCharArray();
    }

    public char[] shortReadableName() {
        StringBuffer buffer = new StringBuffer(this.parameters.length + 20);
        if (this.isConstructor()) {
            buffer.append(this.declaringClass.shortReadableName());
        } else {
            buffer.append(this.selector);
        }
        buffer.append('(');
        if (this.parameters != TypeConstants.NoParameters) {
            int i = 0;
            int length = this.parameters.length;
            while (i < length) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(this.parameters[i].shortReadableName());
                ++i;
            }
        }
        buffer.append(')');
        return buffer.toString().toCharArray();
    }

    protected final void setSelector(char[] selector) {
        this.selector = selector;
        this.signature = null;
    }

    public final char[] signature() {
        int i;
        int count;
        boolean considerSynthetics;
        if (this.signature != null) {
            return this.signature;
        }
        StringBuffer buffer = new StringBuffer(this.parameters.length + 20);
        buffer.append('(');
        TypeBinding[] targetParameters = this.parameters;
        boolean bl = considerSynthetics = this.isConstructorRelated() && this.declaringClass.isNestedType();
        if (considerSynthetics) {
            ReferenceBinding[] syntheticArgumentTypes = this.declaringClass.syntheticEnclosingInstanceTypes();
            count = syntheticArgumentTypes == null ? 0 : syntheticArgumentTypes.length;
            i = 0;
            while (i < count) {
                buffer.append(syntheticArgumentTypes[i].signature());
                ++i;
            }
            if (this instanceof SyntheticAccessMethodBinding) {
                targetParameters = ((SyntheticAccessMethodBinding)this).targetMethod.parameters;
            }
        }
        if (targetParameters != TypeConstants.NoParameters) {
            int i2 = 0;
            while (i2 < targetParameters.length) {
                buffer.append(targetParameters[i2].signature());
                ++i2;
            }
        }
        if (considerSynthetics) {
            SyntheticArgumentBinding[] syntheticOuterArguments = this.declaringClass.syntheticOuterLocalVariables();
            count = syntheticOuterArguments == null ? 0 : syntheticOuterArguments.length;
            i = 0;
            while (i < count) {
                buffer.append(syntheticOuterArguments[i].type.signature());
                ++i;
            }
            i = targetParameters.length;
            int extraLength = this.parameters.length;
            while (i < extraLength) {
                buffer.append(this.parameters[i].signature());
                ++i;
            }
        }
        buffer.append(')');
        buffer.append(this.returnType.signature());
        this.signature = buffer.toString().toCharArray();
        return this.signature;
    }

    public final int sourceEnd() {
        AbstractMethodDeclaration method = this.sourceMethod();
        if (method == null) {
            return 0;
        }
        return method.sourceEnd;
    }

    public AbstractMethodDeclaration sourceMethod() {
        SourceTypeBinding sourceType;
        if (this.declaringClass instanceof BinaryTypeBinding) {
            return null;
        }
        try {
            sourceType = (SourceTypeBinding)this.declaringClass;
        }
        catch (ClassCastException e) {
            return null;
        }
        AbstractMethodDeclaration[] methods = sourceType.scope.referenceContext.methods;
        int i = methods.length;
        while (--i >= 0) {
            if (this != methods[i].binding) continue;
            return methods[i];
        }
        return null;
    }

    public final int sourceStart() {
        AbstractMethodDeclaration method = this.sourceMethod();
        if (method == null) {
            return 0;
        }
        return method.sourceStart;
    }

    public boolean alwaysNeedsAccessMethod() {
        return false;
    }

    public MethodBinding getAccessMethod(boolean staticReference) {
        throw new RuntimeException("unimplemented");
    }

    public final void tagForClearingPrivateModifier() {
        this.modifiers |= 0x4000000;
    }

    public String toString() {
        int length;
        int i;
        String s = this.returnType != null ? this.returnType.debugName() : "NULL TYPE";
        s = String.valueOf(s) + " ";
        s = String.valueOf(s) + (this.selector != null ? new String(this.selector) : "UNNAMED METHOD");
        s = String.valueOf(s) + "(";
        if (this.parameters != null) {
            if (this.parameters != TypeConstants.NoParameters) {
                i = 0;
                length = this.parameters.length;
                while (i < length) {
                    if (i > 0) {
                        s = String.valueOf(s) + ", ";
                    }
                    s = String.valueOf(s) + (this.parameters[i] != null ? this.parameters[i].debugName() : "NULL TYPE");
                    ++i;
                }
            }
        } else {
            s = String.valueOf(s) + "NULL PARAMETERS";
        }
        s = String.valueOf(s) + ") ";
        if (this.thrownExceptions != null) {
            if (this.thrownExceptions != TypeConstants.NoExceptions) {
                s = String.valueOf(s) + "throws ";
                i = 0;
                length = this.thrownExceptions.length;
                while (i < length) {
                    if (i > 0) {
                        s = String.valueOf(s) + ", ";
                    }
                    s = String.valueOf(s) + (this.thrownExceptions[i] != null ? this.thrownExceptions[i].debugName() : "NULL TYPE");
                    ++i;
                }
            }
        } else {
            s = String.valueOf(s) + "NULL THROWN EXCEPTIONS";
        }
        return s;
    }
}

