/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.Scanner;

public abstract class AbstractCommentParser {
    public static final char[] TAG_DEPRECATED = "deprecated".toCharArray();
    public static final char[] TAG_PARAM = "param".toCharArray();
    public static final char[] TAG_RETURN = "return".toCharArray();
    public static final char[] TAG_THROWS = "throws".toCharArray();
    public static final char[] TAG_EXCEPTION = "exception".toCharArray();
    public static final char[] TAG_SEE = "see".toCharArray();
    public static final char[] TAG_LINK = "link".toCharArray();
    public static final char[] TAG_LINKPLAIN = "linkplain".toCharArray();
    public static final char[] TAG_INHERITDOC = "inheritDoc".toCharArray();
    public static final int ORDERED_TAGS_NUMBER = 3;
    public static final int PARAM_TAG_EXPECTED_ORDER = 0;
    public static final int THROWS_TAG_EXPECTED_ORDER = 1;
    public static final int SEE_TAG_EXPECTED_ORDER = 2;
    public static final int COMPIL_PARSER = 1;
    public static final int DOM_PARSER = 2;
    public Scanner scanner;
    public boolean checkDocComment = false;
    protected boolean inherited;
    protected boolean deprecated;
    protected char[] source;
    protected int index;
    protected int endComment;
    protected int lineEnd;
    protected int tokenPreviousPosition;
    protected int textStart;
    protected int memberStart;
    protected int tagSourceStart;
    protected int tagSourceEnd;
    protected int inlineTagStart;
    protected Parser sourceParser;
    protected Object returnStatement;
    protected boolean lineStarted = false;
    protected boolean inlineTagStarted = false;
    protected int kind;
    protected int[] lineEnds;
    private int currentTokenType = -1;
    private int linePtr;
    private int lastLinePtr;
    protected int identifierPtr;
    protected char[][] identifierStack;
    protected int identifierLengthPtr;
    protected int[] identifierLengthStack;
    protected long[] identifierPositionStack;
    protected static int AstStackIncrement = 10;
    protected int astPtr;
    protected Object[] astStack;
    protected int astLengthPtr;
    protected int[] astLengthStack;

    protected AbstractCommentParser(Parser sourceParser) {
        this.sourceParser = sourceParser;
        this.scanner = new Scanner(false, false, false, 0x2F0000L, null, null, true);
        this.identifierStack = new char[20][];
        this.identifierPositionStack = new long[20];
        this.identifierLengthStack = new int[10];
        this.astStack = new Object[30];
        this.astLengthStack = new int[20];
    }

    protected boolean parseComment(int javadocStart, int javadocEnd) {
        boolean validComment = true;
        try {
            this.scanner.resetTo(javadocStart, javadocEnd);
            this.endComment = javadocEnd;
            this.index = javadocStart;
            this.readChar();
            int previousPosition = this.index;
            this.readChar();
            char nextCharacter = this.readChar();
            this.astLengthPtr = -1;
            this.astPtr = -1;
            this.currentTokenType = -1;
            this.inlineTagStarted = false;
            this.inlineTagStart = -1;
            this.lineStarted = false;
            this.returnStatement = null;
            this.inherited = false;
            this.deprecated = false;
            this.linePtr = this.getLineNumber(javadocStart);
            this.lastLinePtr = this.getLineNumber(javadocEnd);
            this.lineEnd = this.linePtr == this.lastLinePtr ? this.endComment : this.getLineEnd(this.linePtr);
            this.textStart = -1;
            char previousChar = '\u0000';
            int invalidTagLineEnd = -1;
            int invalidInlineTagLineEnd = -1;
            block26: while (this.index < this.endComment) {
                previousPosition = this.index;
                previousChar = nextCharacter;
                if (this.index > this.lineEnd + 1) {
                    this.updateLineEnd();
                }
                if (this.currentTokenType < 0) {
                    nextCharacter = this.readChar();
                } else {
                    previousPosition = this.scanner.getCurrentTokenStartPosition();
                    switch (this.currentTokenType) {
                        case 48: {
                            nextCharacter = '}';
                            break;
                        }
                        case 4: {
                            nextCharacter = '*';
                            break;
                        }
                        default: {
                            nextCharacter = this.scanner.currentCharacter;
                        }
                    }
                    this.consumeToken();
                }
                if (this.index >= this.endComment) break;
                switch (nextCharacter) {
                    case '@': {
                        boolean valid = false;
                        if (this.lineStarted && previousChar != 123) continue block26;
                        this.lineStarted = true;
                        if (this.inlineTagStarted) {
                            this.inlineTagStarted = false;
                            if (this.sourceParser != null) {
                                int end = previousPosition < invalidInlineTagLineEnd ? previousPosition : invalidInlineTagLineEnd;
                                this.sourceParser.problemReporter().javadocUnterminatedInlineTag(this.inlineTagStart, end);
                            }
                            validComment = false;
                            if (this.lineStarted && this.textStart != -1 && this.textStart < previousPosition) {
                                this.pushText(this.textStart, previousPosition);
                            }
                            if (this.kind == 2) {
                                this.refreshInlineTagPosition(previousPosition);
                            }
                        }
                        if (previousChar == '{') {
                            if (this.textStart != -1 && this.textStart < this.inlineTagStart) {
                                this.pushText(this.textStart, this.inlineTagStart);
                            }
                            this.inlineTagStarted = true;
                            invalidInlineTagLineEnd = this.lineEnd;
                        } else if (this.textStart != -1 && this.textStart < invalidTagLineEnd) {
                            this.pushText(this.textStart, invalidTagLineEnd);
                        }
                        this.scanner.resetTo(this.index, this.endComment);
                        this.currentTokenType = -1;
                        try {
                            int token = this.readTokenAndConsume();
                            this.tagSourceStart = this.scanner.getCurrentTokenStartPosition();
                            this.tagSourceEnd = this.scanner.getCurrentTokenEndPosition();
                            char[] tag = this.scanner.getCurrentIdentifierSource();
                            if (this.kind == 2) {
                                int tk = token;
                                int le = this.lineEnd;
                                char pc = this.peekChar();
                                block27: while (tk != 75) {
                                    this.tagSourceEnd = this.scanner.getCurrentTokenEndPosition();
                                    token = tk;
                                    switch (pc) {
                                        case '!': 
                                        case '#': 
                                        case '%': 
                                        case '&': 
                                        case '\'': 
                                        case '*': 
                                        case '-': 
                                        case ':': 
                                        case '<': 
                                        case '>': 
                                        case '}': {
                                            break block27;
                                        }
                                        default: {
                                            if (pc == ' ' || Character.isWhitespace(pc)) break block27;
                                            tk = this.readTokenAndConsume();
                                            pc = this.peekChar();
                                        }
                                    }
                                }
                                int length = this.tagSourceEnd - this.tagSourceStart + 1;
                                tag = new char[length];
                                System.arraycopy(this.source, this.tagSourceStart, tag, 0, length);
                                this.index = this.tagSourceEnd + 1;
                                this.scanner.currentPosition = this.tagSourceEnd + 1;
                                this.tagSourceStart = previousPosition;
                                this.lineEnd = le;
                            }
                            switch (token) {
                                case 24: {
                                    if (CharOperation.equals(tag, TAG_DEPRECATED)) {
                                        this.deprecated = true;
                                        if (this.kind == 2) {
                                            valid = this.parseTag();
                                            break;
                                        }
                                        valid = true;
                                        break;
                                    }
                                    if (CharOperation.equals(tag, TAG_INHERITDOC)) {
                                        boolean bl = this.inherited = this.astPtr == -1;
                                        if (this.kind == 2) {
                                            valid = this.parseTag();
                                            break;
                                        }
                                        valid = true;
                                        break;
                                    }
                                    if (CharOperation.equals(tag, TAG_PARAM)) {
                                        valid = this.parseParam();
                                        break;
                                    }
                                    if (CharOperation.equals(tag, TAG_EXCEPTION)) {
                                        valid = this.parseThrows(false);
                                        break;
                                    }
                                    if (CharOperation.equals(tag, TAG_SEE)) {
                                        if (this.inlineTagStarted) {
                                            valid = false;
                                            if (this.sourceParser == null) break;
                                            this.sourceParser.problemReporter().javadocUnexpectedTag(this.tagSourceStart, this.tagSourceEnd);
                                            break;
                                        }
                                        valid = this.parseSee(false);
                                        break;
                                    }
                                    if (CharOperation.equals(tag, TAG_LINK)) {
                                        if (this.inlineTagStarted) {
                                            valid = this.parseSee(false);
                                            break;
                                        }
                                        valid = false;
                                        if (this.sourceParser == null) break;
                                        this.sourceParser.problemReporter().javadocUnexpectedTag(this.tagSourceStart, this.tagSourceEnd);
                                        break;
                                    }
                                    if (CharOperation.equals(tag, TAG_LINKPLAIN)) {
                                        if (this.inlineTagStarted) {
                                            valid = this.parseSee(true);
                                            break;
                                        }
                                        valid = this.parseTag();
                                        break;
                                    }
                                    valid = this.parseTag();
                                    break;
                                }
                                case 84: {
                                    valid = this.parseReturn();
                                    break;
                                }
                                case 97: {
                                    valid = this.parseThrows(true);
                                    break;
                                }
                                default: {
                                    if (this.kind != 2) break;
                                    switch (token) {
                                        case 13: 
                                        case 38: 
                                        case 39: 
                                        case 40: 
                                        case 41: 
                                        case 42: 
                                        case 43: 
                                        case 44: 
                                        case 45: 
                                        case 46: 
                                        case 47: 
                                        case 49: 
                                        case 50: 
                                        case 52: 
                                        case 53: 
                                        case 54: 
                                        case 61: 
                                        case 62: 
                                        case 63: 
                                        case 64: 
                                        case 65: 
                                        case 66: 
                                        case 67: 
                                        case 68: 
                                        case 69: 
                                        case 70: 
                                        case 71: 
                                        case 77: 
                                        case 78: 
                                        case 79: 
                                        case 80: 
                                        case 81: 
                                        case 82: 
                                        case 83: 
                                        case 85: 
                                        case 86: 
                                        case 87: 
                                        case 88: 
                                        case 89: 
                                        case 90: 
                                        case 91: 
                                        case 92: 
                                        case 93: 
                                        case 94: 
                                        case 95: 
                                        case 96: 
                                        case 98: 
                                        case 99: {
                                            valid = this.parseTag();
                                        }
                                    }
                                }
                            }
                            this.textStart = this.index;
                            if (valid) continue block26;
                            validComment = false;
                            if (this.kind != 2) continue block26;
                            this.parseTag();
                            this.textStart = this.tagSourceEnd + 1;
                            invalidTagLineEnd = this.lineEnd;
                        }
                        catch (InvalidInputException e) {
                            this.consumeToken();
                        }
                        continue block26;
                    }
                    case '\n': 
                    case '\r': {
                        if (this.lineStarted && this.textStart < previousPosition) {
                            this.pushText(this.textStart, previousPosition);
                        }
                        this.lineStarted = false;
                        this.textStart = -1;
                        break;
                    }
                    case '}': {
                        if (this.inlineTagStarted) {
                            if (this.lineStarted && this.textStart != -1 && this.textStart < previousPosition) {
                                this.pushText(this.textStart, previousPosition);
                            }
                            if (this.kind == 2) {
                                this.refreshInlineTagPosition(previousPosition);
                            }
                            this.textStart = this.index;
                            this.inlineTagStarted = false;
                        } else if (!this.lineStarted) {
                            this.textStart = previousPosition;
                        }
                        this.lineStarted = true;
                        break;
                    }
                    case '{': {
                        if (this.inlineTagStarted) {
                            this.inlineTagStarted = false;
                            if (this.sourceParser != null) {
                                int end = previousPosition < invalidInlineTagLineEnd ? previousPosition : invalidInlineTagLineEnd;
                                this.sourceParser.problemReporter().javadocUnterminatedInlineTag(this.inlineTagStart, end);
                            }
                            if (this.lineStarted && this.textStart != -1 && this.textStart < previousPosition) {
                                this.pushText(this.textStart, previousPosition);
                            }
                            if (this.kind == 2) {
                                this.refreshInlineTagPosition(previousPosition);
                            }
                        }
                        if (!this.lineStarted) {
                            this.textStart = previousPosition;
                        }
                        this.lineStarted = true;
                        this.inlineTagStart = previousPosition;
                        break;
                    }
                    case '*': {
                        break;
                    }
                    default: {
                        if (CharOperation.isWhitespace(nextCharacter)) continue block26;
                        if (!this.lineStarted) {
                            this.textStart = previousPosition;
                        }
                        this.lineStarted = true;
                    }
                }
            }
            if (this.inlineTagStarted) {
                this.inlineTagStarted = false;
                if (this.sourceParser != null) {
                    int end;
                    int n = end = previousPosition < invalidInlineTagLineEnd ? previousPosition : invalidInlineTagLineEnd;
                    if (this.index >= this.endComment) {
                        end = invalidInlineTagLineEnd;
                    }
                    this.sourceParser.problemReporter().javadocUnterminatedInlineTag(this.inlineTagStart, end);
                }
                if (this.lineStarted && this.textStart != -1 && this.textStart < previousPosition) {
                    this.pushText(this.textStart, previousPosition);
                }
                if (this.kind == 2) {
                    this.refreshInlineTagPosition(previousPosition);
                }
            } else if (this.lineStarted && this.textStart < previousPosition) {
                this.pushText(this.textStart, previousPosition);
            }
            this.updateDocComment();
        }
        catch (Exception ex) {
            validComment = false;
        }
        return validComment;
    }

    private void consumeToken() {
        this.currentTokenType = -1;
        this.updateLineEnd();
    }

    protected abstract Object createArgumentReference(char[] var1, int var2, Object var3, long[] var4, long var5) throws InvalidInputException;

    protected abstract Object createFieldReference(Object var1) throws InvalidInputException;

    protected abstract Object createMethodReference(Object var1, List var2) throws InvalidInputException;

    protected Object createReturnStatement() {
        return null;
    }

    protected abstract Object createTypeReference(int var1);

    private int getEndPosition() {
        if (this.scanner.getCurrentTokenEndPosition() > this.lineEnd) {
            return this.lineEnd;
        }
        return this.scanner.getCurrentTokenEndPosition();
    }

    private Object parseArguments(Object receiver) throws InvalidInputException {
        int modulo = 0;
        int iToken = 0;
        char[] argName = null;
        ArrayList<Object> arguments = new ArrayList<Object>(10);
        int start = this.scanner.getCurrentTokenStartPosition();
        block2: while (this.index < this.scanner.eofPosition) {
            char[] name;
            boolean firstArg;
            Object typeRef;
            try {
                typeRef = this.parseQualifiedName(false);
            }
            catch (InvalidInputException e) {
                break;
            }
            boolean bl = firstArg = modulo == 0;
            if (!firstArg ? iToken % modulo != 0 : iToken != 0) break;
            if (typeRef == null) {
                if (!firstArg || this.currentTokenType != 29) break;
                char pc = this.peekChar();
                if (!(Character.isWhitespace(pc) || this.inlineTagStarted && pc == '}')) {
                    if (this.sourceParser != null) {
                        this.sourceParser.problemReporter().javadocMalformedSeeReference(start, this.lineEnd);
                    }
                    return null;
                }
                this.lineStarted = true;
                return this.createMethodReference(receiver, null);
            }
            ++iToken;
            int dim = 0;
            long[] dimPositions = new long[20];
            if (this.readToken() == 7) {
                int dimStart = this.scanner.getCurrentTokenStartPosition();
                while (this.readToken() == 7) {
                    this.consumeToken();
                    if (this.readToken() != 73) break block2;
                    this.consumeToken();
                    dimPositions[dim++] = ((long)dimStart << 32) + (long)this.scanner.getCurrentTokenEndPosition();
                }
            }
            long argNamePos = -1L;
            if (this.readToken() == 24) {
                this.consumeToken();
                if (!firstArg ? iToken % modulo != 1 : iToken != 1) break;
                if (argName == null && !firstArg) break;
                argName = this.scanner.getCurrentIdentifierSource();
                argNamePos = ((long)this.scanner.getCurrentTokenStartPosition() << 32) + (long)this.scanner.getCurrentTokenEndPosition();
                ++iToken;
            } else if (argName != null) break;
            if (firstArg) {
                modulo = iToken + 1;
            } else if (iToken % modulo != modulo - 1) break;
            int token = this.readToken();
            char[] cArray = name = argName == null ? new char[]{} : argName;
            if (token == 33) {
                Object argument = this.createArgumentReference(name, dim, typeRef, dimPositions, argNamePos);
                arguments.add(argument);
                this.consumeToken();
                ++iToken;
                continue;
            }
            if (token != 29) break;
            char pc = this.peekChar();
            if (!(Character.isWhitespace(pc) || this.inlineTagStarted && pc == '}')) {
                if (this.sourceParser != null) {
                    this.sourceParser.problemReporter().javadocMalformedSeeReference(start, this.lineEnd);
                }
                return null;
            }
            Object argument = this.createArgumentReference(name, dim, typeRef, dimPositions, argNamePos);
            arguments.add(argument);
            this.consumeToken();
            return this.createMethodReference(receiver, arguments);
        }
        throw new InvalidInputException();
    }

    private boolean parseHref() throws InvalidInputException {
        int start = this.scanner.getCurrentTokenStartPosition();
        if (Character.toLowerCase(this.readChar()) == 'a') {
            this.scanner.currentPosition = this.index;
            if (this.readToken() == 24) {
                this.currentTokenType = -1;
                try {
                    if (CharOperation.equals(this.scanner.getCurrentIdentifierSource(), new char[]{'h', 'r', 'e', 'f'}, false) && this.readToken() == 100) {
                        this.currentTokenType = -1;
                        if (this.readToken() == 60) {
                            this.currentTokenType = -1;
                            if (this.readToken() == 16) {
                                this.consumeToken();
                                while (this.readToken() != 17) {
                                    if (this.scanner.currentPosition >= this.scanner.eofPosition || this.scanner.currentCharacter == '@') {
                                        this.index = this.tokenPreviousPosition;
                                        this.scanner.currentPosition = this.tokenPreviousPosition;
                                        this.currentTokenType = -1;
                                        if (this.sourceParser != null) {
                                            this.sourceParser.problemReporter().javadocInvalidSeeUrlReference(start, this.lineEnd);
                                        }
                                        return false;
                                    }
                                    this.consumeToken();
                                }
                                this.currentTokenType = -1;
                                if (this.readChar() == '/' && Character.toLowerCase(this.readChar()) == 'a' && this.readChar() == '>') {
                                    return true;
                                }
                            }
                        }
                    }
                }
                catch (InvalidInputException invalidInputException) {
                    // empty catch block
                }
            }
        }
        this.index = this.tokenPreviousPosition;
        this.scanner.currentPosition = this.tokenPreviousPosition;
        this.currentTokenType = -1;
        if (this.sourceParser != null) {
            this.sourceParser.problemReporter().javadocInvalidSeeUrlReference(start, this.lineEnd);
        }
        return false;
    }

    private Object parseMember(Object receiver) throws InvalidInputException {
        int start;
        this.identifierPtr = -1;
        this.identifierLengthPtr = -1;
        this.memberStart = start = this.scanner.getCurrentTokenStartPosition();
        if (this.readToken() == 24) {
            this.consumeToken();
            this.pushIdentifier(true);
            int previousPosition = this.index;
            if (this.readToken() == 21) {
                this.consumeToken();
                start = this.scanner.getCurrentTokenStartPosition();
                try {
                    return this.parseArguments(receiver);
                }
                catch (InvalidInputException e) {
                    int end = this.scanner.getCurrentTokenEndPosition() < this.lineEnd ? this.scanner.getCurrentTokenEndPosition() : this.scanner.getCurrentTokenStartPosition();
                    int n = end = end < this.lineEnd ? end : this.lineEnd;
                    if (this.sourceParser != null) {
                        this.sourceParser.problemReporter().javadocInvalidSeeReferenceArgs(start, end);
                    }
                    return null;
                }
            }
            if (this.currentTokenType != -1) {
                this.index = previousPosition;
                this.scanner.currentPosition = previousPosition;
                this.currentTokenType = -1;
            }
            return this.createFieldReference(receiver);
        }
        int end = this.getEndPosition() - 1;
        int n = end = start > end ? this.getEndPosition() : end;
        if (this.sourceParser != null) {
            this.sourceParser.problemReporter().javadocInvalidSeeReference(start, end);
        }
        this.index = this.tokenPreviousPosition;
        this.scanner.currentPosition = this.tokenPreviousPosition;
        this.currentTokenType = -1;
        return null;
    }

    protected boolean parseParam() {
        int start = this.tagSourceStart;
        int end = this.tagSourceEnd;
        try {
            int token = this.readToken();
            switch (token) {
                case 24: {
                    this.consumeToken();
                    return this.pushParamName();
                }
                case 75: {
                    break;
                }
                default: {
                    start = this.scanner.getCurrentTokenStartPosition();
                    end = this.getEndPosition();
                    if (end < start) {
                        start = this.tagSourceStart;
                    }
                    break;
                }
            }
        }
        catch (InvalidInputException e) {
            end = this.getEndPosition();
        }
        this.index = this.tokenPreviousPosition;
        this.scanner.currentPosition = this.tokenPreviousPosition;
        this.currentTokenType = -1;
        if (this.sourceParser != null) {
            this.sourceParser.problemReporter().javadocMissingParamName(start, end);
        }
        return false;
    }

    protected Object parseQualifiedName(boolean reset) throws InvalidInputException {
        if (reset) {
            this.identifierPtr = -1;
            this.identifierLengthPtr = -1;
        }
        int primitiveToken = -1;
        int iToken = 0;
        block5: while (true) {
            int token = this.readToken();
            switch (token) {
                case 24: {
                    if (iToken % 2 > 0) break block5;
                    this.pushIdentifier(iToken == 0);
                    this.consumeToken();
                    break;
                }
                case 1: {
                    if (iToken % 2 == 0) {
                        throw new InvalidInputException();
                    }
                    this.consumeToken();
                    break;
                }
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: {
                    if (iToken > 0) {
                        throw new InvalidInputException();
                    }
                    this.pushIdentifier(true);
                    primitiveToken = token;
                    this.consumeToken();
                    break block5;
                }
                default: {
                    if (iToken == 0) {
                        return null;
                    }
                    if (iToken % 2 != 0) break block5;
                    if (this.kind == 2 && this.currentTokenType != -1) {
                        this.index = this.tokenPreviousPosition;
                        this.scanner.currentPosition = this.tokenPreviousPosition;
                        this.currentTokenType = -1;
                    }
                    throw new InvalidInputException();
                }
            }
            ++iToken;
        }
        if (this.currentTokenType != -1) {
            this.index = this.tokenPreviousPosition;
            this.scanner.currentPosition = this.tokenPreviousPosition;
            this.currentTokenType = -1;
        }
        return this.createTypeReference(primitiveToken);
    }

    protected boolean parseReference(boolean plain) throws InvalidInputException {
        Object typeRef = null;
        Object reference = null;
        int previousPosition = -1;
        block8: while (this.index < this.scanner.eofPosition) {
            previousPosition = this.index;
            int token = this.readToken();
            switch (token) {
                case 60: {
                    int start = this.scanner.getCurrentTokenStartPosition();
                    if (typeRef == null) {
                        this.consumeToken();
                        while (Character.isWhitespace(this.source[this.index])) {
                            if (this.source[this.index] == '\r' || this.source[this.index] == '\n') {
                                if (this.kind == 2) {
                                    this.parseTag();
                                    this.pushText(previousPosition, this.index);
                                }
                                return true;
                            }
                            ++this.index;
                        }
                    }
                    if (this.sourceParser != null) {
                        this.sourceParser.problemReporter().javadocInvalidSeeReference(start, this.lineEnd);
                    }
                    return false;
                }
                case 17: {
                    this.consumeToken();
                    int start = this.scanner.getCurrentTokenStartPosition();
                    if (this.parseHref()) {
                        if (typeRef == null) {
                            this.consumeToken();
                            while (Character.isWhitespace(this.source[this.index])) {
                                if (this.source[this.index] == '\r' || this.source[this.index] == '\n') {
                                    if (this.kind == 2) {
                                        this.parseTag();
                                        this.pushText(previousPosition, this.index);
                                    }
                                    return true;
                                }
                                ++this.index;
                            }
                        }
                        if (this.sourceParser != null) {
                            this.sourceParser.problemReporter().javadocInvalidSeeReference(start, this.lineEnd);
                        }
                    }
                    return false;
                }
                case 112: {
                    if (this.scanner.currentCharacter != '#') break block8;
                    this.consumeToken();
                    reference = this.parseMember(typeRef);
                    if (reference != null) {
                        return this.pushSeeRef(reference, plain);
                    }
                    return false;
                }
                case 24: {
                    if (typeRef != null) break block8;
                    typeRef = this.parseQualifiedName(true);
                    break;
                }
                default: {
                    break block8;
                }
            }
        }
        if (reference == null) {
            reference = typeRef;
        }
        if (reference == null) {
            this.index = this.tokenPreviousPosition;
            this.scanner.currentPosition = this.tokenPreviousPosition;
            this.currentTokenType = -1;
            if (this.sourceParser != null) {
                this.sourceParser.problemReporter().javadocMissingSeeReference(this.tagSourceStart, this.tagSourceEnd);
            }
            return false;
        }
        int start = this.scanner.getCurrentTokenStartPosition();
        try {
            int token = this.readToken();
            if (token != 21) {
                if (this.currentTokenType != -1) {
                    this.index = this.tokenPreviousPosition;
                    this.scanner.currentPosition = this.tokenPreviousPosition;
                    this.currentTokenType = -1;
                }
                return this.pushSeeRef(reference, plain);
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        this.index = this.tokenPreviousPosition;
        this.scanner.currentPosition = this.tokenPreviousPosition;
        this.currentTokenType = -1;
        if (this.sourceParser != null) {
            this.sourceParser.problemReporter().javadocInvalidSeeReference(start, this.lineEnd);
        }
        return false;
    }

    protected abstract boolean parseReturn();

    protected boolean parseSee(boolean plain) {
        int start = this.scanner.currentPosition;
        try {
            return this.parseReference(plain);
        }
        catch (InvalidInputException ex) {
            if (this.sourceParser != null) {
                this.sourceParser.problemReporter().javadocInvalidSeeReference(start, this.getEndPosition());
            }
            this.index = this.tokenPreviousPosition;
            this.scanner.currentPosition = this.tokenPreviousPosition;
            this.currentTokenType = -1;
            return false;
        }
    }

    protected abstract boolean parseTag();

    protected boolean parseThrows(boolean real) {
        block4: {
            int start = this.scanner.currentPosition;
            try {
                Object typeRef = this.parseQualifiedName(true);
                if (typeRef == null) {
                    if (this.sourceParser != null) {
                        this.sourceParser.problemReporter().javadocMissingThrowsClassName(this.tagSourceStart, this.tagSourceEnd);
                    }
                    break block4;
                }
                return this.pushThrowName(typeRef, real);
            }
            catch (InvalidInputException ex) {
                if (this.sourceParser == null) break block4;
                this.sourceParser.problemReporter().javadocInvalidThrowsClass(start, this.getEndPosition());
            }
        }
        return false;
    }

    protected void pushIdentifier(boolean newLength) {
        int stackLength = this.identifierStack.length;
        if (++this.identifierPtr >= stackLength) {
            this.identifierStack = new char[stackLength + 10][];
            System.arraycopy(this.identifierStack, 0, this.identifierStack, 0, stackLength);
            this.identifierPositionStack = new long[stackLength + 10];
            System.arraycopy(this.identifierPositionStack, 0, this.identifierPositionStack, 0, stackLength);
        }
        this.identifierStack[this.identifierPtr] = this.scanner.getCurrentIdentifierSource();
        this.identifierPositionStack[this.identifierPtr] = ((long)this.scanner.startPosition << 32) + (long)(this.scanner.currentPosition - 1);
        if (newLength) {
            stackLength = this.identifierLengthStack.length;
            if (++this.identifierLengthPtr >= stackLength) {
                this.identifierLengthStack = new int[stackLength + 10];
                System.arraycopy(this.identifierLengthStack, 0, this.identifierLengthStack, 0, stackLength);
            }
            this.identifierLengthStack[this.identifierLengthPtr] = 1;
        } else {
            int n = this.identifierLengthPtr;
            this.identifierLengthStack[n] = this.identifierLengthStack[n] + 1;
        }
    }

    protected void pushOnAstStack(Object node, boolean newLength) {
        if (node == null) {
            this.astLengthStack[++this.astLengthPtr] = 0;
            return;
        }
        int stackLength = this.astStack.length;
        if (++this.astPtr >= stackLength) {
            this.astStack = new Object[stackLength + AstStackIncrement];
            System.arraycopy(this.astStack, 0, this.astStack, 0, stackLength);
            this.astPtr = stackLength;
        }
        this.astStack[this.astPtr] = node;
        if (newLength) {
            stackLength = this.astLengthStack.length;
            if (++this.astLengthPtr >= stackLength) {
                this.astLengthStack = new int[stackLength + AstStackIncrement];
                System.arraycopy(this.astLengthStack, 0, this.astLengthStack, 0, stackLength);
            }
            this.astLengthStack[this.astLengthPtr] = 1;
        } else {
            int n = this.astLengthPtr;
            this.astLengthStack[n] = this.astLengthStack[n] + 1;
        }
    }

    protected abstract boolean pushParamName();

    protected abstract boolean pushSeeRef(Object var1, boolean var2);

    protected abstract void pushText(int var1, int var2);

    protected void refreshInlineTagPosition(int previousPosition) {
    }

    private char peekChar() {
        char c;
        int idx = this.index;
        if ((c = this.source[idx++]) == '\\' && this.source[idx] == 'u') {
            int c4;
            int c3;
            int c2;
            int c1;
            ++idx;
            while (this.source[idx] == 'u') {
                ++idx;
            }
            if ((c1 = Character.getNumericValue(this.source[idx++])) <= 15 && c1 >= 0 && (c2 = Character.getNumericValue(this.source[idx++])) <= 15 && c2 >= 0 && (c3 = Character.getNumericValue(this.source[idx++])) <= 15 && c3 >= 0 && (c4 = Character.getNumericValue(this.source[idx++])) <= 15 && c4 >= 0) {
                c = (char)(((c1 * 16 + c2) * 16 + c3) * 16 + c4);
            }
        }
        return c;
    }

    protected abstract boolean pushThrowName(Object var1, boolean var2);

    protected char readChar() {
        char c;
        if ((c = this.source[this.index++]) == '\\' && this.source[this.index] == 'u') {
            int c4;
            int c3;
            int c2;
            int c1;
            int pos = this.index++;
            while (this.source[this.index] == 'u') {
                ++this.index;
            }
            if ((c1 = Character.getNumericValue(this.source[this.index++])) <= 15 && c1 >= 0 && (c2 = Character.getNumericValue(this.source[this.index++])) <= 15 && c2 >= 0 && (c3 = Character.getNumericValue(this.source[this.index++])) <= 15 && c3 >= 0 && (c4 = Character.getNumericValue(this.source[this.index++])) <= 15 && c4 >= 0) {
                c = (char)(((c1 * 16 + c2) * 16 + c3) * 16 + c4);
            } else {
                this.index = pos;
            }
        }
        return c;
    }

    private int readToken() throws InvalidInputException {
        if (this.currentTokenType < 0) {
            this.tokenPreviousPosition = this.scanner.currentPosition;
            this.currentTokenType = this.scanner.getNextToken();
            if (this.scanner.currentPosition > this.lineEnd + 1) {
                this.lineStarted = false;
                while (this.currentTokenType == 4) {
                    this.currentTokenType = this.scanner.getNextToken();
                }
            }
            this.index = this.scanner.currentPosition;
            this.lineStarted = true;
        }
        return this.currentTokenType;
    }

    private int readTokenAndConsume() throws InvalidInputException {
        int token = this.readToken();
        this.consumeToken();
        return token;
    }

    public String toString() {
        char[] middle;
        int endPos;
        StringBuffer buffer = new StringBuffer();
        int startPos = this.scanner.currentPosition < this.index ? this.scanner.currentPosition : this.index;
        int n = endPos = this.scanner.currentPosition < this.index ? this.index : this.scanner.currentPosition;
        if (startPos == this.source.length) {
            return "EOF\n\n" + new String(this.source);
        }
        if (endPos > this.source.length) {
            return "behind the EOF\n\n" + new String(this.source);
        }
        char[] front = new char[startPos];
        System.arraycopy(this.source, 0, front, 0, startPos);
        int middleLength = endPos - 1 - startPos + 1;
        if (middleLength > -1) {
            middle = new char[middleLength];
            System.arraycopy(this.source, startPos, middle, 0, middleLength);
        } else {
            middle = CharOperation.NO_CHAR;
        }
        char[] end = new char[this.source.length - (endPos - 1)];
        System.arraycopy(this.source, endPos - 1 + 1, end, 0, this.source.length - (endPos - 1) - 1);
        buffer.append(front);
        if (this.scanner.currentPosition < this.index) {
            buffer.append("\n===============================\nScanner current position here -->");
        } else {
            buffer.append("\n===============================\nParser index here -->");
        }
        buffer.append(middle);
        if (this.scanner.currentPosition < this.index) {
            buffer.append("<-- Parser index here\n===============================\n");
        } else {
            buffer.append("<-- Scanner current position here\n===============================\n");
        }
        buffer.append(end);
        return buffer.toString();
    }

    protected void updateLineEnd() {
        while (this.index > this.lineEnd + 1) {
            if (this.linePtr < this.lastLinePtr) {
                this.lineEnd = this.getLineEnd(++this.linePtr) - 1;
                continue;
            }
            this.lineEnd = this.endComment;
            return;
        }
    }

    protected abstract void updateDocComment();

    public final int getLineNumber(int position) {
        if (this.scanner.linePtr != -1) {
            return this.scanner.getLineNumber(position);
        }
        if (this.lineEnds == null) {
            return 1;
        }
        int length = this.lineEnds.length;
        if (length == 0) {
            return 1;
        }
        int g = 0;
        int d = length - 1;
        int m = 0;
        while (g <= d) {
            m = (g + d) / 2;
            if (position < this.lineEnds[m]) {
                d = m - 1;
                continue;
            }
            if (position > this.lineEnds[m]) {
                g = m + 1;
                continue;
            }
            return m + 1;
        }
        if (position < this.lineEnds[m]) {
            return m + 1;
        }
        return m + 2;
    }

    public final int getLineEnd(int lineNumber) {
        if (this.scanner.linePtr != -1) {
            return this.scanner.getLineEnd(lineNumber);
        }
        if (this.lineEnds == null) {
            return -1;
        }
        if (lineNumber > this.lineEnds.length + 1) {
            return -1;
        }
        if (lineNumber <= 0) {
            return -1;
        }
        if (lineNumber == this.lineEnds.length + 1) {
            return this.scanner.eofPosition;
        }
        return this.lineEnds[lineNumber - 1];
    }
}

