/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import java.util.List;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ImplicitDocTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.ast.JavadocAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.JavadocArgumentExpression;
import org.eclipse.jdt.internal.compiler.ast.JavadocArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocArraySingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocFieldReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocMessageSend;
import org.eclipse.jdt.internal.compiler.ast.JavadocQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.JavadocSingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.parser.AbstractCommentParser;
import org.eclipse.jdt.internal.compiler.parser.Parser;

public class JavadocParser
extends AbstractCommentParser {
    public Javadoc docComment;
    private int invParamsPtr = -1;
    private JavadocSingleNameReference[] invParamsStack;

    JavadocParser(Parser sourceParser) {
        super(sourceParser);
        this.checkDocComment = this.sourceParser.options.docCommentSupport;
        this.kind = 1;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkDeprecation(int javadocStart, int javadocEnd) {
        block12: {
            try {
                this.source = this.sourceParser.scanner.source;
                this.index = javadocStart + 3;
                this.endComment = javadocEnd - 2;
                if (this.checkDocComment) {
                    this.scanner.lineEnds = this.sourceParser.scanner.lineEnds;
                    this.scanner.linePtr = this.sourceParser.scanner.linePtr;
                    this.lineEnds = this.scanner.lineEnds;
                    this.docComment = new Javadoc(javadocStart, javadocEnd);
                    this.parseComment(javadocStart, javadocEnd);
                    break block12;
                }
                this.docComment = this.sourceParser.options.getSeverity(0x100000L) != -1 ? new Javadoc(javadocStart, javadocEnd) : null;
                firstLineNumber = this.sourceParser.scanner.getLineNumber(javadocStart);
                lastLineNumber = this.sourceParser.scanner.getLineNumber(javadocEnd);
                line = firstLineNumber;
                while (true) {
                    if (line > lastLineNumber) {
                        break;
                    }
                    this.index = lineStart = line == firstLineNumber ? javadocStart + 3 : this.sourceParser.scanner.getLineStart(line);
                    v0 = this.lineEnd = line == lastLineNumber ? javadocEnd - 2 : this.sourceParser.scanner.getLineEnd(line);
lbl23:
                    // 3 sources

                    block8: while (this.index < this.lineEnd) {
                        c = this.readChar();
                        switch (c) {
                            default: {
                                if (!Character.isWhitespace(c)) break block8;
                                ** break;
                            }
                            case '*': {
                                ** break;
                            }
                            case '@': {
                                if (this.readChar() != 'd' || this.readChar() != 'e' || this.readChar() != 'p' || this.readChar() != 'r' || this.readChar() != 'e' || this.readChar() != 'c' || this.readChar() != 'a' || this.readChar() != 't' || this.readChar() != 'e' || this.readChar() != 'd') break block8;
                                c = this.readChar();
                                if (!Character.isWhitespace(c)) {
                                    if (c != '*') break block8;
                                }
                                var8_8 = null;
                                this.source = null;
                                return true;
                            }
                        }
                    }
                    ++line;
                }
            }
            catch (Throwable var9_12) {
                var8_10 = null;
                this.source = null;
                throw var9_12;
            }
            var8_9 = null;
            this.source = null;
            return false;
        }
        var8_11 = null;
        this.source = null;
        return this.deprecated;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("check javadoc: ").append(this.checkDocComment).append("\n");
        buffer.append("javadoc: ").append(this.docComment).append("\n");
        buffer.append(super.toString());
        return buffer.toString();
    }

    protected Object createArgumentReference(char[] name, int dim, Object typeRef, long[] dimPositions, long argNamePos) throws InvalidInputException {
        try {
            TypeReference argTypeRef = (TypeReference)typeRef;
            if (dim > 0) {
                long pos = ((long)argTypeRef.sourceStart << 32) + (long)argTypeRef.sourceEnd;
                if (typeRef instanceof JavadocSingleTypeReference) {
                    JavadocSingleTypeReference singleRef = (JavadocSingleTypeReference)typeRef;
                    argTypeRef = new JavadocArraySingleTypeReference(singleRef.token, dim, pos);
                } else {
                    JavadocQualifiedTypeReference qualifRef = (JavadocQualifiedTypeReference)typeRef;
                    argTypeRef = new JavadocArrayQualifiedTypeReference(qualifRef, dim);
                }
            }
            int argEnd = argTypeRef.sourceEnd;
            if (dim > 0) {
                argEnd = (int)dimPositions[dim - 1];
            }
            if (argNamePos >= 0L) {
                argEnd = (int)argNamePos;
            }
            return new JavadocArgumentExpression(name, argTypeRef.sourceStart, argEnd, argTypeRef);
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException();
        }
    }

    protected Object createFieldReference(Object receiver) throws InvalidInputException {
        try {
            TypeReference typeRef = (TypeReference)receiver;
            if (typeRef == null) {
                char[] name = this.sourceParser.compilationUnit.compilationResult.compilationUnit.getMainTypeName();
                typeRef = new ImplicitDocTypeReference(name, this.memberStart);
            }
            JavadocFieldReference field = new JavadocFieldReference(this.identifierStack[0], this.identifierPositionStack[0]);
            field.receiver = typeRef;
            field.tagSourceStart = this.tagSourceStart;
            field.tagSourceEnd = this.tagSourceEnd;
            return field;
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException();
        }
    }

    protected Object createMethodReference(Object receiver, List arguments) throws InvalidInputException {
        try {
            char[] name;
            TypeReference typeRef = (TypeReference)receiver;
            boolean isConstructor = false;
            if (typeRef == null) {
                name = this.sourceParser.compilationUnit.compilationResult.compilationUnit.getMainTypeName();
                isConstructor = CharOperation.equals(this.identifierStack[0], name);
                typeRef = new ImplicitDocTypeReference(name, this.memberStart);
            } else {
                name = null;
                if (typeRef instanceof JavadocSingleTypeReference) {
                    name = ((JavadocSingleTypeReference)typeRef).token;
                } else if (typeRef instanceof JavadocQualifiedTypeReference) {
                    char[][] tokens = ((JavadocQualifiedTypeReference)typeRef).tokens;
                    name = tokens[tokens.length - 1];
                } else {
                    throw new InvalidInputException();
                }
                isConstructor = CharOperation.equals(this.identifierStack[0], name);
            }
            if (arguments == null) {
                if (isConstructor) {
                    JavadocAllocationExpression expr = new JavadocAllocationExpression(this.identifierPositionStack[0]);
                    expr.type = typeRef;
                    return expr;
                }
                JavadocMessageSend msg = new JavadocMessageSend(this.identifierStack[0], this.identifierPositionStack[0]);
                msg.receiver = typeRef;
                return msg;
            }
            JavadocArgumentExpression[] expressions = new JavadocArgumentExpression[arguments.size()];
            arguments.toArray(expressions);
            if (isConstructor) {
                JavadocAllocationExpression alloc = new JavadocAllocationExpression(this.identifierPositionStack[0]);
                alloc.arguments = expressions;
                alloc.type = typeRef;
                return alloc;
            }
            JavadocMessageSend msg = new JavadocMessageSend(this.identifierStack[0], this.identifierPositionStack[0], expressions);
            msg.receiver = typeRef;
            return msg;
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException();
        }
    }

    protected Object createReturnStatement() {
        return new JavadocReturnStatement(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition(), this.scanner.getRawTokenSourceEnd());
    }

    protected Object createTypeReference(int primitiveToken) {
        int size;
        TypeReference typeRef = null;
        if ((size = this.identifierLengthStack[this.identifierLengthPtr--]) == 1) {
            typeRef = new JavadocSingleTypeReference(this.identifierStack[this.identifierPtr], this.identifierPositionStack[this.identifierPtr], this.tagSourceStart, this.tagSourceEnd);
        } else if (size > 1) {
            char[][] tokens = new char[size][];
            System.arraycopy(this.identifierStack, this.identifierPtr - size + 1, tokens, 0, size);
            long[] positions = new long[size];
            System.arraycopy(this.identifierPositionStack, this.identifierPtr - size + 1, positions, 0, size);
            typeRef = new JavadocQualifiedTypeReference(tokens, positions, this.tagSourceStart, this.tagSourceEnd);
        }
        this.identifierPtr -= size;
        return typeRef;
    }

    protected boolean parseReturn() {
        if (this.returnStatement == null) {
            this.returnStatement = this.createReturnStatement();
            return true;
        }
        if (this.sourceParser != null) {
            this.sourceParser.problemReporter().javadocDuplicatedReturnTag(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
        }
        return false;
    }

    protected boolean parseTag() {
        return true;
    }

    protected boolean pushParamName() {
        JavadocSingleNameReference nameRef = new JavadocSingleNameReference(this.scanner.getCurrentIdentifierSource(), this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
        nameRef.tagSourceStart = this.tagSourceStart;
        nameRef.tagSourceEnd = this.tagSourceEnd;
        if (this.astLengthPtr == -1) {
            this.pushOnAstStack(nameRef, true);
        } else {
            int i = 1;
            while (i <= this.astLengthPtr) {
                if (this.astLengthStack[i] != 0) {
                    int stackLength;
                    if (this.sourceParser != null) {
                        this.sourceParser.problemReporter().javadocUnexpectedTag(this.tagSourceStart, this.tagSourceEnd);
                    }
                    if ((long)this.invParamsPtr == -1L) {
                        this.invParamsStack = new JavadocSingleNameReference[10];
                    }
                    if (++this.invParamsPtr >= (stackLength = this.invParamsStack.length)) {
                        this.invParamsStack = new JavadocSingleNameReference[stackLength + AbstractCommentParser.AstStackIncrement];
                        System.arraycopy(this.invParamsStack, 0, this.invParamsStack, 0, stackLength);
                    }
                    this.invParamsStack[this.invParamsPtr] = nameRef;
                    return false;
                }
                i += 3;
            }
            switch (this.astLengthPtr % 3) {
                case 0: {
                    this.pushOnAstStack(nameRef, false);
                    break;
                }
                case 2: {
                    this.pushOnAstStack(nameRef, true);
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean pushSeeRef(Object statement, boolean plain) {
        if (this.astLengthPtr == -1) {
            this.pushOnAstStack(null, true);
            this.pushOnAstStack(null, true);
            this.pushOnAstStack(statement, true);
        } else {
            switch (this.astLengthPtr % 3) {
                case 0: {
                    this.pushOnAstStack(null, true);
                    this.pushOnAstStack(statement, true);
                    break;
                }
                case 1: {
                    this.pushOnAstStack(statement, true);
                    break;
                }
                case 2: {
                    this.pushOnAstStack(statement, false);
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    protected void pushText(int start, int end) {
    }

    protected boolean pushThrowName(Object typeRef, boolean real) {
        if (this.astLengthPtr == -1) {
            this.pushOnAstStack(null, true);
            this.pushOnAstStack(typeRef, true);
        } else {
            switch (this.astLengthPtr % 3) {
                case 0: {
                    this.pushOnAstStack(typeRef, true);
                    break;
                }
                case 1: {
                    this.pushOnAstStack(typeRef, false);
                    break;
                }
                case 2: {
                    this.pushOnAstStack(null, true);
                    this.pushOnAstStack(typeRef, true);
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    protected void updateDocComment() {
        this.docComment.inherited = this.inherited;
        if (this.returnStatement != null) {
            this.docComment.returnStatement = (JavadocReturnStatement)this.returnStatement;
        }
        if (this.invParamsPtr >= 0) {
            this.docComment.invalidParameters = new JavadocSingleNameReference[this.invParamsPtr + 1];
            System.arraycopy(this.invParamsStack, 0, this.docComment.invalidParameters, 0, this.invParamsPtr + 1);
        }
        if (this.astLengthPtr == -1) {
            return;
        }
        int[] sizes = new int[3];
        int i = 0;
        while (i <= this.astLengthPtr) {
            int n = i % 3;
            sizes[n] = sizes[n] + this.astLengthStack[i];
            ++i;
        }
        this.docComment.references = new Expression[sizes[2]];
        this.docComment.thrownExceptions = new TypeReference[sizes[1]];
        this.docComment.parameters = new JavadocSingleNameReference[sizes[0]];
        while (this.astLengthPtr >= 0) {
            int i2;
            int size;
            int ptr = this.astLengthPtr % 3;
            if (ptr == 2) {
                size = this.astLengthStack[this.astLengthPtr--];
                i2 = 0;
                while (i2 < size) {
                    int n = ptr;
                    int n2 = sizes[n] - 1;
                    sizes[n] = n2;
                    this.docComment.references[n2] = (Expression)this.astStack[this.astPtr--];
                    ++i2;
                }
                continue;
            }
            if (ptr == 1) {
                size = this.astLengthStack[this.astLengthPtr--];
                i2 = 0;
                while (i2 < size) {
                    int n = ptr;
                    int n3 = sizes[n] - 1;
                    sizes[n] = n3;
                    this.docComment.thrownExceptions[n3] = (TypeReference)this.astStack[this.astPtr--];
                    ++i2;
                }
                continue;
            }
            if (ptr != 0) continue;
            size = this.astLengthStack[this.astLengthPtr--];
            i2 = 0;
            while (i2 < size) {
                int n = ptr;
                int n4 = sizes[n] - 1;
                sizes[n] = n4;
                this.docComment.parameters[n4] = (JavadocSingleNameReference)this.astStack[this.astPtr--];
                ++i2;
            }
        }
    }
}

