/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaElementDelta;
import org.eclipse.jdt.internal.core.JavaModelOperation;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.util.Util;

public class CreatePackageFragmentOperation
extends JavaModelOperation {
    protected String fName;

    public CreatePackageFragmentOperation(IPackageFragmentRoot parentElement, String packageName, boolean force) {
        super(null, new IJavaElement[]{parentElement}, force);
        this.fName = packageName;
    }

    protected void executeOperation() throws JavaModelException {
        JavaElementDelta delta = null;
        IPackageFragmentRoot root = (IPackageFragmentRoot)this.getParentElement();
        String[] names = Util.getTrimmedSimpleNames(this.fName);
        this.beginTask(Util.bind("operation.createPackageFragmentProgress"), names.length);
        IContainer parentFolder = (IContainer)root.getResource();
        String sideEffectPackageName = "";
        ArrayList<IPackageFragment> results = new ArrayList<IPackageFragment>(names.length);
        char[][] inclusionPatterns = ((PackageFragmentRoot)root).fullInclusionPatternChars();
        char[][] exclusionPatterns = ((PackageFragmentRoot)root).fullExclusionPatternChars();
        int i = 0;
        while (i < names.length) {
            String subFolderName = names[i];
            sideEffectPackageName = String.valueOf(sideEffectPackageName) + subFolderName;
            IResource subFolder = parentFolder.findMember(subFolderName);
            if (subFolder == null) {
                this.createFolder(parentFolder, subFolderName, this.force);
                parentFolder = parentFolder.getFolder(new Path(subFolderName));
                IPackageFragment addedFrag = root.getPackageFragment(sideEffectPackageName);
                if (!Util.isExcluded(parentFolder, inclusionPatterns, exclusionPatterns)) {
                    if (delta == null) {
                        delta = this.newJavaElementDelta();
                    }
                    delta.added(addedFrag);
                }
                results.add(addedFrag);
            } else {
                parentFolder = (IContainer)subFolder;
            }
            sideEffectPackageName = String.valueOf(sideEffectPackageName) + '.';
            this.worked(1);
            ++i;
        }
        if (results.size() > 0) {
            this.resultElements = new IJavaElement[results.size()];
            results.toArray(this.resultElements);
            if (delta != null) {
                this.addDelta(delta);
            }
        }
        this.done();
    }

    public IJavaModelStatus verify() {
        if (this.getParentElement() == null) {
            return new JavaModelStatus(968);
        }
        if (this.fName == null || this.fName.length() > 0 && JavaConventions.validatePackageName(this.fName).getSeverity() == 4) {
            return new JavaModelStatus(983, this.fName);
        }
        IPackageFragmentRoot root = (IPackageFragmentRoot)this.getParentElement();
        if (root.isReadOnly()) {
            return new JavaModelStatus(976, root);
        }
        String[] names = Util.getTrimmedSimpleNames(this.fName);
        IContainer parentFolder = (IContainer)root.getResource();
        int i = 0;
        while (i < names.length) {
            IResource subFolder = parentFolder.findMember(names[i]);
            if (subFolder != null) {
                if (subFolder.getType() != 2) {
                    return new JavaModelStatus(977, Util.bind("status.nameCollision", subFolder.getFullPath().toString()));
                }
                parentFolder = (IContainer)subFolder;
            }
            ++i;
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

