/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IProblemRequestor;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.codeassist.CompletionEngine;
import org.eclipse.jdt.internal.codeassist.SelectionEngine;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.core.BufferManager;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.DeltaProcessingState;
import org.eclipse.jdt.internal.core.DeltaProcessor;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaElementDeltaBuilder;
import org.eclipse.jdt.internal.core.JavaElementInfo;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelCache;
import org.eclipse.jdt.internal.core.JavaModelOperation;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.SetClasspathOperation;
import org.eclipse.jdt.internal.core.builder.JavaBuilder;
import org.eclipse.jdt.internal.core.builder.State;
import org.eclipse.jdt.internal.core.hierarchy.TypeHierarchy;
import org.eclipse.jdt.internal.core.search.AbstractSearchScope;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.search.processing.JobManager;
import org.eclipse.jdt.internal.core.util.Util;

public class JavaModelManager
implements ISaveParticipant {
    final JavaModel javaModel = new JavaModel();
    public HashMap variables = new HashMap(5);
    public HashMap previousSessionVariables = new HashMap(5);
    private ThreadLocal variableInitializationInProgress = new ThreadLocal();
    public HashMap containers = new HashMap(5);
    public HashMap previousSessionContainers = new HashMap(5);
    private ThreadLocal containerInitializationInProgress = new ThreadLocal();
    public boolean batchContainerInitializations = true;
    private ThreadLocal classpathsBeingResolved = new ThreadLocal();
    public static final String CP_VARIABLE_PREFERENCES_PREFIX = "org.eclipse.ajdt.core.plugin.classpathVariable.";
    public static final String CP_CONTAINER_PREFERENCES_PREFIX = "org.eclipse.ajdt.core.plugin.classpathContainer.";
    public static final String CP_ENTRY_IGNORE = "##<cp entry ignore>##";
    public static final String CPVARIABLE_INITIALIZER_EXTPOINT_ID = "classpathVariableInitializer";
    public static final String CPCONTAINER_INITIALIZER_EXTPOINT_ID = "classpathContainerInitializer";
    public static final String FORMATTER_EXTPOINT_ID = "codeFormatter";
    public static final IPath VARIABLE_INITIALIZATION_IN_PROGRESS = new Path("Variable Initialization In Progress");
    public static final IClasspathContainer CONTAINER_INITIALIZATION_IN_PROGRESS = new IClasspathContainer(){

        public IClasspathEntry[] getClasspathEntries() {
            return null;
        }

        public String getDescription() {
            return "Container Initialization In Progress";
        }

        public int getKind() {
            return 0;
        }

        public IPath getPath() {
            return null;
        }

        public String toString() {
            return this.getDescription();
        }
    };
    private static final String BUFFER_MANAGER_DEBUG = "org.eclipse.ajdt.core.plugin/debug/buffermanager";
    private static final String INDEX_MANAGER_DEBUG = "org.eclipse.ajdt.core.plugin/debug/indexmanager";
    private static final String COMPILER_DEBUG = "org.eclipse.ajdt.core.plugin/debug/compiler";
    private static final String JAVAMODEL_DEBUG = "org.eclipse.ajdt.core.plugin/debug/javamodel";
    private static final String CP_RESOLVE_DEBUG = "org.eclipse.ajdt.core.plugin/debug/cpresolution";
    private static final String ZIP_ACCESS_DEBUG = "org.eclipse.ajdt.core.plugin/debug/zipaccess";
    private static final String DELTA_DEBUG = "org.eclipse.ajdt.core.plugin/debug/javadelta";
    private static final String DELTA_DEBUG_VERBOSE = "org.eclipse.ajdt.core.plugin/debug/javadelta/verbose";
    private static final String HIERARCHY_DEBUG = "org.eclipse.ajdt.core.plugin/debug/hierarchy";
    private static final String POST_ACTION_DEBUG = "org.eclipse.ajdt.core.plugin/debug/postaction";
    private static final String BUILDER_DEBUG = "org.eclipse.ajdt.core.plugin/debug/builder";
    private static final String COMPLETION_DEBUG = "org.eclipse.ajdt.core.plugin/debug/completion";
    private static final String SELECTION_DEBUG = "org.eclipse.ajdt.core.plugin/debug/selection";
    private static final String SEARCH_DEBUG = "org.eclipse.ajdt.core.plugin/debug/search";
    public static final ICompilationUnit[] NO_WORKING_COPY = new ICompilationUnit[0];
    public HashSet optionNames = new HashSet(20);
    private static final JavaModelManager MANAGER = new JavaModelManager();
    protected JavaModelCache cache = new JavaModelCache();
    private ThreadLocal temporaryCache = new ThreadLocal();
    protected Map elementsOutOfSynchWithBuffers = new HashMap(11);
    public DeltaProcessingState deltaState = new DeltaProcessingState();
    public IndexManager indexManager = new IndexManager();
    protected Map perProjectInfos = new HashMap(5);
    protected Map perWorkingCopyInfos = new HashMap(5);
    protected WeakHashMap searchScopes = new WeakHashMap();
    public static boolean VERBOSE = false;
    public static boolean CP_RESOLVE_VERBOSE = false;
    public static boolean ZIP_ACCESS_VERBOSE = false;
    private ThreadLocal zipFiles = new ThreadLocal();

    public static boolean conflictsWithOutputLocation(IPath folderPath, JavaProject project) {
        try {
            IPath outputLocation = project.getOutputLocation();
            if (outputLocation == null) {
                return true;
            }
            if (outputLocation.isPrefixOf(folderPath)) {
                IClasspathEntry[] classpath = project.getResolvedClasspath(true, false, false);
                boolean isOutputUsed = false;
                int i = 0;
                int length = classpath.length;
                while (i < length) {
                    IClasspathEntry entry = classpath[i];
                    if (entry.getEntryKind() == 3) {
                        if (entry.getPath().equals(outputLocation)) {
                            return false;
                        }
                        if (entry.getOutputLocation() == null) {
                            isOutputUsed = true;
                        }
                    }
                    ++i;
                }
                return isOutputUsed;
            }
            return false;
        }
        catch (JavaModelException e) {
            return true;
        }
    }

    public synchronized IClasspathContainer containerGet(IJavaProject project, IPath containerPath) {
        HashSet projectInitializations = this.containerInitializationInProgress(project);
        if (projectInitializations.contains(containerPath)) {
            return CONTAINER_INITIALIZATION_IN_PROGRESS;
        }
        Map projectContainers = (Map)this.containers.get(project);
        if (projectContainers == null) {
            return null;
        }
        IClasspathContainer container = (IClasspathContainer)projectContainers.get(containerPath);
        return container;
    }

    private synchronized Map containerClone(IJavaProject project) {
        Map originalProjectContainers = (Map)this.containers.get(project);
        if (originalProjectContainers == null) {
            return null;
        }
        HashMap projectContainers = new HashMap(originalProjectContainers.size());
        projectContainers.putAll(originalProjectContainers);
        return projectContainers;
    }

    private HashSet containerInitializationInProgress(IJavaProject project) {
        HashSet projectInitializations;
        HashMap initializations = (HashMap)this.containerInitializationInProgress.get();
        if (initializations == null) {
            initializations = new HashMap();
            this.containerInitializationInProgress.set(initializations);
        }
        if ((projectInitializations = (HashSet)initializations.get(project)) == null) {
            projectInitializations = new HashSet();
            initializations.put(project, projectInitializations);
        }
        return projectInitializations;
    }

    public synchronized void containerPut(IJavaProject project, IPath containerPath, IClasspathContainer container) {
        HashMap<IPath, IClasspathContainer> projectContainers;
        HashSet projectInitializations = this.containerInitializationInProgress(project);
        if (container == CONTAINER_INITIALIZATION_IN_PROGRESS) {
            projectInitializations.add(containerPath);
            return;
        }
        projectInitializations.remove(containerPath);
        if (projectInitializations.size() == 0) {
            Map initializations = (Map)this.containerInitializationInProgress.get();
            initializations.remove(project);
        }
        if ((projectContainers = (HashMap<IPath, IClasspathContainer>)this.containers.get(project)) == null) {
            projectContainers = new HashMap<IPath, IClasspathContainer>(1);
            this.containers.put(project, projectContainers);
        }
        if (container == null) {
            projectContainers.remove(containerPath);
        } else {
            projectContainers.put(containerPath, container);
        }
        Map previousContainers = (Map)this.previousSessionContainers.get(project);
        if (previousContainers != null) {
            previousContainers.remove(containerPath);
        }
    }

    private synchronized void containersReset(String[] containerIDs) {
        int i = 0;
        while (i < containerIDs.length) {
            String containerID = containerIDs[i];
            Iterator projectIterator = this.containers.keySet().iterator();
            while (projectIterator.hasNext()) {
                IJavaProject project = (IJavaProject)projectIterator.next();
                Map projectContainers = (Map)this.containers.get(project);
                if (projectContainers == null) continue;
                Iterator containerIterator = projectContainers.keySet().iterator();
                while (containerIterator.hasNext()) {
                    IPath containerPath = (IPath)containerIterator.next();
                    if (!containerPath.segment(0).equals(containerID)) continue;
                    projectContainers.put(containerPath, null);
                }
            }
            ++i;
        }
    }

    public static IJavaElement create(IResource resource, IJavaProject project) {
        if (resource == null) {
            return null;
        }
        int type = resource.getType();
        switch (type) {
            case 4: {
                return JavaCore.create((IProject)resource);
            }
            case 1: {
                return JavaModelManager.create((IFile)resource, project);
            }
            case 2: {
                return JavaModelManager.create((IFolder)resource, project);
            }
            case 8: {
                return JavaCore.create((IWorkspaceRoot)resource);
            }
        }
        return null;
    }

    public static IJavaElement create(IFile file, IJavaProject project) {
        if (file == null) {
            return null;
        }
        if (project == null) {
            project = JavaCore.create(file.getProject());
        }
        if (file.getFileExtension() != null) {
            String name = file.getName();
            if (org.eclipse.jdt.internal.compiler.util.Util.isJavaFileName(name)) {
                return JavaModelManager.createCompilationUnitFrom(file, project);
            }
            if (org.eclipse.jdt.internal.compiler.util.Util.isClassFileName(name)) {
                return JavaModelManager.createClassFileFrom(file, project);
            }
            if (org.eclipse.jdt.internal.compiler.util.Util.isArchiveFileName(name)) {
                return JavaModelManager.createJarPackageFragmentRootFrom(file, project);
            }
        }
        return null;
    }

    public static IJavaElement create(IFolder folder, IJavaProject project) {
        if (folder == null) {
            return null;
        }
        if (project == null) {
            project = JavaCore.create(folder.getProject());
        }
        IJavaElement element = JavaModelManager.determineIfOnClasspath(folder, project);
        if (JavaModelManager.conflictsWithOutputLocation(folder.getFullPath(), (JavaProject)project) || folder.getName().indexOf(46) >= 0 && !(element instanceof IPackageFragmentRoot)) {
            return null;
        }
        return element;
    }

    public static IClassFile createClassFileFrom(IFile file, IJavaProject project) {
        IPackageFragment pkg;
        if (file == null) {
            return null;
        }
        if (project == null) {
            project = JavaCore.create(file.getProject());
        }
        if ((pkg = (IPackageFragment)JavaModelManager.determineIfOnClasspath(file, project)) == null) {
            IPackageFragmentRoot root = project.getPackageFragmentRoot(file.getParent());
            pkg = root.getPackageFragment("");
        }
        return pkg.getClassFile(file.getName());
    }

    public static ICompilationUnit createCompilationUnitFrom(IFile file, IJavaProject project) {
        IPackageFragment pkg;
        if (file == null) {
            return null;
        }
        if (project == null) {
            project = JavaCore.create(file.getProject());
        }
        if ((pkg = (IPackageFragment)JavaModelManager.determineIfOnClasspath(file, project)) == null) {
            IPackageFragmentRoot root = project.getPackageFragmentRoot(file.getParent());
            pkg = root.getPackageFragment("");
            if (VERBOSE) {
                System.out.println("WARNING : creating unit element outside classpath (" + Thread.currentThread() + "): " + file.getFullPath());
            }
        }
        return pkg.getCompilationUnit(file.getName());
    }

    public static IPackageFragmentRoot createJarPackageFragmentRootFrom(IFile file, IJavaProject project) {
        if (file == null) {
            return null;
        }
        if (project == null) {
            project = JavaCore.create(file.getProject());
        }
        IPath resourcePath = file.getFullPath();
        try {
            IClasspathEntry[] entries = ((JavaProject)project).getResolvedClasspath(true, false, false);
            int i = 0;
            int length = entries.length;
            while (i < length) {
                IClasspathEntry entry = entries[i];
                IPath rootPath = entry.getPath();
                if (rootPath.equals(resourcePath)) {
                    return project.getPackageFragmentRoot(file);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return null;
    }

    public static IJavaElement determineIfOnClasspath(IResource resource, IJavaProject project) {
        IPath resourcePath = resource.getFullPath();
        try {
            IClasspathEntry[] entries = org.eclipse.jdt.internal.compiler.util.Util.isJavaFileName(resourcePath.lastSegment()) ? project.getRawClasspath() : ((JavaProject)project).getResolvedClasspath(true, false, false);
            int i = 0;
            while (i < entries.length) {
                IClasspathEntry entry = entries[i];
                if (entry.getEntryKind() != 2) {
                    IPath rootPath = entry.getPath();
                    if (rootPath.equals(resourcePath)) {
                        return project.getPackageFragmentRoot(resource);
                    }
                    if (rootPath.isPrefixOf(resourcePath) && !Util.isExcluded(resource, ((ClasspathEntry)entry).fullInclusionPatternChars(), ((ClasspathEntry)entry).fullExclusionPatternChars())) {
                        String pkgName;
                        IPackageFragmentRoot root = ((JavaProject)project).getFolderPackageFragmentRoot(rootPath);
                        if (root == null) {
                            return null;
                        }
                        IPath pkgPath = resourcePath.removeFirstSegments(rootPath.segmentCount());
                        if (resource.getType() == 1) {
                            pkgPath = pkgPath.removeLastSegments(1);
                        }
                        if ((pkgName = Util.packageName(pkgPath)) == null || JavaConventions.validatePackageName(pkgName).getSeverity() == 4) {
                            return null;
                        }
                        return root.getPackageFragment(pkgName);
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException npe) {
            return null;
        }
        return null;
    }

    private JavaModelManager() {
    }

    public void cacheZipFiles() {
        if (this.zipFiles.get() != null) {
            return;
        }
        this.zipFiles.set(new HashMap());
    }

    public void closeZipFile(ZipFile zipFile) {
        if (zipFile == null) {
            return;
        }
        if (this.zipFiles.get() != null) {
            return;
        }
        try {
            if (ZIP_ACCESS_VERBOSE) {
                System.out.println("(" + Thread.currentThread() + ") [JavaModelManager.closeZipFile(ZipFile)] Closing ZipFile on " + zipFile.getName());
            }
            zipFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void configurePluginDebugOptions() {
        if (JavaCore.getPlugin().isDebugging()) {
            String option = Platform.getDebugOption(BUFFER_MANAGER_DEBUG);
            if (option != null) {
                BufferManager.VERBOSE = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption(BUILDER_DEBUG)) != null) {
                JavaBuilder.DEBUG = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption(COMPILER_DEBUG)) != null) {
                Compiler.DEBUG = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption(COMPLETION_DEBUG)) != null) {
                CompletionEngine.DEBUG = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption(CP_RESOLVE_DEBUG)) != null) {
                CP_RESOLVE_VERBOSE = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption(DELTA_DEBUG)) != null) {
                DeltaProcessor.DEBUG = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption(DELTA_DEBUG_VERBOSE)) != null) {
                DeltaProcessor.VERBOSE = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption(HIERARCHY_DEBUG)) != null) {
                TypeHierarchy.DEBUG = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption(INDEX_MANAGER_DEBUG)) != null) {
                JobManager.VERBOSE = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption(JAVAMODEL_DEBUG)) != null) {
                VERBOSE = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption(POST_ACTION_DEBUG)) != null) {
                JavaModelOperation.POST_ACTION_VERBOSE = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption(SEARCH_DEBUG)) != null) {
                SearchEngine.VERBOSE = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption(SELECTION_DEBUG)) != null) {
                SelectionEngine.DEBUG = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption(ZIP_ACCESS_DEBUG)) != null) {
                ZIP_ACCESS_VERBOSE = option.equalsIgnoreCase("true");
            }
        }
    }

    public int discardPerWorkingCopyInfo(CompilationUnit workingCopy) throws JavaModelException {
        JavaElementDeltaBuilder deltaBuilder = null;
        if (workingCopy.isPrimary()) {
            deltaBuilder = new JavaElementDeltaBuilder(workingCopy);
        }
        PerWorkingCopyInfo info = null;
        Map map = this.perWorkingCopyInfos;
        synchronized (map) {
            Map workingCopyToInfos;
            WorkingCopyOwner owner;
            block12: {
                block11: {
                    owner = workingCopy.owner;
                    workingCopyToInfos = (Map)this.perWorkingCopyInfos.get(owner);
                    if (workingCopyToInfos != null) break block11;
                    return -1;
                }
                info = (PerWorkingCopyInfo)workingCopyToInfos.get(workingCopy);
                if (info != null) break block12;
                return -1;
            }
            if (--info.useCount == 0) {
                workingCopyToInfos.remove(workingCopy);
                if (workingCopyToInfos.isEmpty()) {
                    this.perWorkingCopyInfos.remove(owner);
                }
            }
        }
        if (info.useCount == 0) {
            this.removeInfoAndChildren(workingCopy);
            workingCopy.closeBuffer();
            if (deltaBuilder != null) {
                deltaBuilder.buildDeltas();
                if (deltaBuilder.delta != null && deltaBuilder.delta.getAffectedChildren().length > 0) {
                    this.getDeltaProcessor().registerJavaModelDelta(deltaBuilder.delta);
                }
            }
        }
        return info.useCount;
    }

    public void doneSaving(ISaveContext context) {
    }

    public void flushZipFiles() {
        Thread currentThread = Thread.currentThread();
        HashMap map = (HashMap)this.zipFiles.get();
        if (map == null) {
            return;
        }
        this.zipFiles.set(null);
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            try {
                ZipFile zipFile = (ZipFile)iterator.next();
                if (ZIP_ACCESS_VERBOSE) {
                    System.out.println("(" + currentThread + ") [JavaModelManager.flushZipFiles()] Closing ZipFile on " + zipFile.getName());
                }
                zipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public IClasspathContainer getClasspathContainer(IPath containerPath, IJavaProject project) throws JavaModelException {
        IClasspathContainer container = this.containerGet(project, containerPath);
        if (container == null) {
            if (this.batchContainerInitializations) {
                this.batchContainerInitializations = false;
                return this.initializeAllContainers(project, containerPath);
            }
            return this.initializeContainer(project, containerPath);
        }
        return container;
    }

    public DeltaProcessor getDeltaProcessor() {
        return this.deltaState.getDeltaProcessor();
    }

    protected Map getElementsOutOfSynchWithBuffers() {
        return this.elementsOutOfSynchWithBuffers;
    }

    public IndexManager getIndexManager() {
        return this.indexManager;
    }

    public synchronized Object getInfo(IJavaElement element) {
        Object result;
        HashMap tempCache = (HashMap)this.temporaryCache.get();
        if (tempCache != null && (result = tempCache.get(element)) != null) {
            return result;
        }
        return this.cache.getInfo(element);
    }

    public final JavaModel getJavaModel() {
        return this.javaModel;
    }

    public static final JavaModelManager getJavaModelManager() {
        return MANAGER;
    }

    public Object getLastBuiltState(IProject project, IProgressMonitor monitor) {
        if (!JavaProject.hasJavaNature(project)) {
            return null;
        }
        PerProjectInfo info = this.getPerProjectInfo(project, true);
        if (!info.triedRead) {
            info.triedRead = true;
            try {
                if (monitor != null) {
                    monitor.subTask(Util.bind("build.readStateProgress", project.getName()));
                }
                info.savedState = this.readState(project);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return info.savedState;
    }

    public PerProjectInfo getPerProjectInfo(IProject project, boolean create) {
        Map map = this.perProjectInfos;
        synchronized (map) {
            PerProjectInfo info = (PerProjectInfo)this.perProjectInfos.get(project);
            if (info == null && create) {
                info = new PerProjectInfo(project);
                this.perProjectInfos.put(project, info);
            }
            return info;
        }
    }

    public PerProjectInfo getPerProjectInfoCheckExistence(IProject project) throws JavaModelException {
        PerProjectInfo info = this.getPerProjectInfo(project, false);
        if (info == null) {
            if (!JavaProject.hasJavaNature(project)) {
                throw ((JavaProject)JavaCore.create(project)).newNotPresentException();
            }
            info = this.getPerProjectInfo(project, true);
        }
        return info;
    }

    public PerWorkingCopyInfo getPerWorkingCopyInfo(CompilationUnit workingCopy, boolean create, boolean recordUsage, IProblemRequestor problemRequestor) {
        Map map = this.perWorkingCopyInfos;
        synchronized (map) {
            PerWorkingCopyInfo info;
            WorkingCopyOwner owner = workingCopy.owner;
            HashMap<CompilationUnit, PerWorkingCopyInfo> workingCopyToInfos = (HashMap<CompilationUnit, PerWorkingCopyInfo>)this.perWorkingCopyInfos.get(owner);
            if (workingCopyToInfos == null && create) {
                workingCopyToInfos = new HashMap<CompilationUnit, PerWorkingCopyInfo>();
                this.perWorkingCopyInfos.put(owner, workingCopyToInfos);
            }
            PerWorkingCopyInfo perWorkingCopyInfo = info = workingCopyToInfos == null ? null : (PerWorkingCopyInfo)workingCopyToInfos.get(workingCopy);
            if (info == null && create) {
                info = new PerWorkingCopyInfo(workingCopy, problemRequestor);
                workingCopyToInfos.put(workingCopy, info);
            }
            if (info != null && recordUsage) {
                ++info.useCount;
            }
            return info;
        }
    }

    public IClasspathContainer getPreviousSessionContainer(IPath containerPath, IJavaProject project) {
        IClasspathContainer previousContainer;
        Map previousContainerValues = (Map)this.previousSessionContainers.get(project);
        if (previousContainerValues != null && (previousContainer = (IClasspathContainer)previousContainerValues.get(containerPath)) != null) {
            if (CP_RESOLVE_VERBOSE) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("CPContainer INIT - reentering access to project container during its initialization, will see previous value\n");
                buffer.append("\tproject: " + project.getElementName() + '\n');
                buffer.append("\tcontainer path: " + containerPath + '\n');
                buffer.append("\tprevious value: ");
                buffer.append(previousContainer.getDescription());
                buffer.append(" {\n");
                IClasspathEntry[] entries = previousContainer.getClasspathEntries();
                if (entries != null) {
                    int j = 0;
                    while (j < entries.length) {
                        buffer.append(" \t\t");
                        buffer.append(entries[j]);
                        buffer.append('\n');
                        ++j;
                    }
                }
                buffer.append(" \t}");
                Util.verbose(buffer.toString());
                new Exception("<Fake exception>").printStackTrace(System.out);
            }
            return previousContainer;
        }
        return null;
    }

    public IPath getPreviousSessionVariable(String variableName) {
        IPath previousPath = (IPath)this.previousSessionVariables.get(variableName);
        if (previousPath != null) {
            if (CP_RESOLVE_VERBOSE) {
                Util.verbose("CPVariable INIT - reentering access to variable during its initialization, will see previous value\n\tvariable: " + variableName + '\n' + "\tprevious value: " + previousPath);
                new Exception("<Fake exception>").printStackTrace(System.out);
            }
            return previousPath;
        }
        return null;
    }

    public HashMap getTemporaryCache() {
        HashMap result = (HashMap)this.temporaryCache.get();
        if (result == null) {
            result = new HashMap();
            this.temporaryCache.set(result);
        }
        return result;
    }

    public static String[] getRegisteredVariableNames() {
        Plugin jdtCorePlugin = JavaCore.getPlugin();
        if (jdtCorePlugin == null) {
            return null;
        }
        ArrayList<String> variableList = new ArrayList<String>(5);
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ajdt.core.plugin", CPVARIABLE_INITIALIZER_EXTPOINT_ID);
        if (extension != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    String varAttribute = configElements[j].getAttribute("variable");
                    if (varAttribute != null) {
                        variableList.add(varAttribute);
                    }
                    ++j;
                }
                ++i;
            }
        }
        String[] variableNames = new String[variableList.size()];
        variableList.toArray(variableNames);
        return variableNames;
    }

    public static String[] getRegisteredContainerIDs() {
        Plugin jdtCorePlugin = JavaCore.getPlugin();
        if (jdtCorePlugin == null) {
            return null;
        }
        ArrayList<String> containerIDList = new ArrayList<String>(5);
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ajdt.core.plugin", CPCONTAINER_INITIALIZER_EXTPOINT_ID);
        if (extension != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    String idAttribute = configElements[j].getAttribute("id");
                    if (idAttribute != null) {
                        containerIDList.add(idAttribute);
                    }
                    ++j;
                }
                ++i;
            }
        }
        String[] containerIDs = new String[containerIDList.size()];
        containerIDList.toArray(containerIDs);
        return containerIDs;
    }

    private File getSerializationFile(IProject project) {
        if (!project.exists()) {
            return null;
        }
        IPath workingLocation = project.getWorkingLocation("org.eclipse.ajdt.core.plugin");
        return workingLocation.append("state.dat").toFile();
    }

    public ICompilationUnit[] getWorkingCopies(WorkingCopyOwner owner, boolean addPrimary) {
        Map map = this.perWorkingCopyInfos;
        synchronized (map) {
            ICompilationUnit[] primaryWCs = addPrimary && owner != DefaultWorkingCopyOwner.PRIMARY ? this.getWorkingCopies(DefaultWorkingCopyOwner.PRIMARY, false) : null;
            Map workingCopyToInfos = (Map)this.perWorkingCopyInfos.get(owner);
            if (workingCopyToInfos == null) {
                return primaryWCs;
            }
            int primaryLength = primaryWCs == null ? 0 : primaryWCs.length;
            int size = workingCopyToInfos.size();
            ICompilationUnit[] result = new ICompilationUnit[primaryLength + size];
            if (primaryWCs != null) {
                System.arraycopy(primaryWCs, 0, result, 0, primaryLength);
            }
            Iterator iterator = workingCopyToInfos.values().iterator();
            int index = primaryLength;
            while (iterator.hasNext()) {
                result[index++] = ((PerWorkingCopyInfo)iterator.next()).getWorkingCopy();
            }
            return result;
        }
    }

    public ZipFile getZipFile(IPath path) throws CoreException {
        ZipFile zipFile;
        HashMap map = (HashMap)this.zipFiles.get();
        if (map != null && (zipFile = (ZipFile)map.get(path)) != null) {
            return zipFile;
        }
        String fileSystemPath = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource file = root.findMember(path);
        if (file != null) {
            IPath location;
            if (file.getType() != 1 || (location = file.getLocation()) == null) {
                throw new CoreException(new Status(4, "org.eclipse.ajdt.core.plugin", -1, Util.bind("file.notFound", path.toString()), null));
            }
            fileSystemPath = location.toOSString();
        } else {
            fileSystemPath = path.toOSString();
        }
        try {
            if (ZIP_ACCESS_VERBOSE) {
                System.out.println("(" + Thread.currentThread() + ") [JavaModelManager.getZipFile(IPath)] Creating ZipFile on " + fileSystemPath);
            }
            zipFile = new ZipFile(fileSystemPath);
            if (map != null) {
                map.put(path, zipFile);
            }
            return zipFile;
        }
        catch (IOException e) {
            throw new CoreException(new Status(4, "org.eclipse.ajdt.core.plugin", -1, Util.bind("status.IOException"), e));
        }
    }

    public boolean hasTemporaryCache() {
        return this.temporaryCache.get() != null;
    }

    /*
     * Exception decompiling
     */
    private IClasspathContainer initializeAllContainers(IJavaProject javaProjectToInit, IPath containerToInit) throws JavaModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 434->437)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private IClasspathContainer initializeContainer(IJavaProject project, IPath containerPath) throws JavaModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [5 : 366->369)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private HashSet getClasspathBeingResolved() {
        HashSet result = (HashSet)this.classpathsBeingResolved.get();
        if (result == null) {
            result = new HashSet();
            this.classpathsBeingResolved.set(result);
        }
        return result;
    }

    public boolean isClasspathBeingResolved(IJavaProject project) {
        return this.getClasspathBeingResolved().contains(project);
    }

    public void setClasspathBeingResolved(IJavaProject project, boolean classpathIsResolved) {
        if (classpathIsResolved) {
            this.getClasspathBeingResolved().add(project);
        } else {
            this.getClasspathBeingResolved().remove(project);
        }
    }

    /*
     * Exception decompiling
     */
    public void loadVariablesAndContainers() throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [4 : 107->110)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected synchronized Object peekAtInfo(IJavaElement element) {
        Object result;
        HashMap tempCache = (HashMap)this.temporaryCache.get();
        if (tempCache != null && (result = tempCache.get(element)) != null) {
            return result;
        }
        return this.cache.peekAtInfo(element);
    }

    public void prepareToSave(ISaveContext context) {
    }

    protected synchronized void putInfos(IJavaElement openedElement, Map newElements) {
        Object existingInfo = this.cache.peekAtInfo(openedElement);
        if (openedElement instanceof IParent && existingInfo instanceof JavaElementInfo) {
            IJavaElement[] children = ((JavaElementInfo)existingInfo).getChildren();
            int i = 0;
            int size = children.length;
            while (i < size) {
                JavaElement child = (JavaElement)children[i];
                try {
                    child.close();
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
                ++i;
            }
        }
        Iterator iterator = newElements.keySet().iterator();
        while (iterator.hasNext()) {
            IJavaElement element = (IJavaElement)iterator.next();
            Object info = newElements.get(element);
            this.cache.putInfo(element, info);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object readState(IProject project) throws CoreException {
        File file = this.getSerializationFile(project);
        if (file == null) return null;
        if (!file.exists()) return null;
        try {
            DataInputStream in;
            block10: {
                State state;
                block9: {
                    in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                    try {
                        String pluginID = in.readUTF();
                        if (!pluginID.equals("org.eclipse.ajdt.core.plugin")) {
                            throw new IOException(Util.bind("build.wrongFileFormat"));
                        }
                        String kind = in.readUTF();
                        if (!kind.equals("STATE")) {
                            throw new IOException(Util.bind("build.wrongFileFormat"));
                        }
                        if (in.readBoolean()) {
                            state = JavaBuilder.readState(project, in);
                            Object var6_8 = null;
                            break block9;
                        }
                        if (JavaBuilder.DEBUG) {
                            System.out.println("Saved state thinks last build failed for " + project.getName());
                        }
                        break block10;
                    }
                    catch (Throwable throwable) {
                        Object var6_9 = null;
                        in.close();
                        throw throwable;
                    }
                }
                in.close();
                return state;
            }
            Object var6_10 = null;
            in.close();
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CoreException(new Status(4, "org.eclipse.ajdt.core.plugin", 2, "Error reading last build state for project " + project.getName(), e));
        }
    }

    public static void recreatePersistedContainer(String propertyName, String containerString, boolean addToContainerValues) {
        int containerPrefixLength = CP_CONTAINER_PREFERENCES_PREFIX.length();
        int index = propertyName.indexOf(124, containerPrefixLength);
        if (containerString != null) {
            containerString = containerString.trim();
        }
        if (index > 0) {
            final String projectName = propertyName.substring(containerPrefixLength, index).trim();
            JavaProject project = (JavaProject)JavaModelManager.getJavaModelManager().getJavaModel().getJavaProject(projectName);
            final Path containerPath = new Path(propertyName.substring(index + 1).trim());
            if (containerString == null || containerString.equals(CP_ENTRY_IGNORE)) {
                JavaModelManager.getJavaModelManager().containerPut(project, containerPath, null);
            } else {
                final IClasspathEntry[] containerEntries = project.decodeClasspath(containerString, false, false);
                if (containerEntries != null && containerEntries != JavaProject.INVALID_CLASSPATH) {
                    HashMap<Path, 2> projectContainers;
                    IClasspathContainer container = new IClasspathContainer(){

                        public IClasspathEntry[] getClasspathEntries() {
                            return containerEntries;
                        }

                        public String getDescription() {
                            return "Persisted container [" + containerPath + " for project [" + projectName + "]";
                        }

                        public int getKind() {
                            return 0;
                        }

                        public IPath getPath() {
                            return containerPath;
                        }

                        public String toString() {
                            return this.getDescription();
                        }
                    };
                    if (addToContainerValues) {
                        JavaModelManager.getJavaModelManager().containerPut(project, containerPath, container);
                    }
                    if ((projectContainers = (HashMap<Path, 2>)JavaModelManager.getJavaModelManager().previousSessionContainers.get(project)) == null) {
                        projectContainers = new HashMap<Path, 2>(1);
                        JavaModelManager.getJavaModelManager().previousSessionContainers.put(project, projectContainers);
                    }
                    projectContainers.put(containerPath, container);
                }
            }
        }
    }

    public void rememberScope(AbstractSearchScope scope) {
        this.searchScopes.put(scope, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Object removeInfoAndChildren(JavaElement element) throws JavaModelException {
        Object info = this.cache.peekAtInfo(element);
        if (info == null) {
            return null;
        }
        boolean wasVerbose = false;
        try {
            if (VERBOSE) {
                System.out.println("CLOSING Element (" + Thread.currentThread() + "): " + element.toStringWithAncestors());
                wasVerbose = true;
                VERBOSE = false;
            }
            element.closing(info);
            if (element instanceof IParent && info instanceof JavaElementInfo) {
                IJavaElement[] children = ((JavaElementInfo)info).getChildren();
                int i = 0;
                int size = children.length;
                while (i < size) {
                    JavaElement child = (JavaElement)children[i];
                    child.close();
                    ++i;
                }
            }
            this.cache.removeInfo(element);
            if (wasVerbose) {
                System.out.println("-> Package cache size = " + this.cache.pkgSize());
                System.out.println("-> Openable cache filling ratio = " + NumberFormat.getInstance().format(this.cache.openableFillingRatio()) + "%");
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            VERBOSE = wasVerbose;
            throw throwable;
        }
        {
            Object var8_10 = null;
            VERBOSE = wasVerbose;
            return info;
        }
    }

    public void removePerProjectInfo(JavaProject javaProject) {
        Map map = this.perProjectInfos;
        synchronized (map) {
            IProject project = javaProject.getProject();
            PerProjectInfo info = (PerProjectInfo)this.perProjectInfos.get(project);
            if (info != null) {
                this.perProjectInfos.remove(project);
            }
        }
    }

    public void resetTemporaryCache() {
        this.temporaryCache.set(null);
    }

    public void rollback(ISaveContext context) {
    }

    private void saveState(PerProjectInfo info, ISaveContext context) throws CoreException {
        if (context.getKind() == 2) {
            return;
        }
        if (info.triedRead) {
            this.saveBuiltState(info);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveBuiltState(PerProjectInfo info) throws CoreException {
        File file;
        if (JavaBuilder.DEBUG) {
            System.out.println(Util.bind("build.saveStateProgress", info.project.getName()));
        }
        if ((file = this.getSerializationFile(info.project)) == null) {
            return;
        }
        long t = System.currentTimeMillis();
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            try {
                out.writeUTF("org.eclipse.ajdt.core.plugin");
                out.writeUTF("STATE");
                if (info.savedState == null) {
                    out.writeBoolean(false);
                } else {
                    out.writeBoolean(true);
                    JavaBuilder.writeState(info.savedState, out);
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                out.close();
                throw throwable;
            }
            {
                Object var6_9 = null;
                out.close();
            }
        }
        catch (RuntimeException e) {
            try {
                file.delete();
                throw new CoreException(new Status(4, "org.eclipse.ajdt.core.plugin", 2, Util.bind("build.cannotSaveState", info.project.getName()), e));
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            throw new CoreException(new Status(4, "org.eclipse.ajdt.core.plugin", 2, Util.bind("build.cannotSaveState", info.project.getName()), e));
        }
        catch (IOException e) {
            try {
                file.delete();
                throw new CoreException(new Status(4, "org.eclipse.ajdt.core.plugin", 2, Util.bind("build.cannotSaveState", info.project.getName()), e));
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            throw new CoreException(new Status(4, "org.eclipse.ajdt.core.plugin", 2, Util.bind("build.cannotSaveState", info.project.getName()), e));
        }
        if (!JavaBuilder.DEBUG) return;
        t = System.currentTimeMillis() - t;
        System.out.println(Util.bind("build.saveStateComplete", String.valueOf(t)));
    }

    public void saving(ISaveContext context) throws CoreException {
        IProject savedProject;
        Preferences preferences = JavaCore.getPlugin().getPluginPreferences();
        IJavaProject[] projects = this.getJavaModel().getJavaProjects();
        int i = 0;
        int length = projects.length;
        while (i < length) {
            IJavaProject project = projects[i];
            Map projectContainers = this.containerClone(project);
            if (projectContainers != null) {
                Iterator keys = projectContainers.keySet().iterator();
                while (keys.hasNext()) {
                    IPath containerPath = (IPath)keys.next();
                    IClasspathContainer container = (IClasspathContainer)projectContainers.get(containerPath);
                    String containerKey = CP_CONTAINER_PREFERENCES_PREFIX + project.getElementName() + "|" + containerPath;
                    String containerString = CP_ENTRY_IGNORE;
                    try {
                        if (container != null) {
                            containerString = ((JavaProject)project).encodeClasspath(container.getClasspathEntries(), null, false);
                        }
                    }
                    catch (JavaModelException javaModelException) {
                        // empty catch block
                    }
                    preferences.setDefault(containerKey, CP_ENTRY_IGNORE);
                    preferences.setValue(containerKey, containerString);
                }
            }
            ++i;
        }
        JavaCore.getPlugin().savePluginPreferences();
        if (context.getKind() == 1) {
            context.needDelta();
            IndexManager manager = this.indexManager;
            if (manager != null) {
                manager.cleanUpIndexes();
            }
        }
        if ((savedProject = context.getProject()) != null) {
            if (!JavaProject.hasJavaNature(savedProject)) {
                return;
            }
            PerProjectInfo info = this.getPerProjectInfo(savedProject, true);
            this.saveState(info, context);
            return;
        }
        ArrayList<IStatus> vStats = null;
        Iterator iter = this.perProjectInfos.values().iterator();
        while (iter.hasNext()) {
            try {
                PerProjectInfo info = (PerProjectInfo)iter.next();
                this.saveState(info, context);
            }
            catch (CoreException e) {
                if (vStats == null) {
                    vStats = new ArrayList<IStatus>();
                }
                vStats.add(e.getStatus());
            }
        }
        if (vStats != null) {
            IStatus[] stats = new IStatus[vStats.size()];
            vStats.toArray(stats);
            throw new CoreException(new MultiStatus("org.eclipse.ajdt.core.plugin", 4, stats, Util.bind("build.cannotSaveStates"), null));
        }
    }

    protected void setBuildOrder(String[] javaBuildOrder) throws JavaModelException {
        String[] newOrder;
        if (!"compute".equals(JavaCore.getOption("org.eclipse.ajdt.core.plugin.computeJavaBuildOrder"))) {
            return;
        }
        if (javaBuildOrder == null || javaBuildOrder.length <= 1) {
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription description = workspace.getDescription();
        String[] wksBuildOrder = description.getBuildOrder();
        if (wksBuildOrder == null) {
            newOrder = javaBuildOrder;
        } else {
            int javaCount = javaBuildOrder.length;
            HashMap<String, String> newSet = new HashMap<String, String>(javaCount);
            int i = 0;
            while (i < javaCount) {
                newSet.put(javaBuildOrder[i], javaBuildOrder[i]);
                ++i;
            }
            int removed = 0;
            int oldCount = wksBuildOrder.length;
            int i2 = 0;
            while (i2 < oldCount) {
                if (newSet.containsKey(wksBuildOrder[i2])) {
                    wksBuildOrder[i2] = null;
                    ++removed;
                }
                ++i2;
            }
            newOrder = new String[oldCount - removed + javaCount];
            System.arraycopy(javaBuildOrder, 0, newOrder, 0, javaCount);
            int index = javaCount;
            int i3 = 0;
            while (i3 < oldCount) {
                if (wksBuildOrder[i3] != null) {
                    newOrder[index++] = wksBuildOrder[i3];
                }
                ++i3;
            }
        }
        description.setBuildOrder(newOrder);
        try {
            workspace.setDescription(description);
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    public void setLastBuiltState(IProject project, Object state) {
        if (JavaProject.hasJavaNature(project)) {
            PerProjectInfo info = this.getPerProjectInfo(project, true);
            info.triedRead = true;
            info.savedState = state;
        }
        if (state == null) {
            try {
                File file = this.getSerializationFile(project);
                if (file != null && file.exists()) {
                    file.delete();
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    public void shutdown() {
        if (this.indexManager != null) {
            this.indexManager.shutdown();
        }
    }

    public synchronized IPath variableGet(String variableName) {
        HashSet initializations = this.variableInitializationInProgress();
        if (initializations.contains(variableName)) {
            return VARIABLE_INITIALIZATION_IN_PROGRESS;
        }
        return (IPath)this.variables.get(variableName);
    }

    public void updateVariableValues(String[] variableNames, IPath[] variablePaths, IProgressMonitor monitor) throws JavaModelException {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        if (CP_RESOLVE_VERBOSE) {
            Util.verbose("CPVariable SET  - setting variables\n\tvariables: " + org.eclipse.jdt.internal.compiler.util.Util.toString(variableNames) + '\n' + "\tvalues: " + org.eclipse.jdt.internal.compiler.util.Util.toString(variablePaths));
        }
        int varLength = variableNames.length;
        final HashMap<JavaProject, IClasspathEntry[]> affectedProjectClasspaths = new HashMap<JavaProject, IClasspathEntry[]>(5);
        JavaModel model = this.getJavaModel();
        int discardCount = 0;
        int i = 0;
        while (i < varLength) {
            String variableName = variableNames[i];
            IPath oldPath = this.variableGet(variableName);
            if (oldPath == VARIABLE_INITIALIZATION_IN_PROGRESS) {
                oldPath = null;
            }
            if (oldPath != null && oldPath.equals(variablePaths[i])) {
                variableNames[i] = null;
                ++discardCount;
            }
            ++i;
        }
        if (discardCount > 0) {
            if (discardCount == varLength) {
                return;
            }
            int changedLength = varLength - discardCount;
            String[] changedVariableNames = new String[changedLength];
            IPath[] changedVariablePaths = new IPath[changedLength];
            int i2 = 0;
            int index = 0;
            while (i2 < varLength) {
                if (variableNames[i2] != null) {
                    changedVariableNames[index] = variableNames[i2];
                    changedVariablePaths[index] = variablePaths[i2];
                    ++index;
                }
                ++i2;
            }
            variableNames = changedVariableNames;
            variablePaths = changedVariablePaths;
            varLength = changedLength;
        }
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        if (model != null) {
            IJavaProject[] projects = model.getJavaProjects();
            int i3 = 0;
            int projectLength = projects.length;
            while (i3 < projectLength) {
                JavaProject project = (JavaProject)projects[i3];
                IClasspathEntry[] classpath = project.getRawClasspath();
                int j = 0;
                int cpLength = classpath.length;
                block5: while (j < cpLength) {
                    IClasspathEntry entry = classpath[j];
                    int k = 0;
                    while (k < varLength) {
                        String variableName = variableNames[k];
                        if (entry.getEntryKind() == 4) {
                            IPath sourceRootPath;
                            if (variableName.equals(entry.getPath().segment(0))) {
                                affectedProjectClasspaths.put(project, project.getResolvedClasspath(true, false, false));
                                break block5;
                            }
                            IPath sourcePath = entry.getSourceAttachmentPath();
                            if (sourcePath != null && variableName.equals(sourcePath.segment(0)) || (sourceRootPath = entry.getSourceAttachmentRootPath()) != null && variableName.equals(sourceRootPath.segment(0))) {
                                affectedProjectClasspaths.put(project, project.getResolvedClasspath(true, false, false));
                                break block5;
                            }
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i3;
            }
        }
        i = 0;
        while (i < varLength) {
            this.variablePut(variableNames[i], variablePaths[i]);
            ++i;
        }
        Object[] dbgVariableNames = variableNames;
        if (!affectedProjectClasspaths.isEmpty()) {
            try {
                boolean canChangeResources = !ResourcesPlugin.getWorkspace().isTreeLocked();
                JavaCore.run(new IWorkspaceRunnable((String[])dbgVariableNames, canChangeResources){
                    private final /* synthetic */ String[] val$dbgVariableNames;
                    private final /* synthetic */ boolean val$canChangeResources;
                    {
                        this.val$dbgVariableNames = stringArray;
                        this.val$canChangeResources = bl;
                    }

                    public void run(IProgressMonitor progressMonitor) throws CoreException {
                        Iterator projectsToUpdate = affectedProjectClasspaths.keySet().iterator();
                        while (projectsToUpdate.hasNext()) {
                            if (progressMonitor != null && progressMonitor.isCanceled()) {
                                return;
                            }
                            JavaProject affectedProject = (JavaProject)projectsToUpdate.next();
                            if (CP_RESOLVE_VERBOSE) {
                                Util.verbose("CPVariable SET  - updating affected project due to setting variables\n\tproject: " + affectedProject.getElementName() + '\n' + "\tvariables: " + org.eclipse.jdt.internal.compiler.util.Util.toString(this.val$dbgVariableNames));
                            }
                            affectedProject.setRawClasspath(affectedProject.getRawClasspath(), SetClasspathOperation.ReuseOutputLocation, null, this.val$canChangeResources, (IClasspathEntry[])affectedProjectClasspaths.get(affectedProject), false, false);
                        }
                    }
                }, null, monitor);
            }
            catch (CoreException e) {
                if (CP_RESOLVE_VERBOSE) {
                    Util.verbose("CPVariable SET  - FAILED DUE TO EXCEPTION\n\tvariables: " + org.eclipse.jdt.internal.compiler.util.Util.toString(dbgVariableNames), System.err);
                    e.printStackTrace();
                }
                if (e instanceof JavaModelException) {
                    throw (JavaModelException)e;
                }
                throw new JavaModelException(e);
            }
        }
    }

    private HashSet variableInitializationInProgress() {
        HashSet initializations = (HashSet)this.variableInitializationInProgress.get();
        if (initializations == null) {
            initializations = new HashSet();
            this.variableInitializationInProgress.set(initializations);
        }
        return initializations;
    }

    public synchronized String[] variableNames() {
        int length = this.variables.size();
        String[] result = new String[length];
        Iterator vars = this.variables.keySet().iterator();
        int index = 0;
        while (vars.hasNext()) {
            result[index++] = (String)vars.next();
        }
        return result;
    }

    public synchronized void variablePut(String variableName, IPath variablePath) {
        HashSet initializations = this.variableInitializationInProgress();
        if (variablePath == VARIABLE_INITIALIZATION_IN_PROGRESS) {
            initializations.add(variableName);
            return;
        }
        initializations.remove(variableName);
        if (variablePath == null) {
            this.variables.remove(variableName);
        } else {
            this.variables.put(variableName, variablePath);
        }
        this.previousSessionVariables.remove(variableName);
        Preferences preferences = JavaCore.getPlugin().getPluginPreferences();
        String variableKey = CP_VARIABLE_PREFERENCES_PREFIX + variableName;
        String variableString = variablePath == null ? CP_ENTRY_IGNORE : variablePath.toString();
        preferences.setDefault(variableKey, CP_ENTRY_IGNORE);
        preferences.setValue(variableKey, variableString);
        JavaCore.getPlugin().savePluginPreferences();
    }

    public static class PerProjectInfo {
        public IProject project;
        public Object savedState = null;
        public boolean triedRead = false;
        public IClasspathEntry[] rawClasspath;
        public IClasspathEntry[] resolvedClasspath;
        public Map resolvedPathToRawEntries;
        public IPath outputLocation;
        public Preferences preferences;

        public PerProjectInfo(IProject project) {
            this.project = project;
        }

        public synchronized void updateClasspathInformation(IClasspathEntry[] newRawClasspath) {
            this.rawClasspath = newRawClasspath;
            this.resolvedClasspath = null;
            this.resolvedPathToRawEntries = null;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Info for ");
            buffer.append(this.project.getFullPath());
            buffer.append("\nRaw classpath:\n");
            if (this.rawClasspath == null) {
                buffer.append("  <null>\n");
            } else {
                int i = 0;
                int length = this.rawClasspath.length;
                while (i < length) {
                    buffer.append("  ");
                    buffer.append(this.rawClasspath[i]);
                    buffer.append('\n');
                    ++i;
                }
            }
            buffer.append("Resolved classpath:\n");
            IClasspathEntry[] resolvedCP = this.resolvedClasspath;
            if (resolvedCP == null) {
                buffer.append("  <null>\n");
            } else {
                int i = 0;
                int length = resolvedCP.length;
                while (i < length) {
                    buffer.append("  ");
                    buffer.append(resolvedCP[i]);
                    buffer.append('\n');
                    ++i;
                }
            }
            buffer.append("Output location:\n  ");
            if (this.outputLocation == null) {
                buffer.append("<null>");
            } else {
                buffer.append(this.outputLocation);
            }
            return buffer.toString();
        }
    }

    public static class PerWorkingCopyInfo
    implements IProblemRequestor {
        int useCount = 0;
        IProblemRequestor problemRequestor;
        ICompilationUnit workingCopy;

        public PerWorkingCopyInfo(ICompilationUnit workingCopy, IProblemRequestor problemRequestor) {
            this.workingCopy = workingCopy;
            this.problemRequestor = problemRequestor;
        }

        public void acceptProblem(IProblem problem) {
            if (this.problemRequestor == null) {
                return;
            }
            this.problemRequestor.acceptProblem(problem);
        }

        public void beginReporting() {
            if (this.problemRequestor == null) {
                return;
            }
            this.problemRequestor.beginReporting();
        }

        public void endReporting() {
            if (this.problemRequestor == null) {
                return;
            }
            this.problemRequestor.endReporting();
        }

        public ICompilationUnit getWorkingCopy() {
            return this.workingCopy;
        }

        public boolean isActive() {
            return this.problemRequestor != null && this.problemRequestor.isActive();
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Info for ");
            buffer.append(((JavaElement)((Object)this.workingCopy)).toStringWithAncestors());
            buffer.append("\nUse count = ");
            buffer.append(this.useCount);
            buffer.append("\nProblem requestor:\n  ");
            buffer.append(this.problemRequestor);
            return buffer.toString();
        }
    }

    public static class PluginPreferencesListener
    implements Preferences.IPropertyChangeListener {
        public void propertyChange(Preferences.PropertyChangeEvent event) {
            String propertyName = event.getProperty();
            if (propertyName.startsWith(JavaModelManager.CP_VARIABLE_PREFERENCES_PREFIX)) {
                String varName = propertyName.substring(JavaModelManager.CP_VARIABLE_PREFERENCES_PREFIX.length());
                String newValue = (String)event.getNewValue();
                if (newValue != null && !(newValue = newValue.trim()).equals(JavaModelManager.CP_ENTRY_IGNORE)) {
                    JavaModelManager.getJavaModelManager().variables.put(varName, new Path(newValue));
                } else {
                    JavaModelManager.getJavaModelManager().variables.remove(varName);
                }
            }
            if (propertyName.startsWith(JavaModelManager.CP_CONTAINER_PREFERENCES_PREFIX)) {
                JavaModelManager.recreatePersistedContainer(propertyName, (String)event.getNewValue(), false);
            }
        }
    }
}

