/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.Member;
import org.eclipse.jdt.internal.core.SourceFieldElementInfo;

class SourceField
extends Member
implements IField {
    protected SourceField(JavaElement parent, String name) {
        super(parent, name);
    }

    public boolean equals(Object o) {
        if (!(o instanceof SourceField)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean equalsDOMNode(IDOMNode node) {
        return node.getNodeType() == 5 && super.equalsDOMNode(node);
    }

    public Object getConstant() throws JavaModelException {
        Object constant = null;
        SourceFieldElementInfo info = (SourceFieldElementInfo)this.getElementInfo();
        if (info.initializationSource == null) {
            return null;
        }
        String constantSource = new String(info.initializationSource);
        String signature = info.getTypeSignature();
        if (signature.equals("I")) {
            constant = new Integer(constantSource);
        } else if (signature.equals("S")) {
            constant = new Short(constantSource);
        } else if (signature.equals("B")) {
            constant = new Byte(constantSource);
        } else if (signature.equals("Z")) {
            constant = Boolean.valueOf(constantSource);
        } else if (signature.equals("C")) {
            constant = new Character(constantSource.charAt(0));
        } else if (signature.equals("D")) {
            constant = new Double(constantSource);
        } else if (signature.equals("F")) {
            constant = new Float(constantSource);
        } else if (signature.equals("J")) {
            int index;
            constant = constantSource.endsWith("L") || constantSource.endsWith("l") ? ((index = constantSource.lastIndexOf("L")) != -1 ? new Long(constantSource.substring(0, index)) : new Long(constantSource.substring(0, constantSource.lastIndexOf("l")))) : new Long(constantSource);
        } else if (signature.equals("QString;")) {
            constant = constantSource;
        }
        return constant;
    }

    public int getElementType() {
        return 8;
    }

    protected char getHandleMementoDelimiter() {
        return '^';
    }

    public IJavaElement getPrimaryElement(boolean checkOwner) {
        CompilationUnit cu;
        if (checkOwner && (cu = (CompilationUnit)this.getAncestor(5)).isPrimary()) {
            return this;
        }
        IJavaElement primaryParent = this.parent.getPrimaryElement(false);
        return ((IType)primaryParent).getField(this.name);
    }

    public String getTypeSignature() throws JavaModelException {
        SourceFieldElementInfo info = (SourceFieldElementInfo)this.getElementInfo();
        return info.getTypeSignature();
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
        buffer.append(this.tabString(tab));
        if (info == null) {
            this.toStringName(buffer);
            buffer.append(" (not open)");
        } else if (info == JavaElement.NO_INFO) {
            this.toStringName(buffer);
        } else {
            try {
                buffer.append(Signature.toString(this.getTypeSignature()));
                buffer.append(" ");
                this.toStringName(buffer);
            }
            catch (JavaModelException e) {
                buffer.append("<JavaModelException in toString of " + this.getElementName());
            }
        }
    }
}

