/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.search.AbstractSearchScope;

public class JavaSearchScope
extends AbstractSearchScope {
    private ArrayList elements;
    private IPath[] paths;
    private boolean[] pathWithSubFolders;
    private int pathsCount;
    private IPath[] enclosingProjectsAndJars;

    public JavaSearchScope() {
        this.initialize();
    }

    private void addEnclosingProjectOrJar(IPath path) {
        int length = this.enclosingProjectsAndJars.length;
        int i = 0;
        while (i < length) {
            if (this.enclosingProjectsAndJars[i].equals(path)) {
                return;
            }
            ++i;
        }
        this.enclosingProjectsAndJars = new IPath[length + 1];
        System.arraycopy(this.enclosingProjectsAndJars, 0, this.enclosingProjectsAndJars, 0, length);
        this.enclosingProjectsAndJars[length] = path;
    }

    public void add(JavaProject javaProject, int includeMask, HashSet visitedProjects) throws JavaModelException {
        IProject project = javaProject.getProject();
        if (!project.isAccessible() || !visitedProjects.add(project)) {
            return;
        }
        this.addEnclosingProjectOrJar(project.getFullPath());
        IClasspathEntry[] entries = javaProject.getResolvedClasspath(true, false, false);
        IJavaModel model = javaProject.getJavaModel();
        int i = 0;
        int length = entries.length;
        while (i < length) {
            block14: {
                IClasspathEntry entry = entries[i];
                block0 : switch (entry.getEntryKind()) {
                    case 1: {
                        IClasspathEntry rawEntry = null;
                        JavaModelManager.PerProjectInfo perProjectInfo = javaProject.getPerProjectInfo();
                        if (perProjectInfo != null && perProjectInfo.resolvedPathToRawEntries != null) {
                            rawEntry = (IClasspathEntry)perProjectInfo.resolvedPathToRawEntries.get(entry.getPath());
                        }
                        if (rawEntry == null) break;
                        switch (rawEntry.getEntryKind()) {
                            case 1: 
                            case 4: {
                                if ((includeMask & 2) != 0) {
                                    IPath path = entry.getPath();
                                    this.add(path, true);
                                    this.addEnclosingProjectOrJar(path);
                                    break;
                                }
                                break block14;
                            }
                            case 5: {
                                IClasspathContainer container = JavaCore.getClasspathContainer(rawEntry.getPath(), javaProject);
                                if (container == null) break block0;
                                if (container.getKind() == 1 && (includeMask & 2) != 0 || (includeMask & 4) != 0) {
                                    IPath path = entry.getPath();
                                    this.add(path, true);
                                    this.addEnclosingProjectOrJar(path);
                                } else {
                                    break;
                                }
                            }
                        }
                        break;
                    }
                    case 2: {
                        if ((includeMask & 8) == 0) break;
                        this.add((JavaProject)model.getJavaProject(entry.getPath().lastSegment()), includeMask, visitedProjects);
                        break;
                    }
                    case 3: {
                        if ((includeMask & 1) == 0) break;
                        this.add(entry.getPath(), true);
                    }
                }
            }
            ++i;
        }
    }

    public void add(IJavaElement element) throws JavaModelException {
        IPackageFragmentRoot root = null;
        switch (element.getElementType()) {
            case 1: {
                break;
            }
            case 2: {
                int includeMask = 7;
                this.add((JavaProject)element, includeMask, new HashSet(2));
                break;
            }
            case 3: {
                root = (IPackageFragmentRoot)element;
                this.add(root.getPath(), true);
                break;
            }
            case 4: {
                root = (IPackageFragmentRoot)element.getParent();
                if (root.isArchive()) {
                    this.add(root.getPath().append(new Path(element.getElementName().replace('.', '/'))), false);
                    break;
                }
                IResource resource = element.getResource();
                if (resource == null || !resource.isAccessible()) break;
                this.add(resource.getFullPath(), false);
                break;
            }
            default: {
                if (element instanceof IMember) {
                    if (this.elements == null) {
                        this.elements = new ArrayList();
                    }
                    this.elements.add(element);
                }
                this.add(this.fullPath(element), true);
                IJavaElement parent = element.getParent();
                while (parent != null && !(parent instanceof IPackageFragmentRoot)) {
                    parent = parent.getParent();
                }
                if (!(parent instanceof IPackageFragmentRoot)) break;
                root = (IPackageFragmentRoot)parent;
            }
        }
        if (root != null) {
            if (root.getKind() == 2) {
                this.addEnclosingProjectOrJar(root.getPath());
            } else {
                this.addEnclosingProjectOrJar(root.getJavaProject().getProject().getFullPath());
            }
        }
    }

    private void add(IPath path, boolean withSubFolders) {
        if (this.paths.length == this.pathsCount) {
            this.paths = new IPath[this.pathsCount * 2];
            System.arraycopy(this.paths, 0, this.paths, 0, this.pathsCount);
            this.pathWithSubFolders = new boolean[this.pathsCount * 2];
            System.arraycopy(this.pathWithSubFolders, 0, this.pathWithSubFolders, 0, this.pathsCount);
        }
        this.paths[this.pathsCount] = path;
        this.pathWithSubFolders[this.pathsCount++] = withSubFolders;
    }

    public boolean encloses(String resourcePathString) {
        int separatorIndex = resourcePathString.indexOf("|");
        IPath resourcePath = separatorIndex != -1 ? new Path(resourcePathString.substring(0, separatorIndex)).append(new Path(resourcePathString.substring(separatorIndex + 1))) : new Path(resourcePathString);
        return this.encloses(resourcePath);
    }

    private boolean encloses(IPath path) {
        int i = 0;
        while (i < this.pathsCount) {
            IPath scopePath;
            if (this.pathWithSubFolders[i] ? this.paths[i].isPrefixOf(path) : (scopePath = this.paths[i]).isPrefixOf(path) && (scopePath.segmentCount() == path.segmentCount() - 1 || scopePath.segmentCount() == path.segmentCount())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean encloses(IJavaElement element) {
        if (this.elements != null) {
            int i = 0;
            int length = this.elements.size();
            while (i < length) {
                IJavaElement scopeElement = (IJavaElement)this.elements.get(i);
                IJavaElement searchedElement = element;
                while (searchedElement != null) {
                    if (searchedElement.equals(scopeElement)) {
                        return true;
                    }
                    searchedElement = searchedElement.getParent();
                }
                ++i;
            }
            return false;
        }
        return this.encloses(this.fullPath(element));
    }

    public IPath[] enclosingProjectsAndJars() {
        return this.enclosingProjectsAndJars;
    }

    private IPath fullPath(IJavaElement element) {
        Path childPath;
        IPath parentPath;
        if (element instanceof IPackageFragmentRoot) {
            return ((IPackageFragmentRoot)element).getPath();
        }
        IJavaElement parent = element.getParent();
        IPath iPath = parentPath = parent == null ? null : this.fullPath(parent);
        if (element instanceof IPackageFragment) {
            childPath = new Path(element.getElementName().replace('.', '/'));
        } else if (element instanceof IOpenable) {
            childPath = new Path(element.getElementName());
        } else {
            return parentPath;
        }
        return parentPath == null ? childPath : parentPath.append(childPath);
    }

    protected void initialize() {
        this.paths = new IPath[1];
        this.pathWithSubFolders = new boolean[1];
        this.pathsCount = 0;
        this.enclosingProjectsAndJars = new IPath[0];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processDelta(IJavaElementDelta delta) {
        switch (delta.getKind()) {
            case 4: {
                IJavaElementDelta[] children = delta.getAffectedChildren();
                int i = 0;
                int length = children.length;
                while (i < length) {
                    IJavaElementDelta child = children[i];
                    this.processDelta(child);
                    ++i;
                }
                return;
            }
            case 2: {
                IJavaElement element = delta.getElement();
                if (!this.encloses(element)) return;
                if (this.elements != null) {
                    this.elements.remove(element);
                }
                IPath path = null;
                switch (element.getElementType()) {
                    case 2: {
                        path = ((IJavaProject)element).getProject().getFullPath();
                    }
                    case 3: {
                        if (path == null) {
                            path = ((IPackageFragmentRoot)element).getPath();
                        }
                        int toRemove = -1;
                        int i = 0;
                        while (i < this.pathsCount) {
                            if (this.paths[i].equals(path)) {
                                toRemove = i;
                                break;
                            }
                            ++i;
                        }
                        if (toRemove == -1) return;
                        int last = this.pathsCount - 1;
                        if (toRemove != last) {
                            this.paths[toRemove] = this.paths[last];
                            this.pathWithSubFolders[toRemove] = this.pathWithSubFolders[last];
                        }
                        --this.pathsCount;
                    }
                }
            }
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer("JavaSearchScope on ");
        if (this.elements != null) {
            result.append("[");
            int i = 0;
            int length = this.elements.size();
            while (i < length) {
                JavaElement element = (JavaElement)this.elements.get(i);
                result.append("\n\t");
                result.append(element.toStringWithAncestors());
                ++i;
            }
            result.append("\n]");
        } else if (this.pathsCount == 0) {
            result.append("[empty scope]");
        } else {
            result.append("[");
            int i = 0;
            while (i < this.pathsCount) {
                IPath path = this.paths[i];
                result.append("\n\t");
                result.append(path.toString());
                ++i;
            }
            result.append("\n]");
        }
        return result.toString();
    }
}

