/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.builder.ClasspathLocation;
import org.eclipse.jdt.internal.core.util.SimpleLookupTable;

public class ClasspathSourceDirectory
extends ClasspathLocation {
    IContainer sourceFolder;
    String sourceLocation;
    String encoding;
    SimpleLookupTable directoryCache;
    String[] missingPackageHolder = new String[1];

    ClasspathSourceDirectory(IContainer sourceFolder) {
        this.sourceFolder = sourceFolder;
        IPath location = sourceFolder.getLocation();
        this.sourceLocation = location != null ? location.addTrailingSeparator().toString() : "";
        try {
            this.encoding = this.sourceFolder.getDefaultCharset();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.directoryCache = new SimpleLookupTable(5);
    }

    public void cleanup() {
        this.directoryCache = null;
    }

    String[] directoryList(String qualifiedPackageName) {
        String[] dirList = (String[])this.directoryCache.get(qualifiedPackageName);
        if (dirList == this.missingPackageHolder) {
            return null;
        }
        if (dirList != null) {
            return dirList;
        }
        try {
            IResource container = this.sourceFolder.findMember(qualifiedPackageName);
            if (container instanceof IContainer) {
                IResource[] members = ((IContainer)container).members();
                dirList = new String[members.length];
                int index = 0;
                int i = 0;
                int l = members.length;
                while (i < l) {
                    String name;
                    IResource m = members[i];
                    if (m.getType() == 1 && Util.isJavaFileName(name = m.getName())) {
                        dirList[index++] = name;
                    }
                    ++i;
                }
                if (index < dirList.length) {
                    String[] stringArray = dirList;
                    dirList = new String[index];
                    System.arraycopy(stringArray, 0, dirList, 0, index);
                }
                this.directoryCache.put(qualifiedPackageName, dirList);
                return dirList;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.directoryCache.put(qualifiedPackageName, this.missingPackageHolder);
        return null;
    }

    boolean doesFileExist(String fileName, String qualifiedPackageName) {
        String[] dirList = this.directoryList(qualifiedPackageName);
        if (dirList == null) {
            return false;
        }
        int i = dirList.length;
        while (--i >= 0) {
            if (!fileName.equals(dirList[i])) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClasspathSourceDirectory)) {
            return false;
        }
        return this.sourceFolder.equals(((ClasspathSourceDirectory)o).sourceFolder);
    }

    public NameEnvironmentAnswer findClass(String sourceFileName, String qualifiedPackageName, String qualifiedSourceFileName) {
        if (!this.doesFileExist(sourceFileName, qualifiedPackageName)) {
            return null;
        }
        String fullSourcePath = String.valueOf(this.sourceLocation) + qualifiedSourceFileName;
        Path path = new Path(qualifiedSourceFileName);
        IFile file = this.sourceFolder.getFile(path);
        String fileEncoding = this.encoding;
        try {
            fileEncoding = file.getCharset();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return new NameEnvironmentAnswer(new CompilationUnit(null, fullSourcePath, fileEncoding));
    }

    public IPath getProjectRelativePath() {
        return this.sourceFolder.getProjectRelativePath();
    }

    public boolean isPackage(String qualifiedPackageName) {
        return this.directoryList(qualifiedPackageName) != null;
    }

    public void reset() {
        this.directoryCache = new SimpleLookupTable(5);
    }

    public String toString() {
        return "Source classpath directory " + this.sourceFolder.getFullPath().toString();
    }
}

