/**********************************************************************
Copyright (c) 2002 IBM Corporation and others.
All rights reserved. This program and the accompanying materials
are made available under the terms of the Common Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/cpl-v10.html
Contributors:
Adrian Colyer, Andy Clement, Tracy Gardner - initial version
...
**********************************************************************/
package org.eclipse.ajdt.internal.core.tests;

import junit.framework.TestCase;

import org.eclipse.ajdt.internal.core.AJDTUtils;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class AJDTUtilsTest extends TestCase {

	private IProject project;
	private IResource resource;


	/**
	 * Constructor for AJDTUtilsTest.
	 * @param name
	 */
	public AJDTUtilsTest(String name) {
		super(name);
	}

	public void setUp( ) {
		IProject[] projects = AspectJPlugin.getWorkspace().getRoot().getProjects();
		assertTrue( "Must be at least one project in workspace for this test",
		    		projects.length > 0 );
        project = projects[0];
        assertEquals( "Project should be set to 'Examples'", "Examples", 
						project.getName() );
		resource = findRequiredResource( project, "custom1.lst" );
 	}

	public void testGetWorkspacePath() {
		String path = AJDTUtils.getWorkspacePath();
		assertEquals( "D:\\eclipse\\runtime-workspace", path );
	}

	public void testGetProjectRootDirectory() {
		String path = AJDTUtils.getProjectRootDirectory( project );
		assertEquals( "D:\\eclipse\\runtime-workspace\\Examples", path );		
	}

	public void testGetResourcePath() {
		String path = AJDTUtils.getResourcePath( resource );
		assertEquals( "D:\\eclipse\\runtime-workspace\\Examples\\custom1.lst", path );
	}


	private IResource findRequiredResource( IProject p, String fName ) {
		IResource retVal = null;
		IResource[] projectMembers = null;
        try {						
			projectMembers = p.members();
        } catch ( CoreException cEx ) {
        	fail( "Exception listing project contents: " + cEx.getMessage() );
        }
        
        for ( int i = 0; i < projectMembers.length; i++ ) {
			IResource resource = projectMembers[i];
			if ( resource.getName( ).endsWith( fName ) ) {
				retVal = resource;
				break;
			}
		}	
		
		if ( retVal == null ) {
			fail( "Missing required project resource: " + fName + 
				  "in project " + p.getName() );
		}
		
		return retVal;
	}
}
