/**********************************************************************
Copyright (c) 2002 IBM Corporation and others.
All rights reserved. This program and the accompanying materials
are made available under the terms of the Common Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/cpl-v10.html
Contributors:
Adrian Colyer, Andy Clement, Tracy Gardner - initial version
...
**********************************************************************/
package org.eclipse.ajdt.internal.ui.tests;


import junit.textui.TestRunner;

import org.eclipse.ajdt.ui.tests.AllAJPluginTests;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;

public class RunTestSuiteMenuSelection
	implements IWorkbenchWindowPulldownDelegate {

	IWorkbenchWindow window;

	/**
	 * Constructor for RunTestSuiteMenuSelection.
	 */
	public RunTestSuiteMenuSelection() {
		super();
	}


	/**
	 * @see IWorkbenchWindowActionDelegate#dispose()
	 */
	public void dispose() {
		// this method deliberately left blank
	}

	/**
	 * @see IWorkbenchWindowActionDelegate#init(IWorkbenchWindow)
	 */
	public void init(IWorkbenchWindow window) {
		this.window = window;
//		// force the loading of the JUnit plugin
//		IPluginDescriptor desc = 
//			Platform.getPluginRegistry().getPluginDescriptor( "org.junit" );
//		try {
//			desc.getPlugin();
//			ClassLoader loader = desc.getPluginClassLoader();
//			loader.loadClass( "junit.framework.Test" );
//		} catch ( Exception cEx ) {
//			System.err.println( "Error loading JUnit plugin:" + cEx );
//		}
//		System.out.println( desc );		
	}

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {
		System.err.println( "Tests ahoy!" );
		TestRunner.run( AllAJPluginTests.class );
//		 runner = new TestRunner();
//		runner.setSuite( "org.eclipse.ajdt.ui.tests.AllAJPluginTests" );
//		runner.runSuite();
	}

	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		// this method deliberately left blank
	}
	

	/**
	 * @see IWorkbenchWindowPulldownDelegate#getMenu(Control)
	 */
	public Menu getMenu(Control parent) {
		return null;
	}

}
