/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Ian McGrath - added warning message for using existing project structures
 *******************************************************************************/

package org.eclipse.ajdt.internal.ui.wizards;

import java.io.File;

import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

/**
 * Standard main page for the wizard that creates an AspectJ project resource.
 */
public class AspectJWizardNewProjectCreationPage extends WizardNewProjectCreationPage {
	
	public AspectJWizardNewProjectCreationPage(String pageName) {
		super(pageName);
	}
	/**
	 * Returns whether this page's controls currently all contain valid 
	 * values and checks if the project structure already exists.
	*/
	protected boolean validatePage() {

		String projectName = getProjectName();
		
		IWorkspaceRoot wRoot = AspectJPlugin.getWorkspace().getRoot();
		File projectPath = wRoot.getLocation().append(projectName).toFile();
		File classpath = wRoot.getLocation().append(projectName + IPath.SEPARATOR + ".classpath").toFile();
		File projectDetailsFile = wRoot.getLocation().append(projectName + IPath.SEPARATOR + ".project").toFile();
		boolean projectFolderExists = projectPath.exists();
		boolean classpathExists = classpath.exists();
		boolean projectFileExists = projectDetailsFile.exists();
		boolean ProjectInWorkspace = !(wRoot.findMember(projectName) == null);
		boolean errorSet = false;
		
		if (projectFolderExists && classpathExists && projectFileExists && !ProjectInWorkspace) {
			setErrorMessage(null);
			setMessage(AspectJPlugin.getResourceString("NewAspectjProjectCreationWizard.MainPage.project_exists"),
			        IMessageProvider.WARNING);
			errorSet=true;
		}
		
		if(errorSet) 
			return true;
		else
			return super.validatePage();
	}
}
