/*********************************************************************
 * Copyright (c) 2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html 
 * Contributors: 
 * Sian Whiting -  initial version.
 **********************************************************************/
package org.eclipse.ajdt.ui.visualiser;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.aspectj.asm.IProgramElement;
import org.eclipse.contribution.visualiser.interfaces.IMember;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;

/**
 * Utility method used by the providers for the new Visualiser
 */
public class NewVisualiserUtils {
	
	private static IProject project;
	private static Object lastLoadedConfigFile;


	/**
	 * This method returns a list of Maps 
	 * from Integers to a List of Strings representing 
	 * the names of the aspects affecting the line
	 */
	public static List getMarkupInfo(IMember member, IProject project) {
		NewVisualiserUtils.project = project;

		List returningList = new LinkedList();
		List packages = StructureModelUtil.getPackagesInModel();

        String parent = member.getContainingGroup().getFullname();
        boolean defaultPackage = parent.startsWith("(default");


		Iterator it = packages.iterator();
		while (it.hasNext()) {
			Object[] o = (Object[]) it.next();

			if (parent.equals(o[1]) || defaultPackage && o[1].equals("<default>")) {

				IProgramElement packageNode = (IProgramElement) o[0];
				List files = StructureModelUtil.getFilesInPackage(packageNode);

				Iterator it2 = files.iterator();
				while (it2.hasNext()) {

					IProgramElement file = (IProgramElement) it2.next();
					
					org.aspectj.bridge.ISourceLocation isl =
						file.getSourceLocation();

					String testpath = isl.getSourceFile().getAbsolutePath();
					if(testpath.endsWith(".java")) {
						testpath = testpath.substring(0, testpath.length() - 5);
					} else if(testpath.endsWith(".aj")) {
						testpath = testpath.substring(0, testpath.length() - 3);
					}

					if (testpath.endsWith(File.separator + member.getName())) {
						try {
							String fullpath =
								isl.getSourceFile().getAbsolutePath();

							Map lineAdviceMap =
								StructureModelUtil.getLinesToAspectMap(
									fullpath);

							Map map = changeMap(lineAdviceMap, 0);

							returningList.add(map);
						} catch (NumberFormatException e) {
							e.printStackTrace();
						}

					}
				}
			}
		}
		return returningList;
	}

	
	/**
	 * This method changes a Map from line numbers to a List of ProgramElementNodes
	 * into a Map from line numbers to a List of Strings representing the names of
	 * the aspects affecting that line number
	 * 
	 * @return a Map from Integers to a List of Strings
	 */
	private static Map changeMap(Map oldmap, int startline) {
		HashMap newmap = new HashMap();

		Set keys = oldmap.keySet();

		Iterator it = keys.iterator();
		while (it.hasNext()) {
			Integer line = (Integer) it.next();

			Object o = oldmap.get(line);

			List oldaspects = (List)o;

			List newaspects = new LinkedList();

			Iterator iterator2 = oldaspects.iterator();
			while (iterator2.hasNext()) {

				IProgramElement theaspect =
					(IProgramElement) iterator2.next();

				String fullpath = theaspect.getSourceLocation().getSourceFile().getAbsolutePath();

				Path path = new Path(fullpath);
				String aspectname = path.removeFileExtension().lastSegment();

				newaspects.add(aspectname);
			}

			if (!newaspects.isEmpty()) {
				line = new Integer(line.intValue() + startline);

				newmap.put(line, newaspects);
			}
		}

		return newmap;
	}
	
}
