/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     Andy Clement - initial version
 *******************************************************************************/
package org.eclipse.contribution.visualiser.jdtimpl;

import org.eclipse.contribution.visualiser.interfaces.simpleImpl.SimpleMember;
import org.eclipse.jdt.core.IJavaElement;


/**
 * The JDT implementation of IMember.  
 */
public class JDTMember extends SimpleMember {

	private IJavaElement javaElement;

	/**
	 * Default constructor
	 * @param name - the member's name
	 * @param je - the corresponding IJavaElement
	 */
	public JDTMember(String name,IJavaElement je) {
		super(name);
		javaElement = je;
	}
	
	
	/**
	 * Gets the Java element represented by this member
	 * @return
	 */
	public IJavaElement getResource() {
		return javaElement;
	}

	public String toString() {
		return new String("JDTMember:["+fullname+"] Size:["+size.toString()+"]");
	}

}
