/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     JavaSpider    - initial version
 *     Andy Clement  - Added support for creating projects with different names
 *     Adrian Colyer - Made delete synchronous
 *******************************************************************************/
package org.eclipse.ajdt.buildconfigurator.tests;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchConstants;
import org.eclipse.jdt.core.search.ITypeNameRequestor;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.launching.JavaRuntime;

/**
 * The base for this class was taken from the org.eclipse.contribution.junit.test
 * project (Gamma/Beck) and then edited from there.
 */
public class TestProject {

	private IProject project;
	private IJavaProject javaProject;
	private IPackageFragmentRoot sourceFolder;
	
	
	public TestProject() throws CoreException {
		this("TestProject","bin",true);
	}
	
	public TestProject(String pname) throws CoreException {
		this(pname,"bin",true);
	}
	
	public TestProject(String pname, boolean createContent) throws CoreException {
		this(pname,"bin",createContent);
	}

	public TestProject(String pname,String outputfoldername) throws CoreException {
		this(pname,outputfoldername,true);
	}
	
	public TestProject(String pname,String outputfoldername,boolean createContent) throws CoreException {
		IWorkspaceRoot root= ResourcesPlugin.getWorkspace().getRoot();
		project= root.getProject(pname);
		project.create(null);
		project.open(null);
		javaProject= JavaCore.create(project);
		setJavaNature();

		IFolder outputFolder = createOutputFolder(outputfoldername);
	
		javaProject.setRawClasspath(new IClasspathEntry[0], null);
			
		createOutputFolder(outputFolder);
		if (createContent) {
			addSystemLibraries();
		}
	}


	
	public IProject getProject() {
		return project;
	}

	public IJavaProject getJavaProject() {
		return javaProject;
	}
	
	public void addJar(String plugin, String jar) throws MalformedURLException, IOException, JavaModelException {
		Path result= findFileInPlugin(plugin, jar);
		IClasspathEntry[] oldEntries= javaProject.getRawClasspath();
		IClasspathEntry[] newEntries= new IClasspathEntry[oldEntries.length + 1];
		System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
		newEntries[oldEntries.length]= JavaCore.newLibraryEntry(result, null, null);
		javaProject.setRawClasspath(newEntries, null);
	}

	public IPackageFragment createPackage(String name) throws CoreException {
		if (sourceFolder == null)
			sourceFolder= createSourceFolder();
		return sourceFolder.createPackageFragment(name, false, null);
	}

	public IType createType(IPackageFragment pack, String cuName, String source) throws JavaModelException {
		StringBuffer buf= new StringBuffer();
		buf.append("package " + pack.getElementName() + ";\n");
		buf.append("\n");
		buf.append(source);
		ICompilationUnit cu= pack.createCompilationUnit(cuName, buf.toString(), false, null);
		return cu.getTypes()[0];
	}

	public IPackageFragmentRoot getSourceFolder() throws CoreException {
		if (sourceFolder == null)
			sourceFolder= createSourceFolder();
		return sourceFolder;
	}
	
	public IFolder createFolder(IPackageFragmentRoot root, String name) throws JavaModelException, CoreException {
		IFolder folder = (IFolder) root.getCorrespondingResource();
		IFolder ret = folder.getFolder(name);
		ret.create(true,true,null);		
		return ret;
	}
	
	public IFile createFile(IFolder inFolder,String name, String content) throws CoreException {
		IFile file = inFolder.getFile(name);
		ByteArrayInputStream source = new ByteArrayInputStream(content.getBytes());
		file.create(source,true,null);		
		return file;
	}
	
	private boolean disposeDone = false;
	
	public synchronized void dispose() throws CoreException {
		waitForIndexer();
//		System.out.println("start");
		disposeDone = false;
		project.delete(true, true, new IProgressMonitor() {
		
			public void done() {
//				System.out.println("done");
				disposeDone();
			}

			public void beginTask(String name, int totalWork) {}
			public void internalWorked(double work) {}
			public boolean isCanceled() {return false;}
			public void setCanceled(boolean value) {}
			public void setTaskName(String name) {}
			public void subTask(String name) {}
			public void worked(int work) {}
			
		});
		try {
			if (!disposeDone) {
//				System.out.println("waiting...");
				wait();
			}
//			System.out.println("wait over");
		} catch(InterruptedException intEx) {}
	}
	
	private synchronized void disposeDone() {
//		System.out.println("dispose done");
		disposeDone = true;
		notify();
	}
	
	private IFolder createOutputFolder(String outputfoldername) throws CoreException {
		IFolder binFolder= project.getFolder(outputfoldername);
		try {
			if (!binFolder.exists()) binFolder.create(false, true, null);
		} catch (ResourceException e) {
			e.printStackTrace();
		}
		return binFolder;
	}

	private void setJavaNature() throws CoreException {
		IProjectDescription description= project.getDescription();
		description.setNatureIds(new String[] { JavaCore.NATURE_ID });
		project.setDescription(description, null);
	}

	private void createOutputFolder(IFolder binFolder) throws JavaModelException {
		IPath outputLocation= binFolder.getFullPath();
		javaProject.setOutputLocation(outputLocation, null);
	}

	private IPackageFragmentRoot createSourceFolder() throws CoreException {
		IFolder folder= project.getFolder("src");
		folder.create(false, true, null);
		IPackageFragmentRoot root= javaProject.getPackageFragmentRoot(folder);

		IClasspathEntry[] oldEntries= javaProject.getRawClasspath();
		IClasspathEntry[] newEntries= new IClasspathEntry[oldEntries.length + 1];
		System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
		newEntries[oldEntries.length]= JavaCore.newSourceEntry(root.getPath());
		javaProject.setRawClasspath(newEntries, null);
		return root;
	}

	private void addSystemLibraries() throws JavaModelException {
		IClasspathEntry[] oldEntries= javaProject.getRawClasspath();
		IClasspathEntry[] newEntries= new IClasspathEntry[oldEntries.length + 1];
		System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
		newEntries[oldEntries.length]= JavaRuntime.getDefaultJREContainerEntry();
		javaProject.setRawClasspath(newEntries, null);
	}

	private Path findFileInPlugin(String plugin, String file) throws MalformedURLException, IOException {
		org.osgi.framework.Bundle bundle = Platform.getBundle(plugin);
		URL pluginURL = bundle.getEntry("/");
		URL jarURL= new URL(pluginURL, file);
		URL localJarURL= Platform.asLocalURL(jarURL);
		
//		IPluginRegistry registry= Platform.getPluginRegistry();
//		IPluginDescriptor descriptor= registry.getPluginDescriptor(plugin);
//		URL pluginURL= descriptor.getInstallURL();
//		URL jarURL= new URL(pluginURL, file);
		
		return new Path(localJarURL.getPath());
	}

	private void waitForIndexer() throws JavaModelException {
//			new SearchEngine()
//				.searchAllTypeNames(
//					ResourcesPlugin.getWorkspace(),
//					null,
//					null,
//					IJavaSearchConstants.EXACT_MATCH,
//					IJavaSearchConstants.CASE_SENSITIVE,
//					IJavaSearchConstants.CLASS,
//					SearchEngine.createJavaSearchScope(new IJavaElement[0]),
//					new ITypeNameRequestor() {
//				public void acceptClass(char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
//				}
//				public void acceptInterface(char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
//				}
//			}, IJavaSearchConstants.WAIT_UNTIL_READY_TO_SEARCH, null);

			new SearchEngine()
			.searchAllTypeNames(
				null,
				null,
				SearchPattern.R_EXACT_MATCH,
				IJavaSearchConstants.CLASS,
				SearchEngine.createJavaSearchScope(new IJavaElement[0]),
				new ITypeNameRequestor() {
			public void acceptClass(char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
			}
			public void acceptInterface(char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
			}
		}, IJavaSearchConstants.WAIT_UNTIL_READY_TO_SEARCH, null);

		}
}